/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.tree;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.util.StringToolkit;
import org.openjdk.jmc.flightrecorder.rules.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.tree.ITreeNode;
import org.openjdk.jmc.flightrecorder.rules.tree.ITreeVisitor;
import org.openjdk.jmc.flightrecorder.rules.tree.traversal.BFTreeVisitor;
import org.openjdk.jmc.flightrecorder.rules.tree.traversal.LayerBreakdownGenerator;
import org.openjdk.jmc.flightrecorder.rules.tree.traversal.LayerBreakdownVisitor;
import org.openjdk.jmc.flightrecorder.rules.tree.traversal.LongestDurationIterator;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public final class ItemTreeToolkit {
    private static final String NEW_LINE_SEPARATOR = "\n";
    private static final String BULLET_CHARACTER = "\\u2022 ";

    public static String printTree(ITreeNode<IItem> node) {
        final StringBuilder builder = new StringBuilder();
        node.accept((ITreeVisitor<IItem>)new BFTreeVisitor<IItem>(){

            @Override
            protected void processPayload(IItem value, int level) {
                builder.append(String.format("%02d:%s", level, String.valueOf(value)));
            }
        });
        return builder.toString();
    }

    static boolean hasDuration(IItem item) {
        return RulesToolkit.getDuration(item).longValue() != 0L;
    }

    public static void appendLongestBreakdown(StringBuilder report, ITreeNode<IItem> root) {
        LongestDurationIterator itemIterator = new LongestDurationIterator(root);
        report.append(Messages.getString("ItemTreeToolkit_BREAKDOWN_HEADER_MAX_DURATION_EVENT_CHAIN"));
        IQuantity topLevelDuration = null;
        ArrayList<String> reports = new ArrayList<String>();
        while (itemIterator.hasNext()) {
            IItem next = (IItem)itemIterator.next();
            IQuantity duration = RulesToolkit.getDuration(next);
            if (topLevelDuration == null) {
                topLevelDuration = duration;
            }
            reports.add(String.format("&nbsp;&nbsp;%s, %s (%s)", next.getType().getName(), ItemTreeToolkit.toString(duration), RulesToolkit.toRatioPercentString(duration, topLevelDuration)));
        }
        report.append(StringToolkit.join(reports, (String)NEW_LINE_SEPARATOR));
    }

    public static void appendLayeredBreakdown(StringBuilder report, ITreeNode<IItem> root, int maxDepth) {
        LayerBreakdownGenerator layerBreakdown = new LayerBreakdownGenerator(root);
        List<LayerBreakdownVisitor.LayerBreakdown> layers = layerBreakdown.getLayers();
        if (layers.isEmpty()) {
            return;
        }
        IQuantity firstLayerDuration = null;
        report.append(Messages.getString("ItemTreeToolkit_BREAKDOWN_HEADER_LAYERS"));
        report.append(NEW_LINE_SEPARATOR);
        for (int i = 0; i < layers.size() && i <= maxDepth; ++i) {
            LayerBreakdownVisitor.LayerBreakdown breakdown = layers.get(i);
            IQuantity layerDuration = breakdown.getDuration();
            if (layerDuration == null) continue;
            if (firstLayerDuration == null) {
                firstLayerDuration = layerDuration;
            }
            report.append("\n\\u2022 ");
            report.append(MessageFormat.format(Messages.getString("ItemTreeToolkit_BREAKDOWN_LAYER_CAPTION"), breakdown.getLayer()));
            ItemTreeToolkit.appendLayerBreakdown(report, firstLayerDuration, breakdown);
            report.append(NEW_LINE_SEPARATOR);
        }
        report.append("\n\n");
    }

    private static void appendLayerBreakdown(StringBuilder report, IQuantity firstLayerDuration, LayerBreakdownVisitor.LayerBreakdown breakdown) {
        LinkedList<String> reportEntries = new LinkedList<String>();
        for (LayerBreakdownVisitor.LayerEntry entry : breakdown.getLayerEntries()) {
            reportEntries.add(String.format("%s  %s (%s)", RulesToolkit.toRatioPercentString(entry.getDuration(), firstLayerDuration), entry.getType().getName(), ItemTreeToolkit.toString(entry.getDuration())));
        }
        report.append(StringToolkit.join(reportEntries, (String)NEW_LINE_SEPARATOR));
    }

    private static Object toString(IQuantity duration) {
        return duration.displayUsing("auto");
    }

    public static int getDepth(ITreeNode<?> node) {
        int depth = 0;
        ITreeNode<?> parent = node.getParent();
        while (parent != null) {
            parent = parent.getParent();
            ++depth;
        }
        return depth;
    }
}

