/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MCVersion {
    private static final Logger LOGGER = Logger.getLogger("org.openjdk.jmc.ui.common");
    private static final String PROPERTY_FULL_VERSION = "jmc.fullversion";
    private static final String DEFAULT_FULL_VERSION = "debug";
    private static final String FULL_VERSION;
    private static final String PROPERTY_QUALIFIER = "jmc.qualifier";
    private static final String DEFAULT_QUALIFIER = "0";
    private static final String QUALIFIER;
    private static final String PROPERTY_BUILD_ID = "jmc.buildid";
    private static final String DEFAULT_BUILD_ID = "0";
    private static final String BUILD_ID;
    private static final String PROPERTY_CHANGE_ID = "jmc.changeid";
    private static final String DEFAULT_CHANGE_ID = "0";
    private static final String CHANGE_ID;
    private static final String PROPERTY_DATE = "jmc.date";
    private static final String DEFAULT_DATE = "0";
    private static final String DATE;

    static {
        Properties versionProperties = MCVersion.getVersionProperties();
        FULL_VERSION = MCVersion.getVersionProperty(versionProperties, PROPERTY_FULL_VERSION, DEFAULT_FULL_VERSION);
        QUALIFIER = MCVersion.getVersionProperty(versionProperties, PROPERTY_QUALIFIER, "0");
        BUILD_ID = MCVersion.getVersionProperty(versionProperties, PROPERTY_BUILD_ID, "0");
        CHANGE_ID = MCVersion.getVersionProperty(versionProperties, PROPERTY_CHANGE_ID, "0");
        DATE = MCVersion.getVersionProperty(versionProperties, PROPERTY_DATE, "0");
    }

    private static String getVersionProperty(Properties versionProperties, String propertyName, String defaultValue) {
        String propertyValue;
        if (versionProperties != null && (propertyValue = versionProperties.getProperty(propertyName)) != null && !propertyValue.startsWith("@")) {
            return propertyValue;
        }
        return defaultValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties getVersionProperties() {
        Properties versionProperties = new Properties();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream is = MCVersion.class.getResourceAsStream("/version.properties");){
                if (is == null) {
                    LOGGER.log(Level.SEVERE, "Could not open version.properties file.");
                    return null;
                }
                versionProperties.load(is);
                return versionProperties;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error loading version.properties file.", e);
            return null;
        }
    }

    public static String getFullVersion() {
        return FULL_VERSION;
    }

    public static String getChangeId() {
        return CHANGE_ID;
    }

    public static String getQualifier() {
        return QUALIFIER;
    }

    public static String getBuildId() {
        return BUILD_ID;
    }

    public static String getDate() {
        return DATE;
    }
}

