/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.views.stacktrace;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.openjdk.jmc.flightrecorder.stacktrace.FrameSeparator;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;

class FrameSeparatorManager
implements IMenuListener {
    private final Runnable onChangeCallback;
    private FrameSeparator current;

    FrameSeparatorManager(Runnable onChangeCallback, FrameSeparator initial) {
        this.onChangeCallback = onChangeCallback;
        this.current = initial;
    }

    FrameSeparator getFrameSeparator() {
        return this.current;
    }

    MenuManager createMenu() {
        MenuManager menu = new MenuManager(Messages.STACKTRACE_VIEW_DISTINGUISH_FRAMES_BY);
        menu.setRemoveAllWhenShown(true);
        menu.addMenuListener((IMenuListener)this);
        return menu;
    }

    public void menuAboutToShow(IMenuManager manager) {
        Action typeAction = new Action(Messages.STACKTRACE_VIEW_OPTIMIZATION_TYPE, 2){

            public void run() {
                FrameSeparatorManager.this.current = new FrameSeparator(FrameSeparatorManager.this.current.getCategorization(), this.isChecked());
                FrameSeparatorManager.this.onChangeCallback.run();
            }
        };
        typeAction.setChecked(this.current.isDistinguishFramesByOptimization());
        manager.add((IAction)typeAction);
        manager.add((IContributionItem)new Separator());
        FrameSeparator.FrameCategorization[] frameCategorizationArray = FrameSeparator.FrameCategorization.values();
        int n = frameCategorizationArray.length;
        int n2 = 0;
        while (n2 < n) {
            final FrameSeparator.FrameCategorization l = frameCategorizationArray[n2];
            Action levelOption = new Action(l.getLocalizedName(), 8){

                public void run() {
                    if (this.isChecked() && FrameSeparatorManager.this.current.getCategorization() != l) {
                        FrameSeparatorManager.this.current = new FrameSeparator(l, FrameSeparatorManager.this.current.isDistinguishFramesByOptimization());
                        FrameSeparatorManager.this.onChangeCallback.run();
                    }
                }
            };
            levelOption.setChecked(this.current.getCategorization() == l);
            manager.add((IAction)levelOption);
            ++n2;
        }
    }
}

