/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.descriptors;

import org.openjdk.jmc.joverflow.descriptors.AbstractArrayBasedCollectionDescriptor;
import org.openjdk.jmc.joverflow.descriptors.AbstractCollectionDescriptor;
import org.openjdk.jmc.joverflow.descriptors.CollectionInstanceDescriptor;
import org.openjdk.jmc.joverflow.heap.model.JavaClass;
import org.openjdk.jmc.joverflow.heap.model.JavaHeapObject;
import org.openjdk.jmc.joverflow.heap.model.JavaInt;
import org.openjdk.jmc.joverflow.heap.model.JavaObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObjectArray;
import org.openjdk.jmc.joverflow.heap.model.JavaThing;

public class ArrayBasedCollectionDescriptor
extends AbstractArrayBasedCollectionDescriptor {
    private final boolean jdk8HashMap;
    final Factory factory;

    ArrayBasedCollectionDescriptor(JavaObject col, Factory factory) {
        this(col, factory, false);
    }

    ArrayBasedCollectionDescriptor(JavaObject col, Factory factory, boolean jdk8HashMap) {
        super(col, factory);
        this.factory = factory;
        this.jdk8HashMap = jdk8HashMap;
    }

    @Override
    public int getNumElements() {
        return ((JavaInt)this.fields[this.factory.sizeFieldIdx]).getValue();
    }

    @Override
    public int doGetImplSize() {
        int implSize = this.getDirectImplSize();
        if (!this.factory.getClassDescriptor().isMap()) {
            return implSize;
        }
        return implSize + this.getMapEntriesImplSize();
    }

    @Override
    public int getMapEntriesImplSize() {
        return this.jdk8HashMap ? this.getMapBinsImplSize() : super.getMapEntriesImplSize();
    }

    @Override
    public void iterateMap(CollectionInstanceDescriptor.MapIteratorCallback cb) {
        if (this.jdk8HashMap) {
            this.iterateMapEntryOrTree(cb);
        } else {
            super.iterateMap(cb);
        }
    }

    private int preOrderTraverseTree(JavaObject root) {
        if (root == null) {
            return 0;
        }
        int size = root.getSize();
        JavaThing leftField = root.getField(this.factory.leftFieldName);
        if (!(leftField instanceof JavaObject)) {
            return 0;
        }
        size += this.preOrderTraverseTree((JavaObject)leftField);
        JavaThing rightField = root.getField(this.factory.rightFieldName);
        if (!(rightField instanceof JavaObject)) {
            return 0;
        }
        return size += this.preOrderTraverseTree((JavaObject)rightField);
    }

    private void preOrderTraverseTree(JavaObject root, CollectionInstanceDescriptor.MapIteratorCallback cb) {
        JavaHeapObject value;
        if (root == null) {
            return;
        }
        JavaThing entryOrTreeNode = root.getField("entry");
        if (entryOrTreeNode == null || !(entryOrTreeNode instanceof JavaObject)) {
            return;
        }
        JavaThing keyThing = ((JavaObject)entryOrTreeNode).getField(this.factory.getKeyFieldIdx((JavaObject)entryOrTreeNode));
        JavaHeapObject key = keyThing instanceof JavaHeapObject ? (JavaHeapObject)keyThing : null;
        JavaThing valueThing = ((JavaObject)entryOrTreeNode).getField(this.factory.getValueFieldIdx((JavaObject)entryOrTreeNode));
        JavaHeapObject javaHeapObject = value = valueThing instanceof JavaHeapObject ? (JavaHeapObject)valueThing : null;
        if (!cb.scanMapEntry(key, value)) {
            return;
        }
        if (root.getField(this.factory.leftFieldName) instanceof JavaObject) {
            this.preOrderTraverseTree((JavaObject)root.getField(this.factory.leftFieldName), cb);
        }
        if (root.getField(this.factory.rightFieldName) instanceof JavaObject) {
            this.preOrderTraverseTree((JavaObject)root.getField(this.factory.rightFieldName), cb);
        }
    }

    /*
     * Unable to fully structure code
     */
    private int getMapBinsImplSize() {
        numEls = this.getNumElements();
        if (numEls == 0) {
            return 0;
        }
        binsArray = this.getElementsArray();
        if (binsArray == null) {
            return 0;
        }
        bins = binsArray.getElements();
        binsFields = null;
        size = 0;
        var9_6 = bins;
        var8_7 = bins.length;
        var7_8 = 0;
        while (var7_8 < var8_7) {
            block6: {
                block7: {
                    binThing = var9_6[var7_8];
                    if (binThing == null || !(binThing instanceof JavaObject)) break block6;
                    bin = (JavaObject)binThing;
                    if (bin.getField("root") != null) break block7;
                    nextFieldIdx = this.factory.getEntryNextFieldIdx(bin);
                    if (nextFieldIdx != -1) ** GOTO lbl25
                    return 0;
lbl-1000:
                    // 1 sources

                    {
                        bin.setVisitedAsCollectionImpl();
                        size += bin.getSize();
                        binsFields = bin.getFields(binsFields);
                        if (!(binsFields[nextFieldIdx] instanceof JavaObject) || (bin = (JavaObject)binsFields[nextFieldIdx]) == (prevBin = bin)) break block6;
lbl25:
                        // 2 sources

                        ** while (bin != null && !bin.isVisitedAsCollectionImpl())
                    }
lbl26:
                    // 1 sources

                    break block6;
                }
                treeRoot = bin.getField("root");
                if (treeRoot != null && treeRoot instanceof JavaObject) {
                    size += this.preOrderTraverseTree((JavaObject)treeRoot);
                }
            }
            ++var7_8;
        }
        return size;
    }

    private void iterateMapEntryOrTree(CollectionInstanceDescriptor.MapIteratorCallback cb) {
        JavaObjectArray entriesArray = this.getElementsArray();
        if (entriesArray == null) {
            return;
        }
        if (!cb.scanImplementationObject(entriesArray)) {
            return;
        }
        int numElements = this.getNumElements();
        if (numElements == 0) {
            return;
        }
        JavaHeapObject[] entries = entriesArray.getElements();
        JavaThing[] entryFields = null;
        int keyFieldIdx = -1;
        int valueFieldIdx = -1;
        int nextFieldIdx = -1;
        JavaHeapObject[] javaHeapObjectArray = entries;
        int n = entries.length;
        int n2 = 0;
        block0: while (n2 < n) {
            JavaHeapObject entryThing = javaHeapObjectArray[n2];
            if (entryThing != null && entryThing instanceof JavaObject) {
                JavaObject entry = (JavaObject)entryThing;
                if (keyFieldIdx < 0) {
                    keyFieldIdx = this.factory.getKeyFieldIdx(entry);
                    valueFieldIdx = this.factory.getValueFieldIdx(entry);
                    nextFieldIdx = this.factory.getEntryNextFieldIdx(entry);
                }
                if (entry.getField("root") == null) {
                    while (entry != null) {
                        JavaObject prevEntry;
                        JavaHeapObject value;
                        if (!cb.scanImplementationObject(entry)) break;
                        JavaThing keyThing = (entryFields = entry.getFields(entryFields))[keyFieldIdx];
                        JavaHeapObject key = keyThing instanceof JavaHeapObject ? (JavaHeapObject)keyThing : null;
                        JavaThing valueThing = entryFields[valueFieldIdx];
                        JavaHeapObject javaHeapObject = value = valueThing instanceof JavaHeapObject ? (JavaHeapObject)valueThing : null;
                        if (!cb.scanMapEntry(key, value)) break block0;
                        if (entryFields[nextFieldIdx] instanceof JavaObject && (entry = (JavaObject)entryFields[nextFieldIdx]) != (prevEntry = entry)) {
                            continue;
                        }
                        break;
                    }
                } else {
                    if (!cb.scanImplementationObject(entry)) break;
                    JavaThing root = entry.getField("root");
                    if (root instanceof JavaObject) {
                        this.preOrderTraverseTree((JavaObject)root, cb);
                    }
                }
            }
            ++n2;
        }
    }

    static class Factory
    extends AbstractArrayBasedCollectionDescriptor.Factory {
        private final int sizeFieldIdx;
        private final boolean jdk8HashMap;
        private final String leftFieldName;
        private final String rightFieldName;

        Factory(JavaClass clazz, boolean isMap, String sizeFieldName, String elsArrayFieldName, int initialCapacity, JavaClass[] implClasses, String[] parentColClassNames) {
            this(clazz, isMap, sizeFieldName, elsArrayFieldName, initialCapacity, implClasses, parentColClassNames, false);
        }

        Factory(JavaClass clazz, boolean isMap, String sizeFieldName, String elsArrayFieldName, int initialCapacity, JavaClass[] implClasses, String[] parentColClassNames, boolean jdk8HashMap) {
            super(clazz, isMap, elsArrayFieldName, initialCapacity, implClasses, parentColClassNames);
            this.sizeFieldIdx = clazz.getInstanceFieldIndex(sizeFieldName);
            this.jdk8HashMap = jdk8HashMap;
            this.leftFieldName = jdk8HashMap ? "left" : null;
            this.rightFieldName = jdk8HashMap ? "right" : null;
        }

        Factory(JavaClass clazz, AbstractArrayBasedCollectionDescriptor.Factory superclassFactory) {
            super(clazz, superclassFactory);
            this.sizeFieldIdx = ((Factory)superclassFactory).sizeFieldIdx;
            this.jdk8HashMap = ((Factory)superclassFactory).jdk8HashMap;
            this.leftFieldName = ((Factory)superclassFactory).leftFieldName;
            this.rightFieldName = ((Factory)superclassFactory).rightFieldName;
        }

        @Override
        AbstractCollectionDescriptor.Factory cloneForSubclass(JavaClass clazz) {
            return new Factory(clazz, this);
        }

        @Override
        ArrayBasedCollectionDescriptor get(JavaObject col) {
            return new ArrayBasedCollectionDescriptor(col, this, this.jdk8HashMap);
        }
    }
}

