/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.descriptors;

import java.util.logging.Logger;
import org.openjdk.jmc.joverflow.descriptors.AbstractCollectionDescriptor;
import org.openjdk.jmc.joverflow.descriptors.CollectionInstanceDescriptor;
import org.openjdk.jmc.joverflow.heap.model.JavaClass;
import org.openjdk.jmc.joverflow.heap.model.JavaHeapObject;
import org.openjdk.jmc.joverflow.heap.model.JavaLazyReadObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObjectArray;
import org.openjdk.jmc.joverflow.heap.model.JavaThing;
import org.openjdk.jmc.joverflow.heap.model.UnresolvedObject;
import org.openjdk.jmc.joverflow.support.Constants;

public class ConcurrentHashMapDescriptorForJdk8
extends AbstractCollectionDescriptor
implements CollectionInstanceDescriptor.CapacityDifferentFromSize,
Constants {
    private static final Logger LOGGER = Logger.getLogger("org.openjdk.jmc.joverflow.descriptors");
    private final Factory factory;
    private int cachedNumElements = -1;
    private int cachedTotalCapacity = -1;

    private ConcurrentHashMapDescriptorForJdk8(JavaObject col, Factory factory) {
        super(col);
        this.factory = factory;
    }

    private int getNumElementsForOneTable(JavaObjectArray table) {
        JavaHeapObject[] tableElems;
        int result = 0;
        JavaHeapObject[] javaHeapObjectArray = tableElems = table.getElements();
        int n = tableElems.length;
        int n2 = 0;
        while (n2 < n) {
            JavaHeapObject tabThing = javaHeapObjectArray[n2];
            if (tabThing != null && tabThing instanceof JavaObject) {
                ++result;
            }
            ++n2;
        }
        return result;
    }

    @Override
    public int getNumElements() {
        if (this.cachedNumElements != -1) {
            return this.cachedNumElements;
        }
        int result = 0;
        int[] index = new int[]{this.factory.tableFieldIdx, this.factory.nextTableFieldIdx};
        int i = 0;
        while (i < 2) {
            JavaThing tableField = this.fields[index[i]];
            if (tableField != null && tableField instanceof JavaObjectArray) {
                result += this.getNumElementsForOneTable((JavaObjectArray)tableField);
            }
            ++i;
        }
        this.cachedNumElements = result;
        return result;
    }

    @Override
    public void iterateList(CollectionInstanceDescriptor.ListIteratorCallback cb) {
        throw new UnsupportedOperationException();
    }

    private void iterateOneTable(JavaHeapObject[] table, CollectionInstanceDescriptor.MapIteratorCallback cb) {
        int keyFieldIdx = this.factory.nodeKeyFieldIdx;
        int valFieldIdx = this.factory.nodeValFieldIdx;
        int nextFieldIdx = this.factory.nodeNextFieldIdx;
        JavaThing[] nodeFields = null;
        JavaHeapObject[] javaHeapObjectArray = table;
        int n = table.length;
        int n2 = 0;
        block0: while (n2 < n) {
            JavaHeapObject nodeThing = javaHeapObjectArray[n2];
            if (nodeThing != null && nodeThing instanceof JavaObject) {
                JavaObject node = (JavaObject)nodeThing;
                while (cb.scanImplementationObject(node)) {
                    nodeFields = node.getFields(nodeFields);
                    JavaHeapObject key = null;
                    JavaThing keyThing = nodeFields[keyFieldIdx];
                    if (keyThing instanceof JavaHeapObject) {
                        key = (JavaHeapObject)keyThing;
                    }
                    JavaHeapObject val = null;
                    JavaThing valThing = nodeFields[valFieldIdx];
                    if (valThing instanceof JavaHeapObject) {
                        val = (JavaHeapObject)valThing;
                    }
                    if (!cb.scanMapEntry(key, val)) break block0;
                    JavaObject prevNode = node;
                    JavaThing nextNode = nodeFields[nextFieldIdx];
                    if (nextNode != null && nextNode instanceof JavaObject && (node = (JavaObject)nextNode) != prevNode) continue;
                }
            }
            ++n2;
        }
    }

    @Override
    public void iterateMap(CollectionInstanceDescriptor.MapIteratorCallback cb) {
        int[] index = new int[]{this.factory.tableFieldIdx, this.factory.nextTableFieldIdx};
        int i = 0;
        while (i < 2) {
            JavaObjectArray table;
            JavaThing tableThing = this.fields[index[i]];
            if (tableThing != null && tableThing instanceof JavaObjectArray && cb.scanImplementationObject(table = (JavaObjectArray)tableThing)) {
                JavaHeapObject[] tableElems = table.getElements();
                int numElements = this.getNumElements();
                if (numElements != 0) {
                    this.iterateOneTable(tableElems, cb);
                }
            }
            ++i;
        }
    }

    @Override
    public int getCapacity() {
        if (this.cachedTotalCapacity != -1) {
            return this.cachedTotalCapacity;
        }
        int totalCapacity = 0;
        int[] index = new int[]{this.factory.tableFieldIdx, this.factory.nextTableFieldIdx};
        int i = 0;
        while (i < 2) {
            JavaThing tableThing = this.fields[index[i]];
            if (tableThing != null && tableThing instanceof JavaObjectArray) {
                JavaObjectArray table = (JavaObjectArray)tableThing;
                totalCapacity += table.getLength();
            }
            ++i;
        }
        this.cachedTotalCapacity = totalCapacity;
        return totalCapacity;
    }

    private int getSizeOfOneTable(JavaObjectArray table) {
        int result = 0;
        JavaHeapObject[] javaHeapObjectArray = table.getElements();
        int n = javaHeapObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            JavaHeapObject nodeThing = javaHeapObjectArray[n2];
            if (nodeThing != null && nodeThing instanceof JavaObject) {
                JavaObject prev;
                JavaThing nextNodeThing;
                JavaObject node = (JavaObject)nodeThing;
                do {
                    JavaHeapObject val;
                    JavaThing nodeValField;
                    node.setVisitedAsCollectionImpl();
                    result += node.getSize();
                    JavaThing nodeKeyField = node.getField(this.factory.nodeKeyFieldIdx);
                    if (nodeKeyField != null && !(nodeKeyField instanceof UnresolvedObject)) {
                        if (nodeKeyField instanceof JavaLazyReadObject) {
                            key = (JavaLazyReadObject)nodeKeyField;
                            ((JavaLazyReadObject)key).setVisitedAsCollectionImpl();
                            result += key.getSize();
                        } else if (nodeKeyField instanceof JavaClass) {
                            key = (JavaClass)nodeKeyField;
                            result += ((JavaClass)key).getSize();
                        } else {
                            LOGGER.severe("Unexpected nodeKeyField: " + nodeKeyField.getClass().getName());
                        }
                    }
                    if ((nodeValField = node.getField(this.factory.nodeValFieldIdx)) == null || nodeValField instanceof UnresolvedObject) continue;
                    if (nodeValField instanceof JavaLazyReadObject) {
                        val = (JavaLazyReadObject)nodeValField;
                        ((JavaLazyReadObject)val).setVisitedAsCollectionImpl();
                        result += val.getSize();
                        continue;
                    }
                    if (nodeValField instanceof JavaClass) {
                        val = (JavaClass)nodeValField;
                        result += ((JavaClass)val).getSize();
                        continue;
                    }
                    LOGGER.severe("Unexpected nodeValField: " + nodeValField.getClass().getName());
                } while ((nextNodeThing = node.getField(this.factory.nodeNextFieldIdx)) != null && nextNodeThing instanceof JavaObject && (node = (JavaObject)nextNodeThing) != (prev = node));
            }
            ++n2;
        }
        return result;
    }

    @Override
    protected int doGetImplSize() {
        this.col.setVisitedAsCollectionImpl();
        int result = this.col.getSize();
        int[] index = new int[]{this.factory.tableFieldIdx, this.factory.nextTableFieldIdx};
        int i = 0;
        while (i < 2) {
            JavaThing tableThing = this.fields[index[i]];
            if (tableThing == null || !(tableThing instanceof JavaObjectArray)) {
                return result;
            }
            JavaObjectArray table = (JavaObjectArray)tableThing;
            table.setVisitedAsCollectionImpl();
            result += table.getSize();
            result += this.getSizeOfOneTable(table);
            ++i;
        }
        return result;
    }

    @Override
    Factory getFactory() {
        return this.factory;
    }

    @Override
    public int getSparsenessOverhead(int ptrSize) {
        int totalEls = 0;
        int totalCapacity = 0;
        int emptyTableOverhead = 0;
        int[] index = new int[]{this.factory.tableFieldIdx, this.factory.nextTableFieldIdx};
        int i = 0;
        while (i < 2) {
            JavaThing tableThing = this.fields[index[i]];
            if (tableThing != null && !(tableThing instanceof JavaObjectArray)) {
                JavaObjectArray table = (JavaObjectArray)tableThing;
                int nElsInTab = this.getNumElementsForOneTable(table);
                totalEls += nElsInTab;
                totalCapacity += table.getLength();
                if (nElsInTab == 0) {
                    emptyTableOverhead += table.getSize();
                }
            }
            ++i;
        }
        this.cachedTotalCapacity = totalCapacity;
        if (totalEls >= totalCapacity / 2) {
            return -1;
        }
        return (totalCapacity - totalEls) * ptrSize + emptyTableOverhead;
    }

    @Override
    public int getDefaultCapacity() {
        return 16;
    }

    @Override
    public long getModCount() {
        return 0L;
    }

    static class Factory
    extends AbstractCollectionDescriptor.Factory {
        private static final String TABLE_NAME = "table";
        private static final String NEXT_TABLE_NAME = "nextTable";
        private final int tableFieldIdx;
        private final int nextTableFieldIdx;
        private final int nodeKeyFieldIdx;
        private final int nodeValFieldIdx;
        private final int nodeNextFieldIdx;

        Factory(JavaClass mapClazz, JavaClass nodeClazz, JavaClass[] allImplClasses) {
            super(mapClazz, true, allImplClasses, null, false, new String[]{TABLE_NAME, NEXT_TABLE_NAME});
            this.tableFieldIdx = mapClazz.getInstanceFieldIndex(TABLE_NAME);
            this.nextTableFieldIdx = mapClazz.getInstanceFieldIndex(NEXT_TABLE_NAME);
            this.nodeKeyFieldIdx = nodeClazz.getInstanceFieldIndex("key");
            this.nodeValFieldIdx = nodeClazz.getInstanceFieldIndex("val");
            this.nodeNextFieldIdx = nodeClazz.getInstanceFieldIndex("next");
        }

        private Factory(JavaClass clazz, AbstractCollectionDescriptor.Factory superclassFactory) {
            super(clazz, superclassFactory);
            this.tableFieldIdx = ((Factory)superclassFactory).tableFieldIdx;
            this.nextTableFieldIdx = ((Factory)superclassFactory).nextTableFieldIdx;
            this.nodeKeyFieldIdx = ((Factory)superclassFactory).nodeKeyFieldIdx;
            this.nodeValFieldIdx = ((Factory)superclassFactory).nodeValFieldIdx;
            this.nodeNextFieldIdx = ((Factory)superclassFactory).nodeNextFieldIdx;
        }

        @Override
        CollectionInstanceDescriptor get(JavaObject col) {
            return new ConcurrentHashMapDescriptorForJdk8(col, this);
        }

        @Override
        AbstractCollectionDescriptor.Factory cloneForSubclass(JavaClass clazz) {
            return new Factory(clazz, this);
        }

        @Override
        protected boolean setModCountFieldIdx(JavaClass clazz) {
            return false;
        }
    }
}

