/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.common.util;

import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class FilterMatcher {
    public static final String REGEXP_PREFIX = "regexp:";
    private static final char KLEENE_STAR = '*';
    private static final String KLEENE_STAR_STRING = Character.toString('*');
    private static final String QUESTION_STRING = "?";
    private static final String SPACE_STRING = " ";
    private static final FilterMatcher instance = new FilterMatcher();
    private static volatile Pattern lastPattern;

    public static FilterMatcher getInstance() {
        return instance;
    }

    public boolean match(String stringToFilter, String filterString, boolean caseInsensitive) {
        if (FilterMatcher.isUseRegexp(filterString)) {
            String trimmedFilterString = filterString.substring(REGEXP_PREFIX.length()).trim();
            return this.regexpMatch(stringToFilter, trimmedFilterString);
        }
        return stringToFilter != null && this.regexpMatch(stringToFilter, FilterMatcher.kleeneToRegexp(filterString, caseInsensitive));
    }

    public boolean regexpMatch(String stringToFilter, String filterString) {
        Pattern pattern = lastPattern;
        if (pattern == null || !pattern.pattern().equals(filterString)) {
            try {
                pattern = Pattern.compile(filterString);
            }
            catch (Exception exception) {
                return false;
            }
            lastPattern = pattern;
        }
        return pattern.matcher(stringToFilter).matches();
    }

    public static String autoAddKleene(String filterText, Where where) {
        if (FilterMatcher.isUseRegexp(filterText)) {
            return filterText;
        }
        Object newText = filterText;
        if (!(where != Where.BEFORE && where != Where.BEFORE_AND_AFTER || filterText.startsWith(KLEENE_STAR_STRING))) {
            newText = "*" + (String)newText;
        }
        if (!(where != Where.AFTER && where != Where.BEFORE_AND_AFTER || filterText.endsWith(KLEENE_STAR_STRING))) {
            newText = (String)newText + "*";
        }
        return newText;
    }

    private static boolean isUseRegexp(String filterString) {
        return filterString.startsWith(REGEXP_PREFIX);
    }

    private static String kleeneToRegexp(String kleene, boolean caseInsensitive) {
        StringBuilder sb = new StringBuilder();
        if (caseInsensitive) {
            sb.append("(?iu)");
        }
        StringTokenizer st = new StringTokenizer(kleene, KLEENE_STAR_STRING + " ?", true);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            s = KLEENE_STAR_STRING.equals(s) ? ".*" : (QUESTION_STRING.equals(s) ? "." : (SPACE_STRING.equals(s) ? "[ \u00a0]" : Pattern.quote(s)));
            sb.append(s);
        }
        return sb.toString();
    }

    public static enum Where {
        BEFORE,
        AFTER,
        BEFORE_AND_AFTER;

    }
}

