/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.wizards;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Display;
import org.openjdk.jmc.ui.misc.AbstractWarningAction;
import org.openjdk.jmc.ui.misc.DialogToolkit;
import org.openjdk.jmc.ui.misc.DisplayToolkit;
import org.openjdk.jmc.ui.wizards.IWizardFactory;

public abstract class AbstractWizardUserAction
extends AbstractWarningAction
implements IWizardFactory {
    public AbstractWizardUserAction(String name, String description, ImageDescriptor imageDescriptor) {
        super(name, description, imageDescriptor);
    }

    @Override
    public void doExecute() throws Exception {
        final IWizard wizard = this.createWizard();
        if (wizard != null) {
            DisplayToolkit.safeAsyncExec(Display.getDefault(), new Runnable(){

                @Override
                public void run() {
                    DialogToolkit.openWizardWithHelp(wizard);
                }
            });
        }
    }

    @Override
    public IWizard createWizard() throws Exception {
        try {
            IWizard wizard = this.doCreateWizard();
            this.resetWarning();
            return wizard;
        }
        catch (Exception e) {
            this.setWarning(e.getLocalizedMessage());
            throw e;
        }
    }

    protected abstract IWizard doCreateWizard() throws Exception;
}

