/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.service.api;

import java.util.Map;
import org.jolokia.server.core.Version;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.config.Configuration;
import org.jolokia.server.core.service.api.ServerHandle;
import org.jolokia.server.core.util.NetworkUtil;
import org.json.simple.JSONObject;

public class AgentDetails {
    private String serverVendor;
    private String serverProduct;
    private String serverVersion;
    private String url;
    private Boolean secured;
    private final String agentVersion;
    private final String agentId;
    private String agentDescription;
    private boolean sealed;

    public AgentDetails(String pAgentId) {
        this.agentVersion = Version.getAgentVersion();
        this.agentId = pAgentId;
        if (this.agentId == null) {
            throw new IllegalArgumentException("No agent id given");
        }
        this.sealed = false;
    }

    public AgentDetails(Configuration pConfig, ServerHandle pServerHandle) {
        this(NetworkUtil.replaceExpression(pConfig.getConfig(ConfigKey.AGENT_ID)));
        this.agentDescription = pConfig.getConfig(ConfigKey.AGENT_DESCRIPTION);
        this.serverVendor = pServerHandle.getVendor();
        this.serverProduct = pServerHandle.getProduct();
        this.serverVersion = pServerHandle.getVersion();
    }

    public AgentDetails(Map<AgentDetailProperty, Object> pMsgData) {
        this.serverVendor = (String)pMsgData.get((Object)AgentDetailProperty.SERVER_VENDOR);
        this.serverProduct = (String)pMsgData.get((Object)AgentDetailProperty.SERVER_PRODUCT);
        this.serverVersion = (String)pMsgData.get((Object)AgentDetailProperty.SERVER_VERSION);
        this.url = (String)pMsgData.get((Object)AgentDetailProperty.URL);
        if (pMsgData.containsKey((Object)AgentDetailProperty.SECURED)) {
            this.secured = (Boolean)pMsgData.get((Object)AgentDetailProperty.SECURED);
        }
        this.agentVersion = (String)pMsgData.get((Object)AgentDetailProperty.AGENT_VERSION);
        this.agentDescription = (String)pMsgData.get((Object)AgentDetailProperty.AGENT_DESCRIPTION);
        this.agentId = (String)pMsgData.get((Object)AgentDetailProperty.AGENT_ID);
        if (this.agentId == null) {
            throw new IllegalArgumentException("No agent id given");
        }
        this.sealed = true;
    }

    public void updateAgentParameters(String pUrl, Boolean pSecured) {
        this.checkSeal();
        this.url = pUrl;
        this.secured = pSecured;
    }

    public void setUrl(String url) {
        this.checkSeal();
        this.url = url;
    }

    public void setSecured(Boolean pSecured) {
        this.checkSeal();
        this.secured = pSecured;
    }

    private void checkSeal() {
        if (this.sealed) {
            throw new IllegalStateException("Cannot update agent details because it is already initialized and sealed");
        }
    }

    public boolean isInitRequired() {
        return !this.sealed && (this.isUrlMissing() || this.isSecuredMissing());
    }

    public boolean isUrlMissing() {
        return this.url == null;
    }

    public boolean isSecuredMissing() {
        return this.secured == null;
    }

    public void seal() {
        this.sealed = true;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public JSONObject toJSONObject() {
        JSONObject resp = new JSONObject();
        this.add(resp, AgentDetailProperty.URL, this.url);
        if (this.secured != null) {
            this.add(resp, AgentDetailProperty.SECURED, this.secured);
        }
        this.add(resp, AgentDetailProperty.SERVER_VENDOR, this.serverVendor);
        this.add(resp, AgentDetailProperty.SERVER_PRODUCT, this.serverProduct);
        this.add(resp, AgentDetailProperty.SERVER_VERSION, this.serverVersion);
        this.add(resp, AgentDetailProperty.AGENT_VERSION, this.agentVersion);
        this.add(resp, AgentDetailProperty.AGENT_ID, this.agentId);
        this.add(resp, AgentDetailProperty.AGENT_DESCRIPTION, this.agentDescription);
        return resp;
    }

    public String toString() {
        return "AgentDetails{" + this.toJSONObject().toJSONString() + "}";
    }

    private void add(JSONObject pResp, AgentDetailProperty pKey, Object pValue) {
        if (pValue != null) {
            pResp.put((Object)pKey.toString().toLowerCase(), pValue);
        }
    }

    public static enum AgentDetailProperty {
        URL,
        SECURED,
        SERVER_VENDOR,
        SERVER_PRODUCT,
        SERVER_VERSION,
        AGENT_VERSION,
        AGENT_ID,
        AGENT_DESCRIPTION;


        String asKey() {
            return this.name().toLowerCase();
        }

        public static AgentDetailProperty fromKey(String pKey) {
            return AgentDetailProperty.valueOf(pKey.toUpperCase());
        }
    }
}

