/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.util;

import java.util.regex.Pattern;

public class MimeTypeUtil {
    public static String getResponseMimeType(String pRequestMimeType, String defaultMimeType, String pCallback) {
        if (pCallback != null && MimeTypeUtil.isValidCallback(pCallback)) {
            return "text/javascript";
        }
        if (pRequestMimeType != null) {
            return MimeTypeUtil.sanitize(pRequestMimeType);
        }
        return MimeTypeUtil.sanitize(defaultMimeType);
    }

    private static String sanitize(String mimeType) {
        for (String accepted : new String[]{"application/json", "text/plain"}) {
            if (!accepted.equalsIgnoreCase(mimeType)) continue;
            return accepted;
        }
        return "text/plain";
    }

    public static boolean isValidCallback(String pCallback) {
        Pattern validJavaScriptFunctionNamePattern = Pattern.compile("^[$A-Z_][0-9A-Z_$]*$", 2);
        return validJavaScriptFunctionNamePattern.matcher(pCallback).matches();
    }
}

