/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.pages;

import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.util.Environment;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.StreamModel;
import org.openjdk.jmc.flightrecorder.ui.common.DataPageToolkit;
import org.openjdk.jmc.flightrecorder.ui.common.FilterComponent;
import org.openjdk.jmc.flightrecorder.ui.common.FlavorSelector;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.pages.ChartAndTableUI;
import org.openjdk.jmc.flightrecorder.ui.selection.SelectionStoreActionToolkit;
import org.openjdk.jmc.ui.charts.IXDataRenderer;
import org.openjdk.jmc.ui.charts.RendererToolkit;
import org.openjdk.jmc.ui.charts.XYChart;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.ColumnMenusFactory;
import org.openjdk.jmc.ui.handlers.ActionToolkit;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.ActionUiToolkit;
import org.openjdk.jmc.ui.misc.ChartButtonGroup;
import org.openjdk.jmc.ui.misc.ChartCanvas;
import org.openjdk.jmc.ui.misc.ChartControlBar;
import org.openjdk.jmc.ui.misc.ChartTextCanvas;
import org.openjdk.jmc.ui.misc.PersistableSashForm;
import org.openjdk.jmc.ui.misc.TimelineCanvas;

abstract class ThreadsPageLayoutUI
extends ChartAndTableUI {
    private static final double Y_SCALE = (double)Display.getCurrent().getDPI().y / Environment.getNormalDPI();
    private static final String SCROLLED_COMPOSITE_NAME = Messages.ThreadsPage_SCROLLED_COMPOSITE_NAME;
    private static final String TABLE = "table";
    private static final String CHART = "chart";
    private static final String CANVAS_SASH = "canvasSash";
    private static final String PAGE_SASH = "pageSash";
    private static final String SELECTED = "selected";
    private static final int TIMELINE_HEIGHT = 40;
    private static final int X_OFFSET = 0;
    private static final int Y_OFFSET = 0;
    protected ChartControlBar controlBar;
    protected ChartTextCanvas textCanvas;
    protected IPageContainer pageContainer;
    private Composite zoomPanContainer;
    private ChartButtonGroup buttonGroup;
    private IItemCollection selectionItems;
    private IItemFilter pageFilter;
    private IRange<IQuantity> timeRange;
    protected SashForm canvasSash;
    private TimelineCanvas timelineCanvas;

    ThreadsPageLayoutUI(IItemFilter pageFilter, StreamModel model, Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state, String sectionTitle, IItemFilter tableFilter, Image icon, FlavorSelector.FlavorSelectorState flavorSelectorState, IAttribute<?> classifier) {
        super(pageFilter, model, parent, toolkit, pageContainer, state, sectionTitle, tableFilter, icon, flavorSelectorState, classifier);
    }

    @Override
    protected void init(IItemFilter pageFilter, StreamModel model, Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state, String sectionTitle, IItemFilter tableFilter, Image icon, FlavorSelector.FlavorSelectorState flavorSelectorState, IAttribute<?> classifier) {
        String legendSelection;
        this.pageFilter = pageFilter;
        this.model = model;
        this.pageContainer = pageContainer;
        this.form = DataPageToolkit.createForm(parent, toolkit, sectionTitle, icon);
        this.sash = new SashForm(this.form.getBody(), 512);
        toolkit.adapt((Composite)this.sash);
        this.setupTable(state, sectionTitle, tableFilter, classifier);
        this.setupChartContainers(toolkit);
        this.allChartSeriesActions = this.initializeChartConfiguration(state);
        IState chartState = state.getChild(CHART);
        ActionToolkit.loadCheckState((IState)chartState, this.allChartSeriesActions.stream());
        this.chartLegend = ActionUiToolkit.buildCheckboxViewer((Composite)this.chartContainer, this.allChartSeriesActions.stream());
        GridData gridData = new GridData(4, 4, false, true);
        gridData.widthHint = 180;
        this.chartLegend.getControl().setLayoutData((Object)gridData);
        DataPageToolkit.createChartTimestampTooltip(this.chartCanvas);
        DataPageToolkit.createChartTimestampTooltip(this.textCanvas);
        this.chart = new XYChart(pageContainer.getRecordingRange(), RendererToolkit.empty(), 0, Integer.valueOf(0), this.timelineCanvas, this.controlBar, this.buttonGroup);
        DataPageToolkit.setChart(this.chartCanvas, this.chart, pageContainer::showSelection);
        DataPageToolkit.setChart(this.textCanvas, this.chart, pageContainer::showSelection);
        SelectionStoreActionToolkit.addSelectionStoreRangeActions(pageContainer.getSelectionStore(), this.chart, (IAttribute<IRange<IQuantity>>)JfrAttributes.LIFETIME, NLS.bind((String)Messages.ChartAndTableUI_TIMELINE_SELECTION, (Object)this.form.getText()), (IContributionManager)this.chartCanvas.getContextMenu());
        SelectionStoreActionToolkit.addSelectionStoreRangeActions(pageContainer.getSelectionStore(), this.chart, (IAttribute<IRange<IQuantity>>)JfrAttributes.LIFETIME, NLS.bind((String)Messages.ChartAndTableUI_TIMELINE_SELECTION, (Object)this.form.getText()), (IContributionManager)this.textCanvas.getContextMenu());
        this.chartCanvas.setZoomOnClickListener(mouseDown -> this.buttonGroup.zoomOnClick(mouseDown));
        this.chartCanvas.setZoomToSelectionListener(() -> this.buttonGroup.zoomToSelection());
        this.chartCanvas.setTextCanvas(this.textCanvas);
        this.textCanvas.setChartCanvas(this.chartCanvas);
        this.controlBar.setChart(this.chart);
        this.controlBar.setChartCanvas(this.chartCanvas);
        this.controlBar.setTextCanvas(this.textCanvas);
        this.buttonGroup.createZoomPan(this.zoomPanContainer);
        this.timelineCanvas.setChart(this.chart);
        if (chartState != null && (legendSelection = chartState.getAttribute(SELECTED)) != null) {
            this.allChartSeriesActions.stream().filter(ia -> legendSelection.equals(ia.getId())).findFirst().ifPresent(a -> this.chartLegend.setSelection((ISelection)new StructuredSelection(a)));
        }
        if (state.getChild(PAGE_SASH) == null) {
            int[] nArray = new int[2];
            nArray[1] = 3;
            this.sash.setWeights(nArray);
        } else {
            PersistableSashForm.loadState((SashForm)this.sash, (IState)state.getChild(PAGE_SASH));
        }
        if (state.getChild(CANVAS_SASH) == null) {
            this.canvasSash.setWeights(new int[]{1, 4});
        } else {
            PersistableSashForm.loadState((SashForm)this.canvasSash, (IState)state.getChild(CANVAS_SASH));
        }
        this.flavorSelector = FlavorSelector.itemsWithTimerange(this.form, pageFilter, model.getItems(), pageContainer, this::onFlavorSelected, this::onSetRange, flavorSelectorState);
    }

    private void setupTable(IState state, String sectionTitle, IItemFilter tableFilter, IAttribute<?> classifier) {
        this.table = this.buildHistogram((Composite)this.sash, state.getChild(TABLE), classifier);
        MCContextMenuManager mm = MCContextMenuManager.create((Control)this.table.getManager().getViewer().getControl());
        ColumnMenusFactory.addDefaultMenus((ColumnManager)this.table.getManager(), (MCContextMenuManager)mm);
        this.table.getManager().getViewer().addSelectionChangedListener(e -> this.buildChart(true));
        this.table.getManager().getViewer().addSelectionChangedListener(e -> this.pageContainer.showSelection(this.table.getSelection().getItems()));
        SelectionStoreActionToolkit.addSelectionStoreActions(this.pageContainer.getSelectionStore(), this.table, NLS.bind((String)Messages.ChartAndTableUI_HISTOGRAM_SELECTION, (Object)sectionTitle), (IContributionManager)mm);
        this.tableFilterComponent = FilterComponent.createFilterComponent(this.table.getManager().getViewer().getControl(), this.table.getManager(), tableFilter, this.model.getItems().apply(this.pageFilter), this.pageContainer.getSelectionStore()::getSelections, this::onFilterChange);
        mm.add(this.tableFilterComponent.getShowFilterAction());
        mm.add(this.tableFilterComponent.getShowSearchAction());
    }

    private void setupChartContainers(FormToolkit toolkit) {
        final ScrolledComposite scChartContainer = new ScrolledComposite((Composite)this.sash, 768);
        scChartContainer.setData("name", (Object)SCROLLED_COMPOSITE_NAME);
        scChartContainer.setAlwaysShowScrollBars(false);
        scChartContainer.setExpandHorizontal(true);
        scChartContainer.setExpandVertical(true);
        scChartContainer.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                int width = ThreadsPageLayoutUI.this.controlBar.computeSize((int)-1, (int)-1).x;
                int height = ThreadsPageLayoutUI.this.controlBar.computeSize((int)-1, (int)-1).y + ThreadsPageLayoutUI.this.buttonGroup.computeSize((int)-1, (int)-1).y;
                if (width > 0 && height > 0) {
                    scChartContainer.setMinSize(scChartContainer.computeSize(width, height));
                    scChartContainer.removeListener(11, (Listener)this);
                }
            }
        });
        this.chartContainer = toolkit.createComposite((Composite)scChartContainer);
        this.chartContainer.setLayout((Layout)new GridLayout());
        this.chartContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        scChartContainer.setContent((Control)this.chartContainer);
        Listener resetListener = new Listener(){

            public void handleEvent(Event event) {
                ThreadsPageLayoutUI.this.onSetRange(false);
                ThreadsPageLayoutUI.this.table.getManager().getViewer().setSelection(null);
            }
        };
        this.controlBar = new ChartControlBar(this.chartContainer, resetListener, this.pageContainer.getRecordingRange());
        this.controlBar.setLayoutData((Object)new GridData(4, 4, false, false));
        this.buttonGroup = this.controlBar.getButtonGroup();
        Composite zoomPanAndChartContainer = toolkit.createComposite(this.chartContainer);
        zoomPanAndChartContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        zoomPanAndChartContainer.setLayout((Layout)new FormLayout());
        this.zoomPanContainer = toolkit.createComposite(zoomPanAndChartContainer);
        this.zoomPanContainer.setLayout((Layout)new FillLayout());
        FormData fd = new FormData();
        fd.height = 80;
        fd.width = 150;
        fd.bottom = new FormAttachment(100, -12);
        fd.right = new FormAttachment(100, -12);
        this.zoomPanContainer.setLayoutData((Object)fd);
        this.canvasSash = new SashForm(zoomPanAndChartContainer, 256);
        fd = new FormData();
        fd.right = new FormAttachment(100, -1);
        fd.top = new FormAttachment(0, 1);
        fd.left = new FormAttachment(0, 1);
        fd.bottom = new FormAttachment(100, -1);
        this.canvasSash.setLayoutData((Object)fd);
        toolkit.adapt((Composite)this.canvasSash);
        ScrolledComposite scText = new ScrolledComposite((Composite)this.canvasSash, 2560);
        GridData scTextGd = new GridData(4, 4, false, true);
        this.textCanvas = new ChartTextCanvas((Composite)scText);
        this.textCanvas.setLayoutData((Object)new GridData(4, 4, false, true));
        scTextGd.widthHint = 180;
        scText.setLayoutData((Object)scTextGd);
        scText.setContent((Control)this.textCanvas);
        scText.setAlwaysShowScrollBars(false);
        scText.setExpandHorizontal(true);
        scText.setExpandVertical(true);
        ScrolledComposite scChart = new ScrolledComposite((Composite)this.canvasSash, 2560);
        this.chartCanvas = new ChartCanvas((Composite)scChart);
        this.chartCanvas.setLayoutData((Object)new GridData(4, 4, true, true));
        scChart.setLayoutData((Object)new GridData(4, 4, true, true));
        scChart.setContent((Control)this.chartCanvas);
        scChart.setAlwaysShowScrollBars(true);
        scChart.setExpandHorizontal(true);
        scChart.setExpandVertical(true);
        this.timelineCanvas = new TimelineCanvas(this.chartContainer, this.chartCanvas, this.canvasSash, Y_SCALE);
        GridData gridData = new GridData(4, -1, true, false);
        gridData.heightHint = (int)(40.0 * Y_SCALE);
        this.timelineCanvas.setLayoutData((Object)gridData);
    }

    @Override
    protected void onFilterChange(IItemFilter filter) {
        IItemCollection items = this.getItems();
        if (this.tableFilterComponent.isVisible()) {
            this.table.show(items.apply(filter));
            this.tableFilterComponent.setColor(this.table.getAllRows().getRowCount());
        } else if (this.table != null) {
            this.table.show(items);
        }
    }

    private void onSetRange(Boolean useRange) {
        IRange<IQuantity> range = useRange != false ? this.timeRange : this.pageContainer.getRecordingRange();
        this.chart.setVisibleRange((IQuantity)range.getStart(), (IQuantity)range.getEnd());
        this.chart.resetZoomFactor();
        if (this.table != null) {
            this.table.getManager().getViewer().setSelection(null);
        }
        this.chartCanvas.resetLaneHeight();
        this.buildChart(true);
    }

    @Override
    public void saveTo(IWritableState writableState) {
        super.saveTo(writableState);
        PersistableSashForm.saveState((SashForm)this.sash, (IWritableState)writableState.createChild(PAGE_SASH));
        PersistableSashForm.saveState((SashForm)this.canvasSash, (IWritableState)writableState.createChild(CANVAS_SASH));
    }

    private void onFlavorSelected(IItemCollection items, IRange<IQuantity> timeRange) {
        this.selectionItems = items;
        this.timeRange = timeRange;
        this.table.show(this.getItems());
        Object[] tableInput = (Object[])this.table.getManager().getViewer().getInput();
        if (this.selectionItems != null && tableInput != null) {
            this.table.getManager().getViewer().setSelection((ISelection)new StructuredSelection(tableInput));
        } else {
            this.table.getManager().getViewer().setSelection(null);
        }
        this.chart.setVisibleRange((IQuantity)timeRange.getStart(), (IQuantity)timeRange.getEnd());
    }

    protected void buildChart(boolean resetLaneHeightControls) {
        IXDataRenderer rendererRoot = this.getChartRenderer(this.getItems(), this.table.getSelection());
        if (resetLaneHeightControls) {
            this.controlBar.resetLaneHeightToMinimum();
        }
        this.chartCanvas.replaceRenderer(rendererRoot);
        this.textCanvas.replaceRenderer(rendererRoot);
    }

    private IItemCollection getItems() {
        return this.selectionItems != null ? this.selectionItems.apply(this.pageFilter) : this.model.getItems().apply(this.pageFilter);
    }

    public void setTimeRange(IRange<IQuantity> range) {
        this.timeRange = range;
    }
}

