/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.common.subscription.internal;

import java.util.logging.Level;
import org.openjdk.jmc.rjmx.common.IConnectionHandle;
import org.openjdk.jmc.rjmx.common.RJMXCorePlugin;
import org.openjdk.jmc.rjmx.common.subscription.IMRIMetadataProvider;
import org.openjdk.jmc.rjmx.common.subscription.IMRIMetadataService;
import org.openjdk.jmc.rjmx.common.subscription.IMRISubscription;
import org.openjdk.jmc.rjmx.common.subscription.ISubscriptionService;
import org.openjdk.jmc.rjmx.common.subscription.IUpdatePolicy;
import org.openjdk.jmc.rjmx.common.subscription.MRI;
import org.openjdk.jmc.rjmx.common.subscription.internal.DefaultUpdatePolicy;
import org.openjdk.jmc.rjmx.common.subscription.internal.OneShotUpdatePolicy;
import org.openjdk.jmc.rjmx.common.subscription.internal.SimpleUpdatePolicy;

public final class UpdatePolicyToolkit {
    private static final String DEFAULT_UPDATE_INTERVAL = "defaultUpdateInterval";

    private UpdatePolicyToolkit() throws InstantiationException {
        throw new InstantiationException("Should not be instantiated!");
    }

    public static int getDefaultUpdateInterval() {
        return 1000;
    }

    public static void setUpdatePolicy(IConnectionHandle handle, MRI attributeDescriptor, IUpdatePolicy policy) {
        IMRIMetadataService metadataService = UpdatePolicyToolkit.getMetadataService(handle);
        if (metadataService == null) {
            return;
        }
        if (policy instanceof OneShotUpdatePolicy) {
            metadataService.setMetadata(attributeDescriptor, "UpdateTime", Integer.toString(0));
        } else if (policy instanceof SimpleUpdatePolicy) {
            SimpleUpdatePolicy s = (SimpleUpdatePolicy)policy;
            metadataService.setMetadata(attributeDescriptor, "UpdateTime", Integer.toString(s.getIntervalTime()));
        } else if (policy instanceof DefaultUpdatePolicy) {
            metadataService.setMetadata(attributeDescriptor, "UpdateTime", DEFAULT_UPDATE_INTERVAL);
        } else {
            throw new UnsupportedOperationException(String.valueOf(policy.getClass()) + "is not supported!");
        }
        UpdatePolicyToolkit.updateExistingSubscription(handle, attributeDescriptor);
    }

    private static void updateExistingSubscription(IConnectionHandle handle, MRI attributeDescriptor) {
        ISubscriptionService service = handle.getServiceOrNull(ISubscriptionService.class);
        if (service == null) {
            return;
        }
        IMRISubscription attributeSubscription = service.getMRISubscription(attributeDescriptor);
        if (attributeSubscription != null) {
            attributeSubscription.setUpdatePolicy(UpdatePolicyToolkit.getUpdatePolicy(handle, attributeDescriptor));
        }
    }

    public static IUpdatePolicy getUpdatePolicy(IConnectionHandle handle, MRI attributeDescriptor) {
        IMRIMetadataService metadataService = UpdatePolicyToolkit.getMetadataService(handle);
        if (metadataService != null) {
            return UpdatePolicyToolkit.getUpdatePolicy(metadataService.getMetadata(attributeDescriptor));
        }
        return DefaultUpdatePolicy.newPolicy();
    }

    public static IUpdatePolicy getUpdatePolicy(IMRIMetadataProvider info) {
        String update = (String)info.getMetadata("UpdateTime");
        if (update != null && !update.equals(DEFAULT_UPDATE_INTERVAL)) {
            try {
                int interval = Integer.parseInt(update);
                return interval == 0 ? OneShotUpdatePolicy.newPolicy() : SimpleUpdatePolicy.newPolicy(interval);
            }
            catch (NumberFormatException e) {
                RJMXCorePlugin.getDefault().getLogger().log(Level.WARNING, "Warning: The update_interval specified for attribute " + String.valueOf(info.getMRI()) + " is malformed. The default update time (" + Integer.toString(UpdatePolicyToolkit.getDefaultUpdateInterval()) + ") will be used instead.", e);
            }
        }
        return DefaultUpdatePolicy.newPolicy();
    }

    private static IMRIMetadataService getMetadataService(IConnectionHandle handle) {
        return handle.getServiceOrNull(IMRIMetadataService.class);
    }
}

