/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.unit;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openjdk.jmc.common.IMCClassLoader;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCMethod;
import org.openjdk.jmc.common.IMCModule;
import org.openjdk.jmc.common.IMCOldObject;
import org.openjdk.jmc.common.IMCOldObjectArray;
import org.openjdk.jmc.common.IMCOldObjectField;
import org.openjdk.jmc.common.IMCOldObjectGcRoot;
import org.openjdk.jmc.common.IMCPackage;
import org.openjdk.jmc.common.IMCStackTrace;
import org.openjdk.jmc.common.IMCThread;
import org.openjdk.jmc.common.IMCThreadGroup;
import org.openjdk.jmc.common.IMCType;
import org.openjdk.jmc.common.item.Attribute;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.messages.internal.Messages;
import org.openjdk.jmc.common.unit.BinaryPrefix;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.CustomUnitSelector;
import org.openjdk.jmc.common.unit.DecimalPrefix;
import org.openjdk.jmc.common.unit.DecimalUnitSelector;
import org.openjdk.jmc.common.unit.DisplayFormatter;
import org.openjdk.jmc.common.unit.IConstraint;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.KindOfQuantity;
import org.openjdk.jmc.common.unit.LinearKindOfQuantity;
import org.openjdk.jmc.common.unit.LinearUnit;
import org.openjdk.jmc.common.unit.QuantityConversionException;
import org.openjdk.jmc.common.unit.RangeContentType;
import org.openjdk.jmc.common.unit.TimestampKind;
import org.openjdk.jmc.common.unit.TimestampUnit;
import org.openjdk.jmc.common.util.LabeledIdentifier;
import org.openjdk.jmc.common.util.MethodToolkit;

public final class UnitLookup {
    private static final String UNIT_ID_SEPARATOR = ":";
    public static final LinearKindOfQuantity MEMORY = UnitLookup.createMemory();
    public static final LinearKindOfQuantity TIMESPAN = UnitLookup.createTimespan();
    public static final ContentType<Number> COUNT = UnitLookup.createCount();
    public static final ContentType<Number> INDEX = UnitLookup.createIndex();
    public static final ContentType<Number> IDENTIFIER = UnitLookup.createIdentifier();
    public static final KindOfQuantity<TimestampUnit> TIMESTAMP = UnitLookup.createTimestamp(TIMESPAN);
    public static final LinearKindOfQuantity PERCENTAGE = UnitLookup.createPercentage();
    public static final LinearKindOfQuantity NUMBER = UnitLookup.createNumber();
    public static final ContentType<Number> RAW_NUMBER = UnitLookup.createRawNumber();
    public static final ContentType<Long> RAW_LONG = UnitLookup.createRawLong();
    public static final ContentType<IUnit> UNIT = UnitLookup.createSyntheticContentType("unit");
    public static final ContentType<Object> UNKNOWN = UnitLookup.createSyntheticContentType("unknown");
    public static final ContentType<String> PLAIN_TEXT = UnitLookup.createStringContentType("text");
    public static final ContentType<IMCOldObject> OLD_OBJECT = UnitLookup.createSyntheticContentType("oldObject");
    public static final ContentType<IMCOldObjectArray> OLD_OBJECT_ARRAY = UnitLookup.createSyntheticContentType("oldObjectArray");
    public static final ContentType<IMCOldObjectField> OLD_OBJECT_FIELD = UnitLookup.createSyntheticContentType("oldObjectField");
    public static final ContentType<IMCOldObjectGcRoot> OLD_OBJECT_GC_ROOT = UnitLookup.createSyntheticContentType("oldObjectGcRoot");
    public static final ContentType<IMCMethod> METHOD = UnitLookup.createSyntheticContentType("method");
    public static final ContentType<IMCType> CLASS = UnitLookup.createJavaTypeContentType("class");
    public static final ContentType<IMCClassLoader> CLASS_LOADER = UnitLookup.createSyntheticContentType("classLoader");
    public static final ContentType<IMCPackage> PACKAGE = UnitLookup.createSyntheticContentType("package");
    public static final ContentType<IMCModule> MODULE = UnitLookup.createSyntheticContentType("module");
    public static final ContentType<IMCStackTrace> STACKTRACE = UnitLookup.createSyntheticContentType("stacktrace");
    public static final ContentType<IMCFrame> STACKTRACE_FRAME = UnitLookup.createSyntheticContentType("frame");
    public static final ContentType<IMCThread> THREAD = UnitLookup.createSyntheticContentType("thread");
    public static final ContentType<IMCThreadGroup> THREAD_GROUP = UnitLookup.createSyntheticContentType("threadGroup");
    public static final ContentType<LabeledIdentifier> LABELED_IDENTIFIER = UnitLookup.createSyntheticContentType("labeledIdentifier");
    public static final LinearKindOfQuantity ADDRESS = UnitLookup.createAddress();
    public static final LinearKindOfQuantity FREQUENCY = UnitLookup.createFrequency();
    public static final ContentType<Boolean> FLAG = UnitLookup.createFlag("boolean");
    public static final ContentType<IType<?>> TYPE = UnitLookup.createSyntheticContentType("type");
    public static final TimestampUnit EPOCH_MS = TIMESTAMP.getUnit("epochms");
    public static final TimestampUnit EPOCH_NS = TIMESTAMP.getUnit("epochns");
    public static final TimestampUnit EPOCH_S = TIMESTAMP.getUnit("epochs");
    public static final LinearUnit NUMBER_UNITY = NUMBER.getUnit(DecimalPrefix.NONE);
    public static final LinearUnit ADDRESS_UNITY = ADDRESS.getUnit(DecimalPrefix.NONE);
    public static final LinearUnit PERCENT_UNITY = PERCENTAGE.getUnit("");
    public static final LinearUnit PERCENT = PERCENTAGE.getUnit("%");
    public static final LinearUnit BYTE = MEMORY.getUnit(BinaryPrefix.NOBI);
    public static final LinearUnit GIBIBYTE = MEMORY.getUnit(BinaryPrefix.GIBI);
    public static final LinearUnit NANOSECOND = TIMESPAN.getUnit(DecimalPrefix.NANO);
    public static final LinearUnit MICROSECOND = TIMESPAN.getUnit(DecimalPrefix.MICRO);
    public static final LinearUnit MILLISECOND = TIMESPAN.getUnit(DecimalPrefix.MILLI);
    public static final LinearUnit SECOND = TIMESPAN.getUnit(DecimalPrefix.NONE);
    public static final LinearUnit MINUTE = TIMESPAN.getUnit("min");
    public static final LinearUnit HOUR = TIMESPAN.getUnit("h");
    public static final LinearUnit DAY = TIMESPAN.getUnit("d");
    public static final LinearUnit YEAR = TIMESPAN.getUnit("a");
    public static final LinearUnit HERTZ = FREQUENCY.getUnit(DecimalPrefix.NONE);
    public static final IAttribute<Number> NUMERICAL_ATTRIBUTE = Attribute.attr("numerical", "Numerical", "The numerical value of a quantity", RAW_NUMBER);
    public static final IAttribute<IUnit> UNIT_ATTRIBUTE = Attribute.attr("unit", "Unit", "The unit of a quantity", UNIT);
    private static final List<ContentType<?>> CONTENT_TYPES;
    private static final Map<String, RangeContentType<?>> RANGE_CONTENT_TYPES;
    public static final ContentType<IRange<IQuantity>> TIMERANGE;

    public static <M extends Comparable<? super M>> RangeContentType<M> getRangeType(ContentType<M> endPointType) {
        return RANGE_CONTENT_TYPES.get(endPointType.getIdentifier());
    }

    public static List<KindOfQuantity<?>> getKindsOfQuantity() {
        return Arrays.asList(MEMORY, TIMESPAN, TIMESTAMP, NUMBER, PERCENTAGE, FREQUENCY);
    }

    public static List<ContentType<?>> getAllContentTypes() {
        return CONTENT_TYPES;
    }

    public static IQuantity fromDate(Date timestamp) {
        return timestamp != null ? EPOCH_MS.quantity(timestamp.getTime()) : null;
    }

    public static Date toDate(IQuantity timestamp) {
        return timestamp != null ? new Date(timestamp.clampedLongValueIn(EPOCH_MS)) : null;
    }

    static Logger getLogger() {
        return Logger.getLogger("org.openjdk.jmc.common.unit");
    }

    public static <T> ContentType<T> createSyntheticContentType(String id) {
        ContentType contentType = new ContentType(id);
        contentType.addFormatter(new DisplayFormatter(contentType, "auto", "Default"));
        return contentType;
    }

    private static ContentType<Boolean> createFlag(String id) {
        LeafContentType<Boolean> contentType = new LeafContentType<Boolean>(id){

            @Override
            public boolean validate(Boolean value) {
                this.checkNull(value);
                return false;
            }

            @Override
            public String persistableString(Boolean value) {
                return value.toString();
            }

            @Override
            public Boolean parsePersisted(String persistedValue) throws QuantityConversionException {
                if (persistedValue.equals("true")) {
                    return Boolean.TRUE;
                }
                if (persistedValue.equals("false")) {
                    return Boolean.FALSE;
                }
                throw QuantityConversionException.unparsable(persistedValue, Boolean.TRUE, this);
            }

            @Override
            public String interactiveFormat(Boolean content) {
                return content.toString();
            }

            @Override
            public Boolean parseInteractive(String interactiveValue) throws QuantityConversionException {
                this.checkNull(interactiveValue);
                return Boolean.valueOf(interactiveValue);
            }
        };
        contentType.addFormatter(new DisplayFormatter<Boolean>(contentType, "auto", "Default"));
        return contentType;
    }

    private static ContentType<String> createStringContentType(String id) {
        LeafContentType<String> contentType = new LeafContentType<String>(id){

            @Override
            public boolean validate(String value) {
                this.checkNull(value);
                return false;
            }

            @Override
            public String persistableString(String value) {
                this.validate(value);
                return value;
            }

            @Override
            public String parsePersisted(String persistedValue) {
                this.checkNull(persistedValue);
                return persistedValue;
            }

            @Override
            public String interactiveFormat(String value) {
                this.validate(value);
                return value;
            }

            @Override
            public String parseInteractive(String interactiveValue) {
                this.checkNull(interactiveValue);
                return interactiveValue;
            }
        };
        contentType.addFormatter(new DisplayFormatter<String>(contentType, "auto", "Default"));
        return contentType;
    }

    private static ContentType<IMCType> createJavaTypeContentType(String id) {
        LeafContentType<IMCType> contentType = new LeafContentType<IMCType>(id){

            @Override
            public boolean validate(IMCType value) {
                this.checkNull(value);
                return false;
            }

            @Override
            public String persistableString(IMCType value) {
                return value.getFullName();
            }

            @Override
            public IMCType parsePersisted(String persistedValue) {
                this.checkNull(persistedValue);
                return MethodToolkit.typeFromBinaryJLS(persistedValue);
            }

            @Override
            public String interactiveFormat(IMCType value) {
                return value.getFullName();
            }

            @Override
            public IMCType parseInteractive(String interactiveValue) {
                this.checkNull(interactiveValue);
                return MethodToolkit.typeFromBinaryJLS(interactiveValue);
            }
        };
        contentType.addFormatter(new DisplayFormatter<IMCType>(contentType, "auto", "Default"));
        return contentType;
    }

    private static LinearKindOfQuantity createNumber() {
        LinearKindOfQuantity number = new LinearKindOfQuantity("number", "", EnumSet.range(DecimalPrefix.NONE, DecimalPrefix.NONE));
        number.addFormatter(new LinearKindOfQuantity.AutoFormatter(number, "Dynamic", 0.001, 1000000.0));
        number.addFormatter(new KindOfQuantity.ExactFormatter<LinearUnit>(number));
        number.addFormatter(new KindOfQuantity.VerboseFormatter<LinearUnit>(number));
        number.addFormatter(new LinearKindOfQuantity.AutoFormatter(number, "scientificNotation", "Scientific Notation", 1.0, 10.0, 3));
        number.addFormatter(new LinearKindOfQuantity.AutoFormatter(number, "engineeringNotation", "Engineering Notation", 1.0, 1000.0, 3));
        return number;
    }

    private static LinearKindOfQuantity createAddress() {
        LinearKindOfQuantity address = new LinearKindOfQuantity("address", "", EnumSet.range(DecimalPrefix.NONE, DecimalPrefix.NONE)){

            @Override
            public String interactiveFormat(IQuantity quantity) {
                return UnitLookup.formatHexNumber(quantity);
            }
        };
        address.addFormatter(new DisplayFormatter<IQuantity>((ContentType)address, "auto", "Dynamic"){

            @Override
            public String format(IQuantity quantity) {
                return UnitLookup.formatHexNumber(quantity);
            }
        });
        return address;
    }

    private static String formatHexNumber(IQuantity quantity) {
        return String.format("0x%08X", quantity.longValue());
    }

    private static ContentType<Number> createRawNumber() {
        ContentType<Number> contentType = new ContentType<Number>("raw number");
        contentType.addFormatter(new DisplayFormatter(contentType, "auto", "Value"));
        return contentType;
    }

    private static ContentType<Long> createRawLong() {
        ContentType<Long> contentType = new ContentType<Long>("raw long");
        contentType.addFormatter(new DisplayFormatter(contentType, "auto", "Value"));
        return contentType;
    }

    private static LinearKindOfQuantity createMemory() {
        LinearKindOfQuantity memory = new LinearKindOfQuantity("memory", "B", EnumSet.range(BinaryPrefix.NOBI, BinaryPrefix.PEBI), EnumSet.range(BinaryPrefix.NOBI, BinaryPrefix.YOBI));
        memory.addFormatter(new LinearKindOfQuantity.AutoFormatter(memory, "Dynamic", 1.0, 1024.0));
        memory.addFormatter(new KindOfQuantity.ExactFormatter<LinearUnit>(memory));
        memory.addFormatter(new KindOfQuantity.VerboseFormatter<LinearUnit>(memory));
        return memory;
    }

    private static LinearKindOfQuantity createFrequency() {
        LinearKindOfQuantity frequency = new LinearKindOfQuantity("frequency", "Hz", EnumSet.range(DecimalPrefix.NONE, DecimalPrefix.TERA), EnumSet.range(DecimalPrefix.QUECTO, DecimalPrefix.QUETTA));
        frequency.addFormatter(new LinearKindOfQuantity.AutoFormatter(frequency, "Dynamic"));
        frequency.addFormatter(new KindOfQuantity.ExactFormatter<LinearUnit>(frequency));
        frequency.addFormatter(new KindOfQuantity.VerboseFormatter<LinearUnit>(frequency));
        return frequency;
    }

    private static void addQuantities(Collection<ITypedQuantity<LinearUnit>> result, LinearUnit unit, Number ... numbers) {
        for (Number number : numbers) {
            result.add((ITypedQuantity<LinearUnit>)unit.quantity(number));
        }
    }

    private static LinearKindOfQuantity createTimespan() {
        LinearUnit[] units;
        EnumSet<DecimalPrefix> commonPrefixes = EnumSet.range(DecimalPrefix.PICO, DecimalPrefix.MILLI);
        commonPrefixes.add(DecimalPrefix.NONE);
        LinearKindOfQuantity timeSpan = new LinearKindOfQuantity("timespan", "s", commonPrefixes, EnumSet.range(DecimalPrefix.QUECTO, DecimalPrefix.QUETTA));
        LinearUnit second = timeSpan.atomUnit;
        LinearUnit minute = timeSpan.makeUnit("min", (ITypedQuantity<LinearUnit>)second.quantity(60L));
        LinearUnit hour = timeSpan.makeUnit("h", (ITypedQuantity<LinearUnit>)minute.quantity(60L));
        LinearUnit day = timeSpan.makeUnit("d", (ITypedQuantity<LinearUnit>)hour.quantity(24L));
        LinearUnit week = timeSpan.makeUnit("wk", (ITypedQuantity<LinearUnit>)day.quantity(7L));
        LinearUnit year = timeSpan.makeUnit("a", (ITypedQuantity<LinearUnit>)hour.quantity(8766L));
        for (LinearUnit unit : units = new LinearUnit[]{minute, hour, day, week, year}) {
            timeSpan.addUnit(unit);
        }
        TreeSet<ITypedQuantity<LinearUnit>> ticks = new TreeSet<ITypedQuantity<LinearUnit>>();
        UnitLookup.addQuantities(ticks, second, 1, 2, 4, 5, 10, 15, 30);
        UnitLookup.addQuantities(ticks, minute, 1, 2, 4, 5, 10, 15, 30);
        UnitLookup.addQuantities(ticks, hour, 1, 2, 4, 6, 12);
        UnitLookup.addQuantities(ticks, day, 1, 2, 4);
        UnitLookup.addQuantities(ticks, week, 1, 2, 4, 5, 10);
        UnitLookup.addQuantities(ticks, year, 0.25, 0.5, 1);
        DecimalUnitSelector yearSelector = new DecimalUnitSelector(timeSpan, year);
        CustomUnitSelector selector = new CustomUnitSelector(timeSpan, timeSpan.unitSelector, Arrays.asList(units), yearSelector, ticks);
        timeSpan.setDefaultSelector(selector);
        timeSpan.addFormatter(new LinearKindOfQuantity.DualUnitFormatter(timeSpan, "auto", "Human readable", timeSpan.getUnit(DecimalPrefix.NANO)));
        timeSpan.addFormatter(new LinearKindOfQuantity.AutoFormatter(timeSpan, "Dynamic"));
        timeSpan.addFormatter(new KindOfQuantity.ExactFormatter<LinearUnit>(timeSpan));
        timeSpan.addFormatter(new KindOfQuantity.VerboseFormatter<LinearUnit>(timeSpan));
        return timeSpan;
    }

    static DateFormat patchTimestamp(DateFormat df) {
        if (df instanceof SimpleDateFormat) {
            SimpleDateFormat sdf = (SimpleDateFormat)df;
            String pattern = sdf.toPattern();
            String newPattern = pattern.replaceFirst("s{2,4}", "ss.SSS");
            sdf.applyPattern(newPattern);
        }
        return df;
    }

    private static TimestampKind createTimestamp(LinearKindOfQuantity timespan) {
        TimestampKind timestampContentType = TimestampKind.buildContentType(timespan);
        timestampContentType.addFormatter(new DisplayFormatter<IQuantity>((ContentType)timestampContentType, "auto", "Dynamic"){

            @Override
            public String format(IQuantity quantity) {
                try {
                    Date date = new Date(quantity.longValueIn(TimestampKind.MILLIS_UNIT));
                    DateFormat df = UnitLookup.patchTimestamp(DateFormat.getDateTimeInstance(3, 2));
                    return df.format(date);
                }
                catch (QuantityConversionException e) {
                    return Messages.getString("UnitLookup_TIMESTAMP_OUT_OF_RANGE");
                }
            }
        });
        timestampContentType.addFormatter(new KindOfQuantity.ExactFormatter<TimestampUnit>(timestampContentType));
        timestampContentType.addFormatter(new KindOfQuantity.VerboseFormatter<TimestampUnit>(timestampContentType));
        return timestampContentType;
    }

    private static LinearKindOfQuantity createPercentage() {
        LinearKindOfQuantity percentage = new LinearKindOfQuantity("percentage", "%", EnumSet.range(DecimalPrefix.NONE, DecimalPrefix.NONE));
        LinearUnit percentUnit = percentage.atomUnit;
        LinearUnit unity = percentage.makeUnit("", (ITypedQuantity<LinearUnit>)percentUnit.quantity(100L));
        percentage.addUnit(unity);
        percentage.addFormatter(new LinearKindOfQuantity.AutoFormatter(percentage, "Dynamic", 0.001, 1000000.0));
        percentage.addFormatter(new KindOfQuantity.ExactFormatter<LinearUnit>(percentage));
        percentage.addFormatter(new KindOfQuantity.VerboseFormatter<LinearUnit>(percentage));
        percentage.addFormatter(new DisplayFormatter<IQuantity>(percentage, "accuracy2digits", "Accuracy 2 digits)"));
        percentage.addFormatter(new DisplayFormatter<IQuantity>(percentage, "accuracy0digits", "Accuracy 0 digits)"));
        percentage.addFormatter(new DisplayFormatter<IQuantity>(percentage, "accuracy1digit", "Accuracy 1 digit)"));
        percentage.addFormatter(new DisplayFormatter<IQuantity>(percentage, "accuracy3digits", "Accuracy 3 digits)"));
        return percentage;
    }

    private static ContentType<Number> createCount() {
        ContentType<Number> contentType = new ContentType<Number>("count");
        contentType.addFormatter(new DisplayFormatter(contentType, "auto", "Value"));
        return contentType;
    }

    private static ContentType<Number> createIdentifier() {
        ContentType<Number> contentType = new ContentType<Number>("identifier");
        contentType.addFormatter(new DisplayFormatter(contentType, "auto", "Value"));
        return contentType;
    }

    private static ContentType<Number> createIndex() {
        ContentType<Number> contentType = new ContentType<Number>("index");
        contentType.addFormatter(new DisplayFormatter(contentType, "auto", "Value"));
        return contentType;
    }

    public static String getUnitIdentifier(IUnit unit) {
        if (unit.getIdentifier() == null) {
            throw new IllegalArgumentException("Cannot get identifier for impersistable unit :" + String.valueOf(unit));
        }
        KindOfQuantity<?> ct = unit.getContentType();
        return ct.getIdentifier() + UNIT_ID_SEPARATOR + unit.getIdentifier();
    }

    public static IUnit getUnitOrDefault(String unitIdentifier) {
        IUnit unit = UnitLookup.getUnitOrNull(unitIdentifier);
        return unit == null ? NUMBER.getUnit(DecimalPrefix.NONE) : unit;
    }

    public static IUnit getUnitOrNull(String unitIdentifier) {
        ContentType<?> ct;
        String[] parts;
        if (unitIdentifier != null && (parts = unitIdentifier.split(UNIT_ID_SEPARATOR, 2)).length == 2 && (ct = UnitLookup.getContentType(parts[0])) instanceof KindOfQuantity) {
            Object unit = ((KindOfQuantity)ct).getUnit(parts[1]);
            if (unit != null) {
                return unit;
            }
            if (ct instanceof LinearKindOfQuantity) {
                LinearKindOfQuantity kindOfQuantity = (LinearKindOfQuantity)ct;
                String id = parts[1];
                LinearUnit linUnit = kindOfQuantity.getCachedUnit(id);
                if (linUnit != null) {
                    return linUnit;
                }
                try {
                    Object quantity = kindOfQuantity.parsePersisted(id);
                    return kindOfQuantity.makeCustomUnit((ITypedQuantity<LinearUnit>)quantity);
                }
                catch (QuantityConversionException e) {
                    UnitLookup.getLogger().log(Level.WARNING, e.getMessage(), e);
                }
            }
        }
        return null;
    }

    public static ContentType<?> getContentType(String identifier) {
        String[] parts = identifier.split(UNIT_ID_SEPARATOR, 2);
        if (parts.length > 2) {
            return UNKNOWN;
        }
        if (parts.length == 2) {
            identifier = parts[0];
        }
        for (ContentType<?> type : CONTENT_TYPES) {
            if (!identifier.equals(type.getIdentifier())) continue;
            return type;
        }
        return UNKNOWN;
    }

    static {
        ArrayList<KindOfQuantity<TimestampUnit>> quantityKinds = new ArrayList<KindOfQuantity<TimestampUnit>>();
        quantityKinds.add(MEMORY);
        quantityKinds.add(TIMESPAN);
        quantityKinds.add(TIMESTAMP);
        quantityKinds.add(PERCENTAGE);
        quantityKinds.add(NUMBER);
        quantityKinds.add(ADDRESS);
        quantityKinds.add(FREQUENCY);
        HashMap<String, RangeContentType<IQuantity>> rangeTypes = new HashMap<String, RangeContentType<IQuantity>>();
        for (KindOfQuantity kindOfQuantity : quantityKinds) {
            rangeTypes.put(kindOfQuantity.getIdentifier(), RangeContentType.create(kindOfQuantity));
        }
        RANGE_CONTENT_TYPES = Collections.unmodifiableMap(rangeTypes);
        ArrayList<ContentType<Object>> types = new ArrayList<ContentType<Object>>(quantityKinds);
        types.add(COUNT);
        types.add(INDEX);
        types.add(IDENTIFIER);
        types.add(LABELED_IDENTIFIER);
        types.add(PLAIN_TEXT);
        types.add(STACKTRACE);
        types.add(STACKTRACE_FRAME);
        types.add(METHOD);
        types.add(CLASS);
        types.add(CLASS_LOADER);
        types.add(PACKAGE);
        types.add(MODULE);
        types.add(THREAD);
        types.add(THREAD_GROUP);
        types.add(FLAG);
        types.add(TYPE);
        types.add(OLD_OBJECT);
        types.add(UNKNOWN);
        CONTENT_TYPES = Collections.unmodifiableList(types);
        TIMERANGE = UnitLookup.getRangeType(TIMESTAMP);
    }

    private static abstract class LeafContentType<T>
    extends ContentType<T>
    implements IPersister<T> {
        private LeafContentType(String identifier) {
            super(identifier);
        }

        protected final void checkNull(Object value) {
            if (value == null) {
                throw new NullPointerException();
            }
        }

        @Override
        public IConstraint<T> combine(IConstraint<?> other) {
            return this == other ? this : null;
        }

        @Override
        public IPersister<T> getPersister() {
            return this;
        }
    }
}

