/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.memleak;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openjdk.jmc.common.IDisplayable;
import org.openjdk.jmc.common.IMCOldObject;
import org.openjdk.jmc.common.IMCOldObjectArray;
import org.openjdk.jmc.common.IMCOldObjectField;
import org.openjdk.jmc.common.IMCOldObjectGcRoot;
import org.openjdk.jmc.common.IMCType;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.unit.IQuantity;

public class ReferenceTreeObject
implements IMCOldObject,
IDisplayable {
    private final List<ReferenceTreeObject> children = new ArrayList<ReferenceTreeObject>();
    private final Set<IItem> items = new HashSet<IItem>();
    private final Map<IQuantity, ReferenceTreeObject> oldObjectSamples = new HashMap<IQuantity, ReferenceTreeObject>();
    private String rootDescription;
    private IMCOldObject object;
    private int objectsKeptAliveCount;
    private ReferenceTreeObject parent;
    private IQuantity timestamp;
    private double leakRelevance;
    private int distanceFromRoot;
    public static final int FORMAT_PACKAGE = 1;
    public static final int FORMAT_FIELD = 2;
    public static final int FORMAT_STATIC_MODIFIER = 4;
    public static final int FORMAT_OTHER_MODIFIERS = 8;
    public static final int FORMAT_ARRAY_INFO = 16;

    ReferenceTreeObject(IQuantity timestamp, IMCOldObject object) {
        this.timestamp = timestamp;
        this.object = object;
        this.leakRelevance = -1.0;
        this.distanceFromRoot = 0;
    }

    void setDistanceFromRoot(int distance) {
        this.distanceFromRoot = distance;
    }

    public int getDistanceFromRoot() {
        return this.distanceFromRoot;
    }

    void setLeakRelevance(double relevance) {
        this.leakRelevance = relevance;
    }

    public double getLeakRelevance() {
        return this.leakRelevance;
    }

    void addChild(ReferenceTreeObject node) {
        if (!this.children.contains(node)) {
            this.children.add(node);
            node.setParent(this);
        }
    }

    void addItem(IItem item) {
        this.items.add(item);
    }

    public Set<IItem> getItems() {
        return this.items;
    }

    void addRoot(IMCOldObjectGcRoot root) {
        if (root != null) {
            this.rootDescription = root.toString();
        }
    }

    public String getRootDescription() {
        return this.rootDescription;
    }

    public IQuantity getAddress() {
        return this.object.getAddress();
    }

    public IMCOldObjectArray getReferrerArray() {
        return this.object.getReferrerArray();
    }

    public IMCOldObjectArray getArray() {
        if (this.getChildren().size() > 0) {
            return this.getChildren().get(0).getReferrerArray();
        }
        return null;
    }

    public List<ReferenceTreeObject> getChildren() {
        return this.children;
    }

    public IMCOldObjectField getReferrerField() {
        return this.object.getReferrerField();
    }

    public IMCOldObjectField getField() {
        if (this.getChildren().size() > 0) {
            return this.getChildren().get(0).getReferrerField();
        }
        return null;
    }

    public String getDescription() {
        return this.object.getDescription();
    }

    public int getObjectsKeptAliveCount() {
        return this.objectsKeptAliveCount;
    }

    public ReferenceTreeObject getParent() {
        return this.parent;
    }

    public IMCOldObject getReferrer() {
        return this.object.getReferrer();
    }

    public IQuantity getTimestamp() {
        return this.timestamp;
    }

    public IMCType getType() {
        return this.object.getType();
    }

    public int hashCode() {
        return this.object.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ReferenceTreeObject) {
            ReferenceTreeObject that = (ReferenceTreeObject)o;
            return that.getAddress().equals((Object)this.getAddress());
        }
        return false;
    }

    void incrementObjectsKeptAliveCount() {
        ++this.objectsKeptAliveCount;
    }

    public void setParent(ReferenceTreeObject parent) {
        this.parent = parent;
    }

    public ReferenceTreeObject getRootObject() {
        if (this.parent == null) {
            return this;
        }
        ReferenceTreeObject rto = this.parent;
        while (rto.getParent() != null) {
            rto = rto.getParent();
        }
        return rto;
    }

    public int getReferrerSkip() {
        return this.object.getReferrerSkip();
    }

    public Map<IQuantity, ReferenceTreeObject> getOldObjectSamples() {
        return Collections.unmodifiableMap(this.oldObjectSamples);
    }

    public void updateOldObjectSamples(ReferenceTreeObject oldobjectrefnode) {
        this.oldObjectSamples.put(oldobjectrefnode.getTimestamp(), oldobjectrefnode);
    }

    public String displayUsing(String hint) {
        int format = 0;
        switch (hint) {
            case "auto": {
                format = 7;
                break;
            }
            case "exact": 
            case "verbose": {
                format = 31;
            }
        }
        return this.toString(format);
    }

    public String toString(int displayFormatting) {
        Object text = this.getType().getTypeName();
        if ((displayFormatting & 1) != 0) {
            text = this.getType().getFullName();
        }
        if (this.getChildren().size() > 0 && this.getField() != null) {
            if ((displayFormatting & 2) != 0) {
                text = (String)text + "." + this.getField().getName();
            }
            if (this.getField().getModifier() != null) {
                String modifiers = Modifier.toString(this.getField().getModifier());
                if ((displayFormatting & 4) != 0 && (displayFormatting & 8) == 0) {
                    if (modifiers.contains("static")) {
                        text = "static " + (String)text;
                    }
                } else if ((displayFormatting & 8) != 0 && (displayFormatting & 4) == 0) {
                    String nonStaticModifiers = modifiers.replaceAll("static ", "");
                    if (!"".equals(nonStaticModifiers)) {
                        text = nonStaticModifiers + " " + (String)text;
                    }
                } else if ((displayFormatting & 4) != 0 && (displayFormatting & 8) != 0 && !"".equals(modifiers)) {
                    text = modifiers + " " + (String)text;
                }
            }
        }
        if ((displayFormatting & 0x10) != 0 && this.getArray() != null) {
            text = ((String)text).endsWith("[]") ? ((String)text).substring(0, ((String)text).length() - 1) + this.getArray().getIndex() + "/" + this.getArray().getSize() + "]" : (String)text + this.getArray().getIndex() + "/" + this.getArray().getSize();
        }
        return ((String)text).trim();
    }

    public static enum ReferenceTreeObjectType {
        Array,
        InstanceField,
        JavaObject,
        LeakObject;

    }
}

