/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.util;

import org.openjdk.jmc.common.IDisplayable;
import org.openjdk.jmc.common.IMCType;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;

public final class ClassEntry
implements Comparable<ClassEntry>,
IDisplayable {
    public static final ContentType<ClassEntry> CLASS_ENTRY = UnitLookup.createSyntheticContentType((String)"classEntry");
    private final IMCType type;
    private final IQuantity count;

    public ClassEntry(IMCType type, IQuantity count) {
        this.type = type;
        this.count = count;
    }

    @Override
    public int compareTo(ClassEntry o) {
        return this.count.compareTo((Object)o.count);
    }

    public String toString() {
        return this.getType().getFullName() + " (" + this.getCount().displayUsing("auto") + ")";
    }

    public IMCType getType() {
        return this.type;
    }

    public IQuantity getCount() {
        return this.count;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.count.clampedIntFloorIn((IUnit)UnitLookup.NUMBER_UNITY);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassEntry other = (ClassEntry)obj;
        if (this.count != other.count) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals((Object)other.type));
    }

    public String displayUsing(String formatHint) {
        return this.toString();
    }
}

