/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.security;

import org.openjdk.jmc.common.security.SecurityManagerFactory;

public class SecurelyStoredByteArray {
    private final String id;

    public SecurelyStoredByteArray(String id) {
        this.id = id;
    }

    public boolean exists() {
        return SecurityManagerFactory.getSecurityManager().hasKey(this.id);
    }

    public byte[] get() throws Exception {
        return (byte[])SecurityManagerFactory.getSecurityManager().get(this.id);
    }

    public void set(byte ... value) throws Exception {
        SecurityManagerFactory.getSecurityManager().storeWithKey(this.id, value);
    }

    public void remove() throws Exception {
        SecurityManagerFactory.getSecurityManager().withdraw(this.id);
    }
}

