/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.unit;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.openjdk.jmc.common.messages.internal.Messages;
import org.openjdk.jmc.common.unit.DecimalScaleFactor;
import org.openjdk.jmc.common.unit.DecimalUnitSelector;
import org.openjdk.jmc.common.unit.IPrefix;
import org.openjdk.jmc.common.unit.LinearKindOfQuantity;

public final class DecimalPrefix
extends Enum<DecimalPrefix>
implements IPrefix<DecimalPrefix> {
    public static final /* enum */ DecimalPrefix QUECTO = new DecimalPrefix(-30, 'q');
    public static final /* enum */ DecimalPrefix RONTO = new DecimalPrefix(-27, 'r');
    public static final /* enum */ DecimalPrefix YOCTO = new DecimalPrefix(-24, 'y');
    public static final /* enum */ DecimalPrefix ZEPTO = new DecimalPrefix(-21, 'z');
    public static final /* enum */ DecimalPrefix ATTO = new DecimalPrefix(-18, 'a');
    public static final /* enum */ DecimalPrefix FEMTO = new DecimalPrefix(-15, 'f');
    public static final /* enum */ DecimalPrefix PICO = new DecimalPrefix(-12, 'p');
    public static final /* enum */ DecimalPrefix NANO = new DecimalPrefix(-9, 'n');
    public static final /* enum */ DecimalPrefix MICRO = new DecimalPrefix(-6, "\u03bc", "u");
    public static final /* enum */ DecimalPrefix MILLI = new DecimalPrefix(-3, 'm');
    public static final /* enum */ DecimalPrefix CENTI = new DecimalPrefix(-2, 'c');
    public static final /* enum */ DecimalPrefix DECI = new DecimalPrefix(-1, 'd');
    public static final /* enum */ DecimalPrefix NONE = new DecimalPrefix(0, "");
    public static final /* enum */ DecimalPrefix DECA = new DecimalPrefix(1, "da");
    public static final /* enum */ DecimalPrefix HECTO = new DecimalPrefix(2, 'h');
    public static final /* enum */ DecimalPrefix KILO = new DecimalPrefix(3, 'k');
    public static final /* enum */ DecimalPrefix MEGA = new DecimalPrefix(6, 'M');
    public static final /* enum */ DecimalPrefix GIGA = new DecimalPrefix(9, 'G');
    public static final /* enum */ DecimalPrefix TERA = new DecimalPrefix(12, 'T');
    public static final /* enum */ DecimalPrefix PETA = new DecimalPrefix(15, 'P');
    public static final /* enum */ DecimalPrefix EXA = new DecimalPrefix(18, 'E');
    public static final /* enum */ DecimalPrefix ZETTA = new DecimalPrefix(21, 'Z');
    public static final /* enum */ DecimalPrefix YOTTA = new DecimalPrefix(24, 'Y');
    public static final /* enum */ DecimalPrefix RONNA = new DecimalPrefix(27, 'R');
    public static final /* enum */ DecimalPrefix QUETTA = new DecimalPrefix(30, 'Q');
    private static final DecimalPrefix[] THOUSANDS;
    private static final Map<String, DecimalPrefix> PREFIX_BY_SYMBOL;
    private final int powerOfTen;
    private final DecimalScaleFactor scaleFactor;
    private final double doubleMult;
    private final String symbol;
    private final String altSymbol;
    private final String englishName;
    private transient String localizedName;
    private static final /* synthetic */ DecimalPrefix[] $VALUES;

    public static DecimalPrefix[] values() {
        return (DecimalPrefix[])$VALUES.clone();
    }

    public static DecimalPrefix valueOf(String name) {
        return Enum.valueOf(DecimalPrefix.class, name);
    }

    private DecimalPrefix(int powerOf10, char prefixChar) {
        this(powerOf10, "" + prefixChar, null);
    }

    private DecimalPrefix(int powerOf10, String prefix) {
        this(powerOf10, prefix, null);
    }

    private DecimalPrefix(int powerOf10, String prefix, String altPrefix) {
        this.powerOfTen = powerOf10;
        this.symbol = prefix;
        this.altSymbol = altPrefix;
        this.englishName = this.name().toLowerCase(Locale.ENGLISH);
        this.localizedName = prefix.length() == 0 ? "" : Messages.getString("Prefix_" + this.identifier() + "_name", this.englishName);
        this.scaleFactor = DecimalScaleFactor.get(powerOf10);
        this.doubleMult = StrictMath.pow(10.0, powerOf10);
    }

    public static DecimalPrefix getPrefix(String symbol) {
        return PREFIX_BY_SYMBOL.get(symbol);
    }

    public static int getFloorLog10(double value) {
        return value == 0.0 ? 0 : (int)Math.floor(Math.log10(Math.abs(value)));
    }

    public static int getFloorLog1000(double value) {
        return value == 0.0 ? 0 : (int)Math.floor(Math.log10(Math.abs(value)) / 3.0);
    }

    public static DecimalPrefix getEngFloorPrefix(double value) {
        int idx = Math.max(0, DecimalPrefix.getFloorLog1000(value) - DecimalPrefix.QUECTO.powerOfTen / 3);
        return THOUSANDS[Math.min(idx, THOUSANDS.length - 1)];
    }

    public int powerOf10() {
        return this.powerOfTen;
    }

    @Override
    public DecimalScaleFactor scaleFactor() {
        return this.scaleFactor;
    }

    public DecimalScaleFactor valueFactorTo(DecimalPrefix targetPrefix) {
        return DecimalScaleFactor.get(this.powerOfTen - targetPrefix.powerOfTen);
    }

    public double doubleMult() {
        return this.doubleMult;
    }

    @Override
    public final String symbol() {
        return this.symbol;
    }

    @Override
    public final String altSymbol() {
        return this.altSymbol;
    }

    @Override
    public final String identifier() {
        return this.altSymbol != null ? this.altSymbol : this.symbol;
    }

    @Override
    public String localizedName() {
        return this.localizedName;
    }

    @Override
    public StringBuilder asExponentialStringBuilder(boolean multiplicationSign) {
        return this.scaleFactor.asExponentialStringBuilder(multiplicationSign);
    }

    public String toString() {
        return this.englishName;
    }

    @Override
    public LinearKindOfQuantity.LinearUnitSelector createUnitSelector(LinearKindOfQuantity kindOfQuantity, Iterable<DecimalPrefix> prefixes) {
        return new DecimalUnitSelector(kindOfQuantity, prefixes);
    }

    private static /* synthetic */ DecimalPrefix[] $values() {
        return new DecimalPrefix[]{QUECTO, RONTO, YOCTO, ZEPTO, ATTO, FEMTO, PICO, NANO, MICRO, MILLI, CENTI, DECI, NONE, DECA, HECTO, KILO, MEGA, GIGA, TERA, PETA, EXA, ZETTA, YOTTA, RONNA, QUETTA};
    }

    static {
        $VALUES = DecimalPrefix.$values();
        THOUSANDS = new DecimalPrefix[]{QUECTO, RONTO, YOCTO, ZEPTO, ATTO, FEMTO, PICO, NANO, MICRO, MILLI, NONE, KILO, MEGA, GIGA, TERA, EXA, PETA, ZETTA, YOTTA, RONNA, QUETTA};
        HashMap<String, DecimalPrefix> symbolMap = new HashMap<String, DecimalPrefix>();
        for (DecimalPrefix prefix : DecimalPrefix.values()) {
            DecimalPrefix old = symbolMap.put(prefix.symbol, prefix);
            assert (old == null);
            if (prefix.altSymbol == null) continue;
            old = symbolMap.put(prefix.altSymbol, prefix);
            assert (old == null);
        }
        PREFIX_BY_SYMBOL = symbolMap;
    }
}

