/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.greychart.providers;

import java.awt.Polygon;
import java.util.Iterator;
import org.openjdk.jmc.common.xydata.DataSeries;
import org.openjdk.jmc.common.xydata.IXYData;
import org.openjdk.jmc.greychart.XAxis;
import org.openjdk.jmc.greychart.YAxis;
import org.openjdk.jmc.greychart.impl.CancelService;
import org.openjdk.jmc.greychart.impl.LongWorldToDeviceConverter;
import org.openjdk.jmc.greychart.impl.OptimizingProvider;
import org.openjdk.jmc.greychart.impl.SamplePoint;
import org.openjdk.jmc.greychart.impl.WorldToDeviceConverter;
import org.openjdk.jmc.greychart.providers.AbstractSampler;
import org.openjdk.jmc.greychart.providers.IntegratingSubsamplingBuffer;
import org.openjdk.jmc.greychart.providers.SamplePointIterator;
import org.openjdk.jmc.greychart.providers.SubsamplingBuffer;

public final class SubsamplingProvider
implements OptimizingProvider {
    private final DataSeries<IXYData> m_dataSeries;
    private final double m_yMultiplier;
    private final XAxis m_xAxis;
    private AbstractSampler m_sampleBuffer;
    private long m_startX;
    private long m_endX;
    private int m_requestedResolution = 0;
    private long m_requestedStartX = Long.MIN_VALUE;
    private long m_requestedEndX = Long.MAX_VALUE;
    private volatile boolean dataChangeOccured;
    private final boolean m_integrate;
    private final CancelService m_cancelService;

    public SubsamplingProvider(DataSeries<IXYData> s, double yMultiplier, XAxis xAxis, CancelService cancelService, boolean integrate) {
        this.m_dataSeries = s;
        this.m_yMultiplier = yMultiplier;
        this.m_cancelService = cancelService;
        this.m_xAxis = xAxis;
        this.m_integrate = integrate;
    }

    @Override
    public boolean update() {
        if (this.isScheduleResample()) {
            this.scheduleResample(this.m_requestedResolution);
            this.dataChangeOccured = false;
            return true;
        }
        return false;
    }

    private boolean isScheduleResample() {
        return this.hasRangeChanged() || this.hasDataChanged() || this.isSampleBufferInvalid();
    }

    private boolean hasRangeChanged() {
        return this.m_startX != this.m_requestedStartX || this.m_endX != this.m_requestedEndX;
    }

    @Override
    public void setDataChanged(boolean changed) {
        this.dataChangeOccured = changed;
    }

    @Override
    public boolean hasDataChanged() {
        return this.dataChangeOccured;
    }

    private boolean isSampleBufferInvalid() {
        return this.m_sampleBuffer == null || this.m_sampleBuffer.getSize() != this.m_requestedResolution;
    }

    @Override
    public void setResolution(int resolution) {
        this.m_requestedResolution = resolution;
    }

    private void scheduleResample(int resolution) {
        this.m_sampleBuffer = this.createSampleBuffer(resolution);
        this.m_startX = this.m_requestedStartX;
        this.m_endX = this.m_requestedEndX;
    }

    @Override
    public Polygon getSamplesPolygon(LongWorldToDeviceConverter xWorldToDevice, WorldToDeviceConverter yWorldToDevice) {
        int deviceWidth = xWorldToDevice.getDeviceWidth();
        int resultingSamples = this.calculateResultingSamples(deviceWidth);
        int[] xs = new int[resultingSamples + 3];
        int[] ys = new int[resultingSamples + 3];
        int index = 0;
        if (yWorldToDevice.canCalculateDeviceCoordinate()) {
            Iterator<SamplePoint> it = this.getSamples(deviceWidth);
            block5: while (it.hasNext() && index < resultingSamples) {
                SamplePoint sp = it.next();
                xs[index] = sp.x;
                switch ((int)sp.count) {
                    case 0: {
                        assert (false);
                        continue block5;
                    }
                    case 1: {
                        ys[index++] = yWorldToDevice.getDeviceCoordinate(sp.y);
                        break;
                    }
                    case 2: {
                        ys[index] = yWorldToDevice.getDeviceCoordinate(sp.y);
                        xs[++index] = sp.x;
                        ys[index++] = yWorldToDevice.getDeviceCoordinate(sp.yOut);
                        break;
                    }
                    default: {
                        ys[index] = yWorldToDevice.getDeviceCoordinate(sp.y);
                        xs[++index] = sp.x;
                        ys[index] = yWorldToDevice.getDeviceCoordinate(sp.min);
                        xs[++index] = sp.x;
                        ys[index] = yWorldToDevice.getDeviceCoordinate(sp.max);
                        xs[++index] = sp.x;
                        ys[index++] = yWorldToDevice.getDeviceCoordinate(sp.yOut);
                    }
                }
            }
        }
        return new Polygon(xs, ys, index);
    }

    private int calculateResultingSamples(int deviceWidth) {
        int resultCount = 0;
        Iterator<SamplePoint> iter = this.getSamples(deviceWidth);
        while (iter.hasNext()) {
            resultCount += this.calculateNeededSamples(iter.next());
        }
        return resultCount;
    }

    private int calculateNeededSamples(SamplePoint sp) {
        switch ((int)sp.count) {
            case 0: {
                assert (false);
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 4;
    }

    private AbstractSampler createSampleBuffer(int width) {
        Iterator it = this.m_dataSeries.createIterator(this.m_requestedStartX, this.m_requestedEndX);
        if (!it.hasNext()) {
            return this.isIntegrate() ? new IntegratingSubsamplingBuffer(0) : new SubsamplingBuffer(0);
        }
        AbstractSampler sampleBuffer = this.isIntegrate() ? new IntegratingSubsamplingBuffer(width) : new SubsamplingBuffer(width);
        long worldWidth = this.m_xAxis.getMax().longValue() - this.m_xAxis.getMin().longValue();
        long leftEdge = this.m_xAxis.getMin().longValue();
        long rightEdge = leftEdge + worldWidth;
        IXYData leftMost = null;
        IXYData rightMost = null;
        IXYData rightMostWithin = null;
        IXYData leftMostWithin = null;
        while (it.hasNext() && this.m_cancelService.isNotCancelled()) {
            IXYData newData = (IXYData)it.next();
            long x = this.getXAsLong(newData);
            if (x < leftEdge && (leftMost == null || x >= this.getXAsLong(leftMost))) {
                leftMost = newData;
            } else if (x > rightEdge && (rightMost == null || x < this.getXAsLong(rightMost))) {
                rightMost = newData;
            }
            if (x < leftEdge || x > rightEdge) continue;
            this.addXYDataPoint(sampleBuffer, worldWidth, leftEdge, newData);
            if (leftMostWithin == null) {
                leftMostWithin = newData;
                rightMostWithin = newData;
                continue;
            }
            if (this.getXAsLong(leftMostWithin) > x) {
                leftMostWithin = newData;
                continue;
            }
            if (this.getXAsLong(rightMostWithin) > x) continue;
            rightMostWithin = newData;
        }
        if (this.isIntegrate()) {
            ((IntegratingSubsamplingBuffer)sampleBuffer).fixSamples();
        } else {
            leftMostWithin = leftMostWithin == null ? rightMost : leftMostWithin;
            IXYData iXYData = rightMostWithin = rightMostWithin == null ? leftMost : rightMostWithin;
            if (leftMost != null && leftMostWithin != null && this.getXAsLong(leftMostWithin) != leftEdge && this.getXAsLong(leftMost) < leftEdge) {
                this.addInterpolatedNormalizedPoint((SubsamplingBuffer)sampleBuffer, 0.0, leftMost, leftMostWithin, worldWidth, leftEdge);
            }
            if (rightMost != null && rightMostWithin != null && this.getXAsLong(rightMostWithin) != rightEdge && this.getXAsLong(rightMost) > rightEdge) {
                this.addInterpolatedNormalizedPoint((SubsamplingBuffer)sampleBuffer, 1.0, rightMostWithin, rightMost, worldWidth, leftEdge);
            }
        }
        return sampleBuffer;
    }

    private long getXAsLong(IXYData data) {
        return ((Number)data.getX()).longValue();
    }

    private long getYAsLong(IXYData data) {
        return ((Number)data.getY()).longValue();
    }

    private void addInterpolatedNormalizedPoint(SubsamplingBuffer sampleBuffer, double boundary, IXYData beforeData, IXYData afterData, long worldWidth, long leftEdge) {
        assert (!this.isIntegrate());
        double n1 = this.getNormalizedX(beforeData, worldWidth, leftEdge);
        double n2 = this.getNormalizedX(afterData, worldWidth, leftEdge);
        double y1 = this.getY(beforeData);
        double y2 = this.getY(afterData);
        double k = (y2 - y1) / (n2 - n1);
        double yResult = (boundary - n1) * k + y1;
        sampleBuffer.addDataPoint(boundary, yResult);
    }

    private double getY(IXYData data) {
        return ((Number)data.getY()).doubleValue();
    }

    private void addXYDataPoint(AbstractSampler sampleBuffer, long worldWidth, long leftEdge, IXYData data) {
        if (this.isIntegrate()) {
            this.addIntegratedXYDataPoint((IntegratingSubsamplingBuffer)sampleBuffer, worldWidth, leftEdge, data);
        } else {
            this.addNormalXYDataPoint((SubsamplingBuffer)sampleBuffer, worldWidth, leftEdge, data);
        }
    }

    private void addNormalXYDataPoint(SubsamplingBuffer sampleBuffer, long worldWidth, long leftEdge, IXYData data) {
        double n = this.getNormalizedX(data, worldWidth, leftEdge);
        double y = ((Number)data.getY()).doubleValue();
        sampleBuffer.addDataPoint(n, y);
    }

    private void addIntegratedValue(IntegratingSubsamplingBuffer sampleBuffer, long worldWidth, long leftEdge, long x, long y, long duration) {
        double n = this.getNormalizedX(x, worldWidth, leftEdge);
        double n2 = this.getNormalizedX(Math.min(leftEdge + worldWidth, x + duration), worldWidth, leftEdge);
        sampleBuffer.addDataPoint(n, n2, y);
    }

    private void addIntegratedXYDataPoint(IntegratingSubsamplingBuffer sampleBuffer, long worldWidth, long leftEdge, IXYData data) {
        this.addIntegratedValue(sampleBuffer, worldWidth, leftEdge, this.getXAsLong(data), this.getYAsLong(data), this.getYAsLong(data));
    }

    private double getNormalizedX(IXYData data, long worldWidth, long leftEdge) {
        return (double)(this.getXAsLong(data) - leftEdge) / (double)worldWidth;
    }

    private double getNormalizedX(long x, long worldWidth, long leftEdge) {
        return (double)(x - leftEdge) / (double)worldWidth;
    }

    @Override
    public DataSeries getDataSeries() {
        return this.m_dataSeries;
    }

    @Override
    public OptimizingProvider[] getChildren() {
        return new OptimizingProvider[0];
    }

    @Override
    public synchronized long getMaxX() {
        return this.m_endX;
    }

    @Override
    public synchronized long getMinX() {
        return this.m_startX;
    }

    @Override
    public double getMaxY() {
        return this.m_sampleBuffer == null ? Double.NaN : this.m_sampleBuffer.getMaxY() * this.m_yMultiplier;
    }

    @Override
    public double getMinY() {
        return this.m_sampleBuffer == null ? Double.NaN : this.m_sampleBuffer.getMinY() * this.m_yMultiplier;
    }

    @Override
    public WorldToDeviceConverter getYSampleToDeviceConverterFor(YAxis yAxis) {
        double minY = yAxis.getMin().doubleValue() / this.m_yMultiplier;
        double maxY = yAxis.getMax().doubleValue() / this.m_yMultiplier;
        return new WorldToDeviceConverter(yAxis.getRenderedHeight(), 0, minY, maxY);
    }

    @Override
    public synchronized void setRange(long start, long end) {
        this.m_requestedStartX = start;
        this.m_requestedEndX = end;
        this.update();
    }

    @Override
    public Iterator<SamplePoint> getSamples(int width) {
        return new SamplePointIterator(this.m_sampleBuffer.getSamples());
    }

    private boolean isIntegrate() {
        return this.m_integrate;
    }
}

