/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.EditorPart;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.joverflow.heap.model.Snapshot;
import org.openjdk.jmc.joverflow.ui.JOverflowPlugin;
import org.openjdk.jmc.joverflow.ui.JOverflowUi;
import org.openjdk.jmc.joverflow.ui.model.ModelLoader;
import org.openjdk.jmc.joverflow.ui.model.ModelLoaderListener;
import org.openjdk.jmc.joverflow.ui.model.ReferenceChain;
import org.openjdk.jmc.ui.misc.CompositeToolkit;
import org.openjdk.jmc.ui.misc.DialogToolkit;

public class JOverflowEditor
extends EditorPart {
    private final ExecutorService EXECUTOR_SERVICE = Executors.newSingleThreadExecutor();
    private FormToolkit mFormToolkit;
    private Composite mParentComposite;
    private ProgressIndicator mProgressIndicator;
    private JOverflowUi mJOverflowUi;
    private ModelLoader mLoader;
    private Snapshot mSnapshot;
    private Collection<ReferenceChain> mModel;
    private Future<?> mBackground;
    private final List<UiLoadedListener> mUiLoadedListeners = new ArrayList<UiLoadedListener>();

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        IPathEditorInput ipei = input instanceof IPathEditorInput ? (IPathEditorInput)input : (IPathEditorInput)input.getAdapter(IPathEditorInput.class);
        if (ipei == null) {
            throw new PartInitException("The JOverflow editor cannot handle the provided editor input");
        }
        this.loadModel(ipei);
    }

    private void loadModel(IPathEditorInput input) {
        if (this.mLoader != null) {
            this.mLoader.cancel();
            this.mLoader = null;
        }
        if (this.mBackground != null && !this.mBackground.isDone()) {
            this.mBackground.cancel(true);
        }
        if (this.mSnapshot != null) {
            this.mSnapshot.discard();
            this.mSnapshot = null;
        }
        this.setPartName(input.getName());
        final String inputPath = input.getPath().toOSString();
        this.mLoader = new ModelLoader(inputPath, new ModelLoaderListener(){
            private double worked = 0.0;

            @Override
            public void onProgressUpdate(double progress) {
                this.updateUi(progress);
            }

            @Override
            public void onModelLoaded(Snapshot snapshot, Collection<ReferenceChain> model) {
                JOverflowEditor.this.mSnapshot = snapshot;
                JOverflowEditor.this.mModel = model;
                this.updateUi(1.0);
                JOverflowEditor.this.getSite().getShell().getDisplay().asyncExec(() -> {
                    Control[] controlArray = JOverflowEditor.this.mParentComposite.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control child = controlArray[n2];
                        child.dispose();
                        ++n2;
                    }
                    JOverflowEditor.this.createJoverflowUi(JOverflowEditor.this.mParentComposite);
                    JOverflowEditor.this.mJOverflowUi.setModel(JOverflowEditor.this.mModel);
                });
            }

            @Override
            public void onModelLoadFailed(Throwable failure) {
                JOverflowEditor.this.getSite().getShell().getDisplay().asyncExec(() -> {
                    String message = failure.getLocalizedMessage();
                    DialogToolkit.showException((Shell)JOverflowEditor.this.getSite().getShell(), (String)("Could not open " + inputPath), (String)message, (Throwable)failure);
                    JOverflowEditor.this.getSite().getPage().closeEditor((IEditorPart)JOverflowEditor.this, false);
                });
            }

            private void updateUi(double progress) {
                JOverflowEditor.this.getSite().getShell().getDisplay().asyncExec(() -> {
                    if (JOverflowEditor.this.mProgressIndicator == null || JOverflowEditor.this.mProgressIndicator.isDisposed()) {
                        return;
                    }
                    if (progress < this.worked) {
                        JOverflowEditor.this.mProgressIndicator.beginTask(1);
                        this.worked = 0.0;
                    }
                    JOverflowEditor.this.mProgressIndicator.worked(progress - this.worked);
                    this.worked = progress;
                });
            }
        });
        this.mBackground = this.EXECUTOR_SERVICE.submit(this.mLoader);
    }

    public void createPartControl(Composite parent) {
        this.mParentComposite = parent;
        this.mFormToolkit = new FormToolkit(FlightRecorderUI.getDefault().getFormColors(Display.getCurrent()));
        this.mFormToolkit.setBorderStyle(0);
        this.createProgressIndicator(parent);
    }

    private void createProgressIndicator(Composite parent) {
        this.mProgressIndicator = CompositeToolkit.createWaitIndicator((Composite)this.mFormToolkit.createComposite(parent), (FormToolkit)this.mFormToolkit);
        this.mProgressIndicator.beginTask(1);
    }

    private void createJoverflowUi(Composite parent) {
        Form mForm = this.mFormToolkit.createForm(parent);
        mForm.setText("JOverflow");
        mForm.setImage(this.getTitleImage());
        this.mFormToolkit.decorateFormHeading(mForm);
        IToolBarManager manager = mForm.getToolBarManager();
        manager.add((IAction)new Action("Reset"){
            {
                this.setImageDescriptor(JOverflowPlugin.getDefault().getMCImageDescriptor("undo_edit.gif"));
            }

            public void run() {
                JOverflowEditor.this.mJOverflowUi.reset();
            }
        });
        mForm.updateToolBar();
        Composite body = mForm.getBody();
        body.setLayout((Layout)new FillLayout());
        this.mJOverflowUi = new JOverflowUi(body, 0);
        for (UiLoadedListener l : this.mUiLoadedListeners) {
            l.uiLoaded(this.mJOverflowUi);
        }
        parent.layout();
    }

    public void dispose() {
        super.dispose();
        if (this.mLoader != null) {
            this.mLoader.cancel();
        }
        if (this.mSnapshot != null) {
            this.mSnapshot.discard();
        }
    }

    public void setFocus() {
        if (this.mJOverflowUi != null) {
            this.mJOverflowUi.setFocus();
            return;
        }
        if (this.mProgressIndicator != null) {
            this.mProgressIndicator.setFocus();
            return;
        }
        this.mParentComposite.setFocus();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    JOverflowUi getJOverflowUi() {
        return this.mJOverflowUi;
    }

    Snapshot getSnapshot() {
        return this.mSnapshot;
    }

    void addUiLoadedListener(UiLoadedListener listener) {
        this.mUiLoadedListeners.add(listener);
        if (this.mJOverflowUi != null) {
            listener.uiLoaded(this.mJOverflowUi);
        }
    }

    void removeUiLoadedListener(UiLoadedListener listener) {
        this.mUiLoadedListeners.remove(listener);
    }

    static interface UiLoadedListener {
        public void uiLoaded(JOverflowUi var1);
    }
}

