/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.tabs.threads;

import jakarta.inject.Inject;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.openjdk.jmc.console.ui.actions.ResetToDefaultsAction;
import org.openjdk.jmc.console.ui.editor.IConsolePageContainer;
import org.openjdk.jmc.console.ui.editor.IConsolePageStateHandler;
import org.openjdk.jmc.console.ui.editor.internal.ConsoleFormPage;
import org.openjdk.jmc.console.ui.messages.internal.Messages;
import org.openjdk.jmc.console.ui.tabs.threads.DummyThreadsModel;
import org.openjdk.jmc.console.ui.tabs.threads.IThreadsModel;
import org.openjdk.jmc.console.ui.tabs.threads.ThreadMasterDetailBlock;
import org.openjdk.jmc.console.ui.tabs.threads.ThreadsModel;
import org.openjdk.jmc.rjmx.common.IConnectionHandle;
import org.openjdk.jmc.rjmx.ui.internal.CombinedChartSectionPart;
import org.openjdk.jmc.ui.misc.MCActionContributionItem;
import org.openjdk.jmc.ui.misc.MCLayoutFactory;

public class ThreadTab
implements IConsolePageStateHandler {
    private static final String CHART_ID = "threadsChart";
    private static final String TABLE_ID = "threadsTable";
    private static final String TAB_PAGE_ID = "org.openjdk.jmc.console.ui.tabs.threads.ThreadTab";
    private boolean m_platformThreadingMBeanPresent = true;
    private IThreadsModel m_model;
    private CombinedChartSectionPart m_graphSectionPart;
    private ThreadMasterDetailBlock m_masterDetailBlock;

    @Inject
    protected void createPageContent(final IConsolePageContainer page, IManagedForm managedForm, IConnectionHandle connection) {
        this.m_model = this.m_platformThreadingMBeanPresent ? new ThreadsModel(connection) : new DummyThreadsModel();
        ScrolledForm form = managedForm.getForm();
        Composite container = managedForm.getForm().getBody();
        container.setLayout(MCLayoutFactory.createFormPageLayout());
        IToolBarManager toolbarManager = form.getToolBarManager();
        toolbarManager.appendToGroup("first", (IContributionItem)new MCActionContributionItem((IAction)new ResetToDefaultsAction(){

            @Override
            protected void reset() {
                ThreadTab.this.m_graphSectionPart.restoreState(page.getDefaultConfig().getChild(ThreadTab.CHART_ID));
            }
        }));
        toolbarManager.update(true);
        IMemento state = page.loadConfig();
        int style = 258;
        this.m_graphSectionPart = new CombinedChartSectionPart(container, managedForm.getToolkit(), style, connection, state.getChild(CHART_ID));
        managedForm.addPart((IFormPart)this.m_graphSectionPart);
        this.m_graphSectionPart.getSection().setExpanded(false);
        MCLayoutFactory.addGrabOnExpandLayoutData((Section)this.m_graphSectionPart.getSection());
        this.m_masterDetailBlock = new ThreadMasterDetailBlock(container, managedForm, ((ConsoleFormPage)page).getSite(), this.m_model, state.getChild(TABLE_ID));
        this.m_masterDetailBlock.getSashForm().setLayoutData(MCLayoutFactory.createFormPageLayoutData());
        page.getEditor().addPageChangedListener(new IPageChangedListener(){

            public void pageChanged(PageChangedEvent event) {
                if (ThreadTab.TAB_PAGE_ID.equals(((FormPage)event.getSelectedPage()).getId())) {
                    ThreadTab.this.m_model.getPollManager().resume();
                } else {
                    ThreadTab.this.m_model.getPollManager().pause();
                }
            }
        });
        this.validateDependencies(page, connection);
    }

    private void validateDependencies(IConsolePageContainer page, IConnectionHandle connectionHandle) {
        MBeanServerConnection connection = (MBeanServerConnection)connectionHandle.getServiceOrNull(MBeanServerConnection.class);
        try {
            if (connection.queryNames(new ObjectName("java.lang:type=Threading"), null).isEmpty()) {
                page.presentError(Messages.ConsoleEditor_PLATFORM_MBEANS_UNAVAILABLE);
                this.m_platformThreadingMBeanPresent = false;
            }
        }
        catch (Exception exception) {
            page.presentError(Messages.ConsoleEditor_CONNECTION_LOST);
            this.m_platformThreadingMBeanPresent = false;
        }
    }

    @Override
    public void dispose() {
        if (this.m_model != null) {
            this.m_model.dispose();
            this.m_model = null;
        }
    }

    @Override
    public boolean saveState(IMemento state) {
        this.m_graphSectionPart.saveState(state.createChild(CHART_ID));
        this.m_masterDetailBlock.saveState(state.createChild(TABLE_ID));
        return true;
    }
}

