/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.subscription.internal;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.logging.Level;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.openjdk.jmc.rjmx.RJMXPlugin;
import org.openjdk.jmc.rjmx.subscription.internal.AbstractSyntheticAttribute;

public class MonitoredDeadlockedThreadCountAttribute
extends AbstractSyntheticAttribute {
    private ThreadMXBean m_threadMBean;

    public Object getValue(MBeanServerConnection connection) {
        ThreadMXBean threadMBean = this.getThreadMBean(connection);
        if (threadMBean == null) {
            return null;
        }
        long[] monitorDeadlockedThreads = threadMBean.findMonitorDeadlockedThreads();
        return monitorDeadlockedThreads == null ? 0 : monitorDeadlockedThreads.length;
    }

    private ThreadMXBean getThreadMBean(MBeanServerConnection connection) {
        if (this.m_threadMBean == null) {
            try {
                this.m_threadMBean = ManagementFactory.newPlatformMXBeanProxy(connection, "java.lang:type=Threading", ThreadMXBean.class);
            }
            catch (IOException e) {
                RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Unable to look up threading MX bean!", e);
            }
        }
        return this.m_threadMBean;
    }

    public void setValue(MBeanServerConnection connection, Object value) {
    }

    public boolean hasResolvedDependencies(MBeanServerConnection connection) {
        try {
            return connection.getMBeanInfo(new ObjectName("java.lang:type=Threading")) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

