/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.serializers.dot;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.openjdk.jmc.flightrecorder.JfrLoaderToolkit;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.stacktrace.FrameSeparator;
import org.openjdk.jmc.flightrecorder.stacktrace.graph.Edge;
import org.openjdk.jmc.flightrecorder.stacktrace.graph.GraphModelUtils;
import org.openjdk.jmc.flightrecorder.stacktrace.graph.Node;
import org.openjdk.jmc.flightrecorder.stacktrace.graph.StacktraceGraphModel;

public final class DotSerializer {
    private static final String DEFAULT_NAME = "Unnamed";
    private static final String DEFAULT_SHAPE = "box";
    private static final String DEFAULT_STYLE = "filled";
    private static final String DEFAULT_FILL_COLOR = "#f8f8f8";
    private static final String DEFAULT_TITLE_FONT_SIZE = "16";
    private static final String DEFAULT_FONT_NAME = "helvetica";
    private static final String DEFAULT_NODE_FILL_COLOR = "#e1e1e1";
    private static final String DEFAULT_EDGE_STYLE = "solid";
    private static final String DEFAULT_MIN_EDGE_WEIGHT = "2";
    private static final String DEFAULT_MAX_EDGE_WEIGHT = "40";
    private static final String DEFAULT_NODE_SIZE_ATTRIBUTE = "count";
    private static final String DEFAULT_MIN_NODE_FONT_SIZE = "8";
    private static final String DEFAULT_MAX_NODE_FONT_SIZE = "32";

    public static String toDot(StacktraceGraphModel model, int maxNodesRendered, Map<ConfigurationKey, String> configuration) {
        StringBuilder builder = new StringBuilder(2048);
        String graphName = DotSerializer.getConf(configuration, ConfigurationKey.Name, DEFAULT_NAME);
        builder.append(String.format("digraph \"%s\" {%n", graphName));
        int nodeCount = model.getNodes().size();
        if (nodeCount > maxNodesRendered) {
            String message = String.format("Too many nodes in current selection%n(max: %d, actual: %d)", maxNodesRendered, nodeCount);
            DotSerializer.emitMessage(builder, message, configuration);
            builder.append("}");
            return builder.toString();
        }
        if (nodeCount == 0) {
            DotSerializer.emitEmptyMessage(builder, "No graph data in current selection", configuration);
            builder.append("}");
            return builder.toString();
        }
        DotSerializer.createDefaultNodeSettingsEntry(builder, configuration);
        if (Boolean.valueOf(DotSerializer.getConf(configuration, ConfigurationKey.TitleArea, "false")).booleanValue()) {
            DotSerializer.createSubgraphNode(builder, graphName, configuration, model);
        }
        NodeConfigurator nodeConfigurator = new NodeConfigurator(model, configuration);
        model.getNodes().forEach(node -> DotSerializer.emitNode(builder, model, nodeConfigurator, node));
        EdgeConfigurator edgeConfigurator = new EdgeConfigurator(model, configuration);
        model.getEdges().forEach(edge -> DotSerializer.emitEdge(builder, model, edgeConfigurator, edge));
        builder.append("}");
        return builder.toString();
    }

    private static void createDefaultNodeSettingsEntry(StringBuilder builder, Map<ConfigurationKey, String> configuration) {
        builder.append("node [style=");
        builder.append(DotSerializer.getConf(configuration, ConfigurationKey.Style, DEFAULT_STYLE));
        builder.append(" fillcolor=\"");
        builder.append(DotSerializer.getConf(configuration, ConfigurationKey.Fillcolor, DEFAULT_FILL_COLOR));
        builder.append("\" fontname=\"");
        builder.append(DotSerializer.getConf(configuration, ConfigurationKey.Fontname, DEFAULT_FONT_NAME));
        builder.append("\"]\n");
    }

    private static void emitEdge(StringBuilder builder, StacktraceGraphModel model, EdgeConfigurator edgeConfigurator, Edge edge) {
        builder.append("N");
        builder.append(edge.getFrom().getNodeId());
        builder.append(" -> N");
        builder.append(edge.getTo().getNodeId());
        builder.append(" [label=\"");
        if (edgeConfigurator.useCount) {
            builder.append(edge.getCount());
        } else {
            builder.append(edge.getValue());
        }
        builder.append("\"");
        int weight = edgeConfigurator.getWeight(edge);
        if (weight >= 2) {
            builder.append(" weight=");
            builder.append(weight);
        }
        builder.append(edgeConfigurator.isMax(edge) ? " penwidth=2 " : " ");
        builder.append("color=\"");
        builder.append(edgeConfigurator.getColor(edge));
        builder.append("\" tooltip=\"");
        String tooltip = edgeConfigurator.generateTooltip(edge);
        builder.append(tooltip);
        builder.append("\" labeltooltip=\"");
        builder.append(tooltip);
        builder.append("\" style=\"");
        builder.append(edgeConfigurator.style);
        builder.append("\"]\n");
    }

    private static void emitNode(StringBuilder builder, StacktraceGraphModel model, NodeConfigurator configurator, Node node) {
        String percentOfSamples = String.format("%.3f %%", (double)node.getCount() * 100.0 / (double)model.getTotalTraceCount());
        builder.append("N");
        builder.append(node.getNodeId());
        builder.append(" [label=\"");
        builder.append(node.getFrame().getHumanReadableSeparatorSensitiveString());
        builder.append("\\nSamples: ");
        builder.append(node.getCount());
        builder.append(" (");
        builder.append(percentOfSamples);
        builder.append(")\" id=\"node");
        builder.append(node.getNodeId());
        builder.append("\" fontsize=");
        builder.append(configurator.getFontSize(node));
        builder.append(" shape=");
        builder.append(configurator.shape);
        builder.append(" tooltip=\"");
        builder.append(node.getFrame().getHumanReadableSeparatorSensitiveString());
        builder.append(" (");
        builder.append(percentOfSamples);
        builder.append(" %)\" color=\"");
        builder.append(configurator.color);
        builder.append("\" fillcolor=\"");
        builder.append(configurator.fillColor);
        builder.append("\"]\n");
    }

    private static void emitMessage(StringBuilder builder, String message, Map<ConfigurationKey, String> configuration) {
        String shape = DotSerializer.getConf(configuration, ConfigurationKey.NodeShape, DEFAULT_SHAPE);
        String color = DotSerializer.getConf(configuration, ConfigurationKey.NodeColor, "#b22b00");
        String fillColor = DotSerializer.getConf(configuration, ConfigurationKey.NodeFillColor, "#eddbd5");
        builder.append("message [label=\"");
        builder.append(message);
        builder.append("\" id=\"message\"");
        builder.append(" shape=");
        builder.append(shape);
        builder.append(" fontsize=5");
        builder.append(" color=\"");
        builder.append(color);
        builder.append("\" fillcolor=\"");
        builder.append(fillColor);
        builder.append("\"]\n");
    }

    private static void emitEmptyMessage(StringBuilder builder, String message, Map<ConfigurationKey, String> configuration) {
        builder.append("label= <<font color='gray' point-size='1'>");
        builder.append(message);
        builder.append("</font>>");
    }

    private static void createSubgraphNode(StringBuilder builder, String graphName, Map<ConfigurationKey, String> configuration, StacktraceGraphModel model) {
        builder.append("subgraph cluster_L { ");
        builder.append("\"");
        builder.append(graphName);
        builder.append("\" [shape=");
        builder.append(DotSerializer.getConf(configuration, ConfigurationKey.TitleShape, DEFAULT_SHAPE));
        builder.append(" fontsize=");
        builder.append(DotSerializer.getConf(configuration, ConfigurationKey.TitleFontSize, DEFAULT_TITLE_FONT_SIZE));
        builder.append(" label=\"");
        builder.append(graphName);
        builder.append("\\nTypes: ");
        builder.append(GraphModelUtils.getTypeNames((IItemCollection)model.getItems()));
        builder.append("\\lTotal samples = ");
        builder.append(model.getTotalTraceCount());
        builder.append("\\lTotal edge count = ");
        builder.append(model.getTotalEdgeCount());
        builder.append("\\l\" tooltip=\"");
        builder.append(graphName);
        builder.append("\"] }\n");
    }

    public static Map<ConfigurationKey, String> getDefaultConfiguration() {
        HashMap<ConfigurationKey, String> configuration = new HashMap<ConfigurationKey, String>();
        configuration.put(ConfigurationKey.Name, DEFAULT_NAME);
        configuration.put(ConfigurationKey.Fillcolor, DEFAULT_FILL_COLOR);
        configuration.put(ConfigurationKey.NodeFillColor, DEFAULT_NODE_FILL_COLOR);
        configuration.put(ConfigurationKey.Style, DEFAULT_STYLE);
        configuration.put(ConfigurationKey.TitleShape, DEFAULT_SHAPE);
        configuration.put(ConfigurationKey.TitleFontSize, DEFAULT_TITLE_FONT_SIZE);
        configuration.put(ConfigurationKey.NodeShape, DEFAULT_SHAPE);
        configuration.put(ConfigurationKey.NodeSizeAttribute, DEFAULT_NODE_SIZE_ATTRIBUTE);
        configuration.put(ConfigurationKey.MaxNodeFontSize, DEFAULT_MAX_NODE_FONT_SIZE);
        configuration.put(ConfigurationKey.MinNodeFontSize, DEFAULT_MIN_NODE_FONT_SIZE);
        configuration.put(ConfigurationKey.MaxEdgeWeight, DEFAULT_MAX_EDGE_WEIGHT);
        configuration.put(ConfigurationKey.MinEdgeWeight, DEFAULT_MIN_EDGE_WEIGHT);
        configuration.put(ConfigurationKey.EdgeStyle, DEFAULT_EDGE_STYLE);
        configuration.put(ConfigurationKey.Fontname, DEFAULT_FONT_NAME);
        return configuration;
    }

    private static String getConf(Map<ConfigurationKey, String> configuration, ConfigurationKey key, String defaultValue) {
        String value = configuration.get((Object)key);
        return value == null ? defaultValue : value;
    }

    public static void main(String[] args) throws IOException, CouldNotLoadRecordingException {
        if (args.length != 1) {
            System.out.println("Usage: DotSerializer <filename>\n");
            System.out.println("Serializes the execution sample events in a JFR file into a DOT file, suitable for visualizing with GraphViz.");
            System.exit(2);
        }
        File jfrFile = new File(args[0]);
        IItemCollection items = JfrLoaderToolkit.loadEvents((File)jfrFile);
        IItemCollection filteredItems = items.apply(JdkFilters.EXECUTION_SAMPLE);
        FrameSeparator frameSeparator = new FrameSeparator(FrameSeparator.FrameCategorization.METHOD, false);
        StacktraceGraphModel model = new StacktraceGraphModel(frameSeparator, filteredItems, null);
        Map<ConfigurationKey, String> configuration = DotSerializer.getDefaultConfiguration();
        configuration.put(ConfigurationKey.Name, jfrFile.getName());
        System.out.println(DotSerializer.toDot(model, 1000, configuration));
    }

    public static enum ConfigurationKey {
        Name,
        Style,
        Fillcolor,
        Fontname,
        TitleArea,
        TitleFontSize,
        TitleShape,
        NodeShape,
        NodeColor,
        NodeFillColor,
        MaxNodeFontSize,
        MinNodeFontSize,
        NodeSizeAttribute,
        EdgeWeightAttribute,
        EdgeStyle,
        MaxEdgeWeight,
        MinEdgeWeight;

    }

    private static final class NodeConfigurator {
        private static final String COUNT = "count";
        private final String shape;
        private final boolean useCount;
        private final double minCount;
        private final double maxCount;
        private final double minRange;
        private final double maxRange;
        private final int minFontSize;
        private final int maxFontSize;
        private final String color;
        private final String fillColor;

        public NodeConfigurator(StacktraceGraphModel model, Map<ConfigurationKey, String> configuration) {
            this.useCount = DotSerializer.getConf(configuration, ConfigurationKey.NodeSizeAttribute, "count").equals("count");
            this.minCount = model.findNodeMinCount();
            this.maxCount = model.findNodeMaxCount();
            if (this.useCount) {
                this.maxRange = this.maxCount;
                this.minRange = this.minCount;
            } else {
                this.maxRange = model.findNodeMaxWeight();
                this.minRange = model.findNodeMinWeight();
            }
            this.maxFontSize = Integer.parseInt(DotSerializer.getConf(configuration, ConfigurationKey.MaxNodeFontSize, DotSerializer.DEFAULT_MAX_NODE_FONT_SIZE));
            this.minFontSize = Integer.parseInt(DotSerializer.getConf(configuration, ConfigurationKey.MinNodeFontSize, DotSerializer.DEFAULT_MIN_NODE_FONT_SIZE));
            this.shape = DotSerializer.getConf(configuration, ConfigurationKey.NodeShape, DotSerializer.DEFAULT_SHAPE);
            this.color = DotSerializer.getConf(configuration, ConfigurationKey.NodeColor, "#b22b00");
            this.fillColor = DotSerializer.getConf(configuration, ConfigurationKey.NodeFillColor, "#eddbd5");
        }

        public int getFontSize(Node node) {
            double value = this.useCount ? (double)node.getCount() : node.getWeight();
            double fraction = (value - this.minRange) / (this.maxRange - this.minRange);
            return (int)Math.round((double)(this.maxFontSize - this.minFontSize) * fraction + (double)this.minFontSize);
        }
    }

    private static final class EdgeConfigurator {
        private final boolean useCount;
        private final double minWeight;
        private final double maxWeight;
        private final int minCount;
        private final int maxCount;
        private final double minRange;
        private final double maxRange;
        private final String style;

        public EdgeConfigurator(StacktraceGraphModel model, Map<ConfigurationKey, String> configuration) {
            this.useCount = DotSerializer.getConf(configuration, ConfigurationKey.NodeSizeAttribute, DotSerializer.DEFAULT_NODE_SIZE_ATTRIBUTE).equals(DotSerializer.DEFAULT_NODE_SIZE_ATTRIBUTE);
            this.minCount = model.findEdgeMinCount();
            this.maxCount = model.findEdgeMaxCount();
            if (this.useCount) {
                this.minRange = this.minCount;
                this.maxRange = this.maxCount;
            } else {
                this.minRange = model.findEdgeMinValue();
                this.maxRange = model.findEdgeMaxValue();
            }
            this.minWeight = Integer.parseInt(DotSerializer.getConf(configuration, ConfigurationKey.MinEdgeWeight, DotSerializer.DEFAULT_MIN_EDGE_WEIGHT));
            this.maxWeight = Integer.parseInt(DotSerializer.getConf(configuration, ConfigurationKey.MaxEdgeWeight, DotSerializer.DEFAULT_MAX_EDGE_WEIGHT));
            this.style = DotSerializer.getConf(configuration, ConfigurationKey.EdgeStyle, DotSerializer.DEFAULT_EDGE_STYLE);
        }

        public String generateTooltip(Edge e) {
            return e.getFrom().getFrame().getHumanReadableSeparatorSensitiveString() + " -> " + e.getTo().getFrame().getHumanReadableSeparatorSensitiveString() + " (" + this.getPercentage(e) + " %)";
        }

        private String getPercentage(Edge e) {
            double val = 0.0;
            val = this.useCount ? (double)e.getCount() / (double)this.maxCount : e.getValue() / this.maxRange;
            return String.format("%.3f", val);
        }

        public int getWeight(Edge edge) {
            double value = this.useCount ? (double)edge.getCount() : edge.getValue();
            double fraction = (value - this.minRange) / (this.maxRange - this.minRange);
            return (int)Math.round((this.maxWeight - this.minWeight) * fraction + this.minWeight);
        }

        public boolean isMax(Edge edge) {
            if (this.useCount) {
                return edge.getCount() == this.maxCount;
            }
            return edge.getValue() == this.maxRange;
        }

        public String getColor(Edge edge) {
            int color = 0xB20000;
            double value = this.useCount ? (double)edge.getCount() : edge.getValue();
            double fraction = (value - this.minRange) / (this.maxRange - this.minRange);
            int colorval = (int)((1.0 - fraction) * 178.0);
            color = color | colorval << 8 | colorval;
            return "#" + Integer.toHexString(color);
        }
    }
}

