/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.pages;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.IDisplayable;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemCollectionToolkit;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.QuantitiesToolkit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.ColorToolkit;
import org.openjdk.jmc.common.util.StateToolkit;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.IDataPageFactory;
import org.openjdk.jmc.flightrecorder.ui.IDisplayablePage;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.IPageDefinition;
import org.openjdk.jmc.flightrecorder.ui.IPageUI;
import org.openjdk.jmc.flightrecorder.ui.StreamModel;
import org.openjdk.jmc.flightrecorder.ui.common.AbstractDataPage;
import org.openjdk.jmc.flightrecorder.ui.common.CompositeKeyAccessorFactory;
import org.openjdk.jmc.flightrecorder.ui.common.DataPageToolkit;
import org.openjdk.jmc.flightrecorder.ui.common.DurationPercentileTable;
import org.openjdk.jmc.flightrecorder.ui.common.FilterComponent;
import org.openjdk.jmc.flightrecorder.ui.common.FlavorSelector;
import org.openjdk.jmc.flightrecorder.ui.common.ItemHistogram;
import org.openjdk.jmc.flightrecorder.ui.common.ItemHistogramWithInput;
import org.openjdk.jmc.flightrecorder.ui.common.ItemList;
import org.openjdk.jmc.flightrecorder.ui.common.ItemRow;
import org.openjdk.jmc.flightrecorder.ui.common.TypeLabelProvider;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.selection.SelectionStoreActionToolkit;
import org.openjdk.jmc.ui.charts.AWTChartToolkit;
import org.openjdk.jmc.ui.charts.IXDataRenderer;
import org.openjdk.jmc.ui.charts.RendererToolkit;
import org.openjdk.jmc.ui.charts.XYChart;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.ColumnMenusFactory;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.handlers.ActionToolkit;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.layout.SimpleLayout;
import org.openjdk.jmc.ui.layout.SimpleLayoutData;
import org.openjdk.jmc.ui.misc.ChartCanvas;
import org.openjdk.jmc.ui.misc.PersistableSashForm;

public class SocketIOPage
extends AbstractDataPage {
    private static final Color WRITE_COLOR = TypeLabelProvider.getColor("jdk.SocketWrite");
    private static final Color READ_COLOR = TypeLabelProvider.getColor("jdk.SocketRead");
    private static final Color WRITE_ALPHA_COLOR = ColorToolkit.withAlpha((Color)WRITE_COLOR, (int)80);
    private static final Color READ_ALPHA_COLOR = ColorToolkit.withAlpha((Color)READ_COLOR, (int)80);
    private static final IItemFilter TABLE_ITEMS = ItemFilters.type((String[])new String[]{"jdk.SocketRead", "jdk.SocketWrite"});
    private static final String TOTAL_TIME = "totalTime";
    private static final String MAX_TIME = "maxTime";
    private static final String AVG_TIME = "avgTime";
    private static final String STDDEV_TIME = "stddevTime";
    private static final String READ_COUNT = "readCount";
    private static final String WRITE_COUNT = "writeCount";
    private static final String READ_SIZE = "readSize";
    private static final String WRITE_SIZE = "writeSize";
    private static final String READ_EOS = "endOfStream";
    private static final String IO_TIMEOUT = "timeout";
    private static final String PERCENTILE_READ_TIME = "percentileReadTime";
    private static final String PERCENTILE_READ_COUNT = "percentileReadCount";
    private static final String PERCENTILE_WRITE_TIME = "percentileWriteTime";
    private static final String PERCENTILE_WRITE_COUNT = "percentileWriteCount";
    private static final IAccessorFactory<IDisplayable> HOST_AND_PORT_AF = CompositeKeyAccessorFactory.displayable(" : ", new IAccessorFactory[]{JdkAttributes.IO_ADDRESS, JdkAttributes.IO_PORT});
    private static final ItemHistogram.ItemHistogramBuilder HISTOGRAM = new ItemHistogram.ItemHistogramBuilder();
    private static final ItemList.ItemListBuilder LIST = new ItemList.ItemListBuilder();
    private static final DurationPercentileTable.DurationPercentileTableBuilder PERCENTILES = new DurationPercentileTable.DurationPercentileTableBuilder();
    private Map<HistogramType, ColumnManager.SelectionState> primaryTableSelection = new HashMap<HistogramType, ColumnManager.SelectionState>();
    private Map<HistogramType, ColumnManager.SelectionState> secondaryTableSelection = new HashMap<HistogramType, ColumnManager.SelectionState>();
    private ColumnManager.SelectionState itemListSelection;
    private ColumnManager.SelectionState percentileSelection;
    private Map<HistogramType, IItemFilter> primaryTableFilter = new HashMap<HistogramType, IItemFilter>();
    private Map<HistogramType, IItemFilter> secondaryTableFilter = new HashMap<HistogramType, IItemFilter>();
    private IItemFilter itemListFilter;
    private IRange<IQuantity> timelineRange;
    private IRange<IQuantity> durationRange;
    private IRange<IQuantity> sizeRange;
    private int tabFolderIndex = 0;
    public FlavorSelector.FlavorSelectorState flavorSelectorState;

    static {
        HISTOGRAM.addCountColumn();
        HISTOGRAM.addColumn(TOTAL_TIME, JdkAggregators.TOTAL_IO_TIME);
        HISTOGRAM.addColumn(MAX_TIME, JdkAggregators.MAX_IO_TIME);
        HISTOGRAM.addColumn(AVG_TIME, JdkAggregators.AVG_IO_TIME);
        HISTOGRAM.addColumn(STDDEV_TIME, JdkAggregators.STDDEV_IO_TIME);
        HISTOGRAM.addColumn(READ_COUNT, JdkAggregators.SOCKET_READ_COUNT);
        HISTOGRAM.addColumn(WRITE_COUNT, JdkAggregators.SOCKET_WRITE_COUNT);
        HISTOGRAM.addColumn(READ_SIZE, JdkAggregators.SOCKET_READ_SIZE);
        HISTOGRAM.addColumn(WRITE_SIZE, JdkAggregators.SOCKET_WRITE_SIZE);
        LIST.addColumn(JdkAttributes.IO_ADDRESS);
        LIST.addColumn(JdkAttributes.IO_HOST);
        LIST.addColumn(JdkAttributes.IO_PORT);
        LIST.addColumn(JfrAttributes.START_TIME);
        LIST.addColumn(JfrAttributes.END_TIME);
        LIST.addColumn(JfrAttributes.DURATION);
        LIST.addColumn(JdkAttributes.IO_SOCKET_BYTES_READ);
        LIST.addColumn(JdkAttributes.IO_SOCKET_BYTES_WRITTEN);
        LIST.addColumn(JfrAttributes.EVENT_THREAD);
        LIST.addColumn(JdkAttributes.IO_SOCKET_READ_EOS);
        LIST.addColumn(JdkAttributes.IO_TIMEOUT);
        PERCENTILES.addSeries(PERCENTILE_READ_TIME, Messages.SocketIOPage_ROW_SOCKET_READ, PERCENTILE_READ_COUNT, JdkAggregators.SOCKET_READ_COUNT.getName(), "jdk.SocketRead");
        PERCENTILES.addSeries(PERCENTILE_WRITE_TIME, Messages.SocketIOPage_ROW_SOCKET_WRITE, PERCENTILE_WRITE_COUNT, JdkAggregators.SOCKET_WRITE_COUNT.getName(), "jdk.SocketWrite");
    }

    private static TableSettings getTableSettings(IState state) {
        if (state == null) {
            return new TableSettings(TOTAL_TIME, Arrays.asList(new TableSettings.ColumnSettings("itemhistogram.key", Boolean.valueOf(false), Integer.valueOf(500), null), new TableSettings.ColumnSettings(TOTAL_TIME, Boolean.valueOf(true), Integer.valueOf(120), Boolean.valueOf(false)), new TableSettings.ColumnSettings(MAX_TIME, Boolean.valueOf(false), Integer.valueOf(120), Boolean.valueOf(false)), new TableSettings.ColumnSettings(AVG_TIME, Boolean.valueOf(false), Integer.valueOf(120), Boolean.valueOf(false)), new TableSettings.ColumnSettings(STDDEV_TIME, Boolean.valueOf(false), Integer.valueOf(120), Boolean.valueOf(false)), new TableSettings.ColumnSettings(READ_COUNT, Boolean.valueOf(false), Integer.valueOf(120), Boolean.valueOf(false)), new TableSettings.ColumnSettings(WRITE_COUNT, Boolean.valueOf(false), Integer.valueOf(120), Boolean.valueOf(false)), new TableSettings.ColumnSettings(READ_SIZE, Boolean.valueOf(false), Integer.valueOf(120), Boolean.valueOf(false)), new TableSettings.ColumnSettings(WRITE_SIZE, Boolean.valueOf(false), Integer.valueOf(120), Boolean.valueOf(false)), new TableSettings.ColumnSettings(READ_EOS, Boolean.valueOf(false), Integer.valueOf(80), Boolean.valueOf(false)), new TableSettings.ColumnSettings(IO_TIMEOUT, Boolean.valueOf(false), Integer.valueOf(50), Boolean.valueOf(false))));
        }
        return new TableSettings(state);
    }

    @Override
    public IPageUI display(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
        return new IOPageUi(parent, toolkit, pageContainer, state);
    }

    public SocketIOPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
        super(dpd, items, editor);
        this.timelineRange = editor.getRecordingRange();
        this.durationRange = editor.getRecordingRange();
        this.sizeRange = DataPageToolkit.buildSizeRange(items.getItems(), true);
    }

    @Override
    public IItemFilter getDefaultSelectionFilter() {
        return TABLE_ITEMS;
    }

    private static Color getColor(IItem item) {
        return "jdk.SocketRead".equals(item.getType().getIdentifier()) ? READ_ALPHA_COLOR : WRITE_ALPHA_COLOR;
    }

    static /* synthetic */ Color access$3(IItem iItem) {
        return SocketIOPage.getColor(iItem);
    }

    private static enum HistogramType {
        HOST,
        PORT,
        HOST_AND_PORT;

    }

    private class IOPageUi
    implements IPageUI {
        private static final String PRIMARY_FILTER = "primaryFilter";
        private static final String SECONDARY_FILTER = "secondaryFilter";
        private static final String EVENT_FILTER = "eventFilter";
        private static final String SASH_ELEMENT = "sash";
        private static final String LIST_ELEMENT = "eventList";
        private static final String SOCKETIO_TABLE_ELEMENT = "socketTable";
        private static final String SECONDARY_SOCKETIO_TABLE_ELEMENT = "secondarySocketTable";
        private static final String PERCENTILE_TABLE_ELEMENT = "percentileTable";
        private static final String HISTGRAM_TYPE = "histogramType";
        private final ChartCanvas timelineCanvas;
        private final ChartCanvas durationCanvas;
        private final ChartCanvas sizeCanvas;
        private final ItemList itemList;
        private final SashForm sash;
        private final IPageContainer pageContainer;
        private final Composite histogramParent;
        private ItemHistogram primaryHistogram;
        private Supplier<TableSettings> secondaryHistogramSettings;
        private Consumer<IItemCollection> itemConsumerRoot;
        private HistogramType histogramType;
        private ItemHistogram secondaryHistogram;
        private FilterComponent primaryFilter;
        private FilterComponent secondaryFilter;
        private FilterComponent eventFilter;
        private IRange<IQuantity> timeRange;
        private IItemCollection selectionItems;
        private XYChart timelineChart;
        private XYChart durationChart;
        private XYChart sizeChart;
        private CTabFolder tabFolder;
        private FlavorSelector flavorSelector;
        private DurationPercentileTable percentileTable;
        private Composite durationParent;

        IOPageUi(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
            this.pageContainer = pageContainer;
            Form form = DataPageToolkit.createForm(parent, toolkit, SocketIOPage.this.getName(), SocketIOPage.this.getIcon());
            this.sash = new SashForm(form.getBody(), 512);
            toolkit.adapt((Composite)this.sash);
            this.histogramParent = toolkit.createComposite((Composite)this.sash);
            this.histogramParent.setLayout((Layout)new FillLayout(512));
            this.histogramType = (HistogramType)StateToolkit.readEnum((IState)state, (String)HISTGRAM_TYPE, (Enum)HistogramType.HOST, HistogramType.class);
            this.buildHistograms(TableSettings.forState((IState)state.getChild(SOCKETIO_TABLE_ELEMENT)), TableSettings.forState((IState)state.getChild(SECONDARY_SOCKETIO_TABLE_ELEMENT)));
            this.tabFolder = new CTabFolder((Composite)this.sash, 0);
            toolkit.adapt((Composite)this.tabFolder);
            CTabItem t1 = new CTabItem(this.tabFolder, 0);
            t1.setToolTipText(Messages.IO_PAGE_TIMELINE_DESCRIPTION);
            this.timelineCanvas = new ChartCanvas((Composite)this.tabFolder);
            t1.setText(Messages.PAGES_TIMELINE);
            t1.setControl((Control)this.timelineCanvas);
            DataPageToolkit.createChartTimestampTooltip(this.timelineCanvas);
            this.timelineChart = new XYChart(pageContainer.getRecordingRange(), RendererToolkit.empty(), 180);
            this.timelineChart.setVisibleRange((IQuantity)SocketIOPage.this.timelineRange.getStart(), (IQuantity)SocketIOPage.this.timelineRange.getEnd());
            this.timelineChart.addVisibleRangeListener(r -> {
                IRange iRange = SocketIOPage.this.timelineRange = r;
            });
            IItemCollection socketItems = SocketIOPage.this.getDataSource().getItems().apply(JdkFilters.SOCKET_READ_OR_WRITE);
            IQuantity max = (IQuantity)socketItems.getAggregate(JdkAggregators.LONGEST_EVENT);
            max = max == null ? UnitLookup.MILLISECOND.quantity(20L) : max.add((IQuantity)UnitLookup.MILLISECOND.quantity(20L));
            this.durationChart = new XYChart((IQuantity)UnitLookup.MILLISECOND.quantity(0L), max, RendererToolkit.empty(), 180);
            this.durationChart.setVisibleRange((IQuantity)SocketIOPage.this.durationRange.getStart(), (IQuantity)SocketIOPage.this.durationRange.getEnd());
            this.durationChart.addVisibleRangeListener(r -> {
                IRange iRange = SocketIOPage.this.durationRange = r;
            });
            this.buildChart();
            CTabItem t2 = new CTabItem(this.tabFolder, 0);
            this.durationParent = toolkit.createComposite((Composite)this.tabFolder);
            this.durationParent.setLayout((Layout)new SimpleLayout());
            t2.setToolTipText(Messages.IO_PAGE_DURATIONS_DESCRIPTION);
            this.durationCanvas = new ChartCanvas(this.durationParent);
            this.durationCanvas.setLayoutData((Object)new SimpleLayoutData(3.5f));
            DataPageToolkit.createChartTooltip(this.durationCanvas);
            DataPageToolkit.setChart(this.durationCanvas, this.durationChart, (IAttribute<IQuantity>)JfrAttributes.DURATION, pageContainer::showSelection);
            SelectionStoreActionToolkit.addSelectionStoreActions(pageContainer.getSelectionStore(), this.durationChart, (IAttribute<IQuantity>)JfrAttributes.DURATION, Messages.SocketIOPage_DURATION_SELECTION, (IContributionManager)this.durationCanvas.getContextMenu());
            this.percentileTable = PERCENTILES.build(this.durationParent, TableSettings.forState((IState)state.getChild(PERCENTILE_TABLE_ELEMENT)));
            this.percentileTable.getManager().getViewer().getControl().setLayoutData((Object)new SimpleLayoutData(6.5f));
            MCContextMenuManager percentileTableMm = MCContextMenuManager.create((Control)this.percentileTable.getManager().getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.percentileTable.getManager(), (MCContextMenuManager)percentileTableMm);
            SelectionStoreActionToolkit.addSelectionStoreActions((StructuredViewer)this.percentileTable.getManager().getViewer(), pageContainer.getSelectionStore(), this.percentileTable::getSelectedItems, Messages.SocketIOPage_PERCENTILE_SELECTION, (IContributionManager)percentileTableMm);
            this.percentileTable.getManager().setSelectionState(SocketIOPage.this.percentileSelection);
            t2.setText(Messages.PAGES_DURATIONS);
            t2.setControl((Control)this.durationParent);
            IQuantity sizeMax = (IQuantity)QuantitiesToolkit.maxPresent((Comparable)((IQuantity)socketItems.getAggregate(JdkAggregators.SOCKET_READ_LARGEST)), (Comparable)((IQuantity)socketItems.getAggregate(JdkAggregators.SOCKET_WRITE_LARGEST)));
            sizeMax = sizeMax == null ? UnitLookup.BYTE.quantity(64L) : sizeMax.add((IQuantity)UnitLookup.BYTE.quantity(64L));
            this.sizeChart = new XYChart((IQuantity)UnitLookup.BYTE.quantity(0L), sizeMax, RendererToolkit.empty(), 180);
            this.sizeChart.setVisibleRange((IQuantity)SocketIOPage.this.sizeRange.getStart(), sizeMax);
            this.sizeChart.addVisibleRangeListener(range -> {
                IRange iRange = SocketIOPage.this.sizeRange = range;
            });
            CTabItem t3 = new CTabItem(this.tabFolder, 0);
            t3.setToolTipText(Messages.IO_PAGE_SIZE_DESCRIPTION);
            this.sizeCanvas = new ChartCanvas((Composite)this.tabFolder);
            t3.setText(Messages.PAGES_SIZE);
            t3.setControl((Control)this.sizeCanvas);
            DataPageToolkit.createChartTooltip(this.sizeCanvas);
            DataPageToolkit.setChart(this.sizeCanvas, this.sizeChart, (IAttribute<IQuantity>)JdkAttributes.IO_SIZE, pageContainer::showSelection);
            SelectionStoreActionToolkit.addSelectionStoreActions(pageContainer.getSelectionStore(), this.sizeChart, (IAttribute<IQuantity>)JdkAttributes.IO_SIZE, Messages.SocketIOPage_SIZE_SELECTION, (IContributionManager)this.sizeCanvas.getContextMenu());
            CTabItem t4 = new CTabItem(this.tabFolder, 0);
            t4.setToolTipText(Messages.IO_PAGE_EVENT_LOG_DESCRIPTION);
            this.itemList = LIST.buildWithoutBorder((Composite)this.tabFolder, SocketIOPage.getTableSettings(state.getChild(LIST_ELEMENT)));
            MCContextMenuManager itemListMm = MCContextMenuManager.create((Control)this.itemList.getManager().getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.itemList.getManager(), (MCContextMenuManager)itemListMm);
            SelectionStoreActionToolkit.addSelectionStoreActions(pageContainer.getSelectionStore(), this.itemList, Messages.SocketIOPage_LOG_SELECTION, (IContributionManager)itemListMm);
            this.itemList.getManager().getViewer().addSelectionChangedListener(e -> pageContainer.showSelection(ItemCollectionToolkit.build(this.itemList.getSelection().get())));
            t4.setText(Messages.PAGES_EVENT_LOG);
            this.eventFilter = FilterComponent.createFilterComponent(this.itemList, SocketIOPage.this.itemListFilter, SocketIOPage.this.getDataSource().getItems().apply(TABLE_ITEMS), pageContainer.getSelectionStore()::getSelections, this::onEventFilterChange);
            itemListMm.add(this.eventFilter.getShowFilterAction());
            itemListMm.add(this.eventFilter.getShowSearchAction());
            t4.setControl((Control)this.eventFilter.getComponent());
            this.eventFilter.loadState(state.getChild(EVENT_FILTER));
            this.onEventFilterChange(SocketIOPage.this.itemListFilter);
            this.itemList.getManager().setSelectionState(SocketIOPage.this.itemListSelection);
            this.tabFolder.setSelection(SocketIOPage.this.tabFolderIndex);
            PersistableSashForm.loadState((SashForm)this.sash, (IState)state.getChild(SASH_ELEMENT));
            this.flavorSelector = FlavorSelector.itemsWithTimerange(form, TABLE_ITEMS, SocketIOPage.this.getDataSource().getItems(), pageContainer, this::onInputSelected, this::onUseRange, SocketIOPage.this.flavorSelectorState);
            form.getToolBarManager().appendToGroup("pageSetup", this.buildHistogramTypeAction(HistogramType.HOST, Messages.SocketIOPage_BY_HOST_ACTION, FlightRecorderUI.getDefault().getMCImageDescriptor("io_by_host.png")));
            form.getToolBarManager().appendToGroup("pageSetup", this.buildHistogramTypeAction(HistogramType.PORT, Messages.SocketIOPage_BY_PORT_ACTION, FlightRecorderUI.getDefault().getMCImageDescriptor("io_by_port.png")));
            form.getToolBarManager().appendToGroup("pageSetup", this.buildHistogramTypeAction(HistogramType.HOST_AND_PORT, Messages.SocketIOPage_BY_HOST_AND_PORT_ACTION, FlightRecorderUI.getDefault().getMCImageDescriptor("io_by_host_and_port.png")));
            SocketIOPage.this.addResultActions(form);
        }

        private IAction buildHistogramTypeAction(HistogramType histogramType, String text, ImageDescriptor icon) {
            IAction a = ActionToolkit.radioAction(() -> this.setHistogramType(histogramType), (String)text, (ImageDescriptor)icon);
            a.setChecked(histogramType == this.histogramType);
            return a;
        }

        private void setHistogramType(HistogramType histogramType) {
            if (histogramType != this.histogramType) {
                SocketIOPage.this.primaryTableSelection.put(this.histogramType, this.primaryHistogram.getManager().getSelectionState());
                if (this.secondaryHistogram != null) {
                    SocketIOPage.this.secondaryTableSelection.put(this.histogramType, this.secondaryHistogram.getManager().getSelectionState());
                }
                this.histogramType = histogramType;
                TableSettings primarySettings = this.primaryHistogram.getManager().getSettings();
                TableSettings secondarySettings = this.secondaryHistogramSettings.get();
                Control[] controlArray = this.histogramParent.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control c = controlArray[n2];
                    c.dispose();
                    ++n2;
                }
                this.buildHistograms(primarySettings, secondarySettings);
                this.refreshPageItems();
            }
        }

        private void buildHistograms(TableSettings primarySettings, TableSettings secondarySettings) {
            if (this.histogramType == HistogramType.HOST_AND_PORT) {
                this.primaryHistogram = HISTOGRAM.buildWithoutBorder(this.histogramParent, Messages.SocketIOPage_HOST_AND_PORT, UnitLookup.UNKNOWN, HOST_AND_PORT_AF, primarySettings);
                this.primaryFilter = FilterComponent.createFilterComponent(this.primaryHistogram, SocketIOPage.this.primaryTableFilter.get((Object)this.histogramType), SocketIOPage.this.getDataSource().getItems().apply(TABLE_ITEMS), this.pageContainer.getSelectionStore()::getSelections, this::onPrimaryFilterChange);
                this.secondaryHistogram = null;
                this.secondaryHistogramSettings = () -> secondarySettings;
                this.secondaryFilter = null;
                this.onPrimaryFilterChange(SocketIOPage.this.primaryTableFilter.get((Object)this.histogramType));
                this.primaryHistogram.getManager().setSelectionState(SocketIOPage.this.primaryTableSelection.get((Object)this.histogramType));
                this.itemConsumerRoot = ItemHistogramWithInput.chain(this.primaryHistogram, this::updateChartAndListDetails, new ItemHistogram[0]);
            } else {
                SashForm s2 = new SashForm(this.histogramParent, 512);
                IAttribute masterAttr = this.histogramType == HistogramType.HOST ? JdkAttributes.IO_ADDRESS : JdkAttributes.IO_PORT;
                IAttribute slaveAttr = this.histogramType == HistogramType.PORT ? JdkAttributes.IO_ADDRESS : JdkAttributes.IO_PORT;
                this.primaryHistogram = HISTOGRAM.buildWithoutBorder((Composite)s2, masterAttr, primarySettings);
                this.primaryFilter = FilterComponent.createFilterComponent(this.primaryHistogram, SocketIOPage.this.primaryTableFilter.get((Object)this.histogramType), SocketIOPage.this.getDataSource().getItems().apply(TABLE_ITEMS), this.pageContainer.getSelectionStore()::getSelections, this::onPrimaryFilterChange);
                this.secondaryHistogram = HISTOGRAM.buildWithoutBorder((Composite)s2, slaveAttr, secondarySettings);
                this.secondaryFilter = FilterComponent.createFilterComponent(this.secondaryHistogram, SocketIOPage.this.secondaryTableFilter.get((Object)this.histogramType), SocketIOPage.this.getDataSource().getItems().apply(TABLE_ITEMS), this.pageContainer.getSelectionStore()::getSelections, this::onSecondaryFilterChange);
                this.secondaryHistogramSettings = () -> ((ColumnManager)this.secondaryHistogram.getManager()).getSettings();
                this.onPrimaryFilterChange(SocketIOPage.this.primaryTableFilter.get((Object)this.histogramType));
                this.onSecondaryFilterChange(SocketIOPage.this.secondaryTableFilter.get((Object)this.histogramType));
                this.primaryHistogram.getManager().setSelectionState(SocketIOPage.this.primaryTableSelection.get((Object)this.histogramType));
                this.secondaryHistogram.getManager().setSelectionState(SocketIOPage.this.secondaryTableSelection.get((Object)this.histogramType));
                this.itemConsumerRoot = ItemHistogramWithInput.chain(this.primaryHistogram, this::updateChartAndListDetails, this.secondaryHistogram);
                this.addContextMenu(this.secondaryHistogram, this.secondaryFilter.getShowFilterAction(), this.secondaryFilter.getShowSearchAction());
                this.secondaryFilter.loadState(SocketIOPage.this.getState().getChild(SECONDARY_FILTER));
            }
            this.addContextMenu(this.primaryHistogram, this.primaryFilter.getShowFilterAction(), this.primaryFilter.getShowSearchAction());
            this.primaryFilter.loadState(SocketIOPage.this.getState().getChild(PRIMARY_FILTER));
            this.histogramParent.layout();
        }

        private void addContextMenu(ItemHistogram h, IAction ... actions) {
            MCContextMenuManager mm = MCContextMenuManager.create((Control)h.getManager().getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)h.getManager(), (MCContextMenuManager)mm);
            SelectionStoreActionToolkit.addSelectionStoreActions(this.pageContainer.getSelectionStore(), h, Messages.SocketIOPage_HISTOGRAM_SELECTION, (IContributionManager)mm);
            IAction[] iActionArray = actions;
            int n = actions.length;
            int n2 = 0;
            while (n2 < n) {
                IAction action = iActionArray[n2];
                mm.add(action);
                ++n2;
            }
        }

        private void onPrimaryFilterChange(IItemFilter filter) {
            this.primaryFilter.filterChangeHelper(filter, this.primaryHistogram, SocketIOPage.this.getDataSource().getItems().apply(TABLE_ITEMS));
            if (this.secondaryFilter != null) {
                this.secondaryFilter.notifyListener();
            }
            SocketIOPage.this.primaryTableFilter.put(this.histogramType, filter);
        }

        private void onSecondaryFilterChange(IItemFilter filter) {
            this.secondaryFilter.filterChangeHelper(filter, this.secondaryHistogram, SocketIOPage.this.getDataSource().getItems().apply(TABLE_ITEMS));
            SocketIOPage.this.secondaryTableFilter.put(this.histogramType, filter);
        }

        private void onEventFilterChange(IItemFilter filter) {
            this.eventFilter.filterChangeHelper(filter, this.itemList, SocketIOPage.this.getDataSource().getItems().apply(TABLE_ITEMS));
            SocketIOPage.this.itemListFilter = filter;
        }

        public void saveTo(IWritableState writableState) {
            StateToolkit.writeEnum((IWritableState)writableState, (String)HISTGRAM_TYPE, (Enum)this.histogramType);
            PersistableSashForm.saveState((SashForm)this.sash, (IWritableState)writableState.createChild(SASH_ELEMENT));
            this.primaryHistogram.getManager().getSettings().saveState(writableState.createChild(SOCKETIO_TABLE_ELEMENT));
            this.primaryFilter.saveState(writableState.createChild(PRIMARY_FILTER));
            Optional.ofNullable(this.secondaryHistogramSettings.get()).ifPresent(settings -> settings.saveState(writableState.createChild(SECONDARY_SOCKETIO_TABLE_ELEMENT)));
            if (this.secondaryFilter != null) {
                this.secondaryFilter.saveState(writableState.createChild(SECONDARY_FILTER));
            }
            this.itemList.getManager().getSettings().saveState(writableState.createChild(LIST_ELEMENT));
            this.percentileTable.getManager().getSettings().saveState(writableState.createChild(PERCENTILE_TABLE_ELEMENT));
            this.eventFilter.saveState(writableState.createChild(EVENT_FILTER));
            this.saveToLocal();
        }

        private void saveToLocal() {
            SocketIOPage.this.primaryTableSelection.put(this.histogramType, this.primaryHistogram.getManager().getSelectionState());
            if (this.secondaryHistogram != null) {
                SocketIOPage.this.secondaryTableSelection.put(this.histogramType, this.secondaryHistogram.getManager().getSelectionState());
            }
            SocketIOPage.this.itemListSelection = this.itemList.getManager().getSelectionState();
            SocketIOPage.this.tabFolderIndex = this.tabFolder.getSelectionIndex();
            SocketIOPage.this.flavorSelectorState = this.flavorSelector.getFlavorSelectorState();
            SocketIOPage.this.percentileSelection = this.percentileTable.getManager().getSelectionState();
        }

        private void onUseRange(Boolean show) {
            IRange<IQuantity> range = show != false ? this.timeRange : this.pageContainer.getRecordingRange();
            this.timelineChart.setVisibleRange((IQuantity)range.getStart(), (IQuantity)range.getEnd());
            this.buildChart();
        }

        private void buildChart() {
            DataPageToolkit.setChart(this.timelineCanvas, this.timelineChart, selection -> this.pageContainer.showSelection((IItemCollection)selection));
            SelectionStoreActionToolkit.addSelectionStoreRangeActions(this.pageContainer.getSelectionStore(), this.timelineChart, (IAttribute<IRange<IQuantity>>)JfrAttributes.LIFETIME, Messages.SocketIOPage_TIMELINE_SELECTION, (IContributionManager)this.timelineCanvas.getContextMenu());
        }

        private void onInputSelected(IItemCollection items, IRange<IQuantity> timeRange) {
            this.selectionItems = items;
            this.timeRange = timeRange;
            this.refreshPageItems();
        }

        private void refreshPageItems() {
            IItemCollection items = this.selectionItems != null ? this.selectionItems : SocketIOPage.this.getDataSource().getItems();
            IItemCollection filteredItems = items.apply(JdkFilters.SOCKET_READ_OR_WRITE);
            this.itemConsumerRoot.accept(filteredItems);
        }

        private void updateChartAndListDetails(IItemCollection selectedItems) {
            IItemCollection writeItems;
            String hostCount = this.hostPortCount();
            ArrayList<IXDataRenderer> timelineRows = new ArrayList<IXDataRenderer>();
            ArrayList<ItemRow> durationRows = new ArrayList<ItemRow>();
            ArrayList<ItemRow> sizeRows = new ArrayList<ItemRow>();
            IItemCollection readItems = selectedItems.apply(JdkFilters.SOCKET_READ);
            if (readItems.hasItems()) {
                timelineRows.add(DataPageToolkit.buildSizeRow(Messages.SocketIOPage_ROW_SOCKET_READ + hostCount, JdkAggregators.SOCKET_READ_SIZE.getDescription(), readItems, JdkAggregators.SOCKET_READ_SIZE, READ_COLOR, (AWTChartToolkit.IColorProvider<IItem>)((AWTChartToolkit.IColorProvider)SocketIOPage::access$3)));
                durationRows.add(DataPageToolkit.buildDurationHistogram(Messages.SocketIOPage_ROW_SOCKET_READ + hostCount, JdkAggregators.SOCKET_READ_COUNT.getDescription(), readItems, JdkAggregators.SOCKET_READ_COUNT, READ_COLOR));
                sizeRows.add(DataPageToolkit.buildSizeHistogram(Messages.SocketIOPage_ROW_SOCKET_READ + hostCount, JdkAggregators.SOCKET_READ_COUNT.getDescription(), readItems, JdkAggregators.SOCKET_READ_COUNT, READ_COLOR, (IAttribute<IQuantity>)JdkAttributes.IO_SOCKET_BYTES_READ));
            }
            if ((writeItems = selectedItems.apply(JdkFilters.SOCKET_WRITE)).hasItems()) {
                timelineRows.add(DataPageToolkit.buildSizeRow(Messages.SocketIOPage_ROW_SOCKET_WRITE + hostCount, JdkAggregators.SOCKET_WRITE_SIZE.getDescription(), writeItems, JdkAggregators.SOCKET_WRITE_SIZE, WRITE_COLOR, (AWTChartToolkit.IColorProvider<IItem>)((AWTChartToolkit.IColorProvider)SocketIOPage::access$3)));
                durationRows.add(DataPageToolkit.buildDurationHistogram(Messages.SocketIOPage_ROW_SOCKET_WRITE + hostCount, JdkAggregators.SOCKET_WRITE_COUNT.getDescription(), writeItems, JdkAggregators.SOCKET_WRITE_COUNT, WRITE_COLOR));
                sizeRows.add(DataPageToolkit.buildSizeHistogram(Messages.SocketIOPage_ROW_SOCKET_WRITE + hostCount, JdkAggregators.SOCKET_WRITE_COUNT.getDescription(), writeItems, JdkAggregators.SOCKET_WRITE_COUNT, WRITE_COLOR, (IAttribute<IQuantity>)JdkAttributes.IO_SOCKET_BYTES_WRITTEN));
            }
            if (this.timelineCanvas != null) {
                this.timelineCanvas.replaceRenderer(RendererToolkit.uniformRows(timelineRows));
                this.durationCanvas.replaceRenderer(RendererToolkit.uniformRows(durationRows));
                this.sizeCanvas.replaceRenderer(RendererToolkit.uniformRows(sizeRows));
                this.itemList.show(selectedItems);
                this.pageContainer.showSelection(selectedItems);
                this.percentileTable.update(selectedItems);
            }
        }

        public String hostPortCount() {
            ItemHistogram.HistogramSelection hostSelection;
            ItemHistogram.HistogramSelection histogramSelection = this.histogramType == HistogramType.HOST ? this.primaryHistogram.getSelection() : (hostSelection = this.histogramType == HistogramType.PORT ? this.secondaryHistogram.getSelection() : null);
            ItemHistogram.HistogramSelection portSelection = this.histogramType == HistogramType.PORT ? this.primaryHistogram.getSelection() : (this.histogramType == HistogramType.HOST ? this.secondaryHistogram.getSelection() : null);
            ItemHistogram.HistogramSelection hostPortSelection = this.histogramType == HistogramType.HOST_AND_PORT ? this.primaryHistogram.getSelection() : null;
            return this.hostPortCount(hostSelection != null ? hostSelection.getRowCount() : 0, portSelection != null ? portSelection.getRowCount() : 0, hostPortSelection != null ? hostPortSelection.getRowCount() : 0);
        }

        public String hostPortCount(int hostCount, int portCount, int hostPortCount) {
            switch (hostPortCount) {
                case 0: {
                    switch (hostCount) {
                        case 0: {
                            switch (portCount) {
                                case 0: {
                                    return "";
                                }
                                case 1: {
                                    return " (" + Messages.SocketIOPage_SELECTED_PORT + ")";
                                }
                            }
                            return " (" + NLS.bind((String)Messages.SocketIOPage_SELECTED_PORTS, (Object)portCount) + ")";
                        }
                        case 1: {
                            switch (portCount) {
                                case 0: {
                                    return " (" + Messages.SocketIOPage_SELECTED_HOST + ")";
                                }
                                case 1: {
                                    return " (" + Messages.SocketIOPage_SELECTED_HOST_AND_PORT + ")";
                                }
                            }
                            return " (" + NLS.bind((String)Messages.SocketIOPage_SELECTED_HOST_AND_PORTS, (Object)portCount) + ")";
                        }
                    }
                    switch (portCount) {
                        case 0: {
                            return " (" + NLS.bind((String)Messages.SocketIOPage_SELECTED_HOSTS, (Object)hostCount) + ")";
                        }
                        case 1: {
                            return " (" + NLS.bind((String)Messages.SocketIOPage_SELECTED_HOSTS_AND_PORT, (Object)hostCount) + ")";
                        }
                    }
                    return " (" + NLS.bind((String)Messages.SocketIOPage_SELECTED_HOSTS_AND_PORTS, (Object)hostCount, (Object)portCount) + ")";
                }
            }
            return " (" + NLS.bind((String)Messages.SocketIOPage_SELECTED_HOSTS_PORTS, (Object)hostPortCount) + ")";
        }
    }

    public static class SocketIOPageFactory
    implements IDataPageFactory {
        @Override
        public String getName(IState state) {
            return Messages.SocketIOPage_PAGE_NAME;
        }

        @Override
        public ImageDescriptor getImageDescriptor(IState state) {
            return FlightRecorderUI.getDefault().getMCImageDescriptor("pages/io.png");
        }

        @Override
        public String[] getTopics(IState state) {
            return new String[]{"socket_io"};
        }

        @Override
        public IDisplayablePage createPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
            return new SocketIOPage(dpd, items, editor);
        }
    }
}

