/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.pages;

import org.eclipse.jface.resource.ImageDescriptor;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.jdk.JdkQueries;
import org.openjdk.jmc.flightrecorder.rules.jdk.general.PasswordsInArgumentsRule;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.IDataPageFactory;
import org.openjdk.jmc.flightrecorder.ui.IDisplayablePage;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.IPageDefinition;
import org.openjdk.jmc.flightrecorder.ui.StreamModel;
import org.openjdk.jmc.flightrecorder.ui.common.DataPageToolkit;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.pages.DistinctItemsPage;

public class SystemPropertiesPage
extends DistinctItemsPage {
    public SystemPropertiesPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
        super(dpd, items, editor);
        this.setTableDefinition(JdkQueries.SYSTEM_PROPERTIES);
        this.setLabelProvider(DataPageToolkit.createTableHighlightProvider(PasswordsInArgumentsRule.PASSWORD_PATTERN, true));
    }

    @Override
    public IItemFilter getDefaultSelectionFilter() {
        return JdkFilters.SYSTEM_PROPERTIES;
    }

    public static class SystemPropertiesPageFactory
    implements IDataPageFactory {
        @Override
        public String getName(IState state) {
            return Messages.SystemPropertiesPage_PAGE_NAME;
        }

        @Override
        public ImageDescriptor getImageDescriptor(IState state) {
            return FlightRecorderUI.getDefault().getMCImageDescriptor("pages/systemproperties.png");
        }

        @Override
        public String[] getTopics(IState state) {
            return new String[]{"system_properties"};
        }

        @Override
        public IDisplayablePage createPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
            return new SystemPropertiesPage(dpd, items, editor);
        }
    }
}

