/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.configuration.events;

import java.io.InputStream;
import org.openjdk.jmc.common.version.JavaVersion;
import org.openjdk.jmc.common.version.JavaVersionSupport;
import org.openjdk.jmc.flightrecorder.configuration.internal.Messages;

public enum SchemaVersion {
    V1("1.0", "jfc_v1.xsd", Messages.getString("SchemaVersion_JDK_7_OR_8")),
    V2("2.0", "jfc_v2.xsd", Messages.getString("SchemaVersion_JDK_9_AND_ABOVE"));

    private final String version;
    private final String xsdFile;
    private final String description;

    public static SchemaVersion fromBeanVersion(String beanVersion) {
        for (SchemaVersion version : SchemaVersion.values()) {
            if (!version.version.equals(beanVersion)) continue;
            return version;
        }
        return null;
    }

    public static SchemaVersion fromJavaVersion(JavaVersion javaVersion) {
        return javaVersion.isGreaterOrEqualThan(JavaVersionSupport.JDK_9) ? V2 : (javaVersion.isGreaterOrEqualThan(JavaVersionSupport.JDK_7_U_4) ? V1 : null);
    }

    private SchemaVersion(String version, String xsdFile, String description) {
        this.version = version;
        this.xsdFile = xsdFile;
        this.description = description;
    }

    public String attributeValue() {
        return this.version;
    }

    public InputStream createSchemaStream() {
        return SchemaVersion.class.getResourceAsStream(this.xsdFile);
    }

    public String toString() {
        return this.version + " (" + this.xsdFile + ")";
    }

    public String getDescription() {
        return this.description;
    }
}

