/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.openjdk.jmc.common.IDescribable;
import org.openjdk.jmc.common.action.IActionProvider;
import org.openjdk.jmc.common.action.IUserAction;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.LinearKindOfQuantity;
import org.openjdk.jmc.common.unit.LinearUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.Environment;
import org.openjdk.jmc.flightrecorder.configuration.IRecordingDescriptor;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.ControlPanel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.actions.CloseRecordingAction;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.actions.DumpLastPartRecordingAction;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.actions.DumpRecordingAction;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.actions.DumpWholeRecordingAction;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.actions.EditRecordingAction;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.actions.PrintRecordingDescriptorAction;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.actions.StopRecordingAction;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.rjmx.IServerHandle;
import org.openjdk.jmc.rjmx.common.IConnectionHandle;
import org.openjdk.jmc.ui.common.resource.MCFile;
import org.openjdk.jmc.ui.misc.IGraphical;

public class RecordingProvider
implements IActionProvider,
IDescribable,
IGraphical {
    private static final char INFINITY = '\u221e';
    private static final char DELAYED_CONTINUOUS = '\u2192';
    private static final char DELAYED_DURATION = '\u21e5';
    private static final String CUTOFF = "__Cutoff";
    private static final CutoffFormatter CUTOFF_FORMATTER = new CutoffFormatter(UnitLookup.TIMESPAN, "__Cutoff", "Human readable. Only showing one unit and integer values for seconds and below.", UnitLookup.SECOND);
    private IQuantity timeRemaining;
    private IRecordingDescriptor recordingDescriptor;
    private MCFile dumpToFile;
    private final IServerHandle serverHandle;
    private boolean wasClosed = false;
    private boolean isOpening;

    RecordingProvider(IServerHandle serverHandle, IRecordingDescriptor recording) {
        this.serverHandle = serverHandle;
        this.recordingDescriptor = recording;
        this.dumpToFile = ControlPanel.getDefaultRecordingFile(serverHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRecording(IRecordingDescriptor recording, IConnectionHandle connectionHandle) {
        IQuantity timeRemaining = RecordingProvider.calculateTimeRemaining(recording, connectionHandle);
        RecordingProvider recordingProvider = this;
        synchronized (recordingProvider) {
            this.recordingDescriptor = recording;
            this.timeRemaining = timeRemaining;
        }
    }

    private static IQuantity calculateTimeRemaining(IRecordingDescriptor recording, IConnectionHandle connectionHandle) {
        IQuantity startTime = recording.getStartTime();
        IQuantity duration = recording.getDuration();
        if (startTime == null || duration == null) {
            return null;
        }
        ITypedQuantity serverTime = UnitLookup.EPOCH_MS.quantity(RecordingProvider.getLocalTimeAsServerTime(System.currentTimeMillis(), connectionHandle));
        IQuantity remaining = startTime.add(duration).subtract((IQuantity)serverTime);
        return remaining.longValue() >= 0L ? remaining : null;
    }

    private static long getLocalTimeAsServerTime(long localTime, IConnectionHandle connectionHandle) {
        return localTime;
    }

    public IQuantity getEndTime() {
        IQuantity recStart = this.recordingDescriptor.getStartTime();
        IQuantity recDuration = this.recordingDescriptor.getDuration();
        IQuantity endTime = null;
        endTime = recStart != null && recDuration.compareTo((Object)UnitLookup.SECOND.quantity(0L)) > 0 ? recStart.add(recDuration) : this.recordingDescriptor.getDataEndTime();
        return endTime;
    }

    public synchronized IRecordingDescriptor getRecordingDescriptor() {
        return this.recordingDescriptor;
    }

    public synchronized IQuantity getTimeRemaining() {
        return this.timeRemaining;
    }

    public IServerHandle getServerHandle() {
        return this.serverHandle;
    }

    public synchronized void setClosed() {
        this.wasClosed = true;
    }

    public synchronized boolean wasClosed() {
        return this.wasClosed;
    }

    public synchronized void setDumpToFile(MCFile dumpToFile) {
        this.dumpToFile = dumpToFile;
    }

    public synchronized MCFile getDumpToFile() {
        return this.dumpToFile;
    }

    public synchronized void setIsOpening(boolean isOpening) {
        this.isOpening = isOpening;
    }

    private synchronized boolean isOpening() {
        return this.isOpening;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.getRecordingDescriptor().getState() == IRecordingDescriptor.RecordingState.STOPPED || this.getRecordingDescriptor().getState() == IRecordingDescriptor.RecordingState.CREATED) {
            return ControlPanel.getDefault().getMCImageDescriptor("jfr_finished.png");
        }
        return ControlPanel.getDefault().getMCImageDescriptor("jfr_on.png");
    }

    public String getName() {
        IRecordingDescriptor rd = this.getRecordingDescriptor();
        if (rd.getState() == IRecordingDescriptor.RecordingState.RUNNING && rd.isContinuous()) {
            return rd.getName() + " (\u221e)";
        }
        if (rd.getState() == IRecordingDescriptor.RecordingState.STOPPED) {
            return rd.getName() + (String)(this.isOpening() ? " (" + Messages.RECORDING_INFO_OPENING + ")" : "");
        }
        if (rd.getState() == IRecordingDescriptor.RecordingState.CREATED) {
            return rd.getName() + " (" + (rd.isContinuous() ? (char)'\u2192' : '\u21e5') + ")";
        }
        IQuantity timeRemaining = this.getTimeRemaining();
        return rd.getName() + (String)(timeRemaining == null ? "" : " (" + CUTOFF_FORMATTER.format(timeRemaining) + ")");
    }

    public String getDescription() {
        IRecordingDescriptor rd = this.getRecordingDescriptor();
        if (rd.getState() == IRecordingDescriptor.RecordingState.RUNNING && rd.isContinuous()) {
            return NLS.bind((String)Messages.RECORDING_INFO_CONTINUOUS, (Object)rd.getStartTime().displayUsing("exact"));
        }
        if (rd.getState() == IRecordingDescriptor.RecordingState.STOPPED) {
            return NLS.bind((String)Messages.RECORDING_INFO_STOPPED, (Object)rd.getDataEndTime().subtract(rd.getDataStartTime()).displayUsing("auto"));
        }
        if (rd.getState() == IRecordingDescriptor.RecordingState.CREATED) {
            return rd.isContinuous() ? NLS.bind((String)Messages.RECORDING_INFO_CREATED_CONTINUOUS, (Object)rd.getStartTime()) : NLS.bind((String)Messages.RECORDING_INFO_CREATED_DURATION, (Object)rd.getStartTime().displayUsing("exact"), (Object)rd.getDuration().displayUsing("auto"));
        }
        return NLS.bind((String)Messages.RECORDING_INFO_ONGOING, (Object)rd.getStartTime().displayUsing("exact"));
    }

    public boolean hasChildren() {
        return false;
    }

    public Collection<? extends IActionProvider> getChildren() {
        return Collections.emptyList();
    }

    public List<? extends IUserAction> getActions() {
        ArrayList<Object> actions = new ArrayList<Object>();
        if (this.isStarted()) {
            actions.add((Object)new DumpRecordingAction(this));
            actions.add((Object)new DumpWholeRecordingAction(this));
            actions.add((Object)new DumpLastPartRecordingAction(this));
        }
        if (this.isAlive()) {
            actions.add((Object)new EditRecordingAction(this));
            actions.add((Object)new StopRecordingAction(this));
        }
        if (Environment.isDebug()) {
            actions.add(new PrintRecordingDescriptorAction(this));
        }
        actions.add((Object)new CloseRecordingAction(this));
        return actions;
    }

    public IUserAction getDefaultAction() {
        if (!this.isStarted()) {
            return new EditRecordingAction(this);
        }
        if (FlightRecorderUI.getDefault().isSetLastPartToDump()) {
            return new DumpLastPartRecordingAction(this);
        }
        if (FlightRecorderUI.getDefault().isSetDumpWhole()) {
            return new DumpWholeRecordingAction(this);
        }
        return new DumpRecordingAction(this);
    }

    public boolean isAlive() {
        IRecordingDescriptor.RecordingState state = this.getRecordingDescriptor().getState();
        return state == IRecordingDescriptor.RecordingState.CREATED || state == IRecordingDescriptor.RecordingState.RUNNING;
    }

    private boolean isStarted() {
        IRecordingDescriptor.RecordingState state = this.getRecordingDescriptor().getState();
        return state == IRecordingDescriptor.RecordingState.RUNNING || state == IRecordingDescriptor.RecordingState.STOPPING || state == IRecordingDescriptor.RecordingState.STOPPED;
    }

    public boolean isStopped() {
        IRecordingDescriptor.RecordingState state = this.getRecordingDescriptor().getState();
        return state == IRecordingDescriptor.RecordingState.STOPPED;
    }

    private static class CutoffFormatter
    extends LinearKindOfQuantity.DualUnitFormatter {
        protected CutoffFormatter(LinearKindOfQuantity kindOfQuantity, String id, String name, LinearUnit cutoffUnit) {
            super(kindOfQuantity, id, name, cutoffUnit);
        }
    }
}

