/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import org.openjdk.jmc.flightrecorder.configuration.spi.IConfigurationStorageDelegate;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.model.ConfigurationRepositoryFactory;

public class PrivateStorageDelegate
implements IConfigurationStorageDelegate {
    private final File file;

    public static IConfigurationStorageDelegate getDelegate() throws IOException {
        File dir = ConfigurationRepositoryFactory.getCreatedStorageDir();
        File file = File.createTempFile("template-", ".jfc", dir);
        return new PrivateStorageDelegate(file);
    }

    PrivateStorageDelegate(File file) {
        this.file = file;
    }

    public InputStream getContents() {
        try {
            return this.file.exists() ? new FileInputStream(this.file) : null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public boolean isSaveable() {
        return true;
    }

    public boolean save(String fileContent) throws IOException {
        try {
            Charset charset = Charset.forName("UTF-8");
            Throwable throwable = null;
            Object var4_5 = null;
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), charset);){
                out.write(fileContent);
                ((Writer)out).flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return true;
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            return false;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
    }

    public boolean isDeletable() {
        return true;
    }

    public boolean delete() {
        return this.file.delete();
    }

    public String getLocationInfo() {
        return this.file.exists() ? null : Messages.CONFIG_DELETED;
    }

    public String getLocationPath() {
        return this.file != null ? this.file.getAbsolutePath() : null;
    }
}

