/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards;

import java.util.logging.Level;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.KindOfQuantity;
import org.openjdk.jmc.common.unit.QuantityConversionException;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.ControlPanel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.RecordingProvider;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.jobs.DumpRecordingJob;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards.DumpRecordingWizardModel;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.ui.common.idesupport.IDESupportToolkit;
import org.openjdk.jmc.ui.common.resource.MCFile;
import org.openjdk.jmc.ui.misc.DateTimeChooser;
import org.openjdk.jmc.ui.misc.QuantityKindProposal;
import org.openjdk.jmc.ui.wizards.IPerformFinishable;

public class DumpRecordingWizardPage
extends WizardPage
implements IPerformFinishable {
    private Text m_filenameText;
    private Button m_wholeRadioButton;
    private Button m_lastPartRadioButton;
    private Label m_lastPartLabel;
    private Text m_lastPartText;
    private Button m_intervalRadioButton;
    private Label m_startTimeLabel;
    private DateTimeChooser m_startTimeChooser;
    private Label m_endTimeLabel;
    private DateTimeChooser m_endTimeChooser;
    private final DumpRecordingWizardModel wizardModel;
    private Button m_lastPartDefaultCheckbox;

    public DumpRecordingWizardPage(DumpRecordingWizardModel dumpRecordingWizardModel) {
        super("dumpRecording", Messages.DUMP_RECORDING_WIZARD_PAGE_TITLE, ControlPanel.getDefault().getMCImageDescriptor("startjfrwiz.gif"));
        this.wizardModel = dumpRecordingWizardModel;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        int indent = this.convertWidthInCharsToPixels(4);
        this.setDescription(Messages.DUMP_RECORDING_WIZARD_PAGE_DESCRIPTION);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        this.createFileNameInput(container, indent);
        this.createWholeRecordingOption(container, indent);
        this.createLastPartRecordingOption(container, indent);
        this.createIntervalRecordingOption(container, indent);
        DumpRecordingWizardPage.createDivider(container);
        this.createLastPartDefaultCheckbox(container);
        this.selectInitialOption();
        this.updateFilename();
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.openjdk.jmc.flightrecorder.controlpanel.ui.dump_recording");
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("org.openjdk.jmc.flightrecorder.controlpanel.ui.dump_recording");
    }

    private void selectInitialOption() {
        if (FlightRecorderUI.getDefault().isSetDumpWhole()) {
            this.m_wholeRadioButton.setSelection(true);
            this.setLastPartControlsEnabled(false);
            this.setIntervalControlsEnabled(false);
        } else {
            this.m_lastPartRadioButton.setSelection(true);
            this.setLastPartControlsEnabled(true);
            this.setIntervalControlsEnabled(false);
        }
    }

    private void createFileNameInput(Composite parent, int indent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.LABEL_FILENAME_TEXT);
        label.setLayoutData((Object)DumpRecordingWizardPage.createGridData(false, indent));
        this.m_filenameText = new Text(parent, 2056);
        this.m_filenameText.setLayoutData((Object)DumpRecordingWizardPage.createGridData(true));
        Button browseButton = this.createFilenameBrowseButton(parent);
        browseButton.setLayoutData((Object)DumpRecordingWizardPage.createGridData(false));
    }

    private Button createFilenameBrowseButton(Composite parent) {
        final Button button = new Button(parent, 0);
        button.setText(Messages.BUTTON_BROWSE_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MCFile path = ControlPanel.openRecordingFileBrowser(DumpRecordingWizardPage.this.wizardModel.getPath());
                if (path != null) {
                    DumpRecordingWizardPage.this.wizardModel.setPath(path);
                    DumpRecordingWizardPage.this.updateFilename();
                }
                button.setFocus();
            }
        });
        return button;
    }

    private void updateFilename() {
        this.m_filenameText.setText(this.wizardModel.getPath().getPath());
        this.validatePage();
    }

    private void createWholeRecordingOption(Composite parent, int indent) {
        this.m_wholeRadioButton = new Button(parent, 16);
        this.m_wholeRadioButton.setText(Messages.BUTTON_WHOLE_RECORDING_TEXT);
        this.m_wholeRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DumpRecordingWizardPage.this.setLastPartControlsEnabled(false);
                DumpRecordingWizardPage.this.setDefaultControlsEnabled(true);
                DumpRecordingWizardPage.this.setIntervalControlsEnabled(false);
            }
        });
        this.m_wholeRadioButton.setLayoutData((Object)DumpRecordingWizardPage.createGridData(false, 2, 0));
        DumpRecordingWizardPage.createPadding(parent, 1);
    }

    private void createLastPartRecordingOption(Composite parent, int indent) {
        this.m_lastPartRadioButton = new Button(parent, 16);
        this.m_lastPartRadioButton.setText(Messages.BUTTON_LAST_PART_OF_RECORDING_TEXT);
        this.m_lastPartRadioButton.setLayoutData((Object)DumpRecordingWizardPage.createGridData(false, 2, 0));
        this.m_lastPartRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DumpRecordingWizardPage.this.setLastPartControlsEnabled(true);
                DumpRecordingWizardPage.this.setDefaultControlsEnabled(true);
                DumpRecordingWizardPage.this.setIntervalControlsEnabled(false);
            }
        });
        DumpRecordingWizardPage.createPadding(parent, 1);
        this.m_lastPartLabel = DumpRecordingWizardPage.createLabel(parent, Messages.LABEL_TIMESPAN);
        this.m_lastPartLabel.setLayoutData((Object)DumpRecordingWizardPage.createGridData(false, indent));
        this.m_lastPartText = new Text(parent, 2048);
        QuantityKindProposal.install((Text)this.m_lastPartText, (KindOfQuantity)UnitLookup.TIMESPAN);
        this.m_lastPartText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DumpRecordingWizardPage.this.validatePage();
            }
        });
        this.m_lastPartText.setLayoutData((Object)DumpRecordingWizardPage.createGridData(true));
        DumpRecordingWizardPage.createPadding(parent, 1);
    }

    private void validatePage() {
        String lastPartError = FlightRecorderUI.validateDumpTimespan((String)this.m_lastPartText.getText());
        if (lastPartError != null) {
            this.setMessage(lastPartError, 3);
            this.setPageComplete(false);
        } else {
            IStatus validation = IDESupportToolkit.validateFileResourcePath((String)this.wizardModel.getPath().getPath());
            if (validation.getSeverity() == 4) {
                this.setMessage(validation.getMessage(), 3);
                this.setPageComplete(false);
            } else {
                this.setMessage(ControlPanel.getRecordingFileValidationMessage(validation), 2);
                this.setPageComplete(true);
            }
        }
    }

    private static void createDivider(Composite container) {
        Label divider = new Label(container, 258);
        divider.setLayoutData((Object)DumpRecordingWizardPage.createGridData(true, 3, 0));
    }

    private void createLastPartDefaultCheckbox(Composite parent) {
        this.m_lastPartDefaultCheckbox = new Button(parent, 32);
        this.m_lastPartDefaultCheckbox.setText(Messages.DUMP_RECORDING_SAVE_LAST_PART_TO_DUMP);
        this.m_lastPartDefaultCheckbox.setLayoutData((Object)DumpRecordingWizardPage.createGridData(true, 2, 0));
    }

    private void setLastPartControlsEnabled(boolean enabled) {
        this.m_lastPartText.setEnabled(enabled);
        this.m_lastPartLabel.setEnabled(enabled);
        if (FlightRecorderUI.validateDumpTimespan((String)this.m_lastPartText.getText()) != null) {
            this.m_lastPartText.setText(FlightRecorderUI.getDefault().getLastPartToDumpTimespan().interactiveFormat());
        }
    }

    private void setDefaultControlsEnabled(boolean enabled) {
        this.m_lastPartDefaultCheckbox.setEnabled(enabled);
    }

    private void createIntervalRecordingOption(Composite parent, int indent) {
        this.createIntervalRecordingRadioButton(parent);
        this.createStartTimeChooser(parent, indent);
        this.createEndTimeChooser(parent, indent);
        this.m_startTimeChooser.setConstraint(timestamp -> Math.min(timestamp, this.m_endTimeChooser.getTimestamp()));
        this.m_endTimeChooser.setConstraint(timestamp -> Math.max(timestamp, this.m_startTimeChooser.getTimestamp()));
    }

    private void createIntervalRecordingRadioButton(Composite parent) {
        this.m_intervalRadioButton = new Button(parent, 16);
        this.m_intervalRadioButton.setText(Messages.BUTTON_INTERVAL_OF_RECORDING_TEXT);
        this.m_intervalRadioButton.setLayoutData((Object)DumpRecordingWizardPage.createGridData(false, 2, 0));
        this.m_intervalRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DumpRecordingWizardPage.this.setIntervalControlsEnabled(true);
                DumpRecordingWizardPage.this.setLastPartControlsEnabled(false);
                DumpRecordingWizardPage.this.setDefaultControlsEnabled(false);
            }
        });
        DumpRecordingWizardPage.createPadding(parent, 1);
    }

    private void createStartTimeChooser(Composite parent, int indent) {
        this.m_startTimeLabel = DumpRecordingWizardPage.createLabel(parent, Messages.LABEL_START_TIME_TEXT);
        this.m_startTimeLabel.setLayoutData((Object)DumpRecordingWizardPage.createGridData(false, indent));
        this.m_startTimeChooser = new DateTimeChooser(parent, 0);
        this.m_startTimeChooser.setTimestamp(this.wizardModel.getRecordingStartTime().clampedLongValueIn((IUnit)UnitLookup.EPOCH_MS));
        this.m_startTimeChooser.setLayoutData((Object)DumpRecordingWizardPage.createGridData(true));
        DumpRecordingWizardPage.createPadding(parent, 1);
    }

    private void createEndTimeChooser(Composite parent, int indent) {
        this.m_endTimeLabel = DumpRecordingWizardPage.createLabel(parent, Messages.LABEL_END_TIME_TEXT);
        this.m_endTimeLabel.setLayoutData((Object)DumpRecordingWizardPage.createGridData(false, indent));
        this.m_endTimeChooser = new DateTimeChooser(parent, 0);
        this.m_endTimeChooser.setTimestamp(this.wizardModel.recordingEndTime().clampedLongValueIn((IUnit)UnitLookup.EPOCH_MS));
        this.m_endTimeChooser.setLayoutData((Object)DumpRecordingWizardPage.createGridData(true));
        DumpRecordingWizardPage.createPadding(parent, 1);
    }

    private void setIntervalControlsEnabled(boolean enabled) {
        this.m_startTimeLabel.setEnabled(enabled);
        this.m_startTimeChooser.setEnabled(enabled);
        this.m_endTimeLabel.setEnabled(enabled);
        this.m_endTimeChooser.setEnabled(enabled);
    }

    private static Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        return label;
    }

    private static void createPadding(Composite parent, int horizontalSpan) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)DumpRecordingWizardPage.createGridData(false, horizontalSpan, 0));
    }

    private static GridData createGridData(boolean grabExcessHorizontalSpace) {
        return DumpRecordingWizardPage.createGridData(grabExcessHorizontalSpace, 1, 0);
    }

    private static GridData createGridData(boolean grabExcessHorizontalSpace, int indent) {
        return DumpRecordingWizardPage.createGridData(grabExcessHorizontalSpace, 1, indent);
    }

    private static GridData createGridData(boolean grabExcessHorizontalSpace, int horizontalSpan, int indent) {
        GridData gridData = new GridData(4, 0x1000000, grabExcessHorizontalSpace, false);
        gridData.horizontalSpan = horizontalSpan;
        gridData.horizontalIndent = indent;
        return gridData;
    }

    public boolean performFinish() {
        RecordingProvider recDesc = this.wizardModel.getRecordingProvider();
        if (this.m_lastPartText.isEnabled()) {
            try {
                ITypedQuantity timespan = UnitLookup.TIMESPAN.parseInteractive(this.m_lastPartText.getText());
                if (this.m_lastPartDefaultCheckbox.getSelection()) {
                    IPreferenceStore preferenceStore = FlightRecorderUI.getDefault().getPreferenceStore();
                    preferenceStore.setValue("flightrecorder.controlpanel.default.dump.timespan", timespan.persistableString());
                    preferenceStore.setValue("flightrecorder.controlpanel.default.dump.type", 1);
                }
                new DumpRecordingJob(recDesc, this.wizardModel.getPath(), (IQuantity)timespan).schedule();
            }
            catch (QuantityConversionException qce) {
                ControlPanel.getDefault().getLogger().log(Level.SEVERE, "Dump recording wizard should not be closable if dump timespan is not valid", qce);
                return false;
            }
        } else if (this.m_startTimeChooser.isEnabled()) {
            ITypedQuantity startTime = UnitLookup.EPOCH_MS.quantity(this.m_startTimeChooser.getTimestamp());
            ITypedQuantity endTime = UnitLookup.EPOCH_MS.quantity(this.m_endTimeChooser.getTimestamp());
            new DumpRecordingJob(recDesc, this.wizardModel.getPath(), (IQuantity)startTime, (IQuantity)endTime).schedule();
        } else {
            if (this.m_lastPartDefaultCheckbox.getSelection()) {
                IPreferenceStore preferenceStore = FlightRecorderUI.getDefault().getPreferenceStore();
                preferenceStore.setValue("flightrecorder.controlpanel.default.dump.type", 2);
            }
            new DumpRecordingJob(recDesc, this.wizardModel.getPath()).schedule();
        }
        return true;
    }

    public void dispose() {
        this.wizardModel.dispose();
        super.dispose();
    }
}

