/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.gui;

import java.util.function.BiConsumer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.flightrecorder.configuration.model.xml.XMLModel;
import org.openjdk.jmc.flightrecorder.configuration.model.xml.XMLTagInstance;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.gui.Value;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.gui.WidgetNode;

final class FlagNode
extends WidgetNode {
    public FlagNode(XMLModel model, XMLTagInstance flagElement) {
        super(model, flagElement);
    }

    @Override
    public void create(Composite parent, int horisontalSPan, BiConsumer<Object, String> errorTracker) {
        Button button = new Button(parent, 32);
        button.setText(this.getLabel());
        this.adaptButton(horisontalSPan, button);
    }

    @Override
    public void create(FormToolkit toolkit, Composite parent, int horisontalSpan, BiConsumer<Object, String> errorTracker) {
        Button button = toolkit.createButton(parent, this.getLabel(), 32);
        this.adaptButton(horisontalSpan, button);
    }

    private void adaptButton(int horisontalSpan, final Button button) {
        GridData gd = new GridData(4, 0x1000000, false, false);
        gd.horizontalSpan = horisontalSpan;
        button.setLayoutData((Object)gd);
        button.setToolTipText(this.getDescription());
        button.setSelection(this.getEnabled());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FlagNode.this.setValue(Value.valueOf(button.getSelection()).toString());
            }
        });
    }

    private boolean getEnabled() {
        return "true".equalsIgnoreCase(this.getValue().toString());
    }
}

