/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.util.internal;

import java.io.PrintStream;
import org.openjdk.jmc.commands.IExecute;
import org.openjdk.jmc.commands.Statement;
import org.openjdk.jmc.common.security.ICredentials;
import org.openjdk.jmc.common.security.InMemoryCredentials;
import org.openjdk.jmc.rjmx.IServerHandle;
import org.openjdk.jmc.rjmx.common.ConnectionDescriptorBuilder;
import org.openjdk.jmc.rjmx.common.IConnectionDescriptor;

public abstract class RJMXStartCommand
implements IExecute {
    private static final String PASSWORD_PARAMETER = "password";
    private static final String USERNAME_PARAMETER = "username";
    private static final String PORT_PARAMETER = "port";
    private static final String HOST_PARAMETER = "host";

    public abstract boolean execute(Statement var1, PrintStream var2);

    protected IServerHandle createConnectionDescriptor(Statement statement, PrintStream out) {
        ConnectionDescriptorBuilder builder = new ConnectionDescriptorBuilder();
        if (statement.hasValue(HOST_PARAMETER)) {
            builder.hostName(statement.getString(HOST_PARAMETER));
        }
        if (statement.hasValue(PORT_PARAMETER)) {
            builder.port(statement.getNumber(PORT_PARAMETER).intValue());
        }
        if (statement.hasValue(USERNAME_PARAMETER) && statement.hasValue(PASSWORD_PARAMETER)) {
            builder.credentials((ICredentials)new InMemoryCredentials(statement.getString(USERNAME_PARAMETER), statement.getString(PASSWORD_PARAMETER)));
        }
        if (!statement.hasValue(HOST_PARAMETER) && !statement.hasValue(PORT_PARAMETER)) {
            builder.hostName("localhost");
            builder.port(0);
        }
        try {
            IConnectionDescriptor cd = builder.build();
            return IServerHandle.create(cd);
        }
        catch (IllegalStateException e) {
            out.print(e.getMessage());
            return null;
        }
    }
}

