/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.browser.views;

import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.openjdk.jmc.attach.AttachToolkit;
import org.openjdk.jmc.browser.JVMBrowserPlugin;
import org.openjdk.jmc.browser.attach.LocalJVMToolkit;
import org.openjdk.jmc.browser.views.Messages;
import org.openjdk.jmc.ui.misc.DisplayToolkit;

public class NoLocalJVMsWarner {
    public static void warnIfNoLocalJVMs(final Control control) {
        PaintListener noLocalJVMWarner = new PaintListener(){

            public void paintControl(PaintEvent e) {
                control.removePaintListener((PaintListener)this);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (!AttachToolkit.isLocalAttachAvailable() || LocalJVMToolkit.getAttachableJVMs().length == 0) {
                            NoLocalJVMsWarner.showNoLocalJVMsWarning(control);
                        }
                    }
                }).start();
            }
        };
        control.addPaintListener(noLocalJVMWarner);
    }

    private static void showNoLocalJVMsWarning(final Control control) {
        DisplayToolkit.safeAsyncExec((Widget)control, (Runnable)new Runnable(){

            @Override
            public void run() {
                MessageDialogWithToggle warnDialog = MessageDialogWithToggle.openWarning((Shell)control.getShell(), (String)Messages.JVMBrowserView_NO_LOCAL_JVMS_TITLE, (String)(Messages.JVMBrowserView_NO_LOCAL_JVMS_MESSAGE + System.getProperty("line.separator") + Messages.JVMBrowserView_NO_LOCAL_JVMS_WARN_CAUSE), (String)Messages.JVMBrowserView_NO_LOCAL_JVMS_WARN_PREFERENCE, (boolean)true, null, null);
                if (warnDialog.getReturnCode() == 0 && !warnDialog.getToggleState()) {
                    JVMBrowserPlugin.getDefault().setWarnNoLocalJVMs(false);
                }
            }
        });
    }
}

