/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.common.subscription.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import org.openjdk.jmc.rjmx.common.subscription.MRI;

public final class AttributeValueToolkit {
    private static final Logger LOGGER = Logger.getLogger("org.openjdk.jmc.rjmx.common.subscription.internal");

    private AttributeValueToolkit() throws InstantiationException {
        throw new InstantiationException("Should not be instantiated!");
    }

    public static Object getAttribute(MBeanServerConnection connection, MRI attribute) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        assert (attribute.getType() == MRI.Type.ATTRIBUTE);
        return AttributeValueToolkit.getAttribute(connection, attribute.getObjectName(), attribute.getDataPath());
    }

    public static Object getAttribute(MBeanServerConnection connection, ObjectName name, String attribute) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        Object value = connection.getAttribute(name, AttributeValueToolkit.getAttributeName(attribute));
        return AttributeValueToolkit.lookupValue(attribute, value);
    }

    public static Map<MRI, Object> getAttributes(MBeanServerConnection connection, Iterable<MRI> attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        if (attributes == null) {
            throw new IllegalArgumentException("Can't fetch anything! attributes == null!");
        }
        HashMap<MRI, Object> results = new HashMap<MRI, Object>();
        HashMap<ObjectName, ArrayList<String>> mbeanMap = new HashMap<ObjectName, ArrayList<String>>();
        for (MRI mRI : attributes) {
            assert (mRI.getType() == MRI.Type.ATTRIBUTE);
            ArrayList<String> dataPathList = (ArrayList<String>)mbeanMap.get(mRI.getObjectName());
            if (dataPathList == null) {
                dataPathList = new ArrayList<String>();
                mbeanMap.put(mRI.getObjectName(), dataPathList);
            }
            dataPathList.add(mRI.getDataPath());
        }
        for (Map.Entry entry : mbeanMap.entrySet()) {
            AttributeList values = AttributeValueToolkit.getAttributes(connection, (ObjectName)entry.getKey(), (Iterable)entry.getValue());
            for (Object obj : values) {
                Attribute value = (Attribute)obj;
                results.put(new MRI(MRI.Type.ATTRIBUTE, (ObjectName)entry.getKey(), value.getName()), value.getValue());
            }
        }
        return results;
    }

    public static AttributeList getAttributes(MBeanServerConnection connection, ObjectName name, Iterable<String> dataPaths) throws InstanceNotFoundException, ReflectionException, IOException {
        AttributeList results = new AttributeList();
        HashMap<String, List<String>> attributeMap = new HashMap<String, List<String>>();
        for (String dataPath : dataPaths) {
            String attributeName = AttributeValueToolkit.getAttributeName(dataPath);
            ArrayList<String> attributeList = (ArrayList<String>)attributeMap.get(attributeName);
            if (attributeList == null) {
                attributeList = new ArrayList<String>();
                attributeMap.put(attributeName, attributeList);
            }
            attributeList.add(dataPath);
        }
        AttributeList values = connection.getAttributes(name, AttributeValueToolkit.keysAsArray(attributeMap));
        if (values == null) {
            values = new AttributeList();
        }
        for (Object obj : values) {
            Attribute value = (Attribute)obj;
            for (String dataPath : (List)attributeMap.get(value.getName())) {
                try {
                    Attribute attribute = new Attribute(dataPath, AttributeValueToolkit.lookupValue(dataPath, value.getValue()));
                    results.add(attribute);
                }
                catch (AttributeNotFoundException attributeNotFoundException) {}
            }
        }
        return results;
    }

    private static String[] keysAsArray(Map<String, List<String>> attributeMap) {
        Set<String> attributesToGet = attributeMap.keySet();
        return attributesToGet.toArray(new String[attributesToGet.size()]);
    }

    public static Object lookupValue(String dataPath, Object value) throws AttributeNotFoundException {
        String[] compositeParts = dataPath.split("/");
        if (compositeParts.length > 1) {
            if (value != null && !(value instanceof CompositeData)) {
                throw new AttributeNotFoundException("Unable to lookup up " + dataPath + " in non-composite value!");
            }
            CompositeData compositeData = (CompositeData)value;
            if (compositeParts.length != 2) {
                String msg = "Could not resolve the composite data for " + dataPath + ". Number of components " + compositeParts.length + " is not supported yet.";
                LOGGER.log(Level.WARNING, msg);
                throw new AttributeNotFoundException(msg);
            }
            if (compositeData == null) {
                throw new AttributeNotFoundException("Attribute " + compositeParts[0] + " is null!");
            }
            if (!compositeData.containsKey(compositeParts[1])) {
                throw new AttributeNotFoundException("Attribute " + dataPath + " not found!");
            }
            return compositeData.get(compositeParts[1]);
        }
        return value;
    }

    public static String getAttributeName(String dataPath) {
        if (dataPath == null) {
            return dataPath;
        }
        int index = dataPath.indexOf(47);
        if (index >= 0) {
            return dataPath.substring(0, index);
        }
        return dataPath;
    }

    public static void setAttribute(MBeanServerConnection connection, MRI attribute, Object value) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        connection.setAttribute(attribute.getObjectName(), new Attribute(attribute.getDataPath(), value));
    }
}

