/*
 * Decompiled with CFR 0.152.
 */
package io.github.bric3.fireplace.flamegraph;

import io.github.bric3.fireplace.flamegraph.FlamegraphRenderEngine;
import io.github.bric3.fireplace.flamegraph.FlamegraphView;
import io.github.bric3.fireplace.flamegraph.FrameColorProvider;
import io.github.bric3.fireplace.flamegraph.FrameFontProvider;
import io.github.bric3.fireplace.flamegraph.FrameModel;
import io.github.bric3.fireplace.flamegraph.FrameRenderer;
import io.github.bric3.fireplace.flamegraph.FrameTextsProvider;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.Objects;
import java.util.function.IntConsumer;
import org.jetbrains.annotations.NotNull;

public class FlamegraphImage<T> {
    private final FlamegraphRenderEngine<@NotNull T> fre;

    public FlamegraphImage(@NotNull @NotNull FrameTextsProvider<@NotNull T> frameTextsProvider, @NotNull @NotNull FrameColorProvider<@NotNull T> frameColorProvider, @NotNull @NotNull FrameFontProvider<@NotNull T> frameFontProvider) {
        this.fre = new FlamegraphRenderEngine<T>(new FrameRenderer<T>(Objects.requireNonNull(frameTextsProvider), Objects.requireNonNull(frameColorProvider), Objects.requireNonNull(frameFontProvider)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public RenderedImage generate(@NotNull @NotNull FrameModel<@NotNull T> frameModel, @NotNull FlamegraphView.Mode mode, int width) {
        try {
            this.fre.init(Objects.requireNonNull(frameModel));
            int height = this.fre.computeVisibleFlamegraphHeight(new BufferedImage(1, 1, 2).createGraphics(), width);
            BufferedImage imageCanvas = new BufferedImage(width, height, 2);
            Graphics2D g2 = imageCanvas.createGraphics();
            g2.setComposite(AlphaComposite.Clear);
            g2.fillRect(0, 0, imageCanvas.getWidth(), imageCanvas.getHeight());
            g2.setComposite(AlphaComposite.Src);
            this.fre.paintToImage(g2, new Rectangle(0, 0, imageCanvas.getWidth(), imageCanvas.getHeight()), mode == FlamegraphView.Mode.ICICLEGRAPH);
            g2.dispose();
            BufferedImage bufferedImage = imageCanvas;
            return bufferedImage;
        }
        finally {
            this.fre.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(@NotNull @NotNull FrameModel<@NotNull T> frameModel, @NotNull FlamegraphView.Mode mode, int width, @NotNull Graphics2D g2, @NotNull IntConsumer onHeightComputed) {
        try {
            this.fre.init(Objects.requireNonNull(frameModel));
            int height = this.fre.computeVisibleFlamegraphHeight(g2, width);
            onHeightComputed.accept(height);
            this.fre.paintToImage(g2, new Rectangle(0, 0, width, height), mode == FlamegraphView.Mode.ICICLEGRAPH);
        }
        finally {
            this.fre.reset();
        }
    }
}

