/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.overview;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.stream.Stream;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.io.IOToolkit;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.ui.DataPageDescriptor;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.IDataPageFactory;
import org.openjdk.jmc.flightrecorder.ui.IDisplayablePage;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.IPageDefinition;
import org.openjdk.jmc.flightrecorder.ui.IPageUI;
import org.openjdk.jmc.flightrecorder.ui.StreamModel;
import org.openjdk.jmc.flightrecorder.ui.common.AbstractDataPage;
import org.openjdk.jmc.flightrecorder.ui.common.DataPageToolkit;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.overview.ResultReportUi;
import org.openjdk.jmc.flightrecorder.ui.overview.ResultTableUi;
import org.openjdk.jmc.ui.UIPlugin;
import org.openjdk.jmc.ui.idesupport.IDESupportUIToolkit;
import org.openjdk.jmc.ui.misc.DialogToolkit;
import org.openjdk.jmc.ui.misc.DisplayToolkit;

public class ResultOverview
extends AbstractDataPage
implements IPageUI {
    private static final ImageDescriptor ICON = UIPlugin.getDefault().getMCImageDescriptor("mission_control.gif");
    public static final ImageDescriptor ICON_WARNING = FlightRecorderUI.getDefault().getMCImageDescriptor("warning.png");
    public static final ImageDescriptor ICON_INFO = FlightRecorderUI.getDefault().getMCImageDescriptor("info.png");
    public static final ImageDescriptor ICON_OK = FlightRecorderUI.getDefault().getMCImageDescriptor("ok.png");
    public static final ImageDescriptor ICON_NA = FlightRecorderUI.getDefault().getMCImageDescriptor("na.png");
    public static final ImageDescriptor ICON_IGNORE = FlightRecorderUI.getDefault().getMCImageDescriptor("na.png");
    private static final ImageDescriptor ICON_OVERVIEW = FlightRecorderUI.getDefault().getMCImageDescriptor("overview.png");
    private static final ImageDescriptor ICON_TABLE = FlightRecorderUI.getDefault().getMCImageDescriptor("table.gif");
    private static final ImageDescriptor ICON_EXPORT = FlightRecorderUI.getDefault().getMCImageDescriptor("download_time.gif");
    private static final ImageDescriptor ICON_BROWSER = FlightRecorderUI.getDefault().getMCImageDescriptor("browser-16.png");
    private Form form;
    private FormToolkit toolkit;
    private IPageContainer editor;
    private IState loadedState;
    private ExportAction exportAction;
    private ShowOkAction showOkAction;
    private ShowIgnoreAction showIgnoreAction;
    private Separator separator;
    private BrowserAction browserAction;
    private boolean displayReport = !UIPlugin.getDefault().getAccessibilityMode();
    private ResultReportUi report = new ResultReportUi(false);
    private ResultTableUi table;
    private DisplayModeAction reportAction;
    private DisplayModeAction tableAction;
    private volatile boolean isUpdated;

    public ResultOverview(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
        super(dpd, items, editor);
    }

    @Override
    public IPageUI display(Composite parent, FormToolkit toolkit, IPageContainer editor, IState state) {
        this.form = DataPageToolkit.createForm(parent, toolkit, this.getName(), this.getIcon());
        this.toolkit = toolkit;
        this.editor = editor;
        this.loadedState = state;
        this.form.setImage(ICON.createImage());
        this.showOkAction = new ShowOkAction(Messages.RULESPAGE_SHOW_OK_RESULTS_ACTION);
        this.showOkAction.setId("showOk");
        this.form.getToolBarManager().add((IAction)this.showOkAction);
        this.showIgnoreAction = new ShowIgnoreAction(Messages.RULESPAGE_SHOW_IGNORE_RESULTS_ACTION);
        this.showIgnoreAction.setId("showIgnore");
        this.form.getToolBarManager().add((IAction)this.showIgnoreAction);
        this.exportAction = new ExportAction(Messages.ResultOverview_EXPORT_ACTION, ICON_EXPORT, editor);
        this.exportAction.setId("exportAction");
        this.form.getToolBarManager().add((IAction)this.exportAction);
        this.separator = new Separator();
        this.separator.setId("separator");
        this.form.getToolBarManager().add((IContributionItem)this.separator);
        this.browserAction = new BrowserAction(Messages.ResultOverview_BROWSER_ACTION);
        this.browserAction.setId("browserAction");
        this.form.getToolBarManager().add((IAction)this.browserAction);
        this.reportAction = new DisplayModeAction(Messages.ResultOverview_DISPLAYMODE_REPORT, this.form, ICON_OVERVIEW, true);
        this.tableAction = new DisplayModeAction(Messages.ResultOverview_DISPLAYMODE_TABLE, this.form, ICON_TABLE, false);
        if (this.displayReport) {
            this.reportAction.setChecked(true);
        } else {
            this.tableAction.setChecked(true);
        }
        this.form.getToolBarManager().add((IAction)this.reportAction);
        this.form.getToolBarManager().add((IAction)this.tableAction);
        this.form.getToolBarManager().update(true);
        Consumer<IResult> listener = result -> this.updateRule((IResult)result);
        editor.getRuleManager().addResultListener(listener);
        this.form.addDisposeListener(de -> editor.getRuleManager().removeResultListener(listener));
        return this.redisplay();
    }

    private void setVisibleActions(boolean visible) {
        this.form.getToolBarManager().find(this.showOkAction.getId()).setVisible(visible);
        this.form.getToolBarManager().find(this.showIgnoreAction.getId()).setVisible(visible);
        this.form.getToolBarManager().find(this.exportAction.getId()).setVisible(visible);
        this.form.getToolBarManager().find(this.separator.getId()).setVisible(visible);
        this.form.getToolBarManager().find(this.browserAction.getId()).setVisible(false);
        this.form.getToolBarManager().update(true);
    }

    public void updateRule(IResult result) {
        if (this.displayReport && this.report != null) {
            this.report.updateRule(result.getRule());
        } else if (this.table != null) {
            this.isUpdated = false;
            DisplayToolkit.safeAsyncExec(() -> {
                if (!this.isUpdated) {
                    this.table.updateInput(this.createResultMap());
                    this.isUpdated = true;
                }
            });
        }
    }

    private IPageUI redisplay() {
        Control[] controlArray = this.form.getBody().getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        if (this.displayReport) {
            this.setVisibleActions(true);
            try {
                if (!this.report.createHtmlOverview(new Browser(this.form.getBody(), 0), this.editor, this.loadedState)) {
                    this.displayReport = false;
                    this.report = null;
                } else {
                    this.showOkAction.setChecked(this.report.getShowOk());
                    this.showIgnoreAction.setChecked(this.report.getShowIgnore());
                }
            }
            catch (SWTError | SWTException e) {
                this.reportAction.setEnabled(false);
                this.tableAction.setChecked(true);
                FlightRecorderUI.getDefault().getLogger().log(Level.WARNING, "Could not create browser, using SWT table for fallback", e);
                this.displayReport = false;
                this.report = null;
            }
        }
        if (!this.displayReport) {
            this.setVisibleActions(false);
            Map<IResult, DataPageDescriptor> map = this.createResultMap();
            this.table = new ResultTableUi(this.form, this.toolkit, this.editor, this.loadedState, map);
        }
        return this;
    }

    private Map<IResult, DataPageDescriptor> createResultMap() {
        HashMap<IResult, DataPageDescriptor> map = new HashMap<IResult, DataPageDescriptor>();
        FlightRecorderUI.getDefault().getPageManager().getAllPages().forEach(page -> {
            for (IResult result : this.editor.getRuleManager().getResults(page.getTopics())) {
                map.put(result, (DataPageDescriptor)page);
            }
        });
        boolean hasRemainderBucket = FlightRecorderUI.getDefault().getPageManager().getAllPages().flatMap(dpd -> Stream.of(dpd.getTopics())).anyMatch(t -> "".equals(t));
        if (!hasRemainderBucket) {
            for (IResult result : this.editor.getRuleManager().getUnmappedResults()) {
                map.put(result, null);
            }
        }
        return map;
    }

    public void saveTo(IWritableState writableState) {
        if (this.table != null) {
            this.table.saveTo(writableState);
        } else {
            IState oldTable = this.loadedState.getChild("table");
            if (oldTable != null) {
                IWritableState newTable = writableState.createChild("table");
                String[] stringArray = oldTable.getAttributeKeys();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    newTable.putString(key, oldTable.getAttribute(key));
                    ++n2;
                }
                stringArray = oldTable.getChildren();
                n = stringArray.length;
                n2 = 0;
                while (n2 < n) {
                    String oldChild = stringArray[n2];
                    IWritableState newChild = newTable.createChild(oldChild.getType());
                    String[] stringArray2 = oldChild.getAttributeKeys();
                    int n3 = stringArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String key = stringArray2[n4];
                        newChild.putString(key, oldChild.getAttribute(key));
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
        if (this.report != null) {
            this.report.saveTo(writableState);
        }
    }

    public void enableBrowserAction() {
        this.form.getToolBarManager().find(this.showOkAction.getId()).setVisible(false);
        this.form.getToolBarManager().find(this.showIgnoreAction.getId()).setVisible(false);
        this.form.getToolBarManager().find(this.exportAction.getId()).setVisible(false);
        this.form.getToolBarManager().find(this.separator.getId()).setVisible(false);
        this.form.getToolBarManager().find(this.browserAction.getId()).setVisible(true);
        this.browserAction.setChecked(true);
        this.reportAction.setChecked(false);
        this.tableAction.setChecked(false);
        this.form.getToolBarManager().update(true);
    }

    class BrowserAction
    extends Action {
        public BrowserAction(String text) {
            super(text, 2);
            super.setImageDescriptor(ICON_BROWSER);
        }

        public void run() {
            ResultOverview.this.browserAction.setChecked(true);
        }
    }

    private class DisplayModeAction
    extends Action {
        private final Form form;
        private final boolean showBrowser;

        public DisplayModeAction(String text, Form form, ImageDescriptor icon, boolean showBrowser) {
            super(text, 8);
            this.setImageDescriptor(icon);
            this.showBrowser = showBrowser;
            this.form = form;
        }

        public void runWithEvent(Event event) {
            ResultOverview.this.displayReport = this.showBrowser;
            Control[] controlArray = this.form.getBody().getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.dispose();
                ++n2;
            }
            this.form.setCursor(new Cursor((Device)Display.getCurrent(), 1));
            ResultOverview.this.redisplay();
            this.form.getBody().layout();
            this.form.setCursor(new Cursor((Device)Display.getCurrent(), 0));
        }
    }

    class ExportAction
    extends Action {
        private final IPageContainer editor;

        public ExportAction(String text, ImageDescriptor image, IPageContainer editor) {
            super(text, 1);
            super.setImageDescriptor(image);
            this.editor = editor;
        }

        public void run() {
            File saveAsFile;
            File srcFile = new File(System.getProperty("user.home") + System.getProperty("file.separator") + "overview.html");
            do {
                if ((saveAsFile = IDESupportUIToolkit.browseForSaveAsFile((String)Messages.ResultOverview_EXPORT_DIALOG_TITLE, (File)srcFile, (String)"html", (String)Messages.ResultOverview_EXPORT_DIALOG_MESSAGE)) != null) continue;
                return;
            } while (IDESupportUIToolkit.checkAlreadyExists((File)saveAsFile));
            try {
                IOToolkit.saveToFile((File)saveAsFile, ResultOverview.this.report.getHtml(this.editor));
            }
            catch (IOException e) {
                DialogToolkit.showException((Shell)ResultOverview.this.form.getShell(), (String)Messages.SAVE_AS_ERROR_MSG, (Throwable)e);
            }
        }
    }

    public static class ResultOverviewPageFactory
    implements IDataPageFactory {
        @Override
        public String getName(IState state) {
            return Messages.ResultOverview_PAGE_NAME;
        }

        @Override
        public String getDescription(IState state) {
            return Messages.ResultOverview_PAGE_DESC;
        }

        @Override
        public ImageDescriptor getImageDescriptor(IState state) {
            return ICON;
        }

        @Override
        public IDisplayablePage createPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
            return new ResultOverview(dpd, items, editor);
        }
    }

    class ShowIgnoreAction
    extends Action {
        public ShowIgnoreAction(String text) {
            super(text, 2);
            super.setImageDescriptor(ICON_IGNORE);
        }

        public void run() {
            ResultOverview.this.report.setShowIgnore(this.isChecked());
        }
    }

    class ShowOkAction
    extends Action {
        public ShowOkAction(String text) {
            super(text, 2);
            super.setImageDescriptor(ICON_OK);
        }

        public void run() {
            ResultOverview.this.report.setShowOk(this.isChecked());
        }
    }
}

