/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.ui.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.rjmx.common.IConnectionHandle;
import org.openjdk.jmc.rjmx.common.subscription.IMRIMetadataService;
import org.openjdk.jmc.rjmx.common.subscription.IMRIService;
import org.openjdk.jmc.rjmx.common.subscription.IMRIValueListener;
import org.openjdk.jmc.rjmx.common.subscription.ISubscriptionService;
import org.openjdk.jmc.rjmx.common.subscription.MRI;
import org.openjdk.jmc.rjmx.common.subscription.MRIValueEvent;
import org.openjdk.jmc.rjmx.subscription.MRIMetadataToolkit;
import org.openjdk.jmc.rjmx.ui.attributes.EditDisplayNameAction;
import org.openjdk.jmc.rjmx.ui.internal.AccessibleControlAction;
import org.openjdk.jmc.rjmx.ui.internal.AddAttibutesAction;
import org.openjdk.jmc.rjmx.ui.internal.AttributeLabelProvider;
import org.openjdk.jmc.rjmx.ui.internal.FreezeModel;
import org.openjdk.jmc.rjmx.ui.internal.IAttributeSet;
import org.openjdk.jmc.rjmx.ui.internal.MBeanPropertiesOrderer;
import org.openjdk.jmc.rjmx.ui.internal.Messages;
import org.openjdk.jmc.rjmx.ui.internal.StatisticsCalculator;
import org.openjdk.jmc.rjmx.ui.internal.StatisticsTable;
import org.openjdk.jmc.rjmx.ui.internal.ToggleFreezeAction;
import org.openjdk.jmc.ui.dial.Dial;
import org.openjdk.jmc.ui.dial.DialConfiguration;
import org.openjdk.jmc.ui.misc.IRefreshable;
import org.openjdk.jmc.ui.misc.MCLayoutFactory;
import org.openjdk.jmc.ui.misc.MCSectionPart;
import org.openjdk.jmc.ui.misc.MoveControlAction;
import org.openjdk.jmc.ui.rate.RateCoordinator;
import org.openjdk.jmc.ui.rate.RateLimitedRefresher;
import org.openjdk.jmc.ui.rate.RefreshController;

public class CombinedDialsSectionPart
extends MCSectionPart
implements IAttributeSet {
    private static final String ATTRIBUTE_DIAL_TAG = "attribute";
    private static final String TABLE_TAG = "table";
    private final StatisticsTable m_statisticsTable;
    private final Composite m_dialsHolder;
    private final GridLayout m_dialsHolderLayout;
    private final RefreshController m_refreshController;
    private final IConnectionHandle m_connection;
    private final IMRIMetadataService m_mds;
    private final IMRIService m_mriService;
    private final FreezeModel m_freezeModel = new FreezeModel();
    private final ISubscriptionService m_subscriptionService;
    private final Map<MRI, StatisticsCalculator> m_model = new HashMap<MRI, StatisticsCalculator>();
    private final FormToolkit toolkit;
    private Control[] m_orderedDials;
    private final AccessibleControlAction accessibleControlAction;
    private final RateCoordinator rateCoordinator;
    private final RateLimitedRefresher statisticsRefresher;
    private final Observer metadataObserver = new Observer(){

        @Override
        public void update(Observable o, Object arg) {
            CombinedDialsSectionPart.this.statisticsRefresher.setNeedsRefresh();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!CombinedDialsSectionPart.this.getSection().isDisposed()) {
                        Control[] controlArray = (this).CombinedDialsSectionPart.this.m_dialsHolder.getChildren();
                        int n = controlArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Control child = controlArray[n2];
                            ((AttributeDial)child).updateMetadata();
                            ++n2;
                        }
                    }
                }
            });
        }
    };

    public CombinedDialsSectionPart(Composite parent, FormToolkit toolkit, int style, IConnectionHandle ch) {
        this(parent, toolkit, style, ch, null);
    }

    public CombinedDialsSectionPart(Composite parent, FormToolkit toolkit, int style, IConnectionHandle ch, IMemento state) {
        super(parent, toolkit, style);
        this.m_refreshController = RefreshController.createGroup((Display)parent.getDisplay());
        this.toolkit = toolkit;
        this.m_connection = ch;
        this.m_subscriptionService = (ISubscriptionService)this.m_connection.getServiceOrNull(ISubscriptionService.class);
        this.m_mds = (IMRIMetadataService)this.m_connection.getServiceOrNull(IMRIMetadataService.class);
        this.m_mriService = (IMRIService)this.m_connection.getServiceOrNull(IMRIService.class);
        this.rateCoordinator = new RateCoordinator();
        this.m_refreshController.add((IRefreshable)this.rateCoordinator);
        this.statisticsRefresher = new RateLimitedRefresher(this.rateCoordinator, 500){

            protected void doRefresh() {
                TableViewer viewer = CombinedDialsSectionPart.this.m_statisticsTable.getViewer();
                Control control = viewer.getControl();
                if (control != null && !control.isDisposed()) {
                    boolean visible = control.isVisible();
                    if (visible) {
                        control.setRedraw(false);
                    }
                    viewer.refresh();
                    if (visible) {
                        control.setRedraw(true);
                        control.update();
                    }
                }
            }
        };
        this.m_freezeModel.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                if (CombinedDialsSectionPart.this.m_freezeModel.isFreezed()) {
                    CombinedDialsSectionPart.this.m_refreshController.remove((IRefreshable)CombinedDialsSectionPart.this.rateCoordinator);
                } else {
                    CombinedDialsSectionPart.this.m_refreshController.add((IRefreshable)CombinedDialsSectionPart.this.rateCoordinator);
                }
            }
        });
        final StackLayout stackLayout = new StackLayout();
        Composite stackContainer = this.createSectionBody((Layout)stackLayout);
        this.m_dialsHolder = toolkit.createComposite(stackContainer);
        this.m_dialsHolder.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CombinedDialsSectionPart.this.m_orderedDials = CombinedDialsSectionPart.this.m_dialsHolder.getChildren();
            }
        });
        this.m_dialsHolderLayout = new GridLayout(0, true);
        this.m_dialsHolderLayout.horizontalSpacing = 0;
        this.m_dialsHolder.setLayout((Layout)this.m_dialsHolderLayout);
        final Composite tableContainer = toolkit.createComposite(stackContainer);
        tableContainer.setLayout(MCLayoutFactory.createMarginFreeFormPageLayout());
        IMemento tableState = state == null ? null : state.getChild(TABLE_TAG);
        this.m_statisticsTable = new StatisticsTable(tableContainer, new AttributeLabelProvider(this.m_mds, this.m_mriService), this, true, tableState);
        this.m_statisticsTable.getViewer().getControl().setLayoutData(MCLayoutFactory.createFormPageLayoutData());
        this.m_statisticsTable.getViewer().setInput(this.m_model.values());
        this.getMCToolBarManager().add((IAction)new AddAttibutesAction(this.m_mds, this.m_mriService, this), 0);
        this.getMCToolBarManager().add((IAction)new ToggleFreezeAction(this.getMCToolBarManager(), this.m_freezeModel));
        this.accessibleControlAction = new AccessibleControlAction(){

            public void run() {
                stackLayout.topControl = this.isChecked() ? tableContainer : CombinedDialsSectionPart.this.m_dialsHolder;
                tableContainer.setVisible(this.isChecked());
                CombinedDialsSectionPart.this.m_dialsHolder.setVisible(!this.isChecked());
                CombinedDialsSectionPart.this.updateStructure();
            }
        };
        this.getMCToolBarManager().add((IAction)this.accessibleControlAction);
        this.m_mds.addObserver(this.metadataObserver);
        if (state != null) {
            this.restoreState(state);
        }
    }

    public void dispose() {
        if (this.accessibleControlAction != null) {
            this.accessibleControlAction.dispose();
        }
        this.m_refreshController.stop();
        this.m_mds.deleteObserver(this.metadataObserver);
        super.dispose();
    }

    @Override
    public void remove(MRI ... mris) {
        MRI[] mRIArray = mris;
        int n = mris.length;
        int n2 = 0;
        while (n2 < n) {
            MRI mri = mRIArray[n2];
            this.m_model.remove(mri);
            ++n2;
        }
        if (this.m_model.size() == 0) {
            this.m_refreshController.stop();
        }
        HashSet<MRI> removeMris = new HashSet<MRI>(Arrays.asList(mris));
        Control[] controlArray = this.m_dialsHolder.getChildren();
        int n3 = controlArray.length;
        n = 0;
        while (n < n3) {
            Control child = controlArray[n];
            AttributeDial dial = (AttributeDial)child;
            if (removeMris.contains(dial.mri)) {
                dial.dispose();
            }
            ++n;
        }
        this.updateStructure();
    }

    @Override
    public void add(MRI ... mris) {
        MRI[] mRIArray = mris;
        int n = mris.length;
        int n2 = 0;
        while (n2 < n) {
            MRI mri = mRIArray[n2];
            this.add(mri, new DialConfiguration());
            ++n2;
        }
        this.updateStructure();
    }

    public boolean isEmpty() {
        return this.m_model.isEmpty();
    }

    public MRI[] elements() {
        Set<MRI> attributes = this.m_model.keySet();
        return attributes.toArray(new MRI[attributes.size()]);
    }

    private boolean add(final MRI mri, DialConfiguration dialConfiguration) {
        if (!this.m_model.containsKey(mri)) {
            final AttributeDial newDial = new AttributeDial(mri, dialConfiguration);
            newDial.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    CombinedDialsSectionPart.this.m_subscriptionService.removeMRIValueListener((IMRIValueListener)newDial);
                    CombinedDialsSectionPart.this.m_refreshController.remove((IRefreshable)newDial.getDialViewer());
                }
            });
            this.m_model.put(mri, newDial.statistics);
            this.m_refreshController.add((IRefreshable)newDial.getDialViewer());
            this.m_refreshController.start();
            this.m_subscriptionService.addMRIValueListener(mri, (IMRIValueListener)newDial);
            MenuManager menuManager = new MenuManager();
            menuManager.add((IAction)new Action(Messages.AttributeDialSectionPart_CLEAR_STATISTICS_MENU_TEXT){

                public void run() {
                    newDial.reset();
                }
            });
            menuManager.add((IAction)new MoveControlAction((Control)newDial, false));
            menuManager.add((IAction)new MoveControlAction((Control)newDial, true));
            menuManager.add((IAction)new Action(Messages.DELETE_COMMAND_TEXT){
                {
                    super($anonymous0);
                    this.setImageDescriptor(((ICommandImageService)PlatformUI.getWorkbench().getService(ICommandImageService.class)).getImageDescriptor(ActionFactory.DELETE.getCommandId()));
                }

                public void run() {
                    CombinedDialsSectionPart.this.remove(mri);
                }
            });
            menuManager.add((IContributionItem)new Separator());
            menuManager.add((IAction)new EditDisplayNameAction(mri, this.m_mds));
            menuManager.add(newDial.getPropertiesAction());
            newDial.getDialViewer().setMenu(menuManager.createContextMenu((Control)newDial.getDialViewer()));
            newDial.setLayoutData(new GridData(4, 4, true, true));
            return true;
        }
        return false;
    }

    private static int calculateNumberOfColumns(int elementCount) {
        int rowCount = Math.max(1, CombinedDialsSectionPart.ceilDivision(elementCount, 5));
        return CombinedDialsSectionPart.ceilDivision(elementCount, rowCount);
    }

    private static int ceilDivision(int nominator, int denominator) {
        return (nominator + denominator - 1) / denominator;
    }

    public void saveState(IMemento state) {
        this.m_statisticsTable.saveState(state.createChild(TABLE_TAG));
        Control[] controlArray = this.m_dialsHolder.isDisposed() ? this.m_orderedDials : this.m_dialsHolder.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            AttributeDial dial = (AttributeDial)child;
            IMemento dialState = state.createChild(ATTRIBUTE_DIAL_TAG);
            dialState.putTextData(dial.mri.getQualifiedName());
            dial.getDialConfiguration().saveState(dialState);
            ++n2;
        }
    }

    public void restoreState(IMemento state) {
        IMemento[] iMementoArray = state.getChildren(ATTRIBUTE_DIAL_TAG);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento dialState = iMementoArray[n2];
            MRI attribute = MRI.createFromQualifiedName((String)dialState.getTextData().trim());
            DialConfiguration dc = new DialConfiguration();
            dc.restoreState(dialState);
            this.add(attribute, dc);
            ++n2;
        }
        this.updateStructure();
    }

    private void updateStructure() {
        this.m_dialsHolderLayout.numColumns = CombinedDialsSectionPart.calculateNumberOfColumns(this.m_model.size());
        this.getSection().getParent().layout(true);
        this.m_dialsHolder.layout(true, true);
        this.m_statisticsTable.getViewer().refresh();
    }

    private class AttributeDial
    extends Dial
    implements IMRIValueListener {
        final StatisticsCalculator statistics;
        final MRI mri;
        private final RateLimitedRefresher infoRefresher;

        AttributeDial(MRI mri, DialConfiguration dialConfiguration) {
            super(CombinedDialsSectionPart.this.m_dialsHolder, CombinedDialsSectionPart.this.toolkit, dialConfiguration);
            this.mri = mri;
            this.statistics = new StatisticsCalculator(mri);
            this.infoRefresher = new RateLimitedRefresher(CombinedDialsSectionPart.this.rateCoordinator, 100){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void doRefresh() {
                    Number max;
                    Number last;
                    StatisticsCalculator statisticsCalculator = AttributeDial.this.statistics;
                    synchronized (statisticsCalculator) {
                        last = AttributeDial.this.statistics.getLast();
                        max = AttributeDial.this.statistics.getMax();
                    }
                    AttributeDial.this.setInput(last, max, false);
                }
            };
            this.updateMetadata();
            String desc = CombinedDialsSectionPart.this.m_mds.getMetadata(mri).getDescription();
            String path = MBeanPropertiesOrderer.mriAsTooltip(mri);
            this.getDialViewer().setToolTipText(desc != null && desc.length() > 0 ? String.valueOf(path) + "\n" + desc : path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void valueChanged(MRIValueEvent event) {
            if (event.getValue() instanceof Number) {
                double value = ((Number)event.getValue()).doubleValue();
                StatisticsCalculator statisticsCalculator = this.statistics;
                synchronized (statisticsCalculator) {
                    this.statistics.addValue(value);
                    this.infoRefresher.setNeedsRefresh();
                    CombinedDialsSectionPart.this.statisticsRefresher.setNeedsRefresh();
                }
            }
        }

        void updateMetadata() {
            IUnit unit = UnitLookup.getUnitOrDefault((String)CombinedDialsSectionPart.this.m_mds.getMetadata(this.mri).getUnitString());
            if (!unit.equals(this.statistics.getUnit())) {
                this.statistics.setUnit(unit);
                this.setUnit(unit);
            }
            this.setTitle(MRIMetadataToolkit.getDisplayName((IMRIMetadataService)CombinedDialsSectionPart.this.m_mds, (MRI)this.mri));
        }

        public boolean reset() {
            if (this.statistics.reset()) {
                this.setInput(this.statistics.getLast(), this.statistics.getMax(), true);
                return true;
            }
            return false;
        }
    }
}

