/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.heap.model;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.openjdk.jmc.joverflow.heap.model.HeapStringReader;
import org.openjdk.jmc.joverflow.heap.model.JavaClass;
import org.openjdk.jmc.joverflow.heap.model.JavaField;
import org.openjdk.jmc.joverflow.heap.model.JavaHeapObject;
import org.openjdk.jmc.joverflow.heap.model.JavaLazyReadObject;
import org.openjdk.jmc.joverflow.heap.model.JavaLong;
import org.openjdk.jmc.joverflow.heap.model.JavaObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObjectTable;
import org.openjdk.jmc.joverflow.heap.model.JavaThing;
import org.openjdk.jmc.joverflow.heap.model.Root;
import org.openjdk.jmc.joverflow.heap.model.UnresolvedObject;
import org.openjdk.jmc.joverflow.heap.parser.ReadBuffer;
import org.openjdk.jmc.joverflow.util.IntToIntMap;
import org.openjdk.jmc.joverflow.util.LongToIntMap;
import org.openjdk.jmc.joverflow.util.LongToObjectMap;
import org.openjdk.jmc.joverflow.util.MiscUtils;
import org.openjdk.jmc.joverflow.util.NumberToIntMap;
import org.openjdk.jmc.joverflow.util.VerboseOutputCollector;

public class Snapshot {
    public static final long SMALL_ID_MASK = 0xFFFFFFFFL;
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final int hprofPointerSize;
    private final int pointerSize;
    private final int objHeaderSize;
    private final int objAlignment;
    private final boolean usingNarrowPointers;
    private final ArrayList<Root> roots;
    private final JavaObjectTable objectTable;
    private final NumberToIntMap objIdToPosInObjectTable;
    private final JavaClass[] classes;
    private final HashMap<String, JavaClass> classNameToJavaClass;
    private final LongToObjectMap<JavaClass> classIdToJavaClass;
    private final LongToObjectMap<JavaObject> classLoaders;
    private final long roughTotalObjectSize;
    private ReadBuffer readBuf;
    private HeapStringReader stringReader;
    private final boolean unresolvedObjectsOk;
    private SoftReference<ArrayList<JavaHeapObject>> finalizablesCache;
    private JavaClass weakReferenceClass;
    private int referentFieldIndex;
    private JavaClass javaLangClass;
    private JavaClass javaLangString;
    private JavaClass javaLangClassLoader;
    private JavaClass charArrayClass;
    private JavaClass byteArrayClass;
    private volatile boolean calculatingStats;
    private final VerboseOutputCollector vc;

    private Snapshot(int hprofPointerSize, int pointerSize, int objHeaderSize, int objAlignment, boolean usingNarrowPointers, long roughTotalObjectSize, ArrayList<Root> roots, JavaObjectTable objectTable, NumberToIntMap objIdToPosInObjectTable, JavaClass[] classes, HashMap<String, JavaClass> classNameToJavaClass, LongToObjectMap<JavaClass> classIdToJavaClass, ReadBuffer readBuf, VerboseOutputCollector vc, boolean unresolvedObjectsOk) {
        this.hprofPointerSize = hprofPointerSize;
        this.pointerSize = pointerSize;
        this.objHeaderSize = objHeaderSize;
        this.objAlignment = objAlignment;
        this.usingNarrowPointers = usingNarrowPointers;
        this.roughTotalObjectSize = roughTotalObjectSize;
        this.roots = roots;
        this.objectTable = objectTable;
        this.objIdToPosInObjectTable = objIdToPosInObjectTable;
        this.classes = classes;
        this.classNameToJavaClass = classNameToJavaClass;
        this.classIdToJavaClass = classIdToJavaClass;
        this.classLoaders = new LongToObjectMap(50, false);
        this.readBuf = readBuf;
        this.vc = vc;
        this.unresolvedObjectsOk = unresolvedObjectsOk;
        this.javaLangClass = this.getClassForName("java.lang.Class");
        this.javaLangString = this.getClassForName("java.lang.String");
        this.javaLangClassLoader = this.getClassForName("java.lang.ClassLoader");
        this.charArrayClass = this.getClassForName("[C");
        this.byteArrayClass = this.getClassForName("[B");
        this.weakReferenceClass = this.getClassForName("java.lang.ref.Reference");
        JavaClass[] javaClassArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            JavaClass clazz = javaClassArray[n2];
            clazz.resolve(this, roots);
            ++n2;
        }
        this.stringReader = new HeapStringReader(this);
        JavaField[] fields = this.weakReferenceClass.getFieldsForInstance();
        int i = 0;
        while (i < fields.length) {
            if ("referent".equals(fields[i].getName())) {
                this.referentFieldIndex = i;
                break;
            }
            ++i;
        }
    }

    public JavaHeapObject getObjectForId(long id) {
        if (id == 0L) {
            return null;
        }
        int objPosInTable = this.objIdToPosInObjectTable.get(id);
        if (objPosInTable >= 0) {
            return this.objectTable.getObject(objPosInTable);
        }
        return this.classIdToJavaClass.get(id);
    }

    public JavaHeapObject getObjectAtGlobalIndex(int globalIndex) {
        if (globalIndex > 0) {
            return this.objectTable.getObject(globalIndex);
        }
        return this.classes[-globalIndex];
    }

    public JavaClass getClassForName(String name) {
        return this.classNameToJavaClass.get(name);
    }

    public JavaClass getClassForId(long id) {
        return this.classIdToJavaClass.get(id);
    }

    public List<Root> getRoots() {
        return this.roots;
    }

    public Collection<JavaLazyReadObject> getObjects() {
        return this.objectTable.getObjects();
    }

    public Collection<JavaLazyReadObject> getUnvisitedObjects() {
        return this.objectTable.getUnvisitedObjects();
    }

    public JavaClass[] getClasses() {
        return this.classes;
    }

    public Collection<JavaObject> getClassLoaders() {
        return this.classLoaders.values();
    }

    public int getNumObjects() {
        return this.objIdToPosInObjectTable.size();
    }

    public int getNumClasses() {
        return this.classes.length;
    }

    public ReadBuffer getReadBuffer() {
        return this.readBuf;
    }

    public void resetReadBuffer(ReadBuffer.Factory bufFactory) {
        try {
            this.readBuf = bufFactory.create(null);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void discard() {
        this.readBuf.close();
    }

    JavaThing dereferenceField(long objId, JavaField field) {
        if (field != null && !field.isReference()) {
            return new JavaLong(objId);
        }
        if (objId == 0L) {
            return null;
        }
        JavaThing result = this.getObjectForId(objId);
        if (result == null) {
            if (!this.unresolvedObjectsOk && this.vc != null) {
                this.vc.addWarning("Failed to resolve object", "id = " + MiscUtils.toHex(objId) + (field != null ? "for field " + field.getName() + " (signature " + field.getTypeId() + ")" : ""));
            }
            result = new UnresolvedObject(objId);
        }
        return result;
    }

    JavaThing dereferenceClassLoader(long objId, JavaClass clazz) {
        if (objId == 0L) {
            return null;
        }
        JavaObject loader = this.classLoaders.get(objId);
        if (loader != null) {
            return loader;
        }
        loader = (JavaObject)this.getObjectForId(objId);
        if (loader == null) {
            if (!this.unresolvedObjectsOk && this.vc != null) {
                this.vc.addWarning("Failed to resolve classloader", "id = " + MiscUtils.toHex(objId) + " for class " + clazz.getHumanFriendlyName());
            }
            return new UnresolvedObject(objId);
        }
        this.classLoaders.put(objId, loader);
        String s = "Classloader of " + clazz.getName();
        this.roots.add(new Root(objId, clazz.readId(), 9, s));
        return loader;
    }

    public synchronized Iterator<JavaHeapObject> getFinalizerObjects() {
        ArrayList<JavaHeapObject> obj;
        if (this.finalizablesCache != null && (obj = this.finalizablesCache.get()) != null) {
            return obj.iterator();
        }
        JavaClass clazz = this.getClassForName("java.lang.ref.Finalizer");
        JavaObject queue = (JavaObject)clazz.getStaticField("queue");
        JavaThing tmp = queue.getField("head");
        ArrayList<JavaHeapObject> finalizables = new ArrayList<JavaHeapObject>();
        if (tmp != null) {
            JavaObject head = (JavaObject)tmp;
            while (true) {
                JavaHeapObject referent = (JavaHeapObject)head.getField("referent");
                JavaThing next = head.getField("next");
                if (next == null || next.equals(head)) break;
                head = (JavaObject)next;
                finalizables.add(referent);
            }
        }
        this.finalizablesCache = new SoftReference(finalizables);
        return finalizables.iterator();
    }

    public long getRoughTotalObjectSize() {
        return this.roughTotalObjectSize;
    }

    public int getHprofPointerSize() {
        return this.hprofPointerSize;
    }

    public int getPointerSize() {
        return this.pointerSize;
    }

    public int getObjectHeaderSize() {
        return this.objHeaderSize;
    }

    public int getArrayHeaderSize() {
        return this.objHeaderSize + 4;
    }

    public int getObjectAlignment() {
        return this.objAlignment;
    }

    public boolean usingNarrowPointers() {
        return this.usingNarrowPointers;
    }

    public HeapStringReader getStringReader() {
        return this.stringReader;
    }

    public VerboseOutputCollector getVerboseOutputCollector() {
        return this.vc;
    }

    JavaClass getJavaLangClass() {
        return this.javaLangClass;
    }

    JavaClass getJavaLangStringClass() {
        return this.javaLangString;
    }

    JavaClass getJavaLangClassLoaderClass() {
        return this.javaLangClassLoader;
    }

    JavaClass getCharArrayClass() {
        return this.charArrayClass;
    }

    JavaClass getByteArrayClass() {
        return this.byteArrayClass;
    }

    public JavaClass getWeakReferenceClass() {
        return this.weakReferenceClass;
    }

    public int getReferentFieldIndex() {
        return this.referentFieldIndex;
    }

    public boolean isCalculatingStats() {
        return this.calculatingStats;
    }

    public void setCalculatingStats(boolean value) {
        this.calculatingStats = value;
    }

    public static class Builder {
        private static final int EXPECTED_OBJ_SIZE_IN_FILE = 70;
        private int hprofPointerSize;
        private int pointerSize;
        private int objHeaderSize;
        private int objAlignment;
        private boolean usingNarrowPointers;
        private static ObjTableSizePolicy objTableSizePolicy;
        private final ArrayList<Root> roots = new ArrayList();
        private final JavaObjectTable.Builder objTableBuilder;
        private final NumberToIntMap objIdToPosInObjectTable;
        private final ArrayList<Object> classList;
        private final LongToObjectMap<Object> classIdToJavaClass;
        private final HashMap<String, JavaClass> classNameToJavaClass;
        private boolean unresolvedObjectsOk;
        private final VerboseOutputCollector vc;
        private long roughTotalObjectSize;

        public Builder(long hprofFileSize, int hprofIdentifierSize, int explicitPointerSize, VerboseOutputCollector vc) {
            this.vc = vc;
            this.hprofPointerSize = hprofIdentifierSize;
            if (explicitPointerSize > 0) {
                this.pointerSize = explicitPointerSize;
            } else if (hprofIdentifierSize == 4) {
                this.pointerSize = 4;
            } else if (hprofFileSize < 0x680000000L) {
                this.pointerSize = 4;
                this.usingNarrowPointers = true;
            } else {
                this.pointerSize = 8;
            }
            this.objHeaderSize = hprofIdentifierSize == 4 ? 8 : (this.pointerSize == 4 ? 12 : 16);
            this.objAlignment = 8;
            int objTableSize = objTableSizePolicy != null ? objTableSizePolicy.getInitialObjTableSize(hprofFileSize) : (int)(hprofFileSize / 70L);
            this.objIdToPosInObjectTable = this.pointerSize == 4 ? new IntToIntMap(objTableSize) : new LongToIntMap(objTableSize);
            this.classList = new ArrayList(objTableSize / 2000);
            this.objTableBuilder = new JavaObjectTable.Builder(hprofFileSize);
            this.classIdToJavaClass = new LongToObjectMap(objTableSize / 2000, false);
            this.classNameToJavaClass = new HashMap(objTableSize / 2000);
        }

        public static void setObjTableSizePolicy(ObjTableSizePolicy policy) {
            objTableSizePolicy = policy;
        }

        public void onFinishReadObjects() {
            this.objIdToPosInObjectTable.adjustCapacityIfNeeded();
        }

        public Snapshot buildSnapshot(ReadBuffer readBuf) {
            this.checkForMissingJavaClasses();
            JavaClass[] classes = this.classList.toArray(new JavaClass[this.classList.size()]);
            JavaObjectTable objectTable = this.objTableBuilder.buildJavaObjectTable(classes);
            this.resolveSuperclasses(classes);
            this.recheckPointerSize(objectTable, readBuf);
            this.roots.sort(null);
            Snapshot snapshot = new Snapshot(this.hprofPointerSize, this.pointerSize, this.objHeaderSize, this.objAlignment, this.usingNarrowPointers, this.roughTotalObjectSize, this.roots, objectTable, this.objIdToPosInObjectTable, classes, this.classNameToJavaClass, this.classIdToJavaClass, readBuf, this.vc, this.unresolvedObjectsOk);
            return snapshot;
        }

        public void addJavaObject(long id, long classID, long objOfsInFile, int objDataSize) {
            int classIdx = this.getClassIdxForClassID(classID);
            int objPosInTable = this.objTableBuilder.addJavaObject(classIdx, objOfsInFile);
            this.objIdToPosInObjectTable.put(id, objPosInTable);
            this.roughTotalObjectSize += (long)(objDataSize + this.objHeaderSize);
        }

        public void addJavaObjectArray(long id, long classID, long objOfsInFile, int length, int objDataSize) {
            int classIdx = this.getClassIdxForClassID(classID);
            int objPosInTable = this.objTableBuilder.addJavaArray(classIdx, objOfsInFile, length);
            this.objIdToPosInObjectTable.put(id, objPosInTable);
            this.roughTotalObjectSize += (long)(objDataSize + this.objHeaderSize + 4);
        }

        public void addJavaValueArray(long id, char primitiveSignature, long objOfsInFile, int length, int objDataSize) {
            JavaClass clazz = this.getPrimitiveArrayClass(primitiveSignature);
            int classIdx = clazz.getClassListIdx();
            int objPosInTable = this.objTableBuilder.addJavaArray(classIdx, objOfsInFile, length);
            this.objIdToPosInObjectTable.put(id, objPosInTable);
            this.roughTotalObjectSize += (long)(objDataSize + this.objHeaderSize + 4);
        }

        public void addRoot(Root r) {
            this.roots.add(r);
        }

        public void addClass(JavaClass clazz) {
            Object classIdxOrNull = this.classIdToJavaClass.get(clazz.readId());
            if (classIdxOrNull == null) {
                int classIdx = this.classList.size();
                clazz.setClassListIdx(classIdx);
                this.classList.add(clazz);
            } else {
                int classIdx = (Integer)classIdxOrNull;
                clazz.setClassListIdx(classIdx);
                this.classList.set(classIdx, clazz);
            }
            this.addToClassMaps(clazz);
            this.recheckObjectHeaderSize(clazz);
        }

        public int getPointerSize() {
            return this.pointerSize;
        }

        public int getNumAllObjects() {
            return this.objTableBuilder.getNumObjects();
        }

        public int getNumClasses() {
            return this.classList.size();
        }

        public void setUnresolvedObjectsOk(boolean v) {
            this.unresolvedObjectsOk = v;
        }

        public int getInMemoryInstanceSize(int instanceFieldsSize) {
            int result = instanceFieldsSize + this.objHeaderSize;
            return MiscUtils.getAlignedObjectSize(result, this.objAlignment);
        }

        private int getClassIdxForClassID(long classID) {
            Object classOrIdx = this.classIdToJavaClass.get(classID);
            if (classOrIdx == null) {
                int classIdx = this.classList.size();
                this.classList.add(classID);
                this.classIdToJavaClass.put(classID, classIdx);
                return classIdx;
            }
            if (classOrIdx instanceof JavaClass) {
                return ((JavaClass)classOrIdx).getClassListIdx();
            }
            return (Integer)classOrIdx;
        }

        private void checkForMissingJavaClasses() {
            int i = 0;
            while (i < this.classList.size()) {
                Object clazzOrId = this.classList.get(i);
                if (clazzOrId instanceof Long) {
                    long classId = (Long)clazzOrId;
                    if (!this.unresolvedObjectsOk && this.vc != null) {
                        this.vc.addWarning("Failed to resolve object", "No JavaClass found for class ID = " + classId);
                    }
                    JavaClass clazz = this.createFakeClass(classId, 0);
                    clazz.setClassListIdx(i);
                    this.classList.set(i, clazz);
                    this.addToClassMaps(clazz);
                }
                ++i;
            }
        }

        private void addToClassMaps(JavaClass clazz) {
            this.classIdToJavaClass.put(clazz.readId(), clazz);
            JavaClass existingClass = this.classNameToJavaClass.get(clazz.getName());
            if (existingClass != null) {
                existingClass.addNextVersion(clazz);
            } else {
                this.classNameToJavaClass.put(clazz.getName(), clazz);
            }
        }

        JavaClass getPrimitiveArrayClass(char elementSignature) {
            String className = "[" + elementSignature;
            JavaClass clazz = this.classNameToJavaClass.get(className);
            if (clazz == null) {
                clazz = new JavaClass(className, 0L, 0L, 0L, 0L, JavaClass.NO_FIELDS, JavaClass.NO_FIELDS, JavaClass.NO_VALUES, 0, 0);
                int classIdx = this.classList.size();
                clazz.setClassListIdx(classIdx);
                this.classList.add(clazz);
                this.classNameToJavaClass.put(className, clazz);
            }
            return clazz;
        }

        private JavaClass createFakeClass(long classID, int instSize) {
            String name = "unknown-class<@" + MiscUtils.toHex(classID) + ">";
            int numInts = instSize / 4;
            int numBytes = instSize % 4;
            JavaField[] fields = new JavaField[numInts + numBytes];
            int i = 0;
            while (i < numInts) {
                fields[i] = JavaField.newInstance("unknown-field-" + i, 'I', this.pointerSize);
                ++i;
            }
            i = 0;
            while (i < numBytes) {
                fields[i + numInts] = JavaField.newInstance("unknown-field-" + i + numInts, 'B', this.pointerSize);
                ++i;
            }
            return new JavaClass(classID, name, 0L, 0L, 0L, 0L, fields, JavaClass.NO_FIELDS, JavaClass.NO_VALUES, instSize, this.getInMemoryInstanceSize(instSize));
        }

        private void resolveSuperclasses(JavaClass[] classes) {
            JavaClass[] javaClassArray = classes;
            int n = classes.length;
            int n2 = 0;
            while (n2 < n) {
                JavaClass clazz = javaClassArray[n2];
                clazz.resolveSuperclass(this.classIdToJavaClass);
                ++n2;
            }
        }

        private void recheckObjectHeaderSize(JavaClass c) {
            if (c.getName().startsWith("jrockit.vm.") && this.objHeaderSize != 8) {
                this.updateObjectHeaderSize(8);
            }
        }

        private void updateObjectHeaderSize(int objHeaderSize) {
            this.objHeaderSize = objHeaderSize;
            for (Object clazzOrID : this.classList) {
                if (!(clazzOrID instanceof JavaClass)) continue;
                JavaClass clazz = (JavaClass)clazzOrID;
                clazz.updateInstanceSize(this.getInMemoryInstanceSize(clazz.getFieldsSizeInFile()));
            }
        }

        private void recheckPointerSize(JavaObjectTable objectTable, ReadBuffer readBuf) {
            if (this.hprofPointerSize == 4) {
                return;
            }
            Collection<JavaLazyReadObject> allObjects = objectTable.getObjects();
            JavaLazyReadObject prevObj = null;
            long prevObjId = 0L;
            int nCheckedObjs = 0;
            for (JavaLazyReadObject obj : allObjects) {
                long prevObjSize;
                if (prevObj == null) {
                    prevObj = obj;
                    prevObjId = prevObj.readId(readBuf, this.hprofPointerSize);
                    continue;
                }
                long objId = obj.readId(readBuf, this.hprofPointerSize);
                if (prevObj instanceof JavaObject && obj instanceof JavaObject && (++nCheckedObjs > 1000000 || (prevObjSize = objId - prevObjId) > 12L && prevObjSize <= 40L && this.verifyObjSize((JavaObject)prevObj, (int)prevObjSize))) break;
                prevObj = obj;
                prevObjId = objId;
            }
        }

        private boolean verifyObjSize(JavaObject obj, int objSize) {
            JavaClass clazz = obj.getClazz();
            JavaField[] fields = clazz.getFieldsForInstance();
            int nPointers = 0;
            int nInts = 0;
            JavaField[] javaFieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                JavaField field = javaFieldArray[n2];
                if (field.isReference()) {
                    ++nPointers;
                } else if (field.getTypeId() == 'I') {
                    ++nInts;
                } else {
                    return false;
                }
                ++n2;
            }
            if (nPointers < 2) {
                return false;
            }
            int expectedObjSize = MiscUtils.getAlignedObjectSize(this.objHeaderSize + this.pointerSize * nPointers + 4 * nInts, this.objAlignment);
            if (expectedObjSize == objSize) {
                return true;
            }
            int altPointerSize = this.pointerSize == 4 ? 8 : 4;
            int altObjHeaderSize = altPointerSize == 4 ? 12 : 16;
            int newExpectedObjSize = MiscUtils.getAlignedObjectSize(altObjHeaderSize + altPointerSize * nPointers + 4 * nInts, this.objAlignment);
            if (newExpectedObjSize == objSize) {
                this.pointerSize = altPointerSize;
                this.objHeaderSize = altObjHeaderSize;
            }
            return true;
        }
    }

    public static interface ObjTableSizePolicy {
        public int getInitialObjTableSize(long var1);
    }
}

