/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.heap.parser;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import org.openjdk.jmc.joverflow.heap.model.ArrayTypeCodes;
import org.openjdk.jmc.joverflow.heap.model.JavaBoolean;
import org.openjdk.jmc.joverflow.heap.model.JavaByte;
import org.openjdk.jmc.joverflow.heap.model.JavaChar;
import org.openjdk.jmc.joverflow.heap.model.JavaClass;
import org.openjdk.jmc.joverflow.heap.model.JavaDouble;
import org.openjdk.jmc.joverflow.heap.model.JavaField;
import org.openjdk.jmc.joverflow.heap.model.JavaFloat;
import org.openjdk.jmc.joverflow.heap.model.JavaInt;
import org.openjdk.jmc.joverflow.heap.model.JavaLong;
import org.openjdk.jmc.joverflow.heap.model.JavaObjectRef;
import org.openjdk.jmc.joverflow.heap.model.JavaShort;
import org.openjdk.jmc.joverflow.heap.model.JavaThing;
import org.openjdk.jmc.joverflow.heap.model.Root;
import org.openjdk.jmc.joverflow.heap.model.Snapshot;
import org.openjdk.jmc.joverflow.heap.model.StackFrame;
import org.openjdk.jmc.joverflow.heap.model.StackTrace;
import org.openjdk.jmc.joverflow.heap.parser.DumpCorruptedException;
import org.openjdk.jmc.joverflow.heap.parser.HeapDumpReader;
import org.openjdk.jmc.joverflow.heap.parser.HprofParsingCancelledException;
import org.openjdk.jmc.joverflow.heap.parser.PositionDataInputStream;
import org.openjdk.jmc.joverflow.heap.parser.ReadBuffer;
import org.openjdk.jmc.joverflow.util.FileUtils;
import org.openjdk.jmc.joverflow.util.LongToObjectMap;
import org.openjdk.jmc.joverflow.util.MiscUtils;
import org.openjdk.jmc.joverflow.util.VerboseOutputCollector;

class HprofReader
extends HeapDumpReader
implements ArrayTypeCodes {
    static final int MAGIC_NUMBER = 1245795905;
    private static final String[] VERSIONS = new String[]{" PROFILE 1.0\u0000", " PROFILE 1.0.1\u0000", " PROFILE 1.0.2\u0000"};
    private static final int VERSION_JDK12BETA3 = 0;
    private static final int VERSION_JDK12BETA4 = 1;
    private static final int VERSION_JDK6 = 2;
    static final int HPROF_UTF8 = 1;
    static final int HPROF_LOAD_CLASS = 2;
    static final int HPROF_UNLOAD_CLASS = 3;
    static final int HPROF_FRAME = 4;
    static final int HPROF_TRACE = 5;
    static final int HPROF_ALLOC_SITES = 6;
    static final int HPROF_HEAP_SUMMARY = 7;
    static final int HPROF_START_THREAD = 10;
    static final int HPROF_END_THREAD = 11;
    static final int HPROF_HEAP_DUMP = 12;
    static final int HPROF_CPU_SAMPLES = 13;
    static final int HPROF_CONTROL_SETTINGS = 14;
    static final int HPROF_LOCKSTATS_WAIT_TIME = 16;
    static final int HPROF_LOCKSTATS_HOLD_TIME = 17;
    static final int HPROF_GC_ROOT_UNKNOWN = 255;
    static final int HPROF_GC_ROOT_JNI_GLOBAL = 1;
    static final int HPROF_GC_ROOT_JNI_LOCAL = 2;
    static final int HPROF_GC_ROOT_JAVA_FRAME = 3;
    static final int HPROF_GC_ROOT_NATIVE_STACK = 4;
    static final int HPROF_GC_ROOT_STICKY_CLASS = 5;
    static final int HPROF_GC_ROOT_THREAD_BLOCK = 6;
    static final int HPROF_GC_ROOT_MONITOR_USED = 7;
    static final int HPROF_GC_ROOT_THREAD_OBJ = 8;
    static final int HPROF_GC_CLASS_DUMP = 32;
    static final int HPROF_GC_INSTANCE_DUMP = 33;
    static final int HPROF_GC_OBJ_ARRAY_DUMP = 34;
    static final int HPROF_GC_PRIM_ARRAY_DUMP = 35;
    static final int HPROF_HEAP_DUMP_SEGMENT = 28;
    static final int HPROF_HEAP_DUMP_END = 44;
    private static final int T_CLASS = 2;
    private final ReadBuffer.Factory bufFactory;
    private final File hprofFile;
    private final byte[] fileImageBytes;
    private PositionDataInputStream in;
    private final long fileSize;
    private int version;
    private int dumpsToSkip;
    private int identifierSize;
    private final LongToObjectMap<String> names;
    private HashMap<Integer, ThreadObject> threadObjects;
    private LongToObjectMap<String> classNameFromObjectID;
    private HashMap<Long, StackFrame> stackFrames;
    private HashMap<Integer, StackTrace> stackTraces;
    private HashMap<Integer, String> classNameFromSerialNo;
    private Snapshot.Builder snpBuilder;
    private static final int MAX_BB_SIZE = Integer.MAX_VALUE;
    private final boolean longFile;
    private final ArrayList<Long> mappedBBEndOfs;
    private long currentBBMaxOfs;
    private long prevObjStartOfs;
    private final int explicitPointerSize;
    private final VerboseOutputCollector vc;
    private volatile boolean cancelled;

    HprofReader(ReadBuffer.Factory bufFactory, boolean callStack, int explicitPointerSize, VerboseOutputCollector vc) throws DumpCorruptedException {
        int dumpNumber;
        block10: {
            int pos;
            this.bufFactory = bufFactory;
            String fileName = bufFactory.getFileName();
            dumpNumber = 1;
            if (fileName != null && (pos = fileName.lastIndexOf(35)) > -1) {
                String num = fileName.substring(pos + 1, fileName.length());
                try {
                    dumpNumber = Integer.parseInt(num, 10);
                }
                catch (NumberFormatException numberFormatException) {
                    String msg = "in file name \"" + fileName + "\", a dump number was " + "expected after the :, but \"" + num + "\" was found instead.";
                    throw new DumpCorruptedException(msg);
                }
                fileName = fileName.substring(0, pos);
            }
            this.fileImageBytes = bufFactory.getFileImageBytes();
            if (this.fileImageBytes == null) {
                try {
                    this.hprofFile = FileUtils.checkFileExistsAndReadable(fileName, false);
                    this.fileSize = this.hprofFile.length();
                    if (this.fileSize == 0L) {
                        throw new DumpCorruptedException("file size is 0");
                    }
                    break block10;
                }
                catch (IOException ex) {
                    throw new DumpCorruptedException(ex.getMessage());
                }
            }
            this.hprofFile = null;
            this.fileSize = this.fileImageBytes.length;
        }
        this.vc = vc;
        this.dumpsToSkip = dumpNumber - 1;
        this.explicitPointerSize = explicitPointerSize;
        this.names = new LongToObjectMap((int)(this.fileSize / 100000L), false);
        this.threadObjects = new HashMap(43);
        this.classNameFromObjectID = new LongToObjectMap(1000, false);
        if (callStack) {
            this.stackFrames = new HashMap(43);
            this.stackTraces = new HashMap(43);
            this.classNameFromSerialNo = new HashMap();
        }
        boolean bl = this.longFile = this.fileSize > Integer.MAX_VALUE;
        if (this.longFile) {
            this.mappedBBEndOfs = new ArrayList();
            this.currentBBMaxOfs = 0x7FFFFFFEL;
        } else {
            this.mappedBBEndOfs = null;
        }
    }

    @Override
    public Snapshot read() throws DumpCorruptedException, HprofParsingCancelledException {
        ReadBuffer readBuf;
        String dumpCorruptedExMsg;
        block25: {
            dumpCorruptedExMsg = "";
            readBuf = null;
            try {
                try {
                    this.in = this.hprofFile != null ? new PositionDataInputStream(new BufferedInputStream(new FileInputStream(this.hprofFile))) : new PositionDataInputStream(new ByteArrayInputStream(this.fileImageBytes));
                    this.doRead();
                    if (this.snpBuilder.getNumAllObjects() == 0) {
                        throw new DumpCorruptedException("did not read any objects");
                    }
                    if (this.snpBuilder.getNumClasses() == 0) {
                        throw new DumpCorruptedException("did not read any classes");
                    }
                    this.snpBuilder.onFinishReadObjects();
                    long[] mappedBBEndOfsArray = null;
                    if (this.mappedBBEndOfs != null) {
                        mappedBBEndOfsArray = new long[this.mappedBBEndOfs.size() + 1];
                        int i = 0;
                        while (i < this.mappedBBEndOfs.size()) {
                            mappedBBEndOfsArray[i] = this.mappedBBEndOfs.get(i);
                            ++i;
                        }
                        mappedBBEndOfsArray[mappedBBEndOfsArray.length - 1] = this.fileSize - 1L;
                    }
                    readBuf = this.bufFactory.create(mappedBBEndOfsArray);
                }
                catch (IOException ex) {
                    dumpCorruptedExMsg = "caught exception " + ex + ". Details:\n";
                    StringWriter exWriterBuf = new StringWriter(200);
                    ex.printStackTrace(new PrintWriter(exWriterBuf));
                    dumpCorruptedExMsg = String.valueOf(dumpCorruptedExMsg) + exWriterBuf.toString();
                    if (this.in != null) {
                        try {
                            this.in.close();
                        }
                        catch (IOException ex2) {
                            dumpCorruptedExMsg = String.valueOf(dumpCorruptedExMsg) + "\nAlso, could not close the stream properly: caught exception " + ex2;
                            if (readBuf != null) {
                                readBuf.close();
                            }
                        }
                    }
                    break block25;
                }
            }
            catch (Throwable throwable) {
                block26: {
                    if (this.in != null) {
                        try {
                            this.in.close();
                        }
                        catch (IOException ex) {
                            dumpCorruptedExMsg = String.valueOf(dumpCorruptedExMsg) + "\nAlso, could not close the stream properly: caught exception " + ex;
                            if (readBuf == null) break block26;
                            readBuf.close();
                        }
                    }
                }
                throw throwable;
            }
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException ex) {
                    dumpCorruptedExMsg = String.valueOf(dumpCorruptedExMsg) + "\nAlso, could not close the stream properly: caught exception " + ex;
                    if (readBuf == null) break block25;
                    readBuf.close();
                }
            }
        }
        if (dumpCorruptedExMsg.length() > 0) {
            throw new DumpCorruptedException(dumpCorruptedExMsg);
        }
        try {
            return this.snpBuilder.buildSnapshot(readBuf);
        }
        catch (RuntimeException ex) {
            if (readBuf != null) {
                readBuf.close();
            }
            throw ex;
        }
        catch (Error er) {
            if (readBuf != null) {
                readBuf.close();
            }
            throw er;
        }
    }

    @Override
    public synchronized int getProgressPercentage() {
        if (this.in != null) {
            return (int)(this.in.position() * 100L / this.fileSize);
        }
        return 0;
    }

    @Override
    public void cancelReading() {
        this.cancelled = true;
    }

    private void doRead() throws DumpCorruptedException, IOException, HprofParsingCancelledException {
        int magicNumber = this.in.readInt();
        if (magicNumber != 1245795905) {
            throw new DumpCorruptedException("unrecognized magic number: " + magicNumber);
        }
        this.version = this.readVersionHeader();
        this.identifierSize = this.in.readInt();
        if (this.identifierSize != 4 && this.identifierSize != 8) {
            throw new DumpCorruptedException("unsupported format: specifies pointer size of " + this.identifierSize + ". JOverflow supports only size 4 and 8.");
        }
        this.snpBuilder = new Snapshot.Builder(this.fileSize, this.identifierSize, this.explicitPointerSize, this.vc);
        this.skipBytes(8L);
        block16: while (true) {
            int type;
            try {
                type = this.in.readUnsignedByte();
            }
            catch (EOFException eOFException) {
                break;
            }
            this.in.readInt();
            long length = (long)this.in.readInt() & 0xFFFFFFFFL;
            if (length < 0L) {
                throw new DumpCorruptedException("bad record length of " + length + " at byte " + (this.in.position() - 4L) + " of file.");
            }
            switch (type) {
                case 1: {
                    long id = this.readID();
                    byte[] chars = new byte[(int)length - this.identifierSize];
                    this.in.readFully(chars);
                    this.names.put(id, new String(chars));
                    continue block16;
                }
                case 2: {
                    int serialNo = this.in.readInt();
                    long classID = this.readID();
                    this.in.readInt();
                    long classNameID = this.readID();
                    String nm = this.getNameFromID(classNameID).replace('/', '.');
                    this.classNameFromObjectID.put(classID, nm);
                    if (this.classNameFromSerialNo == null) continue block16;
                    this.classNameFromSerialNo.put(serialNo, nm);
                    continue block16;
                }
                case 12: {
                    if (this.dumpsToSkip <= 0) {
                        try {
                            this.vc.debug("Sub-dump of length " + length + " starts at position " + this.in.position());
                            this.readHeapDump(length);
                        }
                        catch (EOFException exp) {
                            this.handleEOF(exp);
                        }
                        return;
                    }
                    --this.dumpsToSkip;
                    this.skipBytes(length);
                    continue block16;
                }
                case 44: {
                    if (this.version >= 2) {
                        if (this.dumpsToSkip <= 0) {
                            this.skipBytes(length);
                            return;
                        }
                        --this.dumpsToSkip;
                    } else {
                        this.vc.addWarning("Ignoring unrecognized record type", Integer.toString(type));
                    }
                    this.skipBytes(length);
                    continue block16;
                }
                case 28: {
                    if (this.version >= 2) {
                        if (this.dumpsToSkip <= 0) {
                            try {
                                this.vc.debug("Segment of length " + length + " starts at position " + this.in.position());
                                this.readHeapDump(length);
                            }
                            catch (EOFException exp) {
                                this.handleEOF(exp);
                            }
                            continue block16;
                        }
                        this.skipBytes(length);
                        continue block16;
                    }
                    this.vc.addWarning("Ignoring unrecognized record type", Integer.toString(type));
                    this.skipBytes(length);
                    continue block16;
                }
                case 4: {
                    if (this.stackFrames == null) {
                        this.skipBytes(length);
                        continue block16;
                    }
                    long id = this.readID();
                    String methodName = this.getNameFromID(this.readID());
                    String methodSig = this.getNameFromID(this.readID());
                    String sourceFile = this.getNameFromID(this.readID());
                    int classSer = this.in.readInt();
                    String className = this.classNameFromSerialNo.get(classSer);
                    int lineNumber = this.in.readInt();
                    if (lineNumber < -3) {
                        this.vc.addWarning("Weird stack frame line number", Integer.toString(lineNumber));
                        lineNumber = -1;
                    }
                    this.stackFrames.put(id, new StackFrame(methodName, methodSig, className, sourceFile, lineNumber));
                    continue block16;
                }
                case 5: {
                    if (this.stackTraces == null) {
                        this.skipBytes(length);
                        continue block16;
                    }
                    int serialNo = this.in.readInt();
                    this.in.readInt();
                    StackFrame[] frames = new StackFrame[this.in.readInt()];
                    int i = 0;
                    while (i < frames.length) {
                        long fid = this.readID();
                        frames[i] = this.stackFrames.get(fid);
                        if (frames[i] == null) {
                            throw new DumpCorruptedException("stack frame " + this.toHex(fid) + " not found");
                        }
                        ++i;
                    }
                    this.stackTraces.put(serialNo, new StackTrace(frames));
                    continue block16;
                }
                case 3: 
                case 6: 
                case 7: 
                case 10: 
                case 11: 
                case 13: 
                case 14: 
                case 16: 
                case 17: {
                    this.skipBytes(length);
                    continue block16;
                }
            }
            this.skipBytes(length);
            this.vc.addWarning("Ignoring unrecognized record type", Integer.toString(type));
        }
    }

    private void skipBytes(long length) throws IOException, DumpCorruptedException {
        long remainingBytes = length;
        do {
            int skippedBytes;
            if ((remainingBytes -= (long)(skippedBytes = this.in.skipBytes((int)length))) <= 0L || this.in.position() < this.fileSize) continue;
            throw new DumpCorruptedException("Reached end of file while trying to skip " + length + " bytes");
        } while (remainingBytes > 0L);
    }

    private int readVersionHeader() throws IOException, DumpCorruptedException {
        int candidatesLeft = VERSIONS.length;
        boolean[] matched = new boolean[VERSIONS.length];
        int i = 0;
        while (i < candidatesLeft) {
            matched[i] = true;
            ++i;
        }
        int pos = 0;
        while (candidatesLeft > 0) {
            char c = (char)this.in.readByte();
            int i2 = 0;
            while (i2 < VERSIONS.length) {
                if (matched[i2]) {
                    if (c != VERSIONS[i2].charAt(pos)) {
                        matched[i2] = false;
                        --candidatesLeft;
                    } else if (pos == VERSIONS[i2].length() - 1) {
                        this.vc.debug("Hprof file version: " + VERSIONS[i2]);
                        return i2;
                    }
                }
                ++i2;
            }
            ++pos;
        }
        throw new DumpCorruptedException("version string not recognized at byte " + (pos + 3));
    }

    private void readHeapDump(long dumpLength) throws DumpCorruptedException, IOException, HprofParsingCancelledException {
        long pos;
        long startPos = this.in.position();
        long endPos = startPos + dumpLength;
        int curChunk = (int)(this.in.position() >> 19);
        while ((pos = this.in.position()) < endPos) {
            int recordType = this.in.readUnsignedByte();
            int newCurChunk = (int)(pos >> 19);
            if (newCurChunk > curChunk) {
                curChunk = newCurChunk;
                this.checkForCancellation();
            }
            switch (recordType) {
                case 33: {
                    this.readInstance();
                    break;
                }
                case 34: {
                    this.readArray(false);
                    break;
                }
                case 35: {
                    this.readArray(true);
                    break;
                }
                case 255: {
                    long id = this.readID();
                    this.snpBuilder.addRoot(new Root(id, 0L, 1, ""));
                    break;
                }
                case 8: {
                    long id = this.readID();
                    int threadSeq = this.in.readInt();
                    int stackSeq = this.in.readInt();
                    this.threadObjects.put(threadSeq, new ThreadObject(id, stackSeq));
                    break;
                }
                case 1: {
                    long id = this.readID();
                    this.readID();
                    this.snpBuilder.addRoot(new Root(id, 0L, 4, ""));
                    break;
                }
                case 2: {
                    long id = this.readID();
                    int threadSeq = this.in.readInt();
                    int depth = this.in.readInt();
                    ThreadObject to = this.getThreadObjectFromSequence(threadSeq);
                    StackTrace st = this.getStackTraceFromSerial(to.stackSeq);
                    if (st != null) {
                        st = st.traceForDepth(depth + 1);
                    }
                    this.snpBuilder.addRoot(new Root(id, to.threadId, 3, "", st));
                    break;
                }
                case 3: {
                    long id = this.readID();
                    int threadSeq = this.in.readInt();
                    int depth = this.in.readInt();
                    ThreadObject to = this.getThreadObjectFromSequence(threadSeq);
                    StackTrace st = this.getStackTraceFromSerial(to.stackSeq);
                    if (st != null) {
                        st = st.traceForDepth(depth + 1);
                    }
                    this.snpBuilder.addRoot(new Root(id, to.threadId, 7, "", st));
                    break;
                }
                case 4: {
                    long id = this.readID();
                    int threadSeq = this.in.readInt();
                    ThreadObject to = this.getThreadObjectFromSequence(threadSeq);
                    StackTrace st = this.getStackTraceFromSerial(to.stackSeq);
                    this.snpBuilder.addRoot(new Root(id, to.threadId, 8, "", st));
                    break;
                }
                case 5: {
                    long id = this.readID();
                    this.snpBuilder.addRoot(new Root(id, 0L, 2, ""));
                    break;
                }
                case 6: {
                    long id = this.readID();
                    int threadSeq = this.in.readInt();
                    ThreadObject to = this.getThreadObjectFromSequence(threadSeq);
                    StackTrace st = this.getStackTraceFromSerial(to.stackSeq);
                    this.snpBuilder.addRoot(new Root(id, to.threadId, 5, "", st));
                    break;
                }
                case 7: {
                    long id = this.readID();
                    this.snpBuilder.addRoot(new Root(id, 0L, 6, ""));
                    break;
                }
                case 32: {
                    this.readClass();
                    break;
                }
                default: {
                    throw new DumpCorruptedException("unrecognized heap dump sub-record type:  " + recordType + ". Technical info: position = " + pos + ", bytes left = " + (endPos - pos));
                }
            }
        }
        if (pos != endPos) {
            this.vc.addWarning("Error reading heap dump or heap dump segment", "Byte count is " + pos + " instead of " + endPos + ". Difference is " + (endPos - pos));
            this.skipBytes(endPos - pos);
        }
    }

    private long readID() throws IOException {
        return this.identifierSize == 4 ? 0xFFFFFFFFL & (long)this.in.readInt() : this.in.readLong();
    }

    private int readValue(JavaThing[] resultArr) throws DumpCorruptedException, IOException {
        byte type = this.in.readByte();
        return 1 + this.readValueForType(type, resultArr);
    }

    private int readValueForType(byte type, JavaThing[] resultArr) throws DumpCorruptedException, IOException {
        if (this.version >= 1) {
            type = this.signatureFromTypeId(type);
        }
        return this.readValueForTypeSignature(type, resultArr);
    }

    private int readValueForTypeSignature(byte type, JavaThing[] resultArr) throws DumpCorruptedException, IOException {
        switch (type) {
            case 76: 
            case 91: {
                long id = this.readID();
                if (resultArr != null) {
                    resultArr[0] = new JavaObjectRef(id);
                }
                return this.identifierSize;
            }
            case 90: {
                byte b = this.in.readByte();
                if (b != 0 && b != 1) {
                    this.vc.addWarning("Illegal boolean value read", Integer.toString(b));
                }
                if (resultArr != null) {
                    resultArr[0] = new JavaBoolean(b != 0);
                }
                return 1;
            }
            case 66: {
                byte b = this.in.readByte();
                if (resultArr != null) {
                    resultArr[0] = new JavaByte(b);
                }
                return 1;
            }
            case 83: {
                short s = this.in.readShort();
                if (resultArr != null) {
                    resultArr[0] = new JavaShort(s);
                }
                return 2;
            }
            case 67: {
                char ch = this.in.readChar();
                if (resultArr != null) {
                    resultArr[0] = new JavaChar(ch);
                }
                return 2;
            }
            case 73: {
                int val = this.in.readInt();
                if (resultArr != null) {
                    resultArr[0] = new JavaInt(val);
                }
                return 4;
            }
            case 74: {
                long val = this.in.readLong();
                if (resultArr != null) {
                    resultArr[0] = new JavaLong(val);
                }
                return 8;
            }
            case 70: {
                float val = this.in.readFloat();
                if (resultArr != null) {
                    resultArr[0] = new JavaFloat(val);
                }
                return 4;
            }
            case 68: {
                double val = this.in.readDouble();
                if (resultArr != null) {
                    resultArr[0] = new JavaDouble(val);
                }
                return 8;
            }
        }
        throw new DumpCorruptedException("Bad value signature:  " + type);
    }

    private ThreadObject getThreadObjectFromSequence(int threadSeq) throws DumpCorruptedException, IOException {
        ThreadObject to = this.threadObjects.get(threadSeq);
        if (to == null) {
            throw new DumpCorruptedException("thread " + threadSeq + " not found for JNI local ref");
        }
        return to;
    }

    private String getNameFromID(long id) throws IOException {
        if (id == 0L) {
            return "";
        }
        String result = this.names.get(id);
        if (result == null) {
            this.vc.addWarning("name not found", "at " + this.toHex(id));
            return "unresolved name " + this.toHex(id);
        }
        return result;
    }

    private StackTrace getStackTraceFromSerial(int ser) throws IOException {
        if (this.stackTraces == null) {
            return null;
        }
        StackTrace result = this.stackTraces.get(ser);
        if (result == null) {
            this.vc.addWarning("Stack trace not found", "for serial # " + ser);
        }
        return result;
    }

    private int readClass() throws DumpCorruptedException, IOException {
        JavaThing[] staticValues;
        long id = this.readID();
        this.skipBytes(4L);
        long superId = this.readID();
        long classLoaderId = this.readID();
        long signersId = this.readID();
        long protDomainId = this.readID();
        this.readID();
        this.readID();
        int fieldsSize = this.in.readInt();
        int bytesRead = 7 * this.identifierSize + 8;
        int numConstPoolEntries = this.in.readUnsignedShort();
        bytesRead += 2;
        int i = 0;
        while (i < numConstPoolEntries) {
            this.in.readUnsignedShort();
            bytesRead += 2;
            bytesRead += this.readValue(null);
            ++i;
        }
        int numStatics = this.in.readUnsignedShort();
        bytesRead += 2;
        int numQuasiFields = signersId != 0L || protDomainId != 0L ? 2 : 0;
        int nAllStatics = numStatics + numQuasiFields;
        JavaField[] staticFields = nAllStatics > 0 ? new JavaField[nAllStatics] : JavaClass.NO_FIELDS;
        JavaThing[] javaThingArray = staticValues = nAllStatics > 0 ? new JavaThing[nAllStatics] : JavaClass.NO_VALUES;
        if (numStatics > 0) {
            JavaThing[] valueBin = new JavaThing[1];
            int i2 = 0;
            while (i2 < numStatics) {
                long nameId = this.readID();
                bytesRead += this.identifierSize;
                byte type = this.in.readByte();
                ++bytesRead;
                bytesRead += this.readValueForType(type, valueBin);
                String fieldName = this.getNameFromID(nameId);
                if (this.version >= 1) {
                    type = this.signatureFromTypeId(type);
                }
                staticFields[i2] = JavaField.newInstance(fieldName, (char)type, this.snpBuilder.getPointerSize());
                staticValues[i2] = valueBin[0];
                ++i2;
            }
        }
        if (numQuasiFields > 0) {
            JavaField.addStaticQuaziFields(staticFields);
        }
        int numFields = this.in.readUnsignedShort();
        bytesRead += 2;
        JavaField[] fields = numFields > 0 ? new JavaField[numFields] : JavaClass.NO_FIELDS;
        int i3 = 0;
        while (i3 < numFields) {
            long nameId = this.readID();
            bytesRead += this.identifierSize;
            byte type = this.in.readByte();
            ++bytesRead;
            String fieldName = this.getNameFromID(nameId);
            if (this.version >= 1) {
                type = this.signatureFromTypeId(type);
            }
            fields[i3] = JavaField.newInstance(fieldName, (char)type, this.snpBuilder.getPointerSize());
            ++i3;
        }
        String name = this.classNameFromObjectID.get(id);
        if (name == null) {
            this.vc.addWarning("Class name not found", "for " + this.toHex(id));
            name = "unknown-name@" + this.toHex(id);
        }
        JavaClass c = new JavaClass(id, name, superId, classLoaderId, signersId, protDomainId, fields, staticFields, staticValues, fieldsSize, this.snpBuilder.getInMemoryInstanceSize(fieldsSize));
        this.snpBuilder.addClass(c);
        return bytesRead;
    }

    private String toHex(long addr) {
        return MiscUtils.toHex(addr);
    }

    private int readInstance() throws DumpCorruptedException, IOException {
        long objOfsInFile = this.in.position();
        long id = this.readID();
        this.skipBytes(4L);
        long classID = this.readID();
        int objDataSize = this.in.readInt();
        int bytesRead = 2 * this.identifierSize + 8 + objDataSize;
        this.skipBytes(objDataSize);
        this.snpBuilder.addJavaObject(id, classID, objOfsInFile, objDataSize);
        if (this.longFile) {
            this.handlePossibleBBBorder(objOfsInFile);
        }
        return bytesRead;
    }

    private int readArray(boolean isPrimitive) throws DumpCorruptedException, IOException {
        int dataSize;
        long arrayClassID;
        long objOfsInFile = this.in.position();
        long id = this.readID();
        this.skipBytes(4L);
        int num = this.in.readInt();
        int bytesRead = this.identifierSize + 8;
        if (isPrimitive) {
            arrayClassID = this.in.readByte();
            ++bytesRead;
        } else {
            arrayClassID = this.readID();
            bytesRead += this.identifierSize;
        }
        char primitiveSignature = '\u0000';
        int elSize = 0;
        if (isPrimitive || this.version < 1) {
            switch ((int)arrayClassID) {
                case 4: {
                    primitiveSignature = 'Z';
                    elSize = 1;
                    break;
                }
                case 5: {
                    primitiveSignature = 'C';
                    elSize = 2;
                    break;
                }
                case 6: {
                    primitiveSignature = 'F';
                    elSize = 4;
                    break;
                }
                case 7: {
                    primitiveSignature = 'D';
                    elSize = 8;
                    break;
                }
                case 8: {
                    primitiveSignature = 'B';
                    elSize = 1;
                    break;
                }
                case 9: {
                    primitiveSignature = 'S';
                    elSize = 2;
                    break;
                }
                case 10: {
                    primitiveSignature = 'I';
                    elSize = 4;
                    break;
                }
                case 11: {
                    primitiveSignature = 'J';
                    elSize = 8;
                }
            }
            if (this.version >= 1 && primitiveSignature == '\u0000') {
                throw new DumpCorruptedException("unrecognized typecode: " + arrayClassID);
            }
        }
        int n = dataSize = isPrimitive ? elSize * num : this.identifierSize * num;
        if (this.in.position() + (long)dataSize > this.fileSize) {
            throw new DumpCorruptedException(String.valueOf(isPrimitive ? "Primitive" : "Object") + " array at position " + this.in.position() + " is " + dataSize + " bytes long, that does not fit into the dump file");
        }
        bytesRead += dataSize;
        this.skipBytes(dataSize);
        if (isPrimitive) {
            this.snpBuilder.addJavaValueArray(id, primitiveSignature, objOfsInFile, num, dataSize);
        } else {
            this.snpBuilder.addJavaObjectArray(id, arrayClassID, objOfsInFile, num, dataSize);
        }
        if (this.longFile) {
            this.handlePossibleBBBorder(objOfsInFile);
        }
        return bytesRead;
    }

    private byte signatureFromTypeId(byte typeId) throws DumpCorruptedException, IOException {
        switch (typeId) {
            case 2: {
                return 76;
            }
            case 4: {
                return 90;
            }
            case 5: {
                return 67;
            }
            case 6: {
                return 70;
            }
            case 7: {
                return 68;
            }
            case 8: {
                return 66;
            }
            case 9: {
                return 83;
            }
            case 10: {
                return 73;
            }
            case 11: {
                return 74;
            }
        }
        throw new DumpCorruptedException("invalid type id of " + typeId);
    }

    private void handlePossibleBBBorder(long thisObjStartOfs) {
        if (thisObjStartOfs >= this.currentBBMaxOfs) {
            if (this.prevObjStartOfs > 0L) {
                this.mappedBBEndOfs.add(this.prevObjStartOfs - 1L);
            } else {
                this.mappedBBEndOfs.add((Long)Integer.MAX_VALUE);
            }
            this.currentBBMaxOfs = this.mappedBBEndOfs.get(this.mappedBBEndOfs.size() - 1) + Integer.MAX_VALUE;
        }
        this.prevObjStartOfs = thisObjStartOfs;
    }

    private void handleEOF(EOFException exp) {
        this.vc.addWarning("Unexpected EOF", "Will miss information");
        this.snpBuilder.setUnresolvedObjectsOk(true);
    }

    private void checkForCancellation() throws HprofParsingCancelledException {
        if (this.cancelled) {
            throw new HprofParsingCancelledException();
        }
    }

    private static class ThreadObject {
        long threadId;
        int stackSeq;

        ThreadObject(long threadId, int stackSeq) {
            this.threadId = threadId;
            this.stackSeq = stackSeq;
        }
    }
}

