/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class LongArrayList
implements Iterable<Long> {
    private static final long[] EMPTY_ARRAY = new long[0];
    private long[] array;
    private int size;

    public LongArrayList(int capacity) {
        this.array = new long[capacity];
    }

    public long get(int idx) {
        return this.array[idx];
    }

    public int size() {
        return this.size;
    }

    public void add(long value) {
        if (this.size == this.array.length) {
            long[] oldArray = this.array;
            this.array = new long[oldArray.length * 2];
            System.arraycopy(oldArray, 0, this.array, 0, oldArray.length);
        }
        this.array[this.size++] = value;
    }

    public boolean contains(long v) {
        int i = 0;
        while (i < this.size) {
            if (this.array[i] == v) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public long[] internalArray() {
        return this.array;
    }

    public long[] toArray() {
        if (this.size == 0) {
            return EMPTY_ARRAY;
        }
        long[] result = new long[this.size];
        System.arraycopy(this.array, 0, result, 0, this.size);
        return result;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        this.size = 0;
    }

    public LongArrayListIterator iterator() {
        return new LongArrayListIterator(this);
    }

    public static class LongArrayListIterator
    implements Iterator<Long> {
        private final LongArrayList list;
        private int index;

        public LongArrayListIterator(LongArrayList list) {
            this.list = list;
        }

        @Override
        public boolean hasNext() {
            return this.index >= 0 && this.index < this.list.size();
        }

        @Override
        public Long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.list.get(this.index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

