/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.misc;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.openjdk.jmc.common.IDisplayable;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.util.Environment;
import org.openjdk.jmc.ui.UIPlugin;
import org.openjdk.jmc.ui.accessibility.FocusTracker;
import org.openjdk.jmc.ui.charts.IChartInfoVisitor;
import org.openjdk.jmc.ui.charts.IXDataRenderer;
import org.openjdk.jmc.ui.charts.XYChart;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.AwtCanvas;
import org.openjdk.jmc.ui.misc.ChartTextCanvas;
import org.openjdk.jmc.ui.misc.PatternFly;

public class ChartCanvas
extends Canvas {
    private int laneHeight;
    private int minLaneHeight = -1;
    private int minReadableLaneHeight;
    private int savedLaneHeight;
    private int numItems = 0;
    private int lastMouseX = -1;
    private int lastMouseY = -1;
    private List<Rectangle2D> highlightRects;
    private Object hoveredItemData;
    private boolean isCtrlHeld;
    private final double xScale;
    private final double yScale;
    private final AwtCanvas awtCanvas;
    private boolean awtNeedsRedraw;
    private Runnable selectionListener;
    private Runnable zoomToSelectionListener;
    private Consumer<Boolean> zoomOnClickListener;
    private IPropertyChangeListener aaListener;
    private XYChart awtChart;
    private MCContextMenuManager chartMenu;
    private ChartTextCanvas textCanvas;
    private Listener zoomer;

    public void setNumItems(int numItems) {
        this.numItems = numItems;
    }

    private int getNumItems() {
        return this.numItems;
    }

    private boolean isScrollableChart() {
        return this.getParent() instanceof ScrolledComposite;
    }

    protected int initMinLaneHeight() {
        if (this.getNumItems() == 0 || this.minReadableLaneHeight * this.getNumItems() > this.getParent().getSize().y) {
            return this.minReadableLaneHeight;
        }
        return this.getParent().getSize().y / this.getNumItems();
    }

    protected int calculateMinLaneHeight(Rectangle rect) {
        return (int)((double)this.awtCanvas.getGraphics(rect.width, rect.height).getFontMetrics().getHeight() * this.xScale);
    }

    public boolean isLaneHeightMinimumSize() {
        return this.laneHeight == this.minLaneHeight;
    }

    void setOverviewLaneHeight() {
        this.savedLaneHeight = this.laneHeight;
        this.setLaneHeight(-1);
        this.zoomer = new Zoomer();
        this.addListener(37, this.zoomer);
    }

    void adjustLaneHeight(int amount) {
        if (this.laneHeight == -1) {
            this.restoreLaneHeight();
        }
        this.laneHeight = Math.max(this.minLaneHeight, this.laneHeight + amount);
    }

    void setLaneHeight(int height) {
        this.laneHeight = height;
    }

    void restoreLaneHeight() {
        this.laneHeight = this.savedLaneHeight;
        this.removeListener(37, this.zoomer);
    }

    public void resetLaneHeight() {
        if (this.minLaneHeight != -1) {
            if (this.laneHeight == -1) {
                this.removeListener(37, this.zoomer);
            }
            this.laneHeight = this.minLaneHeight = this.initMinLaneHeight();
        }
    }

    public ChartCanvas(Composite parent) {
        super(parent, 262144);
        this.xScale = (double)Display.getDefault().getDPI().x / Environment.getNormalDPI();
        this.yScale = (double)Display.getDefault().getDPI().y / Environment.getNormalDPI();
        this.awtCanvas = new AwtCanvas();
        this.addPaintListener(new Painter());
        Selector selector = new Selector();
        this.addMouseListener((MouseListener)selector);
        this.addMouseMoveListener(selector);
        FocusTracker.enableFocusTracking((Composite)this);
        this.addKeyListener(new KeyNavigator());
        this.aaListener = new AntiAliasingListener();
        UIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.aaListener);
        this.addDisposeListener(e -> UIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.aaListener));
        if (Environment.getOSType() == Environment.OSType.WINDOWS) {
            this.addMouseTrackListener(new WheelStealingZoomer());
        }
        if (this.isScrollableChart()) {
            ((ScrolledComposite)this.getParent()).getVerticalBar().addListener(13, e -> this.vBarScroll());
        } else {
            this.addMouseTrackListener(selector);
            this.addListener(37, new Zoomer());
        }
    }

    private void vBarScroll() {
        if (this.textCanvas != null) {
            Point location = ((ScrolledComposite)this.getParent()).getOrigin();
            this.textCanvas.syncScroll(location);
            this.awtChart.updateZoomPanIndicator();
        }
    }

    public IMenuManager getContextMenu() {
        if (this.chartMenu == null) {
            this.chartMenu = MCContextMenuManager.create((Control)this);
            this.chartMenu.addMenuListener(manager -> this.clearHighlightRects());
        }
        return this.chartMenu;
    }

    private void render(Graphics2D context, int width, int height) {
        if (this.awtChart != null) {
            this.awtChart.renderChart(context, width, height);
            if (this.textCanvas == null) {
                this.awtChart.renderText(context, width, height);
            }
            this.awtChart.updateZoomPanIndicator();
        }
    }

    protected Point translateDisplayToImageCoordinates(int x, int y) {
        int xImage = (int)Math.round((double)x / this.xScale);
        int yImage = (int)Math.round((double)y / this.yScale);
        return new Point(xImage, yImage);
    }

    protected int translateDisplayToImageXCoordinates(int x) {
        return (int)Math.round((double)x / this.xScale);
    }

    protected int translateDisplayToImageYCoordinates(int y) {
        return (int)Math.round((double)y / this.yScale);
    }

    public Object getHoveredItemData() {
        return this.hoveredItemData;
    }

    public void setHoveredItemData(Object data) {
        this.hoveredItemData = data;
    }

    public void resetHoveredItemData() {
        this.hoveredItemData = null;
    }

    public void syncHighlightedRectangles(List<Rectangle2D> newRects) {
        this.highlightRects = newRects;
        this.redraw();
    }

    private void updateHighlightRects() {
        final ArrayList<Rectangle2D> newRects = new ArrayList<Rectangle2D>();
        this.infoAt(new IChartInfoVisitor.Adapter(){

            @Override
            public void visit(IChartInfoVisitor.IBucket bucket) {
                newRects.add(bucket.getTarget());
            }

            @Override
            public void visit(IChartInfoVisitor.IPoint point) {
                Point2D target = point.getTarget();
                newRects.add(new Rectangle2D.Double(target.getX(), target.getY(), 0.0, 0.0));
            }

            @Override
            public void visit(IChartInfoVisitor.ISpan span) {
                newRects.add(span.getTarget());
            }

            @Override
            public void visit(IChartInfoVisitor.ITick tick) {
                Point2D target = tick.getTarget();
                newRects.add(new Rectangle2D.Double(target.getX(), target.getY(), 0.0, 0.0));
            }

            @Override
            public void visit(IChartInfoVisitor.ILane lane) {
            }

            @Override
            public void hover(Object data) {
                if (data != null) {
                    ChartCanvas.this.setHoveredItemData(data);
                }
            }
        }, this.lastMouseX, this.lastMouseY);
        if (!newRects.equals(this.highlightRects)) {
            this.highlightRects = newRects;
            if (this.textCanvas != null) {
                this.textCanvas.syncHighlightedRectangles(this.highlightRects);
            }
            this.redraw();
        }
    }

    private void clearHighlightRects() {
        if (this.highlightRects != null) {
            this.highlightRects = null;
            this.redraw();
        }
    }

    private void handleWheelEvent(int stateMask, int x, int count) {
        if ((stateMask & SWT.MOD1) != 0) {
            this.pan(count * 3);
        } else {
            this.zoom(this.translateDisplayToImageXCoordinates(x), count);
        }
    }

    private void pan(int rightPercent) {
        if (this.awtChart != null && this.awtChart.pan(rightPercent)) {
            this.redrawChart();
        }
    }

    private void zoom(int zoomInSteps) {
        if (this.awtChart != null && this.awtChart.zoom(zoomInSteps)) {
            this.redrawChart();
        }
    }

    private void zoom(int x, int zoomInSteps) {
        if (this.awtChart != null && this.awtChart.zoom(x, zoomInSteps)) {
            this.redrawChart();
        }
    }

    private void select(int x1, int x2, int y1, int y2, boolean clear) {
        Point p1 = this.translateDisplayToImageCoordinates(x1, y1);
        Point p2 = this.translateDisplayToImageCoordinates(x2, y2);
        if (this.awtChart != null && this.awtChart.select(p1.x, p2.x, p1.y, p2.y, clear)) {
            this.redrawChart();
            this.redrawChartText();
        }
    }

    private void toggleSelect(int x, int y) {
        Point p = this.translateDisplayToImageCoordinates(x, y);
        if (this.awtChart != null) {
            final IQuantity[] range = new IQuantity[2];
            this.infoAt(new IChartInfoVisitor.Adapter(){

                @Override
                public void visit(IChartInfoVisitor.IBucket bucket) {
                    if (range[0] == null) {
                        range[0] = (IQuantity)bucket.getStartX();
                        range[1] = (IQuantity)bucket.getEndX();
                    }
                }

                @Override
                public void visit(IChartInfoVisitor.ISpan span) {
                    if (range[0] == null) {
                        IDisplayable x0 = span.getStartX();
                        IDisplayable x1 = span.getEndX();
                        range[0] = x0 instanceof IQuantity ? (IQuantity)x0 : null;
                        range[1] = x1 instanceof IQuantity ? (IQuantity)x1 : null;
                    }
                }
            }, x, y);
            if (range[0] != null || range[1] != null) {
                if (!this.awtChart.select(range[0], range[1], p.y, p.y, true)) {
                    this.awtChart.clearSelection();
                }
            } else if (!this.awtChart.select(p.x, p.x, p.y, p.y, true)) {
                this.awtChart.clearSelection();
            }
            this.notifyZoomOnClickListener(3);
            this.redrawChart();
            this.redrawChartText();
        }
    }

    public void setChart(XYChart awtChart) {
        this.awtChart = awtChart;
        this.notifyListener();
        this.redrawChart();
    }

    public void setTextCanvas(ChartTextCanvas textCanvas) {
        this.textCanvas = textCanvas;
    }

    public void syncScroll(Point scrollPoint) {
        ((ScrolledComposite)this.getParent()).setOrigin(scrollPoint);
    }

    public void replaceRenderer(IXDataRenderer rendererRoot) {
        assert (this.awtChart != null);
        this.awtChart.setRendererRoot(rendererRoot);
        this.notifyListener();
        this.redrawChart();
    }

    public void setSelectionListener(Runnable selectionListener) {
        this.selectionListener = selectionListener;
    }

    public void setZoomToSelectionListener(Runnable zoomListener) {
        this.zoomToSelectionListener = zoomListener;
    }

    public void setZoomOnClickListener(Consumer<Boolean> clickListener) {
        this.zoomOnClickListener = clickListener;
    }

    private void notifyZoomOnClickListener(Integer button) {
        if (this.zoomOnClickListener != null) {
            this.zoomOnClickListener.accept(button == 3);
        }
    }

    private void notifyListener() {
        if (this.selectionListener != null) {
            this.selectionListener.run();
        }
    }

    public void changeCursor(Cursor cursor) {
        this.setCursor(cursor);
    }

    public void infoAt(IChartInfoVisitor visitor, int x, int y) {
        Point p = this.translateDisplayToImageCoordinates(x, y);
        if (this.awtChart != null) {
            this.awtChart.infoAt(visitor, p.x, p.y);
        }
    }

    public void redrawChart() {
        this.awtNeedsRedraw = true;
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!ChartCanvas.this.isDisposed()) {
                    ChartCanvas.this.redraw();
                }
            }
        });
    }

    private void redrawChartText() {
        if (this.textCanvas != null) {
            this.textCanvas.redrawChartText();
        }
    }

    private class AntiAliasingListener
    implements IPropertyChangeListener {
        private AntiAliasingListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            ChartCanvas.this.redrawChart();
        }
    }

    class KeyNavigator
    implements KeyListener {
        KeyNavigator() {
        }

        public void keyPressed(KeyEvent event) {
            block0 : switch (event.character) {
                case '+': {
                    ChartCanvas.this.zoom(1);
                    break;
                }
                case '-': {
                    ChartCanvas.this.zoom(-1);
                    break;
                }
                default: {
                    switch (event.keyCode) {
                        case 27: {
                            ChartCanvas.this.awtChart.clearSelection();
                            if (ChartCanvas.this.selectionListener != null) {
                                ChartCanvas.this.selectionListener.run();
                            }
                            ChartCanvas.this.redrawChart();
                            ChartCanvas.this.redrawChartText();
                            break block0;
                        }
                        case 262144: {
                            ChartCanvas.this.isCtrlHeld = true;
                            break block0;
                        }
                        case 97: {
                            if (!ChartCanvas.this.isCtrlHeld) break block0;
                            ChartCanvas.this.awtChart.selectAll(ChartCanvas.this.numItems, ChartCanvas.this.laneHeight);
                            if (ChartCanvas.this.selectionListener != null) {
                                ChartCanvas.this.selectionListener.run();
                            }
                            ChartCanvas.this.redrawChart();
                            ChartCanvas.this.redrawChartText();
                            break block0;
                        }
                        case 0x1000004: {
                            ChartCanvas.this.pan(10);
                            break block0;
                        }
                        case 0x1000003: {
                            ChartCanvas.this.pan(-10);
                            break block0;
                        }
                        case 0x1000001: {
                            ChartCanvas.this.zoom(1);
                            break block0;
                        }
                        case 0x1000002: {
                            ChartCanvas.this.zoom(-1);
                        }
                    }
                }
            }
        }

        public void keyReleased(KeyEvent event) {
            switch (event.keyCode) {
                case 262144: {
                    ChartCanvas.this.isCtrlHeld = false;
                }
            }
        }
    }

    class Painter
    implements PaintListener {
        Painter() {
        }

        public void paintControl(PaintEvent e) {
            Rectangle rect = new Rectangle(0, 0, ChartCanvas.this.getParent().getSize().x, ChartCanvas.this.getParent().getSize().y);
            if (ChartCanvas.this.minLaneHeight == -1) {
                ChartCanvas.this.laneHeight = ChartCanvas.this.minLaneHeight = ChartCanvas.this.calculateMinLaneHeight(rect);
            }
            if (ChartCanvas.this.getNumItems() == 0) {
                rect = ChartCanvas.this.getClientArea();
            } else if (ChartCanvas.this.getNumItems() != 1 && ChartCanvas.this.laneHeight * ChartCanvas.this.getNumItems() >= rect.height) {
                rect.height = ChartCanvas.this.laneHeight * ChartCanvas.this.getNumItems();
            }
            if (ChartCanvas.this.awtNeedsRedraw || !ChartCanvas.this.awtCanvas.hasImage(rect.width, rect.height)) {
                Graphics2D g2d = ChartCanvas.this.awtCanvas.getGraphics(rect.width, rect.height);
                Point adjusted = ChartCanvas.this.translateDisplayToImageCoordinates(rect.width, rect.height);
                g2d.setColor(PatternFly.Palette.PF_BLACK_100.getAWTColor());
                g2d.fillRect(0, 0, adjusted.x, adjusted.y);
                ChartCanvas.this.render(g2d, adjusted.x, adjusted.y);
                if (ChartCanvas.this.isScrollableChart()) {
                    ChartCanvas.this.minReadableLaneHeight = (int)((double)g2d.getFontMetrics().getHeight() * ChartCanvas.this.xScale);
                    ChartCanvas.this.minLaneHeight = ChartCanvas.this.initMinLaneHeight();
                    ((ScrolledComposite)ChartCanvas.this.getParent()).setMinSize(rect.width, rect.height);
                }
                ChartCanvas.this.awtNeedsRedraw = false;
            }
            ChartCanvas.this.awtCanvas.paint(e, 0, 0);
            List<Rectangle2D> rs = ChartCanvas.this.highlightRects;
            if (rs != null) {
                GC gc = e.gc;
                gc.setForeground(ChartCanvas.this.getForeground());
                for (Rectangle2D r : rs) {
                    int height;
                    int width;
                    int x = (int)((double)((int)r.getX()) * ChartCanvas.this.xScale);
                    int y = (int)((double)((int)r.getY()) * ChartCanvas.this.yScale);
                    if (r.getWidth() == 0.0 && r.getHeight() == 0.0) {
                        width = (int)Math.round(4.0 * ChartCanvas.this.xScale);
                        height = (int)Math.round(4.0 * ChartCanvas.this.yScale);
                        gc.drawOval(x - (int)Math.round(2.0 * ChartCanvas.this.xScale), y - (int)Math.round(2.0 * ChartCanvas.this.yScale), width, height);
                        continue;
                    }
                    width = (int)Math.round(r.getWidth() * ChartCanvas.this.xScale);
                    height = (int)Math.round(r.getHeight() * ChartCanvas.this.yScale);
                    gc.drawRectangle(x, y, width, height);
                }
                ChartCanvas.this.updateHighlightRects();
            }
        }
    }

    private class Selector
    extends MouseAdapter
    implements MouseMoveListener,
    MouseTrackListener {
        int selectionStartX = -1;
        int selectionStartY = -1;
        Point highlightSelectionStart;
        Point highlightSelectionEnd;
        Point lastSelection;
        boolean selectionIsClick = false;

        private Selector() {
        }

        public void mouseDown(MouseEvent e) {
            if (e.button == 1 && (e.stateMask & SWT.MOD4) == 0 && (e.stateMask & 0x40000) == 0 && (e.stateMask & 0x20000) == 0) {
                this.selectionStartX = e.x;
                this.selectionStartY = e.y;
                this.highlightSelectionEnd = new Point(-1, -1);
                this.lastSelection = new Point(-1, -1);
                this.selectionIsClick = true;
                ChartCanvas.this.toggleSelect(this.selectionStartX, this.selectionStartY);
            } else if ((e.stateMask & 0x40000) != 0 && e.button == 1) {
                ChartCanvas.this.select(e.x, e.x, e.y, e.y, false);
                if (ChartCanvas.this.selectionListener != null) {
                    ChartCanvas.this.selectionListener.run();
                }
            } else if ((e.stateMask & 0x20000) != 0 && e.button == 1) {
                if (this.highlightSelectionEnd.y == -1) {
                    this.lastSelection = this.highlightSelectionEnd = new Point(e.x, e.y);
                    if (this.highlightSelectionStart.y > this.highlightSelectionEnd.y) {
                        Point temp = this.highlightSelectionStart;
                        this.highlightSelectionStart = this.highlightSelectionEnd;
                        this.highlightSelectionEnd = temp;
                    }
                } else if (e.y > this.highlightSelectionStart.y && e.y < this.highlightSelectionEnd.y) {
                    if (e.y < this.lastSelection.y) {
                        this.highlightSelectionEnd = new Point(e.x, e.y);
                    } else if (e.y > this.lastSelection.y) {
                        this.highlightSelectionStart = new Point(e.x, e.y);
                    }
                } else if (e.y < this.highlightSelectionStart.y) {
                    this.lastSelection = this.highlightSelectionStart = new Point(e.x, e.y);
                } else if (e.y > this.highlightSelectionEnd.y) {
                    this.lastSelection = this.highlightSelectionEnd = new Point(e.x, e.y);
                }
                ChartCanvas.this.select(this.highlightSelectionStart.x, this.highlightSelectionEnd.x, this.highlightSelectionStart.y, this.highlightSelectionEnd.y, true);
                if (ChartCanvas.this.selectionListener != null) {
                    ChartCanvas.this.selectionListener.run();
                }
            }
        }

        public void mouseMove(MouseEvent e) {
            if (this.selectionStartX >= 0) {
                ChartCanvas.this.highlightRects = null;
                this.updateSelectionState(e);
            } else {
                ChartCanvas.this.lastMouseX = e.x;
                ChartCanvas.this.lastMouseY = e.y;
                ChartCanvas.this.updateHighlightRects();
            }
        }

        private void updateSelectionState(MouseEvent e) {
            int x = e.x;
            int y = e.y;
            if (this.selectionIsClick && (Math.abs(x - this.selectionStartX) > 3 || Math.abs(y - this.selectionStartY) > 3)) {
                this.selectionIsClick = false;
            }
            if (!this.selectionIsClick) {
                ChartCanvas.this.select((int)((double)this.selectionStartX / ChartCanvas.this.xScale), (int)((double)x / ChartCanvas.this.xScale), (int)((double)this.selectionStartY / ChartCanvas.this.yScale), (int)((double)y / ChartCanvas.this.yScale), true);
            }
        }

        public void mouseUp(MouseEvent e) {
            if (this.selectionStartX >= 0 && e.button == 1) {
                this.updateSelectionState(e);
                this.highlightSelectionStart = new Point(this.selectionStartX, this.selectionStartY);
                this.selectionStartX = -1;
                this.selectionStartY = -1;
                if (this.selectionIsClick) {
                    ChartCanvas.this.notifyZoomOnClickListener(e.button);
                }
                if (ChartCanvas.this.selectionListener != null) {
                    ChartCanvas.this.selectionListener.run();
                    if (ChartCanvas.this.zoomToSelectionListener != null && !this.selectionIsClick) {
                        ChartCanvas.this.zoomToSelectionListener.run();
                    }
                }
            }
        }

        public void mouseEnter(MouseEvent e) {
        }

        public void mouseExit(MouseEvent e) {
            if (!ChartCanvas.this.getClientArea().contains(e.x, e.y)) {
                ChartCanvas.this.resetHoveredItemData();
            }
            ChartCanvas.this.clearHighlightRects();
        }

        public void mouseHover(MouseEvent e) {
        }
    }

    class WheelStealingZoomer
    implements Listener,
    MouseTrackListener,
    FocusListener {
        private Control stealWheelFrom;

        WheelStealingZoomer() {
        }

        public void handleEvent(Event event) {
            if (ChartCanvas.this.isDisposed()) {
                this.stop();
            } else if (this.stealWheelFrom != null && !this.stealWheelFrom.isDisposed()) {
                Point canvasSize = ChartCanvas.this.getSize();
                Point canvasPoint = ChartCanvas.this.toControl(this.stealWheelFrom.toDisplay(event.x, event.y));
                if (canvasPoint.x >= 0 && canvasPoint.y >= 0 && canvasPoint.x < canvasSize.x && canvasPoint.y < canvasSize.y) {
                    ChartCanvas.this.handleWheelEvent(event.stateMask, canvasPoint.x, event.count);
                    event.doit = false;
                }
            }
        }

        private void stop() {
            if (this.stealWheelFrom != null && !this.stealWheelFrom.isDisposed()) {
                this.stealWheelFrom.removeListener(37, (Listener)this);
                this.stealWheelFrom.removeFocusListener((FocusListener)this);
                this.stealWheelFrom = null;
            }
        }

        public void mouseEnter(MouseEvent e) {
            this.stop();
            Control stealWheelFrom = ChartCanvas.this.getDisplay().getFocusControl();
            if (stealWheelFrom != null && stealWheelFrom != ChartCanvas.this) {
                stealWheelFrom.addListener(37, (Listener)this);
                stealWheelFrom.addFocusListener((FocusListener)this);
                this.stealWheelFrom = stealWheelFrom;
            }
        }

        public void mouseExit(MouseEvent e) {
        }

        public void mouseHover(MouseEvent e) {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            this.stop();
        }
    }

    class Zoomer
    implements Listener {
        Zoomer() {
        }

        public void handleEvent(Event event) {
            ChartCanvas.this.handleWheelEvent(event.stateMask, event.x, event.count);
        }
    }
}

