/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.ui.operations;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.util.ExceptionToolkit;
import org.openjdk.jmc.rjmx.common.services.IOperation;
import org.openjdk.jmc.rjmx.ui.RJMXUIPlugin;
import org.openjdk.jmc.rjmx.ui.attributes.AttributeTreeBuilder;
import org.openjdk.jmc.rjmx.ui.operations.InvocatorBuilderForm;
import org.openjdk.jmc.rjmx.ui.operations.Messages;
import org.openjdk.jmc.rjmx.ui.operations.OperationsLabelProvider;
import org.openjdk.jmc.rjmx.util.internal.DefaultAttribute;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.misc.DisplayToolkit;
import org.openjdk.jmc.ui.misc.MCLayoutFactory;
import org.openjdk.jmc.ui.misc.MementoToolkit;
import org.openjdk.jmc.ui.misc.TreeStructureContentProvider;

public class ExecuteOperationForm {
    private final FormToolkit formToolkit;
    private final Text commandText;
    private final CTabFolder results;
    private final Button invokeButton;
    private final InvocatorBuilderForm invocatorForm;
    private Callable<?> invocator;
    private final Composite buttonContainer;
    public static final String RESULT_TAB_NAME = "operation.result";
    public static final String RESULT_TREE_NAME = "operation.result.tree";

    public ExecuteOperationForm(SashForm parent, FormToolkit formToolkit, boolean showOperationReturnType, IMemento state) {
        this.formToolkit = formToolkit;
        parent.setBackground(formToolkit.getColors().getBackground());
        Composite upperContainer = formToolkit.createComposite((Composite)parent);
        upperContainer.setLayout(MCLayoutFactory.createMarginFreeFormPageLayout());
        SashForm invocatorFormSash = new SashForm(upperContainer, 256);
        this.invocatorForm = new InvocatorBuilderForm(invocatorFormSash, formToolkit, showOperationReturnType, TableSettings.forState((IState)MementoToolkit.asState((IMemento)state)), new InvocatorBuilderForm.InvocatorUpdateListener(){

            @Override
            public void onInvocatorUpdated(IOperation operation, Callable<?> invocator) {
                ExecuteOperationForm.this.invocator = invocator;
                ExecuteOperationForm.this.buttonContainer.setVisible(operation != null);
                ExecuteOperationForm.this.invokeButton.setEnabled(invocator != null);
                ExecuteOperationForm.this.commandText.setText(invocator == null ? "" : invocator.toString());
                ExecuteOperationForm.this.invokeButton.setImage(OperationsLabelProvider.getOperationIcon(operation));
                ExecuteOperationForm.this.buttonContainer.layout(true);
            }
        });
        invocatorFormSash.setLayoutData((Object)new GridData(4, 4, true, true));
        this.buttonContainer = formToolkit.createComposite(upperContainer);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.center = true;
        buttonLayout.wrap = false;
        this.buttonContainer.setLayout((Layout)buttonLayout);
        this.buttonContainer.setLayoutData((Object)new GridData(4, 4, true, false));
        this.buttonContainer.setVisible(false);
        this.invokeButton = formToolkit.createButton(this.buttonContainer, Messages.ExecuteOperationForm_EXECUTE_BUTTON_TEXT, 8);
        this.commandText = new Text(this.buttonContainer, 72);
        this.commandText.setBackground(formToolkit.getColors().getBackground());
        this.results = new CTabFolder((Composite)parent, 262208);
        this.results.setBackground(formToolkit.getColors().getBackground());
        this.results.setVisible(false);
        this.results.setData("name", (Object)RESULT_TAB_NAME);
        this.results.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                if (ExecuteOperationForm.this.results.getItemCount() <= 1) {
                    ExecuteOperationForm.this.results.setVisible(false);
                    ExecuteOperationForm.this.results.getParent().layout();
                }
            }
        });
        this.addResultsContextMenu();
        parent.setWeights(new int[]{2, 1});
        this.invokeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecuteOperationForm.this.executeOperation();
            }
        });
    }

    protected void executeOperation() {
        this.invokeAsync(this.invocator);
    }

    public void saveState(IMemento state) {
        this.invocatorForm.saveState(state);
    }

    protected Button createButton(String label) {
        Button button = this.formToolkit.createButton(this.buttonContainer, label, 8);
        button.moveAbove((Control)this.invokeButton);
        return button;
    }

    protected void invokeAsync(final Callable<?> job) {
        new Job(job.toString()){

            protected IStatus run(IProgressMonitor monitor) {
                String resultTitle;
                Object result;
                Image resultImage = null;
                try {
                    result = job.call();
                    resultTitle = NLS.bind((String)Messages.ExecuteOperationForm_RESULT_MSG, (Object)this.getCurrentTimeFormatted(), (Object)job);
                }
                catch (Exception e) {
                    resultTitle = NLS.bind((String)Messages.ExecuteOperationForm_FAILED_EXECUTION_MSG, (Object)this.getCurrentTimeFormatted(), (Object)job);
                    resultImage = RJMXUIPlugin.getDefault().getImage("error.gif");
                    result = String.valueOf(NLS.bind((String)Messages.ExecuteOperationForm_FAILED_TO_EXECUTE_MSG, (Object)job)) + "\n\n" + ExceptionToolkit.toString((Throwable)e);
                }
                this.showAsyncInvocationResult(monitor, resultTitle, resultImage, result);
                return Status.OK_STATUS;
            }

            private String getCurrentTimeFormatted() {
                return DateFormat.getDateTimeInstance(3, 2).format(new Date());
            }

            private void showAsyncInvocationResult(IProgressMonitor monitor, final String resultTitle, final Image resultImage, final Object result) {
                if (!monitor.isCanceled()) {
                    DisplayToolkit.safeAsyncExec((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (!(this).ExecuteOperationForm.this.results.isDisposed()) {
                                ExecuteOperationForm.this.createInvocationResult(resultTitle, resultImage, result);
                            }
                        }
                    });
                }
            }
        }.schedule();
    }

    private void createInvocationResult(String resultTitle, Image resultImage, Object result) {
        Object[] val;
        final CTabItem tab = new CTabItem(this.results, 0);
        tab.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Control c = tab.getControl();
                if (c != null && !c.isDisposed()) {
                    c.dispose();
                }
            }
        });
        tab.setText(resultTitle);
        if (resultImage != null) {
            tab.setImage(resultImage);
        }
        if ((val = new DefaultAttribute(null, result).getChildren().toArray()).length > 0) {
            Tree tree = new Tree((Composite)this.results, 68354);
            tree.setData("name", (Object)RESULT_TREE_NAME);
            tab.setControl((Control)tree);
            TreeViewer viewer = new TreeViewer(tree);
            viewer.setContentProvider((IContentProvider)new TreeStructureContentProvider());
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
            ArrayList<TableSettings.ColumnSettings> columnSettings = new ArrayList<TableSettings.ColumnSettings>();
            columnSettings.add(new TableSettings.ColumnSettings(AttributeTreeBuilder.NAME.getId(), Boolean.valueOf(false), Integer.valueOf(300), null));
            columnSettings.add(new TableSettings.ColumnSettings(AttributeTreeBuilder.VALUE.getId(), Boolean.valueOf(false), Integer.valueOf(300), null));
            columnSettings.add(new TableSettings.ColumnSettings(AttributeTreeBuilder.TYPE.getId(), Boolean.valueOf(true), Integer.valueOf(150), null));
            TableSettings tableSettings = new TableSettings(AttributeTreeBuilder.NAME.getId(), columnSettings);
            ColumnManager.build((TreeViewer)viewer, Arrays.asList(AttributeTreeBuilder.NAME, AttributeTreeBuilder.VALUE, AttributeTreeBuilder.TYPE), (TableSettings)tableSettings);
            viewer.setInput((Object)val);
        } else {
            String resultValue = "";
            if (result != null) {
                resultValue = result.getClass().isArray() ? Arrays.toString((Object[])result) : result.toString();
            }
            Text textResult = this.formToolkit.createText((Composite)this.results, resultValue, 584);
            tab.setControl((Control)textResult);
        }
        this.results.setVisible(true);
        this.results.setSelection(tab);
        this.results.getParent().layout();
    }

    private void addResultsContextMenu() {
        MenuManager mm = new MenuManager();
        mm.add((IAction)new Action(Messages.ExecuteOperationForm_CLOSE_ALL_LABEL){

            public void runWithEvent(Event event) {
                while (ExecuteOperationForm.this.results.getItemCount() != 0) {
                    ExecuteOperationForm.this.results.getItem(0).dispose();
                }
                ExecuteOperationForm.this.results.setVisible(false);
                ExecuteOperationForm.this.results.getParent().layout();
            }
        });
        Menu menu = mm.createContextMenu((Control)this.results);
        this.results.setMenu(menu);
    }

    public void setOperations(Collection<? extends IOperation> input) {
        this.invocatorForm.setOperations(input);
    }

    protected IOperation getSelectedOperation() {
        return this.invocatorForm.getSelectedOperation();
    }
}

