/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.ui.CoreImages;
import org.openjdk.jmc.ui.UIPlugin;

public class TypeAppearance {
    private static final Map<String, ImageDescriptor> APPEARANCE = new HashMap<String, ImageDescriptor>();

    static {
        APPEARANCE.put(UnitLookup.ADDRESS.getIdentifier(), CoreImages.ADDRESS);
        APPEARANCE.put(UnitLookup.MEMORY.getIdentifier(), CoreImages.DATA);
        APPEARANCE.put(UnitLookup.CLASS.getIdentifier(), CoreImages.CLASS_PUBLIC);
        APPEARANCE.put(UnitLookup.PACKAGE.getIdentifier(), CoreImages.PACKAGE);
        APPEARANCE.put(UnitLookup.MODULE.getIdentifier(), CoreImages.MODULE);
        APPEARANCE.put(UnitLookup.METHOD.getIdentifier(), CoreImages.METHOD_NON_OPTIMIZED);
        APPEARANCE.put(UnitLookup.TIMESPAN.getIdentifier(), CoreImages.TIMESPAN);
        APPEARANCE.put(UnitLookup.TIMESTAMP.getIdentifier(), CoreImages.CLOCK);
        APPEARANCE.put(UnitLookup.TIMERANGE.getIdentifier(), CoreImages.CLOCK);
        APPEARANCE.put(UnitLookup.THREAD.getIdentifier(), CoreImages.THREAD);
    }

    public static ImageDescriptor getImageDescriptor(String typeId) {
        return APPEARANCE.get(typeId);
    }

    public static Image getImage(String typeId) {
        ImageDescriptor imageDesc;
        String id;
        ImageRegistry ir = UIPlugin.getDefault().getImageRegistry();
        Image i = ir.get(id = String.valueOf(UIPlugin.ImageRegistryPrefixes.TYPE_IMAGES.name()) + typeId);
        if (i == null && (imageDesc = TypeAppearance.getImageDescriptor(typeId)) != null) {
            i = imageDesc.createImage();
            ir.put(id, i);
        }
        return i;
    }
}

