/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.dial;

import java.awt.Color;
import org.openjdk.jmc.ui.dial.IDialProvider;

public class MovingDial
implements IDialProvider {
    private double m_damping = 0.9;
    private double m_mass = 0.05;
    private double m_stiffness = 2.0;
    private double m_target = 0.0;
    private double m_timeOffset = Double.NaN;
    private double m_lastTime = 0.0;
    private double m_position = 0.0;
    private double m_velocity = 0.0;
    private double m_maxIterationStep = 0.06;
    private double m_maximumSimulationLength = 2.0;
    private final String m_id;
    private Color m_color;

    public MovingDial(String id, Color color) {
        this.m_color = color;
        this.m_id = id;
    }

    public MovingDial(String id) {
        this(id, new Color(0, 0, 0));
    }

    public void setCurrentVelocity(double velocity) {
        this.m_velocity = velocity;
    }

    public void setCurrentPosition(double position) {
        this.m_position = position;
    }

    public void setDamping(double damping) {
        this.m_damping = damping;
    }

    public void setStiffness(double stiffness) {
        this.m_stiffness = stiffness;
    }

    public void setTarget(double target) {
        this.m_target = target;
    }

    public void setMass(double mass) {
        this.m_mass = mass;
    }

    @Override
    public Color getColor(Object input) {
        return this.m_color;
    }

    public void setColor(Color color) {
        this.m_color = color;
    }

    @Override
    public double getValue(Object input) {
        if (input instanceof Number) {
            if (this.getLastCalculatedTime() == Double.NEGATIVE_INFINITY) {
                this.setCurrentPosition(((Number)input).doubleValue());
            }
            this.setTarget(((Number)input).doubleValue());
            this.runSimulation();
            return this.getLastCalculatedPosition();
        }
        return Double.NEGATIVE_INFINITY;
    }

    public void setIterationLength(long seconds) {
        this.m_maxIterationStep = seconds;
    }

    public void runSimulation() {
        double time = this.currentTime();
        double elapsed = time - this.getLastCalculatedTime();
        double maxIterationStep = this.getMaximumIterationLength();
        if (elapsed != 0.0) {
            if (elapsed > this.getMaximumSimulationLength()) {
                this.setCurrentPosition(this.getTarget());
                this.setCurrentVelocity(0.0);
                this.setCurrentTime(time);
            } else {
                double t = this.getLastCalculatedTime() + maxIterationStep;
                while (t < time) {
                    this.simulate(t, maxIterationStep);
                    t += maxIterationStep;
                }
                this.simulate(time, time - this.getLastCalculatedTime());
            }
        }
    }

    public double getMaximumSimulationLength() {
        return this.m_maximumSimulationLength;
    }

    public void setMaximumSimulationLength(double seconds) {
        this.m_maximumSimulationLength = seconds;
    }

    public double getMaximumIterationLength() {
        return this.m_maxIterationStep;
    }

    private void simulate(double time, double e) {
        final double m = this.getMass();
        final double k = this.getStiffness();
        final double b = this.getDamping();
        final double p = this.getTarget();
        double[] y = new double[]{this.getLastCalculatedPosition(), this.getLastCalculatedVelocity()};
        y = RK2Solver.solve(y, time, e, new RK2Solver.DifferentialEquation[]{new RK2Solver.DifferentialEquation(){

            @Override
            public double evaluate(double t, double[] x) {
                return x[1];
            }
        }, new RK2Solver.DifferentialEquation(){

            @Override
            public double evaluate(double t, double[] x) {
                return (-k * (x[0] - p) - b * x[1]) / m;
            }
        }});
        this.setCurrentPosition(y[0]);
        this.setCurrentVelocity(y[1]);
        this.setCurrentTime(time);
    }

    public double getTarget() {
        return this.m_target;
    }

    public double getDamping() {
        return this.m_damping;
    }

    public double getStiffness() {
        return this.m_stiffness;
    }

    public double getMass() {
        return this.m_mass;
    }

    public double getLastCalculatedTime() {
        return this.m_lastTime;
    }

    public double getLastCalculatedVelocity() {
        return this.m_velocity;
    }

    public double getLastCalculatedPosition() {
        return this.m_position;
    }

    private void setCurrentTime(double time) {
        this.m_lastTime = time;
    }

    private double currentTime() {
        if (Double.isNaN(this.m_timeOffset)) {
            this.m_timeOffset = (double)System.currentTimeMillis() / 1000.0;
            this.m_lastTime = 0.0;
        }
        return (double)System.currentTimeMillis() / 1000.0 - this.m_timeOffset;
    }

    @Override
    public String getId() {
        return this.m_id;
    }

    public static class RK2Solver {
        public static double[] solve(double[] x, double t, double h, DifferentialEquation[] f) {
            double[] a = RK2Solver.evaluate(f, t, x);
            double[] b = RK2Solver.evaluate(f, t + h / 2.0, RK2Solver.add(x, RK2Solver.multiply(h / 2.0, a)));
            double[] c = RK2Solver.evaluate(f, t + h / 2.0, RK2Solver.add(x, RK2Solver.multiply(h / 2.0, b)));
            double[] d = RK2Solver.evaluate(f, t + h, RK2Solver.add(x, RK2Solver.multiply(h, c)));
            return RK2Solver.add(x, RK2Solver.multiply(h / 6.0, RK2Solver.add(RK2Solver.multiply(2.0, RK2Solver.add(b, c)), RK2Solver.add(a, d))));
        }

        private static double[] evaluate(DifferentialEquation[] f, double t, double[] x) {
            double[] result = new double[f.length];
            int n = 0;
            while (n < result.length) {
                result[n] = f[n].evaluate(t, x);
                ++n;
            }
            return result;
        }

        private static double[] multiply(double constant, double[] v) {
            double[] result = new double[v.length];
            int n = 0;
            while (n < result.length) {
                result[n] = constant * v[n];
                ++n;
            }
            return result;
        }

        private static double[] add(double[] v1, double[] v2) {
            double[] result = new double[v1.length];
            int n = 0;
            while (n < result.length) {
                result[n] = v1[n] + v2[n];
                ++n;
            }
            return result;
        }

        public static interface DifferentialEquation {
            public double evaluate(double var1, double[] var3);
        }
    }
}

