/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.handlers;

import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.commands.ICommandService;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.ui.UIPlugin;

public class ActionToolkit {
    private static final String CHECKED_ACTION = "checkedAction";
    private static final String ID_ATTRIBUTE = "id";

    public static void loadCheckState(IState state, Stream<IAction> actions) {
        if (state != null) {
            Set selected = Stream.of(state.getChildren(CHECKED_ACTION)).map(s -> s.getAttribute(ID_ATTRIBUTE)).collect(Collectors.toSet());
            actions.forEach(a -> a.setChecked(selected.contains(a.getId())));
        }
    }

    public static void saveCheckState(IWritableState state, Stream<IAction> actions) {
        actions.filter(a -> a.isChecked()).forEach(action -> state.createChild(CHECKED_ACTION).putString(ID_ATTRIBUTE, action.getId()));
    }

    public static void convertToCommandAction(IAction a, String commandId) {
        try {
            a.setActionDefinitionId(commandId);
            IWorkbench sl = PlatformUI.getWorkbench();
            ICommandImageService is = (ICommandImageService)sl.getService(ICommandImageService.class);
            ICommandService cs = (ICommandService)sl.getService(ICommandService.class);
            Command command = cs.getCommand(commandId);
            a.setText(command.getName());
            a.setDescription(command.getDescription());
            a.setImageDescriptor(is.getImageDescriptor(commandId, 0));
            a.setDisabledImageDescriptor(is.getImageDescriptor(commandId, 1));
            a.setHoverImageDescriptor(is.getImageDescriptor(commandId, 2));
        }
        catch (RuntimeException e) {
            a.setText(commandId);
            UIPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not create CommandAction for " + commandId, e);
        }
        catch (NotDefinedException e) {
            a.setText(commandId);
            UIPlugin.getDefault().getLogger().log(Level.SEVERE, String.valueOf(commandId) + " not defined", e);
        }
    }

    public static IAction commandAction(Runnable runnable, String commandId) {
        IAction a = ActionToolkit.action(runnable, null);
        ActionToolkit.convertToCommandAction(a, commandId);
        return a;
    }

    public static IAction action(Runnable runnable, String text) {
        return ActionToolkit.action(runnable, text, null);
    }

    public static IAction action(final Runnable runnable, String text, ImageDescriptor icon) {
        Action a = new Action(text, icon){

            public void run() {
                runnable.run();
            }
        };
        return a;
    }

    public static IAction radioAction(final Runnable runnable, String text, ImageDescriptor icon) {
        Action a = new Action(text, 8){

            public void run() {
                if (this.isChecked()) {
                    runnable.run();
                }
            }
        };
        a.setImageDescriptor(icon);
        return a;
    }

    public static IAction checkAction(final Consumer<Boolean> onChange, String text, ImageDescriptor icon) {
        Action a = new Action(text, 2){

            public void run() {
                onChange.accept(this.isChecked());
            }
        };
        a.setImageDescriptor(icon);
        return a;
    }

    public static IAction checkAction(Consumer<Boolean> onChange, String text, String description, ImageDescriptor icon, String id) {
        IAction a = ActionToolkit.checkAction(onChange, text, icon);
        a.setDescription(description);
        a.setId(id);
        return a;
    }

    public static IAction action(final Runnable runnable, String text, ImageDescriptor icon, int style) {
        Action a = new Action(text, style){

            public void run() {
                runnable.run();
            }
        };
        a.setImageDescriptor(icon);
        return a;
    }

    public static IAction forTreeSelection(AbstractTreeViewer viewer, String name, boolean refresh, Function<TreeSelection, Runnable> actionProvider) {
        return new SupplierSelectionProviderAction((StructuredViewer)viewer, name, refresh, selection -> (Runnable)actionProvider.apply((TreeSelection)selection));
    }

    public static <T> IAction forListSelection(StructuredViewer viewer, String name, boolean refresh, Function<List<T>, Runnable> actionProvider) {
        return new SupplierSelectionProviderAction(viewer, name, refresh, selection -> (Runnable)actionProvider.apply(selection.toList()));
    }

    public static <T> IAction forListSelection(StructuredViewer viewer, String name, boolean refresh, int minElements, Consumer<List<T>> action) {
        return ActionToolkit.forListSelection(viewer, name, refresh, list -> list.size() >= minElements ? () -> action.accept((List)list) : null);
    }

    private static class SupplierSelectionProviderAction
    extends SelectionProviderAction {
        private final Function<IStructuredSelection, Runnable> actionProvider;
        private final boolean refreshViewer;
        private Runnable action;

        SupplierSelectionProviderAction(StructuredViewer viewer, String text, boolean refresh, Function<IStructuredSelection, Runnable> actionProvider) {
            super((ISelectionProvider)viewer, text);
            this.refreshViewer = refresh;
            this.actionProvider = actionProvider;
            this.selectionChanged(this.getStructuredSelection());
        }

        public void selectionChanged(IStructuredSelection selection) {
            this.action = this.actionProvider.apply(selection);
            this.setEnabled(this.action != null);
        }

        public void run() {
            this.action.run();
            if (this.refreshViewer) {
                ((StructuredViewer)this.getSelectionProvider()).refresh();
            }
        }
    }
}

