/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.agent.manager.wizards;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.openjdk.jmc.console.agent.manager.model.IEvent;
import org.openjdk.jmc.console.agent.manager.model.IField;
import org.openjdk.jmc.console.agent.manager.wizards.CapturedValueEditingPage;
import org.openjdk.jmc.console.agent.messages.internal.Messages;
import org.openjdk.jmc.console.agent.wizards.BaseWizardPage;
import org.openjdk.jmc.ui.misc.AbstractStructuredContentProvider;
import org.openjdk.jmc.ui.misc.DialogToolkit;
import org.openjdk.jmc.ui.wizards.OnePageWizardDialog;

public class EventEditingWizardFieldPage
extends BaseWizardPage {
    private final IEvent event;
    private BaseWizardPage.TableInspector tableInspector;

    protected EventEditingWizardFieldPage(IEvent event) {
        super(Messages.EventEditingWizardFieldPage_PAGE_NAME);
        this.event = event;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.setTitle(Messages.EventEditingWizardFieldPage_MESSAGE_EVENT_EDITING_WIZARD_FIELD_PAGE_TITLE);
        this.setDescription(Messages.EventEditingWizardFieldPage_MESSAGE_EVENT_EDITING_WIZARD_FIELD_PAGE_DESCRIPTION);
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        Composite container = new Composite((Composite)sc, 0);
        sc.setContent((Control)container);
        container.setLayout((Layout)new FillLayout());
        this.createFieldTableContainer(container);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinSize(container.computeSize(-1, -1));
        this.setControl((Control)sc);
        this.populateUi();
    }

    private Composite createFieldTableContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout());
        this.tableInspector = new BaseWizardPage.TableInspector(container, 63){

            @Override
            protected void addColumns() {
                this.addColumn(Messages.EventEditingWizardFieldPage_LABEL_NAME, Messages.EventEditingWizardFieldPage_ID_NAME, new FieldTableLabelProvider(){

                    @Override
                    protected String doGetText(IField field) {
                        return field.getName();
                    }
                });
                this.addColumn(Messages.EventEditingWizardFieldPage_LABEL_EXPRESSION, Messages.EventEditingWizardFieldPage_ID_EXPRESSION, new FieldTableLabelProvider(){

                    @Override
                    protected String doGetText(IField field) {
                        return field.getExpression();
                    }
                });
                this.addColumn(Messages.EventEditingWizardFieldPage_LABEL_DESCRIPTION, Messages.EventEditingWizardFieldPage_ID_DESCRIPTION, new FieldTableLabelProvider(){

                    @Override
                    protected String doGetText(IField field) {
                        return field.getDescription();
                    }
                });
            }

            @Override
            protected void onAddButtonSelected(IStructuredSelection selection) {
                IField field = EventEditingWizardFieldPage.this.event.createField();
                while (new OnePageWizardDialog(Display.getCurrent().getActiveShell(), (IWizardPage)new CapturedValueEditingPage(EventEditingWizardFieldPage.this.event, field)).open() == 0) {
                    try {
                        EventEditingWizardFieldPage.this.event.addField(field);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        if (!DialogToolkit.openConfirmOnUiThread((String)Messages.EventEditingWizardFieldPage_MESSAGE_UNABLE_TO_SAVE_THE_FIELD, (String)e.getMessage())) break;
                    }
                }
                EventEditingWizardFieldPage.this.tableInspector.getViewer().refresh();
            }

            @Override
            protected void onEditButtonSelected(IStructuredSelection selection) {
                IField original = (IField)selection.getFirstElement();
                IField workingCopy = original.createWorkingCopy();
                while (new OnePageWizardDialog(Display.getCurrent().getActiveShell(), (IWizardPage)new CapturedValueEditingPage(EventEditingWizardFieldPage.this.event, workingCopy)).open() == 0) {
                    try {
                        EventEditingWizardFieldPage.this.event.updateField(original, workingCopy);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        if (!DialogToolkit.openConfirmOnUiThread((String)Messages.EventEditingWizardFieldPage_MESSAGE_UNABLE_TO_SAVE_THE_FIELD, (String)e.getMessage())) break;
                    }
                }
                EventEditingWizardFieldPage.this.tableInspector.getViewer().refresh();
            }

            @Override
            protected void onDuplicateButtonSelected(IStructuredSelection selection) {
                IField original = (IField)selection.getFirstElement();
                IField duplicate = original.createDuplicate();
                EventEditingWizardFieldPage.this.event.addField(duplicate);
                EventEditingWizardFieldPage.this.tableInspector.getViewer().refresh();
            }

            @Override
            protected void onRemoveButtonSelected(IStructuredSelection selection) {
                for (Object field : selection) {
                    EventEditingWizardFieldPage.this.event.removeField((IField)field);
                }
                EventEditingWizardFieldPage.this.tableInspector.getViewer().refresh();
            }
        };
        this.tableInspector.setContentProvider((IContentProvider)new FieldTableContentProvider());
        return container;
    }

    private void populateUi() {
        this.tableInspector.setInput(this.event);
    }

    private static class FieldTableContentProvider
    extends AbstractStructuredContentProvider {
        private FieldTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (!(inputElement instanceof IEvent)) {
                throw new IllegalArgumentException("input element must be an IEvent");
            }
            IEvent event = (IEvent)inputElement;
            return event.getFields();
        }
    }

    private static abstract class FieldTableLabelProvider
    extends ColumnLabelProvider {
        private FieldTableLabelProvider() {
        }

        public String getText(Object element) {
            if (!(element instanceof IField)) {
                throw new IllegalArgumentException("element must be an IField");
            }
            return this.doGetText((IField)element);
        }

        protected abstract String doGetText(IField var1);
    }
}

