/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.agent.manager.wizards;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.openjdk.jmc.console.agent.manager.model.IPreset;
import org.openjdk.jmc.console.agent.messages.internal.Messages;
import org.openjdk.jmc.console.agent.wizards.BaseWizardPage;

public class PresetEditingWizardConfigPage
extends BaseWizardPage {
    private final IPreset preset;
    private Text fileNameText;
    private Text classPrefixText;
    private Button allowToStringButton;
    private Button allowConverterButton;

    protected PresetEditingWizardConfigPage(IPreset preset) {
        super(Messages.PresetEditingWizardConfigPage_PAGE_NAME);
        this.preset = preset;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.setTitle(Messages.PresetEditingWizardConfigPage_MESSAGE_PRESET_EDITING_WIZARD_CONFIG_PAGE_TITLE);
        this.setDescription(Messages.PresetEditingWizardConfigPage_MESSAGE_PRESET_EDITING_WIZARD_CONFIG_PAGE_DESCRIPTION);
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        Composite container = new Composite((Composite)sc, 0);
        sc.setContent((Control)container);
        container.setLayout((Layout)new GridLayout());
        this.createFileNameContainer(container).setLayoutData((Object)new GridData(4, 4, true, false));
        PresetEditingWizardConfigPage.createSeparator(container).setLayoutData((Object)new GridData(4, 4, true, false));
        this.createGlobalConfigContainer(container).setLayoutData((Object)new GridData(4, 4, true, false));
        this.populateUi();
        this.bindListeners();
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinSize(container.computeSize(-1, -1));
        this.setControl((Control)sc);
    }

    private Composite createFileNameContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        int cols = 5;
        GridLayout layout = new GridLayout(cols, false);
        layout.horizontalSpacing = 8;
        container.setLayout((Layout)layout);
        this.fileNameText = PresetEditingWizardConfigPage.createTextInput(container, cols, Messages.PresetEditingWizardConfigPage_LABEL_FILE_NAME, Messages.PresetEditingWizardConfigPage_MESSAGE_NAME_OF_THE_SAVED_XML);
        return container;
    }

    private Composite createGlobalConfigContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        int cols = 5;
        GridLayout layout = new GridLayout(cols, false);
        layout.horizontalSpacing = 8;
        container.setLayout((Layout)layout);
        this.classPrefixText = PresetEditingWizardConfigPage.createTextInput(container, cols, Messages.PresetEditingWizardConfigPage_LABEL_CLASS_PREFIX, Messages.PresetEditingWizardConfigPage_MESSAGE_PREFIX_ADDED_TO_GENERATED_EVENT_CLASSES);
        this.allowToStringButton = PresetEditingWizardConfigPage.createCheckboxInput(parent, cols, Messages.PresetEditingWizardConfigPage_LABEL_ALLOW_TO_STRING);
        this.allowConverterButton = PresetEditingWizardConfigPage.createCheckboxInput(parent, cols, Messages.PresetEditingWizardConfigPage_LABEL_ALLOW_CONVERTER);
        return container;
    }

    private void bindListeners() {
        this.fileNameText.addModifyListener(this.handleExceptionIfAny(e -> this.preset.setFileName(this.fileNameText.getText())));
        this.classPrefixText.addModifyListener(this.handleExceptionIfAny(e -> this.preset.setClassPrefix(this.classPrefixText.getText())));
        this.allowToStringButton.addListener(13, this.handleExceptionIfAny(e -> this.preset.setAllowToString(this.allowToStringButton.getSelection())));
        this.allowConverterButton.addListener(13, this.handleExceptionIfAny(e -> this.preset.setAllowConverter(this.allowConverterButton.getSelection())));
    }

    private void populateUi() {
        PresetEditingWizardConfigPage.setText(this.fileNameText, this.preset.getFileName());
        PresetEditingWizardConfigPage.setText(this.classPrefixText, this.preset.getClassPrefix());
        this.allowToStringButton.setSelection(this.preset.getAllowToString());
        this.allowConverterButton.setSelection(this.preset.getAllowConverter());
    }
}

