/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.agent.raweditor.internal;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.StorageDocumentProvider;
import org.openjdk.jmc.console.agent.raweditor.internal.XmlPartitionScanner;

public class XmlDocumentProvider
extends StorageDocumentProvider {
    protected IDocument createDocument(Object element) throws CoreException {
        IDocument document = super.createDocument(element);
        if (document != null) {
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new XmlPartitionScanner(), new String[]{"__xml_tag", "__xml_comment"});
            partitioner.connect(document);
            document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        }
        return document;
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        IStorageEditorInput ei = (IStorageEditorInput)element;
        File out = ei.getStorage().getFullPath().toFile();
        if (!out.exists()) {
            try {
                Files.createFile(out.toPath(), new FileAttribute[0]);
            }
            catch (IOException | SecurityException e) {
                Status s22 = new Status(4, "org.eclipse.ui.editors", 0, e.getMessage(), (Throwable)e);
                throw new CoreException((IStatus)s22);
            }
        }
        try {
            Throwable e = null;
            Object s22 = null;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(out), StandardCharsets.UTF_8));){
                writer.write(document.get());
            }
            catch (Throwable s22) {
                if (e == null) {
                    e = s22;
                } else if (e != s22) {
                    e.addSuppressed(s22);
                }
                throw e;
            }
        }
        catch (IOException e) {
            Status s = new Status(4, "org.eclipse.ui.editors", 0, e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)s);
        }
    }
}

