/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.jdk;

import java.util.ArrayList;
import java.util.List;
import org.openjdk.jmc.common.IDisplayable;
import org.openjdk.jmc.common.IMCClassLoader;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCMethod;
import org.openjdk.jmc.common.IMCModule;
import org.openjdk.jmc.common.IMCOldObject;
import org.openjdk.jmc.common.IMCOldObjectGcRoot;
import org.openjdk.jmc.common.IMCPackage;
import org.openjdk.jmc.common.IMCStackTrace;
import org.openjdk.jmc.common.IMCThread;
import org.openjdk.jmc.common.IMCThreadGroup;
import org.openjdk.jmc.common.IMCType;
import org.openjdk.jmc.common.item.Attribute;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.FormatToolkit;
import org.openjdk.jmc.common.util.LabeledIdentifier;
import org.openjdk.jmc.common.util.MCClassLoader;
import org.openjdk.jmc.common.util.MemberAccessorToolkit;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.messages.internal.Messages;

public final class JdkAttributes {
    public static final IAttribute<String> EVENT_THREAD_NAME = Attribute.canonicalize((Attribute)new Attribute<String>("(thread).name", Messages.getString("ATTR_EVENT_THREAD_NAME"), Messages.getString("ATTR_EVENT_THREAD_NAME_DESC"), UnitLookup.PLAIN_TEXT){

        public <U> IMemberAccessor<String, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = JfrAttributes.EVENT_THREAD.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<String, U>(){

                public String getMember(U i) {
                    IMCThread thread = (IMCThread)accessor.getMember(i);
                    return thread == null ? null : thread.getThreadName();
                }
            };
        }
    });
    public static final IAttribute<String> EVENT_THREAD_GROUP_NAME = Attribute.canonicalize((Attribute)new Attribute<String>("(thread).groupName", Messages.getString("ATTR_EVENT_THREAD_GROUP"), Messages.getString("ATTR_EVENT_THREAD_GROUP_DESC"), UnitLookup.PLAIN_TEXT){

        public <U> IMemberAccessor<String, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = JfrAttributes.EVENT_THREAD.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<String, U>(){

                public String getMember(U i) {
                    IMCThreadGroup group;
                    IMCThread thread = (IMCThread)accessor.getMember(i);
                    if (thread != null && (group = thread.getThreadGroup()) != null) {
                        return group.getName();
                    }
                    return null;
                }
            };
        }
    });
    public static final IAttribute<IQuantity> EVENT_THREAD_ID = Attribute.canonicalize((Attribute)new Attribute<IQuantity>("(thread).javaThreadId", Messages.getString("ATTR_EVENT_THREAD_ID"), Messages.getString("ATTR_EVENT_THREAD_ID_DESC"), (ContentType)UnitLookup.NUMBER){

        public <U> IMemberAccessor<IQuantity, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = JfrAttributes.EVENT_THREAD.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<IQuantity, U>(){

                public IQuantity getMember(U i) {
                    IMCThread thread = (IMCThread)accessor.getMember(i);
                    return thread == null || thread.getThreadId() == null ? null : UnitLookup.NUMBER_UNITY.quantity((Number)thread.getThreadId());
                }
            };
        }
    });
    public static final IAttribute<String> STACK_TRACE_STRING = Attribute.canonicalize((Attribute)new Attribute<String>("(stackTrace).string", Messages.getString("ATTR_STACK_TRACE_STRING"), Messages.getString("ATTR_STACK_TRACE_STRING_DESC"), UnitLookup.PLAIN_TEXT){

        public <U> IMemberAccessor<String, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = JfrAttributes.EVENT_STACKTRACE.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<String, U>(){

                public String getMember(U i) {
                    IMCStackTrace trace = (IMCStackTrace)accessor.getMember(i);
                    return trace == null ? null : FormatToolkit.getHumanReadable((IMCStackTrace)trace, (String)"", (String)"", null);
                }
            };
        }
    });
    public static final IAttribute<IMCFrame> STACK_TRACE_TOP_FRAME = Attribute.canonicalize((Attribute)new Attribute<IMCFrame>("(stackTrace).topframe", Messages.getString("ATTR_STACK_TRACE_FRAME"), Messages.getString("ATTR_STACK_TRACE_FRAME_DESC"), UnitLookup.STACKTRACE_FRAME){

        public <U> IMemberAccessor<IMCFrame, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = JfrAttributes.EVENT_STACKTRACE.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<IMCFrame, U>(){

                public IMCFrame getMember(U i) {
                    IMCStackTrace trace = (IMCStackTrace)accessor.getMember(i);
                    return trace == null || trace.getFrames().isEmpty() ? null : (IMCFrame)trace.getFrames().get(0);
                }
            };
        }
    });
    public static final IAttribute<String> STACK_TRACE_TOP_PACKAGE = Attribute.canonicalize((Attribute)new Attribute<String>("(stackTrace).topPackage", Messages.getString("ATTR_STACK_TRACE_PACKAGE"), Messages.getString("ATTR_STACK_TRACE_PACKAGE_DESC"), UnitLookup.PLAIN_TEXT){

        public <U> IMemberAccessor<String, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = STACK_TRACE_TOP_CLASS.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<String, U>(){

                public String getMember(U i) {
                    IMCType type = (IMCType)accessor.getMember(i);
                    return type == null ? null : FormatToolkit.getPackage((IMCPackage)type.getPackage());
                }
            };
        }
    });
    public static final IAttribute<IMCType> STACK_TRACE_TOP_CLASS = Attribute.canonicalize((Attribute)new Attribute<IMCType>("(stackTrace).topClass", Messages.getString("ATTR_STACK_TRACE_CLASS"), Messages.getString("ATTR_STACK_TRACE_CLASS_DESC"), UnitLookup.CLASS){

        public <U> IMemberAccessor<IMCType, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = STACK_TRACE_TOP_METHOD.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<IMCType, U>(){

                public IMCType getMember(U i) {
                    IMCMethod method = (IMCMethod)accessor.getMember(i);
                    return method == null ? null : method.getType();
                }
            };
        }
    });
    public static final IAttribute<String> STACK_TRACE_TOP_CLASS_STRING = Attribute.canonicalize((Attribute)new Attribute<String>("(stackTrace).topClass.string", Messages.getString("ATTR_STACK_TRACE_CLASS"), Messages.getString("ATTR_STACK_TRACE_CLASS_DESC"), UnitLookup.PLAIN_TEXT){

        public <U> IMemberAccessor<String, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = STACK_TRACE_TOP_CLASS.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<String, U>(){

                public String getMember(U i) {
                    IMCType type = (IMCType)accessor.getMember(i);
                    return type == null ? null : type.getFullName();
                }
            };
        }
    });
    public static final IAttribute<IMCMethod> STACK_TRACE_TOP_METHOD = Attribute.canonicalize((Attribute)new Attribute<IMCMethod>("(stackTrace).topMethod", Messages.getString("ATTR_STACK_TRACE_METHOD"), Messages.getString("ATTR_STACK_TRACE_METHOD_DESC"), UnitLookup.METHOD){

        public <U> IMemberAccessor<IMCMethod, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = STACK_TRACE_TOP_FRAME.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<IMCMethod, U>(){

                public IMCMethod getMember(U i) {
                    IMCFrame frame = (IMCFrame)accessor.getMember(i);
                    return frame == null ? null : frame.getMethod();
                }
            };
        }
    });
    public static final IAttribute<String> STACK_TRACE_TOP_METHOD_STRING = Attribute.canonicalize((Attribute)new Attribute<String>("(stackTrace).topMethodString", Messages.getString("ATTR_STACK_TRACE_METHOD"), Messages.getString("ATTR_STACK_TRACE_METHOD_DESC"), UnitLookup.PLAIN_TEXT){

        public <U> IMemberAccessor<String, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = STACK_TRACE_TOP_METHOD.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<String, U>(){

                public String getMember(U i) {
                    IMCMethod method = (IMCMethod)accessor.getMember(i);
                    return method == null ? null : FormatToolkit.getHumanReadable((IMCMethod)method);
                }
            };
        }
    });
    public static final IAttribute<IMCFrame> STACK_TRACE_BOTTOM_FRAME = Attribute.canonicalize((Attribute)new Attribute<IMCFrame>("(stackTrace).bottomFrame", Messages.getString("ATTR_STACK_TRACE_BOTTOM_FRAME"), Messages.getString("ATTR_STACK_TRACE_BOTTOM_FRAME_DESC"), UnitLookup.STACKTRACE_FRAME){

        public <U> IMemberAccessor<IMCFrame, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = JfrAttributes.EVENT_STACKTRACE.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<IMCFrame, U>(){

                public IMCFrame getMember(U i) {
                    IMCStackTrace trace = (IMCStackTrace)accessor.getMember(i);
                    if (trace != null) {
                        List frames = trace.getFrames();
                        return frames == null || frames.size() == 0 ? null : (IMCFrame)frames.get(frames.size() - 1);
                    }
                    return null;
                }
            };
        }
    });
    public static final IAttribute<IMCMethod> STACK_TRACE_BOTTOM_METHOD = Attribute.canonicalize((Attribute)new Attribute<IMCMethod>("(stackTrace).bottomMethod", Messages.getString("ATTR_STACK_TRACE_BOTTOM_METHOD"), Messages.getString("ATTR_STACK_TRACE_BOTTOM_METHOD_DESC"), UnitLookup.METHOD){

        public <U> IMemberAccessor<IMCMethod, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = STACK_TRACE_BOTTOM_FRAME.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<IMCMethod, U>(){

                public IMCMethod getMember(U i) {
                    IMCFrame frame = (IMCFrame)accessor.getMember(i);
                    return frame == null ? null : frame.getMethod();
                }
            };
        }
    });
    public static final IAttribute<String> STACK_TRACE_BOTTOM_METHOD_STRING = Attribute.canonicalize((Attribute)new Attribute<String>("(stackTrace).bottomMethodString", Messages.getString("ATTR_STACK_TRACE_BOTTOM_METHOD"), Messages.getString("ATTR_STACK_TRACE_BOTTOM_METHOD_DESC"), UnitLookup.PLAIN_TEXT){

        public <U> IMemberAccessor<String, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = STACK_TRACE_BOTTOM_METHOD.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<String, U>(){

                public String getMember(U i) {
                    IMCMethod method = (IMCMethod)accessor.getMember(i);
                    return method == null ? null : FormatToolkit.getHumanReadable((IMCMethod)method);
                }
            };
        }
    });
    public static final IAttribute<Boolean> STACK_TRACE_TRUNCATED = Attribute.canonicalize((Attribute)new Attribute<Boolean>("(stackTrace).truncationState", Messages.getString("ATTR_STACK_TRACE_DEPTH"), Messages.getString("ATTR_STACK_TRACE_DEPTH_DESC"), UnitLookup.FLAG){

        public <U> IMemberAccessor<Boolean, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = JfrAttributes.EVENT_STACKTRACE.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<Boolean, U>(){

                public Boolean getMember(U i) {
                    IMCStackTrace trace = (IMCStackTrace)accessor.getMember(i);
                    return trace == null ? null : Boolean.valueOf(trace.getTruncationState().isTruncated());
                }
            };
        }
    });
    public static final IAttribute<String> PID = Attribute.attr((String)"pid", (String)Messages.getString("ATTR_PID"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<String> COMMAND_LINE = Attribute.attr((String)"commandLine", (String)Messages.getString("ATTR_COMMAND_LINE"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> JVM_SYSTEM = Attribute.attr((String)"jvmSystem", (String)Messages.getString("ATTR_JVM_SYSTEM"), (String)Messages.getString("ATTR_JVM_SYSTEM_DESC"), (ContentType)UnitLookup.PERCENTAGE);
    public static final IAttribute<IQuantity> JVM_USER = Attribute.attr((String)"jvmUser", (String)Messages.getString("ATTR_JVM_USER"), (String)Messages.getString("ATTR_JVM_USER_DESC"), (ContentType)UnitLookup.PERCENTAGE);
    public static final IAttribute<IQuantity> JVM_TOTAL = Attribute.canonicalize((Attribute)new Attribute<IQuantity>("jvmTotal", Messages.getString("ATTR_JVM_TOTAL"), Messages.getString("ATTR_JVM_TOTAL_DESC"), (ContentType)UnitLookup.PERCENTAGE){

        public <U> IMemberAccessor<IQuantity, U> customAccessor(IType<U> type) {
            final IMemberAccessor jvmUserAccessor = type.getAccessor(JVM_USER.getKey());
            final IMemberAccessor jvmSystemAccessor = type.getAccessor(JVM_SYSTEM.getKey());
            if (jvmUserAccessor == null || jvmSystemAccessor == null) {
                return null;
            }
            return new IMemberAccessor<IQuantity, U>(){

                public IQuantity getMember(U i) {
                    IQuantity jvmUser = (IQuantity)jvmUserAccessor.getMember(i);
                    IQuantity jvmSystem = (IQuantity)jvmSystemAccessor.getMember(i);
                    return jvmUser != null && jvmSystem != null ? jvmUser.add(jvmSystem) : null;
                }
            };
        }
    });
    public static final IAttribute<IQuantity> MACHINE_TOTAL = Attribute.attr((String)"machineTotal", (String)Messages.getString("ATTR_MACHINE_TOTAL"), (String)Messages.getString("ATTR_MACHINE_TOTAL_DESC"), (ContentType)UnitLookup.PERCENTAGE);
    public static final IAttribute<IQuantity> OTHER_CPU = Attribute.canonicalize((Attribute)new Attribute<IQuantity>("otherCpu", Messages.getString("ATTR_OTHER_CPU"), Messages.getString("ATTR_OTHER_CPU_DESC"), (ContentType)UnitLookup.PERCENTAGE){

        public <U> IMemberAccessor<IQuantity, U> customAccessor(IType<U> type) {
            final IMemberAccessor jvmTotalAccessor = JVM_TOTAL.getAccessor(type);
            final IMemberAccessor machineTotalAccessor = type.getAccessor(MACHINE_TOTAL.getKey());
            if (jvmTotalAccessor == null || machineTotalAccessor == null) {
                return null;
            }
            return new IMemberAccessor<IQuantity, U>(){

                public IQuantity getMember(U i) {
                    IQuantity jvmTotal = (IQuantity)jvmTotalAccessor.getMember(i);
                    IQuantity machineTotal = (IQuantity)machineTotalAccessor.getMember(i);
                    return jvmTotal != null && machineTotal != null ? machineTotal.subtract(jvmTotal) : null;
                }
            };
        }
    });
    public static final IAttribute<IQuantity> OTHER_CPU_RATIO = Attribute.canonicalize((Attribute)new Attribute<IQuantity>("otherCpuRatio", Messages.getString("ATTR_OTHER_CPU_RATIO"), Messages.getString("ATTR_OTHER_CPU_RATIO_DESC"), (ContentType)UnitLookup.PERCENTAGE){

        public <U> IMemberAccessor<IQuantity, U> customAccessor(IType<U> type) {
            final IMemberAccessor otherCpuAccessor = OTHER_CPU.getAccessor(type);
            final IMemberAccessor machineTotalAccessor = type.getAccessor(MACHINE_TOTAL.getKey());
            if (otherCpuAccessor == null || machineTotalAccessor == null) {
                return null;
            }
            return new IMemberAccessor<IQuantity, U>(){

                public IQuantity getMember(U i) {
                    IQuantity machineTotal = (IQuantity)machineTotalAccessor.getMember(i);
                    IQuantity otherCpu = (IQuantity)otherCpuAccessor.getMember(i);
                    return otherCpu != null && machineTotal != null ? otherCpu.multiply(machineTotal.doubleValue()) : null;
                }
            };
        }
    });
    public static final IAttribute<IQuantity> RECORDING_ID = Attribute.attr((String)"id", (String)Messages.getString("ATTR_RECORDING_ID"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<String> RECORDING_NAME = Attribute.attr((String)"name", (String)Messages.getString("ATTR_RECORDING_NAME"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> RECORDING_START = Attribute.attr((String)"recordingStart", (String)Messages.getString("ATTR_RECORDING_START"), (ContentType)UnitLookup.TIMESTAMP);
    public static final IAttribute<IQuantity> RECORDING_DURATION = Attribute.attr((String)"recordingDuration", (String)Messages.getString("ATTR_RECORDING_DURATION"), (ContentType)UnitLookup.TIMESPAN);
    public static final IAttribute<IQuantity> RECORDING_MAX_SIZE = Attribute.attr((String)"maxSize", (String)Messages.getString("ATTR_RECORDING_MAX_SIZE"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> RECORDING_MAX_AGE = Attribute.attr((String)"maxAge", (String)Messages.getString("ATTR_RECORDING_MAX_AGE"), (ContentType)UnitLookup.TIMESPAN);
    public static final IAttribute<String> RECORDING_DESTINATION = Attribute.attr((String)"destination", (String)Messages.getString("ATTR_RECORDING_DESTINATION"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<LabeledIdentifier> REC_SETTING_FOR = Attribute.attr((String)"settingFor", (String)Messages.getString("ATTR_REC_SETTING_FOR"), (ContentType)UnitLookup.LABELED_IDENTIFIER);
    public static final IAttribute<String> REC_SETTING_NAME = Attribute.attr((String)"name", (String)Messages.getString("ATTR_REC_SETTING_NAME"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<String> REC_SETTING_VALUE = Attribute.attr((String)"value", (String)Messages.getString("ATTR_REC_SETTING_VALUE"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<String> REC_SETTING_FOR_NAME = Attribute.canonicalize((Attribute)new Attribute<String>("settingFor.string", Messages.getString("ATTR_REC_SETTING_FOR"), null, UnitLookup.PLAIN_TEXT){

        public <U> IMemberAccessor<String, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = REC_SETTING_FOR.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<String, U>(){

                public String getMember(U i) {
                    LabeledIdentifier identifier = (LabeledIdentifier)accessor.getMember(i);
                    return identifier == null ? null : identifier.getName();
                }
            };
        }
    });
    public static final IAttribute<String> REC_SETTING_FOR_ID = Attribute.canonicalize((Attribute)new Attribute<String>("settingFor.id", Messages.getString("ATTR_REC_SETTING_FOR"), null, UnitLookup.PLAIN_TEXT){

        public <U> IMemberAccessor<String, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = REC_SETTING_FOR.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<String, U>(){

                public String getMember(U i) {
                    LabeledIdentifier identifier = (LabeledIdentifier)accessor.getMember(i);
                    return identifier == null ? null : identifier.getInterfaceId();
                }
            };
        }
    });
    public static final IAttribute<IMCPackage> EXPORTED_PACKAGE = Attribute.attr((String)"exportedPackage", (String)Messages.getString("ATTR_EXPORTED_PACKAGE"), (ContentType)UnitLookup.PACKAGE);
    public static final IAttribute<IMCModule> EXPORTING_MODULE = Attribute.canonicalize((Attribute)new Attribute<IMCModule>("exportingModule", Messages.getString("ATTR_EXPORTING_MODULE"), null, UnitLookup.MODULE){

        public <U> IMemberAccessor<IMCModule, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = EXPORTED_PACKAGE.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<IMCModule, U>(){

                public IMCModule getMember(U i) {
                    IMCPackage thePackage = (IMCPackage)accessor.getMember(i);
                    return thePackage == null ? null : thePackage.getModule();
                }
            };
        }
    });
    public static final IAttribute<IQuantity> JVM_START_TIME = Attribute.attr((String)"jvmStartTime", (String)Messages.getString("ATTR_JVM_START_TIME"), (ContentType)UnitLookup.TIMESTAMP);
    public static final IAttribute<String> JVM_NAME = Attribute.attr((String)"jvmName", (String)Messages.getString("ATTR_JVM_NAME"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> JVM_PID = Attribute.attr((String)"pid", (String)Messages.getString("ATTR_JVM_PID"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<String> JVM_VERSION = Attribute.attr((String)"jvmVersion", (String)Messages.getString("ATTR_JVM_VERSION"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<String> JVM_ARGUMENTS = Attribute.attr((String)"jvmArguments", (String)Messages.getString("ATTR_JVM_ARGUMENTS"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<String> JAVA_ARGUMENTS = Attribute.attr((String)"javaArguments", (String)Messages.getString("ATTR_JAVA_ARGUMENTS"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<String> IO_PATH = Attribute.attr((String)"path", (String)Messages.getString("ATTR_IO_PATH"), (String)Messages.getString("ATTR_IO_PATH_DESC"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> IO_FILE_BYTES_READ = Attribute.attr((String)"bytesRead", (String)Messages.getString("ATTR_IO_FILE_BYTES_READ"), (String)Messages.getString("ATTR_IO_FILE_BYTES_READ_DESC"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<Boolean> IO_FILE_FORCE_METADATA = Attribute.attr((String)"metaData", (String)Messages.getString("ATTR_IO_FILE_FORCE_METADATA"), (String)Messages.getString("ATTR_IO_FILE_FORCE_METADATA_DESC"), (ContentType)UnitLookup.FLAG);
    public static final IAttribute<Boolean> IO_FILE_READ_EOF = Attribute.attr((String)"endOfFile", (String)Messages.getString("ATTR_IO_FILE_READ_EOF"), (String)Messages.getString("ATTR_IO_FILE_READ_EOF_DESC"), (ContentType)UnitLookup.FLAG);
    public static final IAttribute<IQuantity> IO_FILE_BYTES_WRITTEN = Attribute.attr((String)"bytesWritten", (String)Messages.getString("ATTR_IO_FILE_BYTES_WRITTEN"), (String)Messages.getString("ATTR_IO_FILE_BYTES_WRITTEN_DESC"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> IO_SOCKET_BYTES_READ = Attribute.attr((String)"bytesRead", (String)Messages.getString("ATTR_IO_SOCKET_BYTES_READ"), (String)Messages.getString("ATTR_IO_SOCKET_BYTES_READ_DESC"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<Boolean> IO_SOCKET_READ_EOS = Attribute.attr((String)"endOfStream", (String)Messages.getString("ATTR_IO_SOCKET_READ_EOS"), (String)Messages.getString("ATTR_IO_SOCKET_READ_EOS_DESC"), (ContentType)UnitLookup.FLAG);
    public static final IAttribute<IQuantity> IO_SOCKET_BYTES_WRITTEN = Attribute.attr((String)"bytesWritten", (String)Messages.getString("ATTR_IO_SOCKET_BYTES_WRITTEN"), (String)Messages.getString("ATTR_IO_SOCKET_BYTES_WRITTEN_DESC"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> IO_SIZE = Attribute.canonicalize((Attribute)new Attribute<IQuantity>("size", "Size", null, (ContentType)UnitLookup.MEMORY){

        public <U> IMemberAccessor<IQuantity, U> customAccessor(IType<U> type) {
            ArrayList<IMemberAccessor> accessorList = new ArrayList<IMemberAccessor>();
            accessorList.add(type.getAccessor(IO_SOCKET_BYTES_READ.getKey()));
            accessorList.add(type.getAccessor(IO_SOCKET_BYTES_WRITTEN.getKey()));
            accessorList.add(type.getAccessor(IO_FILE_BYTES_READ.getKey()));
            accessorList.add(type.getAccessor(IO_FILE_BYTES_WRITTEN.getKey()));
            for (IMemberAccessor accessor : accessorList) {
                if (accessor == null) continue;
                return accessor;
            }
            return MemberAccessorToolkit.constant((Object)UnitLookup.BYTE.quantity(0L));
        }
    });
    public static final IAttribute<String> IO_ADDRESS = Attribute.attr((String)"address", (String)Messages.getString("ATTR_IO_ADDRESS"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<String> IO_HOST = Attribute.attr((String)"host", (String)Messages.getString("ATTR_IO_HOST"), (String)Messages.getString("ATTR_IO_HOST_DESC"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> IO_PORT = Attribute.attr((String)"port", (String)Messages.getString("ATTR_IO_PORT"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<Object> IO_PORT_ON_ADDRESS = Attribute.canonicalize((Attribute)new Attribute<Object>("portOnAddress", Messages.getString("ATTR_IO_PORT_ON_ADDRESS"), null, UnitLookup.UNKNOWN){

        public <U> IMemberAccessor<Object, U> customAccessor(IType<U> type) {
            final IMemberAccessor addressAccessor = type.getAccessor(IO_ADDRESS.getKey());
            final IMemberAccessor portAccessor = type.getAccessor(IO_PORT.getKey());
            if (addressAccessor == null || portAccessor == null) {
                return null;
            }
            return new IMemberAccessor<Object, U>(){

                public IDisplayable getMember(U i) {
                    String address = (String)addressAccessor.getMember(i);
                    IQuantity port = (IQuantity)portAccessor.getMember(i);
                    if (address != null && port != null) {
                        class PortOnAddress
                        implements IDisplayable {
                            final String address;
                            final IQuantity port;

                            PortOnAddress(String address, IQuantity port) {
                                this.address = address;
                                this.port = port;
                            }

                            public String displayUsing(String formatHint) {
                                return this.address + " : " + this.port.displayUsing(formatHint);
                            }

                            public int hashCode() {
                                return 31 * this.address.hashCode() + this.port.hashCode();
                            }

                            public boolean equals(Object o) {
                                return o instanceof PortOnAddress && ((PortOnAddress)o).address.equals(this.address) && ((PortOnAddress)o).port.equals(this.port);
                            }
                        }
                        return new PortOnAddress(address, port);
                    }
                    return null;
                }
            };
        }
    });
    public static final IAttribute<IQuantity> IO_TIMEOUT = Attribute.attr((String)"timeout", (String)Messages.getString("ATTR_IO_TIMEOUT"), (ContentType)UnitLookup.TIMESPAN);
    public static final IAttribute<IQuantity> TLAB_SIZE = Attribute.attr((String)"tlabSize", (String)Messages.getString("ATTR_TLAB_SIZE"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> ALLOCATION_SIZE = Attribute.attr((String)"allocationSize", (String)Messages.getString("ATTR_ALLOCATION_SIZE"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> TOTAL_ALLOCATION_SIZE = Attribute.canonicalize((Attribute)new Attribute<IQuantity>("(totalAllocationSize)", Messages.getString("ATTR_ALLOCATION_TOTAL_SIZE"), Messages.getString("ATTR_ALLOCATION_TOTAL_SIZE_DESC"), (ContentType)UnitLookup.MEMORY){

        public <U> IMemberAccessor<IQuantity, U> customAccessor(IType<U> type) {
            if (type.getIdentifier().equals("jdk.ObjectAllocationInNewTLAB")) {
                return TLAB_SIZE.getAccessor(type);
            }
            if (type.getIdentifier().equals("jdk.ObjectAllocationOutsideTLAB")) {
                return ALLOCATION_SIZE.getAccessor(type);
            }
            return null;
        }
    });
    public static final IAttribute<IMCType> ALLOCATION_CLASS = Attribute.attr((String)"objectClass", (String)Messages.getString("ATTR_ALLOCATION_CLASS"), (String)Messages.getString("ATTR_ALLOCATION_CLASS_DESC"), (ContentType)UnitLookup.CLASS);
    public static final IAttribute<IMCType> OBJECT_CLASS = Attribute.attr((String)"objectClass", (String)Messages.getString("ATTR_OBJECT_CLASS"), (ContentType)UnitLookup.CLASS);
    public static final IAttribute<String> OBJECT_CLASS_FULLNAME = Attribute.canonicalize((Attribute)new Attribute<String>("objectClass.humanreadable", Messages.getString("ATTR_OBJECT_CLASS"), null, UnitLookup.PLAIN_TEXT){

        public <U> IMemberAccessor<String, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = OBJECT_CLASS.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<String, U>(){

                public String getMember(U i) {
                    IMCType type = (IMCType)accessor.getMember(i);
                    return type == null ? null : type.getFullName();
                }
            };
        }
    });
    public static final IAttribute<IQuantity> COUNT = Attribute.attr((String)"count", (String)Messages.getString("ATTR_COUNT"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> HW_THREADS = Attribute.attr((String)"hwThreads", (String)Messages.getString("ATTR_HW_THREADS"), (String)Messages.getString("ATTR_HW_THREADS_DESC"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> PARALLEL_GC_THREADS = Attribute.attr((String)"parallelGCThreads", (String)Messages.getString("ATTR_PARALLEL_GC_THREADS"), (String)Messages.getString("ATTR_PARALLEL_GC_THREADS_DESC"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> CONCURRENT_GC_THREADS = Attribute.attr((String)"concurrentGCThreads", (String)Messages.getString("ATTR_CONCURRENT_GC_THREADS"), (String)Messages.getString("ATTR_CONCURRENT_GC_THREADS_DESC"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<String> YOUNG_COLLECTOR = Attribute.attr((String)"youngCollector", (String)Messages.getString("ATTR_YOUNG_COLLECTOR"), (String)Messages.getString("ATTR_YOUNG_COLLECTOR_DESC"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<String> OLD_COLLECTOR = Attribute.attr((String)"oldCollector", (String)Messages.getString("ATTR_OLD_COLLECTOR"), (String)Messages.getString("ATTR_OLD_COLLECTOR_DESC"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<Boolean> EXPLICIT_GC_CONCURRENT = Attribute.attr((String)"isExplicitGCConcurrent", (String)Messages.getString("ATTR_EXPLICIT_GC_CONCURRENT"), (String)Messages.getString("ATTR_EXPLICIT_GC_CONCURRENT_DESC"), (ContentType)UnitLookup.FLAG);
    public static final IAttribute<Boolean> EXPLICIT_GC_DISABLED = Attribute.attr((String)"isExplicitGCDisabled", (String)Messages.getString("ATTR_EXPLICIT_GC_DISABLED"), (String)Messages.getString("ATTR_EXPLICIT_GC_DISABLED_DESC"), (ContentType)UnitLookup.FLAG);
    public static final IAttribute<Boolean> USE_DYNAMIC_GC_THREADS = Attribute.attr((String)"usesDynamicGCThreads", (String)Messages.getString("ATTR_USE_DYNAMIC_GC_THREADS"), (String)Messages.getString("ATTR_USE_DYNAMIC_GC_THREADS_DESC"), (ContentType)UnitLookup.FLAG);
    public static final IAttribute<IQuantity> GC_TIME = Attribute.attr((String)"gcTime", (String)Messages.getString("ATTR_GC_TIME"), (ContentType)UnitLookup.TIMESPAN);
    public static final IAttribute<IQuantity> GC_TIME_RATIO = Attribute.attr((String)"gcTimeRatio", (String)Messages.getString("ATTR_GC_TIME_RATIO"), (String)Messages.getString("ATTR_GC_TIME_RATIO_DESC"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> HEAP_MAX_SIZE = Attribute.attr((String)"maxSize", (String)Messages.getString("ATTR_HEAP_MAX_SIZE"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> HEAP_MIN_SIZE = Attribute.attr((String)"minSize", (String)Messages.getString("ATTR_HEAP_MIN_SIZE"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> HEAP_INITIAL_SIZE = Attribute.attr((String)"initialSize", (String)Messages.getString("ATTR_HEAP_INITIAL_SIZE"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> HEAP_OBJECT_ALIGNMENT = Attribute.attr((String)"objectAlignment", (String)Messages.getString("ATTR_HEAP_OBJECT_ALIGNMENT"), (String)Messages.getString("ATTR_HEAP_OBJECT_ALIGNMENT_DESC"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> HEAP_ADDRESS_SIZE = Attribute.attr((String)"heapAddressBits", (String)Messages.getString("ATTR_HEAP_ADDRESS_SIZE"), (String)Messages.getString("ATTR_HEAP_ADDRESS_SIZE_DESC"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<Boolean> HEAP_USE_COMPRESSED_OOPS = Attribute.attr((String)"usesCompressedOops", (String)Messages.getString("ATTR_HEAP_USE_COMPRESSED_OOPS"), (String)Messages.getString("ATTR_HEAP_USE_COMPRESSED_OOPS_DESC"), (ContentType)UnitLookup.FLAG);
    public static final IAttribute<String> HEAP_COMPRESSED_OOPS_MODE = Attribute.attr((String)"compressedOopsMode", (String)Messages.getString("ATTR_HEAP_COMPRESSED_OOPS_MODE"), (String)Messages.getString("ATTR_HEAP_COMPRESSED_OOPS_MODE_DESC"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> YOUNG_GENERATION_MIN_SIZE = Attribute.attr((String)"minSize", (String)Messages.getString("ATTR_YOUNG_GENERATION_MIN_SIZE"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> YOUNG_GENERATION_MAX_SIZE = Attribute.attr((String)"maxSize", (String)Messages.getString("ATTR_YOUNG_GENERATION_MAX_SIZE"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> NEW_RATIO = Attribute.attr((String)"newRatio", (String)Messages.getString("ATTR_NEW_RATIO"), (String)Messages.getString("ATTR_NEW_RATIO_DESC"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> TENURING_THRESHOLD_INITIAL = Attribute.attr((String)"initialTenuringThreshold", (String)Messages.getString("ATTR_TENURING_THRESHOLD_INITIAL"), (String)Messages.getString("ATTR_TENURING_THRESHOLD_INITIAL_DESC"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> TENURING_THRESHOLD_MAXIMUM = Attribute.attr((String)"maxTenuringThreshold", (String)Messages.getString("ATTR_TENURING_THRESHOLD_MAXIMUM"), (String)Messages.getString("ATTR_TENURING_THRESHOLD_MAXIMUM_DESC"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<Boolean> USES_TLABS = Attribute.attr((String)"usesTLABs", (String)Messages.getString("ATTR_USES_TLABS"), (String)Messages.getString("ATTR_USES_TLABS_DESC"), (ContentType)UnitLookup.FLAG);
    public static final IAttribute<IQuantity> TLAB_MIN_SIZE = Attribute.attr((String)"minTLABSize", (String)Messages.getString("ATTR_TLAB_MIN_SIZE"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> TLAB_MAX_SIZE = Attribute.attr((String)"maxTLABSize", (String)Messages.getString("ATTR_TLAB_MAX_SIZE"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> TLAB_REFILL_WASTE_LIMIT = Attribute.attr((String)"tlabRefillWasteLimit", (String)Messages.getString("ATTR_TLAB_REFILL_WASTE_LIMIT"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> HEAP_TOTAL = Attribute.attr((String)"totalSize", (String)Messages.getString("ATTR_HEAP_TOTAL"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> HEAP_USED = Attribute.attr((String)"heapUsed", (String)Messages.getString("ATTR_HEAP_USED"), (String)Messages.getString("ATTR_HEAP_USED_DESC"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<String> GC_WHEN = Attribute.attr((String)"when", (String)Messages.getString("ATTR_GC_WHEN"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> GC_ID = Attribute.attr((String)"gcId", (String)Messages.getString("ATTR_GC_ID"), (String)Messages.getString("ATTR_GC_ID_DESC"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> REFERENCE_COUNT = Attribute.attr((String)"count", (String)Messages.getString("ATTR_REFERENCE_COUNT"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<String> GC_PHASE_NAME = Attribute.attr((String)"name", (String)Messages.getString("ATTR_GC_PHASE_NAME"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> GC_HEAPSPACE_COMMITTED = Attribute.attr((String)"heapSpace:committedSize", (String)Messages.getString("ATTR_GC_HEAPSPACE_COMMITTED"), (String)Messages.getString("ATTR_GC_HEAPSPACE_COMMITTED_DESC"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> GC_HEAPSPACE_RESERVED = Attribute.attr((String)"heapSpace:reservedSize", (String)Messages.getString("ATTR_GC_HEAPSPACE_RESERVED"), (String)Messages.getString("ATTR_GC_HEAPSPACE_RESERVED_DESC"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> GC_METASPACE_CAPACITY = Attribute.attr((String)"metaspace:capacity", (String)Messages.getString("ATTR_GC_METASPACE_CAPACITY"), (String)Messages.getString("ATTR_GC_METASPACE_CAPACITY_DESC"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> GC_METASPACE_COMMITTED = Attribute.attr((String)"metaspace:committed", (String)Messages.getString("ATTR_GC_METASPACE_COMMITTED"), (String)Messages.getString("ATTR_GC_METASPACE_COMMITTED_DESC"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> GC_METASPACE_RESERVED = Attribute.attr((String)"metaspace:reserved", (String)Messages.getString("ATTR_GC_METASPACE_RESERVED"), (String)Messages.getString("ATTR_GC_METASPACE_RESERVED_DESC"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> GC_METASPACE_USED = Attribute.attr((String)"metaspace:used", (String)Messages.getString("ATTR_GC_METASPACE_USED"), (String)Messages.getString("ATTR_GC_METASPACE_USED_DESC"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> GC_DATASPACE_COMMITTED = Attribute.attr((String)"dataSpace:committed", (String)Messages.getString("ATTR_GC_METASPACE_DATA_COMMITTED"), (String)Messages.getString("ATTR_GC_METASPACE_DATA_COMMITTED_DESC"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> GC_DATASPACE_RESERVED = Attribute.attr((String)"dataSpace:reserved", (String)Messages.getString("ATTR_GC_METASPACE_DATA_RESERVED"), (String)Messages.getString("ATTR_GC_METASPACE_DATA_RESERVED_DESC"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> GC_DATASPACE_USED = Attribute.attr((String)"dataSpace:used", (String)Messages.getString("ATTR_GC_METASPACE_DATA_USED"), (String)Messages.getString("ATTR_GC_METASPACE_DATA_USED_DESC"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> GC_CLASSSPACE_COMMITTED = Attribute.attr((String)"classSpace:committed", (String)Messages.getString("ATTR_GC_METASPACE_CLASS_COMMITTED"), (String)Messages.getString("ATTR_GC_METASPACE_CLASS_COMMITTED_DESC"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> GC_CLASSSPACE_RESERVED = Attribute.attr((String)"classSpace:reserved", (String)Messages.getString("ATTR_GC_METASPACE_CLASS_RESERVED"), (String)Messages.getString("ATTR_GC_METASPACE_CLASS_RESERVED_DESC"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> GC_CLASSSPACE_USED = Attribute.attr((String)"classSpace:used", (String)Messages.getString("ATTR_GC_METASPACE_CLASS_USED"), (String)Messages.getString("ATTR_GC_METASPACE_CLASS_USED_DESC"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> GC_PAUSE_TARGET = Attribute.attr((String)"pauseTarget", (String)Messages.getString("ATTR_GC_PAUSE_TARGET"), (ContentType)UnitLookup.TIMESPAN);
    public static final IAttribute<IQuantity> GC_TIME_REAL = Attribute.attr((String)"realTime", (String)Messages.getString("ATTR_GC_TIME_REAL"), (ContentType)UnitLookup.TIMESPAN);
    public static final IAttribute<IQuantity> GC_TIME_SYSTEM = Attribute.attr((String)"systemTime", (String)Messages.getString("ATTR_GC_TIME_SYSTEM"), (ContentType)UnitLookup.TIMESPAN);
    public static final IAttribute<IQuantity> GC_TIME_USER = Attribute.attr((String)"userTime", (String)Messages.getString("ATTR_GC_TIME_USER"), (ContentType)UnitLookup.TIMESPAN);
    public static final IAttribute<IQuantity> GC_THRESHOLD = Attribute.attr((String)"gcThreshold", (String)Messages.getString("ATTR_GC_THRESHOLD"), (String)Messages.getString("ATTR_GC_THRESHOLD_DESC"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> OS_MEMORY_TOTAL = Attribute.attr((String)"totalSize", (String)Messages.getString("ATTR_OS_MEMORY_TOTAL"), (String)Messages.getString("ATTR_OS_MEMORY_TOTAL_DESC"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> OS_MEMORY_USED = Attribute.attr((String)"usedSize", (String)Messages.getString("ATTR_OS_MEMORY_USED"), (String)Messages.getString("ATTR_OS_MEMORY_USED_DESC"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<String> FLAG_NAME = Attribute.attr((String)"name", (String)Messages.getString("ATTR_FLAG_NAME"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<Boolean> FLAG_NEW_VALUE_BOOLEAN = Attribute.attr((String)"newValue", (String)Messages.getString("ATTR_FLAG_NEW_VALUE BOOLEAN"), (ContentType)UnitLookup.FLAG);
    public static final IAttribute<IQuantity> FLAG_NEW_VALUE_NUMBER = Attribute.attr((String)"newValue", (String)Messages.getString("ATTR_FLAG_NEW_VALUE_NUMBER"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<String> FLAG_NEW_VALUE_TEXT = Attribute.attr((String)"newValue", (String)Messages.getString("ATTR_FLAG_NEW_VALUE_TEXT"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<Boolean> FLAG_OLD_VALUE_BOOLEAN = Attribute.attr((String)"oldValue", (String)Messages.getString("ATTR_FLAG_OLD_VALUE_BOOLEAN"), (ContentType)UnitLookup.FLAG);
    public static final IAttribute<IQuantity> FLAG_OLD_VALUE_NUMBER = Attribute.attr((String)"oldValue", (String)Messages.getString("ATTR_FLAG_OLD_VALUE_NUMBER"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<String> FLAG_OLD_VALUE_TEXT = Attribute.attr((String)"oldValue", (String)Messages.getString("ATTR_FLAG_OLD_VALUE_TEXT"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<String> FLAG_ORIGIN = Attribute.attr((String)"origin", (String)Messages.getString("ATTR_FLAG_ORIGIN"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> FLAG_VALUE_NUMBER = Attribute.attr((String)"value", (String)Messages.getString("ATTR_FLAG_VALUE_NUMBER"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<Boolean> FLAG_VALUE_BOOLEAN = Attribute.attr((String)"value", (String)Messages.getString("ATTR_FLAG_VALUE_BOOLEAN"), (ContentType)UnitLookup.FLAG);
    public static final IAttribute<String> FLAG_VALUE_TEXT = Attribute.attr((String)"value", (String)Messages.getString("ATTR_FLAG_VALUE_TEXT"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<String> THREAD_DUMP_RESULT = Attribute.attr((String)"result", (String)Messages.getString("ATTR_THREAD_DUMP_RESULT"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<String> DUMP_REASON = Attribute.attr((String)"reason", (String)Messages.getString("ATTR_DUMP_REASON"), (String)Messages.getString("ATTR_DUMP_REASON_DESC"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<String> DUMP_REASON_RECORDING_ID = Attribute.attr((String)"recordingId", (String)Messages.getString("ATTR_DUMP_REASON_RECORDING_ID"), (String)Messages.getString("ATTR_DUMP_REASON_RECORDING_ID_DESC"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> THREAD_SYSTEM_CPU_LOAD = Attribute.attr((String)"system", (String)Messages.getString("ATTR_SYSTEM_LOAD"), (String)Messages.getString("ATTR_SYSTEM_LOAD_DESC"), (ContentType)UnitLookup.PERCENTAGE);
    public static final IAttribute<IQuantity> THREAD_USER_CPU_LOAD = Attribute.attr((String)"user", (String)Messages.getString("ATTR_USER_LOAD"), (String)Messages.getString("ATTR_USER_LOAD_DESC"), (ContentType)UnitLookup.PERCENTAGE);
    public static final IAttribute<IMCThread> JAVA_THREAD_POSTJDK9 = Attribute.attr((String)"thread", (String)Messages.getString("ATTR_JAVA_THREAD"), (String)Messages.getString("ATTR_JAVA_THREAD_DESC"), (ContentType)UnitLookup.THREAD);
    public static final IAttribute<IMCThread> JAVA_THREAD_PREJDK9 = Attribute.attr((String)"javalangthread", (String)Messages.getString("ATTR_JAVA_THREAD"), (String)Messages.getString("ATTR_JAVA_THREAD_DESC"), (ContentType)UnitLookup.THREAD);
    public static final IAttribute<IMCThread> JAVA_THREAD = Attribute.canonicalize((Attribute)new Attribute<IMCThread>("(thread)", Messages.getString("ATTR_JAVA_THREAD"), Messages.getString("ATTR_JAVA_THREAD_DESC"), UnitLookup.THREAD){

        public <U> IMemberAccessor<IMCThread, U> customAccessor(IType<U> type) {
            IMemberAccessor postJDK9Accessor = JAVA_THREAD_POSTJDK9.getAccessor(type);
            IMemberAccessor preJDK9Accessor = JAVA_THREAD_PREJDK9.getAccessor(type);
            return postJDK9Accessor == null ? preJDK9Accessor : postJDK9Accessor;
        }
    });
    public static final IAttribute<String> INFLATION_REASON = Attribute.attr((String)"cause", (String)Messages.getString("ATTR_INFLATION_REASON"), (String)Messages.getString("ATTR_INFLATION_REASON_DESC"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<String> SHUTDOWN_REASON = Attribute.attr((String)"reason", (String)Messages.getString("ATTR_SHUTDOWN_REASON"), (String)Messages.getString("ATTR_SHUTDOWN_REASON_DESC"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> CLASSLOADER_LOADED_COUNT = Attribute.attr((String)"loadedClassCount", (String)Messages.getString("ATTR_CLASSLOADER_LOADED_COUNT"), (String)Messages.getString("ATTR_CLASSLOADER_LOADED_COUNT_DESC"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> CLASSLOADER_UNLOADED_COUNT = Attribute.attr((String)"unloadedClassCount", (String)Messages.getString("ATTR_CLASSLOADER_UNLOADED_COUNT"), (String)Messages.getString("ATTR_CLASSLOADER_UNLOADED_COUNT_DESC"), (ContentType)UnitLookup.NUMBER);
    private static final IAttribute<IMCType> CLASS_DEFINING_CLASSLOADER_V0 = Attribute.attr((String)"definingClassLoader", (String)Messages.getString("ATTR_CLASS_DEFINING_CLASSLOADER"), (ContentType)UnitLookup.CLASS);
    private static final IAttribute<IMCType> CLASS_INITIATING_CLASSLOADER_V0 = Attribute.attr((String)"initiatingClassLoader", (String)Messages.getString("ATTR_CLASS_INITIATING_CLASSLOADER"), (ContentType)UnitLookup.CLASS);
    private static final IAttribute<IMCType> PARENT_CLASSLOADER_V0 = Attribute.attr((String)"parentClassLoader", (String)Messages.getString("ATTR_PARENT_CLASSLOADER"), (ContentType)UnitLookup.CLASS);
    private static final IAttribute<IMCType> CLASSLOADER_V0 = Attribute.attr((String)"classLoader", (String)Messages.getString("ATTR_CLASSLOADER"), (ContentType)UnitLookup.CLASS);
    public static final IAttribute<IMCClassLoader> CLASS_DEFINING_CLASSLOADER = Attribute.canonicalize((Attribute)new Attribute<IMCClassLoader>("definingClassLoader", Messages.getString("ATTR_CLASS_DEFINING_CLASSLOADER"), null, UnitLookup.CLASS_LOADER){

        public <U> IMemberAccessor<IMCClassLoader, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessorV0 = CLASS_DEFINING_CLASSLOADER_V0.getAccessor(type);
            if (accessorV0 != null) {
                return new IMemberAccessor<IMCClassLoader, U>(){

                    public IMCClassLoader getMember(U i) {
                        IMCType type = (IMCType)accessorV0.getMember(i);
                        return new MCClassLoader(type, null);
                    }
                };
            }
            return null;
        }
    });
    public static final IAttribute<IMCClassLoader> CLASS_INITIATING_CLASSLOADER = Attribute.canonicalize((Attribute)new Attribute<IMCClassLoader>("initiatingClassLoader", Messages.getString("ATTR_CLASS_INITIATING_CLASSLOADER"), null, UnitLookup.CLASS_LOADER){

        public <U> IMemberAccessor<IMCClassLoader, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessorV0 = CLASS_INITIATING_CLASSLOADER_V0.getAccessor(type);
            if (accessorV0 != null) {
                return new IMemberAccessor<IMCClassLoader, U>(){

                    public IMCClassLoader getMember(U i) {
                        IMCType type = (IMCType)accessorV0.getMember(i);
                        return new MCClassLoader(type, null);
                    }
                };
            }
            return null;
        }
    });
    public static final IAttribute<IMCClassLoader> PARENT_CLASSLOADER = Attribute.canonicalize((Attribute)new Attribute<IMCClassLoader>("parentClassLoader", Messages.getString("ATTR_PARENT_CLASSLOADER"), null, UnitLookup.CLASS_LOADER){

        public <U> IMemberAccessor<IMCClassLoader, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessorV0 = PARENT_CLASSLOADER_V0.getAccessor(type);
            if (accessorV0 != null) {
                return new IMemberAccessor<IMCClassLoader, U>(){

                    public IMCClassLoader getMember(U i) {
                        IMCType type = (IMCType)accessorV0.getMember(i);
                        return new MCClassLoader(type, null);
                    }
                };
            }
            return null;
        }
    });
    public static final IAttribute<IMCClassLoader> CLASSLOADER = Attribute.canonicalize((Attribute)new Attribute<IMCClassLoader>("classLoader", Messages.getString("ATTR_CLASSLOADER"), null, UnitLookup.CLASS_LOADER){

        public <U> IMemberAccessor<IMCClassLoader, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessorV0 = CLASSLOADER_V0.getAccessor(type);
            if (accessorV0 != null) {
                return new IMemberAccessor<IMCClassLoader, U>(){

                    public IMCClassLoader getMember(U i) {
                        IMCType type = (IMCType)accessorV0.getMember(i);
                        return new MCClassLoader(type, null);
                    }
                };
            }
            return null;
        }
    });
    public static final IAttribute<String> CLASS_DEFINING_CLASSLOADER_STRING = Attribute.canonicalize((Attribute)new Attribute<String>("defininingClassLoader.string", Messages.getString("ATTR_CLASS_DEFINING_CLASSLOADER"), null, UnitLookup.PLAIN_TEXT){

        public <U> IMemberAccessor<String, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = CLASS_DEFINING_CLASSLOADER.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<String, U>(){

                public String getMember(U i) {
                    IMCClassLoader cl = (IMCClassLoader)accessor.getMember(i);
                    return cl == null ? null : FormatToolkit.getHumanReadable((IMCClassLoader)cl);
                }
            };
        }
    });
    public static final IAttribute<String> CLASS_INITIATING_CLASSLOADER_STRING = Attribute.canonicalize((Attribute)new Attribute<String>("initiatingClassLoader.string", Messages.getString("ATTR_CLASS_INITIATING_CLASSLOADER"), null, UnitLookup.PLAIN_TEXT){

        public <U> IMemberAccessor<String, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = CLASS_INITIATING_CLASSLOADER.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<String, U>(){

                public String getMember(U i) {
                    IMCClassLoader cl = (IMCClassLoader)accessor.getMember(i);
                    return cl == null ? null : FormatToolkit.getHumanReadable((IMCClassLoader)cl);
                }
            };
        }
    });
    public static final IAttribute<String> PARENT_CLASSLOADER_STRING = Attribute.canonicalize((Attribute)new Attribute<String>("parentClassLoader.string", Messages.getString("ATTR_PARENT_CLASSLOADER"), null, UnitLookup.PLAIN_TEXT){

        public <U> IMemberAccessor<String, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = PARENT_CLASSLOADER.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<String, U>(){

                public String getMember(U i) {
                    IMCClassLoader cl = (IMCClassLoader)accessor.getMember(i);
                    return cl == null ? null : FormatToolkit.getHumanReadable((IMCClassLoader)cl);
                }
            };
        }
    });
    public static final IAttribute<String> CLASSLOADER_STRING = Attribute.canonicalize((Attribute)new Attribute<String>("classLoader.string", Messages.getString("ATTR_CLASSLOADER"), null, UnitLookup.PLAIN_TEXT){

        public <U> IMemberAccessor<String, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = CLASSLOADER.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<String, U>(){

                public String getMember(U i) {
                    IMCClassLoader cl = (IMCClassLoader)accessor.getMember(i);
                    return cl == null ? null : FormatToolkit.getHumanReadable((IMCClassLoader)cl);
                }
            };
        }
    });
    public static final IAttribute<IMCType> CLASS_LOADED = Attribute.attr((String)"loadedClass", (String)Messages.getString("ATTR_CLASS_LOADED"), (ContentType)UnitLookup.CLASS);
    public static final IAttribute<IMCType> CLASS_UNLOADED = Attribute.attr((String)"unloadedClass", (String)Messages.getString("ATTR_CLASS_UNLOADED"), (ContentType)UnitLookup.CLASS);
    public static final IAttribute<IMCType> CLASS_DEFINED = Attribute.attr((String)"definedClass", (String)Messages.getString("ATTR_CLASS_DEFINED"), (ContentType)UnitLookup.CLASS);
    public static final IAttribute<IQuantity> ANONYMOUS_BLOCK_SIZE = Attribute.attr((String)"anonymousBlockSize", (String)Messages.getString("ATTR_ANONYMOUS_BLOCK_SIZE"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> ANONYMOUS_CHUNK_SIZE = Attribute.attr((String)"anonymousChunkSize", (String)Messages.getString("ATTR_ANONYMOUS_CHUNK_SIZE"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> ANONYMOUS_CLASS_COUNT = Attribute.attr((String)"anonymousClassCount", (String)Messages.getString("ATTR_ANONYMOUS_CLASS_COUNT"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> BLOCK_SIZE = Attribute.attr((String)"blockSize", (String)Messages.getString("ATTR_BLOCK_SIZE"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> CHUNK_SIZE = Attribute.attr((String)"chunkSize", (String)Messages.getString("ATTR_CHUNK_SIZE"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> CLASS_COUNT = Attribute.attr((String)"classCount", (String)Messages.getString("ATTR_CLASS_COUNT"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> CLASS_LOADER_DATA = Attribute.attr((String)"classLoaderData", (String)Messages.getString("ATTR_CLASSLOADER_DATA"), (ContentType)UnitLookup.ADDRESS);
    public static final IAttribute<IQuantity> COMPILER_COMPILATION_ID = Attribute.attr((String)"compileId", (String)Messages.getString("ATTR_COMPILER_COMPILATION_ID"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> COMPILER_CODE_SIZE = Attribute.attr((String)"codeSize", (String)Messages.getString("ATTR_COMPILER_CODE_SIZE"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> COMPILER_INLINED_SIZE = Attribute.attr((String)"inlinedBytes", (String)Messages.getString("ATTR_COMPILER_INLINED_SIZE"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IMCMethod> COMPILER_METHOD = Attribute.attr((String)"method", (String)Messages.getString("ATTR_COMPILER_METHOD"), (ContentType)UnitLookup.METHOD);
    public static final IAttribute<String> COMPILER_METHOD_STRING = Attribute.canonicalize((Attribute)new Attribute<String>("method.humanreadable", Messages.getString("ATTR_COMPILER_METHOD_HUMAN"), Messages.getString("ATTR_COMPILER_METHOD_HUMAN_DESC"), UnitLookup.PLAIN_TEXT){

        public <U> IMemberAccessor<String, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = COMPILER_METHOD.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<String, U>(){

                public String getMember(U i) {
                    IMCMethod method = (IMCMethod)accessor.getMember(i);
                    return method == null ? null : FormatToolkit.getHumanReadable((IMCMethod)method);
                }
            };
        }
    });
    public static final IAttribute<String> COMPILER_FAILED_MESSAGE = Attribute.attr((String)"failureMessage", (String)Messages.getString("ATTR_COMPILER_FAILED_MESSAGE"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> COMPILER_STANDARD_COUNT = Attribute.attr((String)"standardCompileCount", (String)Messages.getString("ATTR_COMPILER_STANDARD_COUNT"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> COMPILER_OSR_COUNT = Attribute.attr((String)"osrCompileCount", (String)Messages.getString("ATTR_COMPILER_OSR_COUNT"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> COMPILER_COMPILATION_LEVEL = Attribute.attr((String)"compileLevel", (String)Messages.getString("ATTR_COMPILER_COMPILATION_LEVEL"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<Boolean> COMPILER_COMPILATION_SUCCEEDED = Attribute.attr((String)"succeded", (String)Messages.getString("ATTR_COMPILER_COMPILATION_SUCCEEDED"), (ContentType)UnitLookup.FLAG);
    public static final IAttribute<Boolean> COMPILER_IS_OSR = Attribute.attr((String)"isOsr", (String)Messages.getString("ATTR_COMPILER_IS_OSR"), (ContentType)UnitLookup.FLAG);
    public static final IAttribute<IQuantity> START_ADDRESS = Attribute.attr((String)"startAddress", (String)Messages.getString("ATTR_START_ADDRESS"), (ContentType)UnitLookup.ADDRESS);
    public static final IAttribute<IQuantity> COMMITTED_TOP = Attribute.attr((String)"commitedTopAddress", (String)Messages.getString("ATTR_COMMITTED_TOP"), (ContentType)UnitLookup.ADDRESS);
    public static final IAttribute<IQuantity> RESERVED_TOP = Attribute.attr((String)"reservedTopAddress", (String)Messages.getString("ATTR_RESERVED_TOP"), (ContentType)UnitLookup.ADDRESS);
    public static final IAttribute<IQuantity> ENTRIES = Attribute.attr((String)"entryCount", (String)Messages.getString("ATTR_ENTRIES"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> METHODS = Attribute.attr((String)"methodCount", (String)Messages.getString("ATTR_METHODS"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> ADAPTORS = Attribute.attr((String)"adaptorCount", (String)Messages.getString("ATTR_ADAPTORS"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> FULL_COUNT = Attribute.attr((String)"fullCount", (String)Messages.getString("ATTR_FULL_COUNT"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> UNALLOCATED = Attribute.attr((String)"unallocatedCapacity", (String)Messages.getString("ATTR_UNALLOCATED"), (ContentType)UnitLookup.MEMORY);
    private static final String CODE_HEAP_NON_NMETHODS = "CodeHeap 'non-nmethods'";
    private static final String CODE_HEAP_NON_PROFILED_NMETHODS = "CodeHeap 'non-profiled nmethods'";
    private static final String CODE_HEAP_PROFILED_NMETHODS = "CodeHeap 'profiled nmethods'";
    public static final IAttribute<IQuantity> PROFILED_UNALLOCATED = Attribute.canonicalize(JdkAttributes.createCodeHeapAttribute(UNALLOCATED, "CodeHeap 'profiled nmethods'", "profiledUnallocated", Messages.getString("ATTR_PROFILED_NMETHODS_UNALLOCATED"), Messages.getString("ATTR_PROFILED_NMETHODS_UNALLOCATED_DESCRIPTION"), (ContentType<IQuantity>)UnitLookup.MEMORY));
    public static final IAttribute<IQuantity> PROFILED_ENTRIES = Attribute.canonicalize(JdkAttributes.createCodeHeapAttribute(ENTRIES, "CodeHeap 'profiled nmethods'", "profiledEntries", Messages.getString("ATTR_PROFILED_NMETHODS_ENTRIES"), Messages.getString("ATTR_PROFILED_NMETHODS_ENTRIES_DESCRIPTION"), (ContentType<IQuantity>)UnitLookup.NUMBER));
    public static final IAttribute<IQuantity> PROFILED_METHODS = Attribute.canonicalize(JdkAttributes.createCodeHeapAttribute(METHODS, "CodeHeap 'profiled nmethods'", "profiledMethods", Messages.getString("ATTR_PROFILED_NMETHODS_METHODS"), Messages.getString("ATTR_PROFILED_NMETHODS_METHODS_DESCRIPTION"), (ContentType<IQuantity>)UnitLookup.NUMBER));
    public static final IAttribute<IQuantity> NON_PROFILED_NMETHODS_UNALLOCATED = Attribute.canonicalize(JdkAttributes.createCodeHeapAttribute(UNALLOCATED, "CodeHeap 'non-profiled nmethods'", "nonProfiledUnallocated", Messages.getString("ATTR_NON_PROFILED_NMETHODS_UNALLOCATED"), Messages.getString("ATTR_NON_PROFILED_NMETHODS_UNALLOCATED_DESCRIPTION"), (ContentType<IQuantity>)UnitLookup.MEMORY));
    public static final IAttribute<IQuantity> NON_PROFILED_NMETHODS_ENTRIES = Attribute.canonicalize(JdkAttributes.createCodeHeapAttribute(ENTRIES, "CodeHeap 'non-profiled nmethods'", "nonProfiledEntries", Messages.getString("ATTR_NON_PROFILED_NMETHODS_ENTRIES"), Messages.getString("ATTR_NON_PROFILED_NMETHODS_ENTRIES_DESCRIPTION"), (ContentType<IQuantity>)UnitLookup.NUMBER));
    public static final IAttribute<IQuantity> NON_PROFILED_METHODS = Attribute.canonicalize(JdkAttributes.createCodeHeapAttribute(METHODS, "CodeHeap 'non-profiled nmethods'", "nonProfiledMethods", Messages.getString("ATTR_NON_PROFILED_NMETHODS_METHODS"), Messages.getString("ATTR_NON_PROFILED_NMETHODS_METHODS_DESCRIPTION"), (ContentType<IQuantity>)UnitLookup.NUMBER));
    public static final IAttribute<IQuantity> NON_NMETHODS_UNALLOCATED = Attribute.canonicalize(JdkAttributes.createCodeHeapAttribute(UNALLOCATED, "CodeHeap 'non-nmethods'", "nonNmethodsUnallocated", Messages.getString("ATTR_NON_NMETHODS_UNALLOCATED"), Messages.getString("ATTR_NON_NMETHODS_UNALLOCATED_DESCRIPTION"), (ContentType<IQuantity>)UnitLookup.MEMORY));
    public static final IAttribute<IQuantity> NON_NMETHODS_ENTRIES = Attribute.canonicalize(JdkAttributes.createCodeHeapAttribute(ENTRIES, "CodeHeap 'non-nmethods'", "nonNmethodsEntries", Messages.getString("ATTR_NON_NMETHODS_ENTRIES"), Messages.getString("ATTR_NON_NMETHODS_ENTRIES_DESCRIPTION"), (ContentType<IQuantity>)UnitLookup.NUMBER));
    public static final IAttribute<IQuantity> NON_NMETHODS_ADAPTORS = Attribute.canonicalize(JdkAttributes.createCodeHeapAttribute(ADAPTORS, "CodeHeap 'non-nmethods'", "nonNmethodsAdaptors", Messages.getString("ATTR_NON_NMETHODS_ADAPTORS"), Messages.getString("ATTR_NON_NMETHODS_ADAPTORS_DESCRIPTION"), (ContentType<IQuantity>)UnitLookup.NUMBER));
    public static final IAttribute<String> CODE_HEAP = Attribute.attr((String)"codeBlobType", (String)Messages.getString("ATTR_CODE_HEAP"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> SWEEP_INDEX = Attribute.attr((String)"sweepId", (String)Messages.getString("ATTR_SWEEP_INDEX"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> SWEEP_FRACTION_INDEX = Attribute.attr((String)"sweepFractionIndex", (String)Messages.getString("ATTR_SWEEP_FRACTION_INDEX"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> SWEEP_METHOD_SWEPT = Attribute.attr((String)"sweptCount", (String)Messages.getString("ATTR_SWEEP_METHOD_SWEPT"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> SWEEP_METHOD_FLUSHED = Attribute.attr((String)"flushedCount", (String)Messages.getString("ATTR_SWEEP_METHOD_FLUSHED"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> SWEEP_METHOD_RECLAIMED = Attribute.attr((String)"markedCount", (String)Messages.getString("ATTR_SWEEP_METHOD_RECLAIMED"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> SWEEP_METHOD_ZOMBIFIED = Attribute.attr((String)"zombifiedCount", (String)Messages.getString("ATTR_SWEEP_METHOD_ZOMBIFIED"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> INITIAL_SIZE = Attribute.attr((String)"initialSize", (String)Messages.getString("ATTR_INITIAL_SIZE"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> RESERVED_SIZE = Attribute.attr((String)"reservedSize", (String)Messages.getString("ATTR_RESERVED_SIZE"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> EXPANSION_SIZE = Attribute.attr((String)"expansionSize", (String)Messages.getString("ATTR_EXPANSION_SIZE"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> NON_PROFILED_SIZE = Attribute.attr((String)"nonProfiledSize", (String)Messages.getString("ATTR_NON_PROFILED_SIZE"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> PROFILED_SIZE = Attribute.attr((String)"profiledSize", (String)Messages.getString("ATTR_PROFILED_SIZE"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> NON_NMETHOD_SIZE = Attribute.attr((String)"nonNMethodSize", (String)Messages.getString("ATTR_NON_NMETHOD_SIZE"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<String> ENVIRONMENT_KEY = Attribute.attr((String)"key", (String)Messages.getString("ATTR_ENVIRONMENT_KEY"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<String> ENVIRONMENT_VALUE = Attribute.attr((String)"value", (String)Messages.getString("ATTR_ENVIRONMENT_VALUE"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> EXCEPTION_THROWABLES_COUNT = Attribute.attr((String)"throwables", (String)Messages.getString("ATTR_EXCEPTION_THROWABLES_COUNT"), (String)Messages.getString("ATTR_EXCEPTION_THROWABLES_COUNT_DESC"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<IMCType> EXCEPTION_THROWNCLASS = Attribute.attr((String)"thrownClass", (String)Messages.getString("ATTR_EXCEPTION_THROWNCLASS"), (ContentType)UnitLookup.CLASS);
    public static final IAttribute<String> EXCEPTION_THROWNCLASS_NAME = Attribute.canonicalize((Attribute)new Attribute<String>("thrownClassName", Messages.getString("ATTR_EXCEPTION_THROWNCLASS_NAME"), Messages.getString("ATTR_EXCEPTION_THROWNCLASS_NAME_DESC"), UnitLookup.PLAIN_TEXT){

        public <U> IMemberAccessor<String, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = EXCEPTION_THROWNCLASS.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<String, U>(){

                public String getMember(U i) {
                    IMCType type = (IMCType)accessor.getMember(i);
                    return type == null ? null : type.getFullName();
                }
            };
        }
    });
    public static final IAttribute<String> EXCEPTION_MESSAGE = Attribute.attr((String)"message", (String)Messages.getString("ATTR_EXCEPTION_MESSAGE"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> MONITOR_ADDRESS = Attribute.attr((String)"address", (String)Messages.getString("ATTR_MONITOR_ADDRESS"), (ContentType)UnitLookup.ADDRESS);
    public static final IAttribute<IMCType> MONITOR_CLASS = Attribute.attr((String)"monitorClass", (String)Messages.getString("ATTR_MONITOR_CLASS"), (ContentType)UnitLookup.CLASS);
    public static final IAttribute<IMCThread> MONITOR_PREVIOUS_OWNER = Attribute.attr((String)"previousOwner", (String)Messages.getString("ATTR_MONITOR_PREVIOUS_OWNER"), (ContentType)UnitLookup.THREAD);
    private static final IAttribute<IQuantity> OS_SWITCH_RATE_FREQUENCY = Attribute.attr((String)"switchRate", (String)Messages.getString("ATTR_OS_SWITCH_RATE"), (ContentType)UnitLookup.FREQUENCY);
    private static final IAttribute<IQuantity> OS_SWITCH_RATE_NUMBER = Attribute.attr((String)"switchRate", (String)Messages.getString("ATTR_OS_SWITCH_RATE"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> OS_SWITCH_RATE = Attribute.canonicalize((Attribute)new Attribute<IQuantity>("(switchRate)", Messages.getString("ATTR_OS_SWITCH_RATE"), "", (ContentType)UnitLookup.FREQUENCY){

        public <U> IMemberAccessor<IQuantity, U> customAccessor(IType<U> type) {
            IMemberAccessor rateNumberAccessor = OS_SWITCH_RATE_NUMBER.getAccessor(type);
            IMemberAccessor rateFrequencyAccessor = OS_SWITCH_RATE_FREQUENCY.getAccessor(type);
            return rateNumberAccessor == null ? rateFrequencyAccessor : rateNumberAccessor;
        }
    });
    public static final IAttribute<String> REFERENCE_STATISTICS_TYPE = Attribute.attr((String)"type", (String)Messages.getString("ATTR_REFERENCE_STATISTICS_TYPE"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> REFERENCE_STATISTICS_COUNT = Attribute.attr((String)"count", (String)Messages.getString("ATTR_REFERENCE_STATISTICS_COUNT"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> GC_SUM_OF_PAUSES = Attribute.attr((String)"sumOfPauses", (String)Messages.getString("ATTR_GC_SUM_OF_PAUSES"), (String)Messages.getString("ATTR_GC_SUM_OF_PAUSES_DESC"), (ContentType)UnitLookup.TIMESPAN);
    public static final IAttribute<IQuantity> GC_LONGEST_PAUSE = Attribute.attr((String)"longestPause", (String)Messages.getString("ATTR_GC_LONGEST_PAUSE"), (String)Messages.getString("ATTR_GC_LONGEST_PAUSE_DESC"), (ContentType)UnitLookup.TIMESPAN);
    public static final IAttribute<String> GC_NAME = Attribute.attr((String)"name", (String)Messages.getString("ATTR_GC_NAME"), (String)Messages.getString("ATTR_GC_NAME_DESC"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<String> GC_CAUSE = Attribute.attr((String)"cause", (String)Messages.getString("ATTR_GC_CAUSE"), (String)Messages.getString("ATTR_GC_CAUSE_DESC"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IMCOldObject> OBJECT = Attribute.attr((String)"object", (String)Messages.getString("ATTR_REFERRER"), (String)Messages.getString("ATTR_REFERRER_DESC"), (ContentType)UnitLookup.OLD_OBJECT);
    public static final IAttribute<IQuantity> ALLOCATION_TIME = Attribute.attr((String)"allocationTime", (String)Messages.getString("ATTR_REFERRER"), (String)Messages.getString("ATTR_REFERRER_DESC"), (ContentType)UnitLookup.TIMESTAMP);
    public static final IAttribute<IMCOldObjectGcRoot> GC_ROOT = Attribute.attr((String)"root", (String)Messages.getString("ATTR_GC_ROOT"), (String)Messages.getString("ATTR_GC_ROOT_DESC"), (ContentType)UnitLookup.OLD_OBJECT_GC_ROOT);
    public static final IAttribute<IMCType> OLD_OBJECT_CLASS = Attribute.canonicalize((Attribute)new Attribute<IMCType>("oldObjectClass", Messages.getString("ATTR_OLD_OBJECT_CLASS"), Messages.getString("ATTR_OLD_OBJECT_CLASS_DESC"), UnitLookup.CLASS){

        public <U> IMemberAccessor<IMCType, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = OBJECT.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<IMCType, U>(){

                public IMCType getMember(U i) {
                    IMCOldObject object = (IMCOldObject)accessor.getMember(i);
                    return object == null ? null : object.getType();
                }
            };
        }
    });
    public static final IAttribute<String> OLD_OBJECT_DESCRIPTION = Attribute.canonicalize((Attribute)new Attribute<String>("oldObjectDescription", Messages.getString("ATTR_OLD_OBJECT_DESCRIPTION"), Messages.getString("ATTR_OLD_OBJECT_DESCRIPTION_DESC"), UnitLookup.PLAIN_TEXT){

        public <U> IMemberAccessor<String, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = OBJECT.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<String, U>(){

                public String getMember(U i) {
                    IMCOldObject object = (IMCOldObject)accessor.getMember(i);
                    return object == null ? null : object.getDescription();
                }
            };
        }
    });
    public static final IAttribute<Long> OLD_OBJECT_ARRAY_SIZE = Attribute.canonicalize((Attribute)new Attribute<Long>("oldObjectArraySize", Messages.getString("ATTR_OLD_OBJECT_ARRAY_SIZE"), Messages.getString("ATTR_OLD_OBJECT_ARRAY_SIZE_DESC"), UnitLookup.RAW_LONG){

        public <U> IMemberAccessor<Long, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = OBJECT.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<Long, U>(){

                public Long getMember(U i) {
                    IMCOldObject object = (IMCOldObject)accessor.getMember(i);
                    return object != null && object.getReferrerArray() != null ? object.getReferrerArray().getSize() : null;
                }
            };
        }
    });
    public static final IAttribute<IQuantity> OLD_OBJECT_ADDRESS = Attribute.canonicalize((Attribute)new Attribute<IQuantity>("oldObjectAddress", Messages.getString("ATTR_OLD_OBJECT_ADDRESS"), Messages.getString("ATTR_OLD_OBJECT_ADDRESS_DESC"), (ContentType)UnitLookup.ADDRESS){

        public <U> IMemberAccessor<IQuantity, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = OBJECT.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<IQuantity, U>(){

                public IQuantity getMember(U i) {
                    IMCOldObject object = (IMCOldObject)accessor.getMember(i);
                    return object == null ? null : object.getAddress();
                }
            };
        }
    });
    public static final IAttribute<String> OS_VERSION = Attribute.attr((String)"osVersion", (String)Messages.getString("ATTR_OS_VERSION"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> NUMBER_OF_SOCKETS = Attribute.attr((String)"sockets", (String)Messages.getString("ATTR_NUMBER_OF_SOCKETS"), (String)Messages.getString("ATTR_NUMBER_OF_SOCKETS_DESC"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<String> CPU_DESCRIPTION = Attribute.attr((String)"description", (String)Messages.getString("ATTR_CPU_DESCRIPTION"), (String)Messages.getString("ATTR_CPU_DESCRIPTION_DESC"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<String> CPU_TYPE = Attribute.attr((String)"cpu", (String)Messages.getString("ATTR_CPU_TYPE"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> NUMBER_OF_CORES = Attribute.attr((String)"cores", (String)Messages.getString("ATTR_NUMBER_OF_CORES"), (String)Messages.getString("ATTR_NUMBER_OF_CORES_DESC"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<Boolean> BLOCKING = Attribute.attr((String)"blocking", (String)Messages.getString("ATTR_BLOCKING"), (String)Messages.getString("ATTR_BLOCKING_DESC"), (ContentType)UnitLookup.FLAG);
    public static final IAttribute<Boolean> SAFEPOINT = Attribute.attr((String)"safepoint", (String)Messages.getString("ATTR_SAFEPOINT"), (String)Messages.getString("ATTR_SAFEPOINT_DESC"), (ContentType)UnitLookup.FLAG);
    public static final IAttribute<String> OPERATION = Attribute.attr((String)"operation", (String)Messages.getString("ATTR_OPERATION"), (String)Messages.getString("ATTR_OPERATION_DESC"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IMCThread> CALLER = Attribute.attr((String)"caller", (String)Messages.getString("ATTR_CALLER"), (String)Messages.getString("ATTR_CALLER_DESC"), (ContentType)UnitLookup.THREAD);
    public static final IAttribute<IMCType> BIASED_REVOCATION_LOCK_CLASS = Attribute.attr((String)"lockClass", (String)Messages.getString("ATTR_REVOKATION_LOCK_CLASS"), (String)Messages.getString("ATTR_REVOKATION_LOCK_CLASS_DESC"), (ContentType)UnitLookup.CLASS);
    public static final IAttribute<IMCType> BIASED_REVOCATION_CLASS = Attribute.attr((String)"revokedClass", (String)Messages.getString("ATTR_REVOKED_CLASS"), (String)Messages.getString("ATTR_REVOKED_CLASS_DESC"), (ContentType)UnitLookup.CLASS);
    public static final IAttribute<Boolean> BIASED_REVOCATION_DISABLE_BIASING = Attribute.attr((String)"disableBiasing", (String)Messages.getString("ATTR_DISABLE_BIASING"), (ContentType)UnitLookup.FLAG);
    public static final IAttribute<String> NATIVE_LIBRARY_NAME = Attribute.attr((String)"name", (String)Messages.getString("ATTR_NATIVE_LIBRARY_NAME"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> BASE_ADDRESS = Attribute.attr((String)"baseAddress", (String)Messages.getString("ATTR_BASE_ADDRESS"), (ContentType)UnitLookup.ADDRESS);
    public static final IAttribute<IQuantity> TOP_ADDRESS = Attribute.attr((String)"topAddress", (String)Messages.getString("ATTR_TOP_ADDRESS"), (ContentType)UnitLookup.ADDRESS);
    public static final IAttribute<String> CONSTANT_POOLS_NAME = Attribute.attr((String)"name", (String)Messages.getString("ATTR_CONSTANT_POOLS_NAME"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> CONSTANT_POOLS_COUNT = Attribute.attr((String)"count", (String)Messages.getString("ATTR_CONSTANT_POOLS_COUNT"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<IQuantity> CONSTANT_POOLS_SIZE = Attribute.attr((String)"size", (String)Messages.getString("ATTR_CONSTANT_POOLS_SIZE"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<String> CONSTANT_TYPE = Attribute.attr((String)"typeName", (String)Messages.getString("ATTR_CONSTANT_TYPE"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<String> CONSTANT_VALUE = Attribute.attr((String)"constant", (String)Messages.getString("ATTR_CONSTANT_VALUE"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> SAMPLE_WEIGHT = Attribute.attr((String)"weight", (String)Messages.getString("ATTR_SAMPLE_WEIGHT"), (ContentType)UnitLookup.MEMORY);
    public static final IAttribute<IQuantity> TOTAL_FINALIZERS_RUN = Attribute.attr((String)"totalFinalizersRun", (String)Messages.getString("ATTR_TOTAL_FINALIZERS_RUN"), (String)Messages.getString("ATTR_TOTAL_FINALIZERS_RUN_DESC"), (ContentType)UnitLookup.NUMBER);
    public static final IAttribute<IMCType> FINALIZABLE_CLASS = Attribute.attr((String)"finalizableClass", (String)Messages.getString("ATTR_FINALIZABLE_CLASS"), (String)Messages.getString("ATTR_FINALIZABLE_CLASS_DESC"), (ContentType)UnitLookup.CLASS);
    public static final IAttribute<String> FINALIZABLE_CLASS_NAME = Attribute.canonicalize((Attribute)new Attribute<String>("finalizableClassName", Messages.getString("ATTR_FINALIZABLE_CLASS_NAME"), Messages.getString("ATTR_FINALIZABLE_CLASS_NAME_DESC"), UnitLookup.PLAIN_TEXT){

        public <U> IMemberAccessor<String, U> customAccessor(IType<U> type) {
            final IMemberAccessor accessor = FINALIZABLE_CLASS.getAccessor(type);
            return accessor == null ? null : new IMemberAccessor<String, U>(){

                public String getMember(U i) {
                    IMCType type = (IMCType)accessor.getMember(i);
                    return type == null ? null : type.getFullName();
                }
            };
        }
    });
    public static final IAttribute<Boolean> AGENT_DYNAMIC = Attribute.attr((String)"dynamic", (String)Messages.getString("ATTR_AGENT_DYNAMIC"), (String)Messages.getString("ATTR_AGENT_DYNAMIC_DESC"), (ContentType)UnitLookup.FLAG);
    public static final IAttribute<String> AGENT_NAME = Attribute.attr((String)"name", (String)Messages.getString("ATTR_AGENT_NAME"), (String)Messages.getString("ATTR_AGENT_NAME_DESC"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<String> AGENT_OPTIONS = Attribute.attr((String)"options", (String)Messages.getString("ATTR_AGENT_OPTIONS"), (String)Messages.getString("ATTR_AGENT_OPTIONS_DESC"), (ContentType)UnitLookup.PLAIN_TEXT);
    public static final IAttribute<IQuantity> AGENT_INITIALIZATION_TIME = Attribute.attr((String)"initializationTime", (String)Messages.getString("ATTR_AGENT_INITIALIZATION_TIME"), (String)Messages.getString("ATTR_AGENT_INITIALIZATION_TIME_DESC"), (ContentType)UnitLookup.TIMESTAMP);
    public static final IAttribute<IQuantity> AGENT_INITIALIZATION_DURATION = Attribute.attr((String)"initializationDuration", (String)Messages.getString("ATTR_AGENT_INITIALIZATION_DURATION"), (String)Messages.getString("ATTR_AGENT_INITIALIZATION_DURATION_DESC"), (ContentType)UnitLookup.TIMESPAN);

    private static Attribute<IQuantity> createCodeHeapAttribute(final IAttribute<IQuantity> attribute, final String codeHeap, String identifier, String name, String description, ContentType<IQuantity> contentType) {
        return new Attribute<IQuantity>(identifier, name, description, contentType){

            public <U> IMemberAccessor<IQuantity, U> customAccessor(IType<U> type) {
                final IMemberAccessor attributeAccessor = attribute.getAccessor(type);
                final IMemberAccessor codeHeapAccessor = CODE_HEAP.getAccessor(type);
                return attributeAccessor == null || codeHeapAccessor == null ? null : new IMemberAccessor<IQuantity, U>(){

                    public IQuantity getMember(U i) {
                        return ((String)codeHeapAccessor.getMember(i)).equals(codeHeap) ? (IQuantity)attributeAccessor.getMember(i) : null;
                    }
                };
            }
        };
    }
}

