/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.codeanalysis;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openjdk.jmc.joverflow.batch.DetailedStats;
import org.openjdk.jmc.joverflow.batch.ReferencedObjCluster;
import org.openjdk.jmc.joverflow.heap.model.JavaClass;
import org.openjdk.jmc.joverflow.support.HeapStats;
import org.openjdk.jmc.joverflow.support.RefChainElement;
import org.openjdk.jmc.joverflow.support.RefChainElementImpl;
import org.openjdk.jmc.joverflow.support.ReferenceChain;
import org.openjdk.jmc.joverflow.util.Pair;

public class DupStringFieldFinder {
    public static List<String> getFieldsToInternAsText(HeapStats hs, DetailedStats ds) {
        List<Pair<ClassAndField, Float>> fields = DupStringFieldFinder.getFieldsToIntern(hs, ds);
        LinkedHashMap<ClassAndField, StringBuilder> resMap = new LinkedHashMap<ClassAndField, StringBuilder>();
        for (Pair<ClassAndField, Float> fieldAndOvhd : fields) {
            StringBuilder comment;
            int fieldIdx;
            ClassAndField field = fieldAndOvhd.getV1();
            JavaClass clazz = field.getClazz();
            JavaClass declaringClazz = clazz.getDeclaringClassForField(fieldIdx = field.getFieldIdx());
            if (declaringClazz != clazz) {
                field = new ClassAndField(declaringClazz, fieldIdx);
                comment = (StringBuilder)resMap.get(field);
                if (comment != null) {
                    comment.append(", ").append(clazz.getHumanFriendlyName());
                } else {
                    comment = new StringBuilder(40);
                    comment.append("  // Used in sublcass ").append(clazz.getHumanFriendlyName());
                    resMap.put(field, comment);
                }
            } else {
                comment = new StringBuilder(20);
                comment.append("  //");
                resMap.put(field, comment);
            }
            comment.append(String.format(" %.1f%%", fieldAndOvhd.getV2()));
        }
        ArrayList<String> result = new ArrayList<String>(resMap.size());
        for (Map.Entry entry : resMap.entrySet()) {
            ClassAndField classAndField = (ClassAndField)entry.getKey();
            JavaClass clazz = classAndField.getClazz();
            String className = clazz.getName();
            String fieldName = clazz.getFieldForInstance(classAndField.getFieldIdx()).getName();
            StringBuilder commentSB = (StringBuilder)entry.getValue();
            String comment = commentSB != null ? commentSB.toString() : "";
            result.add(String.valueOf(className) + "." + fieldName + comment);
        }
        return result;
    }

    static List<Pair<ClassAndField, Float>> getFieldsToIntern(HeapStats hs, DetailedStats ds) {
        ArrayList<Pair<ClassAndField, Float>> result = new ArrayList<Pair<ClassAndField, Float>>();
        List<ReferencedObjCluster.DupStrings> rsFields = ds.dupStringClusters.get(1);
        for (ReferencedObjCluster.DupStrings c : rsFields) {
            JavaClass clazz;
            RefChainElementImpl.InstanceFieldOrLinkedList refField;
            RefChainElement secondNode;
            RefChainElement referer;
            List<RefChainElement> classAndFieldExt;
            if (c.getTotalOverhead() < ds.minOvhdToReport) break;
            if (c.getNumNonDupStrings() > c.getNumBadObjects() / 2 || (classAndFieldExt = ReferenceChain.getChain(referer = c.getReferer())).size() > 1 && (classAndFieldExt.size() > 2 || !((secondNode = classAndFieldExt.get(1)) instanceof RefChainElementImpl.Array)) || !(classAndFieldExt.get(0) instanceof RefChainElementImpl.InstanceFieldOrLinkedList) || !(refField = (RefChainElementImpl.InstanceFieldOrLinkedList)classAndFieldExt.get(0)).isInstanceField() || (clazz = refField.getJavaClass()).getName().startsWith("java.util.")) continue;
            int fieldIdx = refField.getFieldIdx();
            float ovhdInPercent = (float)c.getTotalOverhead() * 100.0f / (float)hs.totalObjSize;
            result.add(new Pair<ClassAndField, Float>(new ClassAndField(clazz, fieldIdx), Float.valueOf(ovhdInPercent)));
        }
        return result;
    }

    static class ClassAndField
    extends Pair<JavaClass, Integer> {
        ClassAndField(JavaClass clazz, int fieldIdx) {
            super(clazz, fieldIdx);
        }

        JavaClass getClazz() {
            return (JavaClass)super.getV1();
        }

        int getFieldIdx() {
            return (Integer)super.getV2();
        }
    }
}

