/*
 * Decompiled with CFR 0.152.
 */
package io.github.bric3.fireplace.flamegraph;

import io.github.bric3.fireplace.core.ui.JScrollPaneWithBackButton;
import io.github.bric3.fireplace.core.ui.MouseInputListenerWorkaroundForToolTipEnabledComponent;
import io.github.bric3.fireplace.flamegraph.FlamegraphRenderEngine;
import io.github.bric3.fireplace.flamegraph.FrameBox;
import io.github.bric3.fireplace.flamegraph.FrameColorProvider;
import io.github.bric3.fireplace.flamegraph.FrameFontProvider;
import io.github.bric3.fireplace.flamegraph.FrameModel;
import io.github.bric3.fireplace.flamegraph.FrameRenderer;
import io.github.bric3.fireplace.flamegraph.FrameTextsProvider;
import io.github.bric3.fireplace.flamegraph.ZoomTarget;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;

public class FlamegraphView<T> {
    private static final String OWNER_KEY = "flamegraphOwner";
    public static String SHOW_STATS = "flamegraph.show_stats";
    private final FlamegraphCanvas<T> canvas;
    public final JComponent component;
    private final FlamegraphScrollPaneMouseInputListener<T> scrollPaneListener;
    private FrameModel<T> framesModel = FrameModel.empty();

    public static <T> Optional<FlamegraphView<T>> from(JComponent component) {
        return Optional.ofNullable((FlamegraphView)component.getClientProperty(OWNER_KEY));
    }

    public FlamegraphView() {
        this.canvas = new FlamegraphCanvas(this);
        this.canvas.putClientProperty(OWNER_KEY, this);
        this.scrollPaneListener = new FlamegraphScrollPaneMouseInputListener<T>(this.canvas);
        JScrollPane scrollPane = new JScrollPane(this.canvas);
        scrollPane.putClientProperty(OWNER_KEY, this);
        JLayer<JScrollPane> layeredScrollPane = JScrollPaneWithBackButton.create(() -> {
            scrollPane.getVerticalScrollBar().setUnitIncrement(16);
            scrollPane.getHorizontalScrollBar().setUnitIncrement(16);
            this.scrollPaneListener.install(scrollPane);
            new MouseInputListenerWorkaroundForToolTipEnabledComponent(scrollPane).install(this.canvas);
            this.canvas.linkListenerTo(scrollPane);
            return scrollPane;
        });
        this.canvas.addPropertyChangeListener("mode", evt -> {
            Mode mode = (Mode)((Object)((Object)evt.getNewValue()));
            layeredScrollPane.firePropertyChange("backToDirection", -1, mode == Mode.ICICLEGRAPH ? 1 : 5);
        });
        this.component = this.wrap(layeredScrollPane, bg -> {
            scrollPane.setBorder(null);
            scrollPane.setBackground((Color)bg);
            scrollPane.getVerticalScrollBar().setBackground((Color)bg);
            scrollPane.getHorizontalScrollBar().setBackground((Color)bg);
            this.canvas.setBackground((Color)bg);
        });
    }

    private JPanel wrap(JComponent owner, final Consumer<Color> configureBorderAndBackground) {
        JPanel wrapper = new JPanel(new BorderLayout()){

            @Override
            public void updateUI() {
                super.updateUI();
                configureBorderAndBackground.accept(this.getBackground());
            }

            @Override
            public void setBackground(Color bg) {
                super.setBackground(bg);
                configureBorderAndBackground.accept(bg);
            }
        };
        wrapper.setBorder(null);
        wrapper.add(owner);
        wrapper.putClientProperty(OWNER_KEY, this);
        return wrapper;
    }

    public void configureCanvas(Consumer<JComponent> canvasConfigurer) {
        Objects.requireNonNull(canvasConfigurer).accept(this.canvas);
    }

    public void setFrameColorProvider(FrameColorProvider<T> frameColorProvider) {
        this.canvas.getFlamegraphRenderEngine().ifPresent(fgp -> fgp.getFrameRenderer().setFrameColorProvider(frameColorProvider));
    }

    public FrameColorProvider<T> getFrameColorProvider() {
        return this.canvas.getFlamegraphRenderEngine().map(fgp -> fgp.getFrameRenderer().getFrameColorProvider()).orElse(null);
    }

    public void setFrameFontProvider(FrameFontProvider<T> frameFontProvider) {
        this.canvas.getFlamegraphRenderEngine().ifPresent(fgp -> fgp.getFrameRenderer().setFrameFontProvider(frameFontProvider));
    }

    public FrameFontProvider<T> getFrameFontProvider() {
        return this.canvas.getFlamegraphRenderEngine().map(fgp -> fgp.getFrameRenderer().getFrameFontProvider()).orElse(null);
    }

    public void setFrameTextsProvider(FrameTextsProvider<T> frameTextsProvider) {
        this.canvas.getFlamegraphRenderEngine().ifPresent(fgp -> fgp.getFrameRenderer().setFrameTextsProvider(frameTextsProvider));
    }

    public FrameTextsProvider<T> getFrameTextsProvider() {
        return this.canvas.getFlamegraphRenderEngine().map(fgp -> fgp.getFrameRenderer().getFrameTextsProvider()).orElse(null);
    }

    public void setFrameGapEnabled(boolean frameGapEnabled) {
        this.canvas.getFlamegraphRenderEngine().ifPresent(fgp -> fgp.getFrameRenderer().setDrawingFrameGap(frameGapEnabled));
    }

    public boolean isFrameGapEnabled() {
        return this.canvas.getFlamegraphRenderEngine().map(fgp -> fgp.getFrameRenderer().isDrawingFrameGap()).orElse(false);
    }

    public void setMinimapShadeColorSupplier(Supplier<Color> minimapShadeColorSupplier) {
        this.canvas.setMinimapShadeColorSupplier(Objects.requireNonNull(minimapShadeColorSupplier));
    }

    public void setShowMinimap(boolean showMinimap) {
        this.canvas.showMinimap(showMinimap);
    }

    public boolean isShowMinimap() {
        return this.canvas.isShowMinimap();
    }

    public void setShowHoveredSiblings(boolean showHoveredSiblings) {
        this.canvas.getFlamegraphRenderEngine().ifPresent(fre -> fre.setShowHoveredSiblings(showHoveredSiblings));
    }

    public boolean isShowHoveredSiblings() {
        return this.canvas.getFlamegraphRenderEngine().map(FlamegraphRenderEngine::isShowHoveredSiblings).orElse(false);
    }

    public void setMode(Mode mode) {
        this.canvas.setMode(mode);
    }

    public Mode getMode() {
        return this.canvas.getMode();
    }

    public void setTooltipComponentSupplier(Supplier<JToolTip> tooltipComponentSupplier) {
        this.canvas.setTooltipComponentSupplier(Objects.requireNonNull(tooltipComponentSupplier));
    }

    public void setPopupConsumer(BiConsumer<FrameBox<T>, MouseEvent> consumer) {
        this.canvas.setPopupConsumer(Objects.requireNonNull(consumer));
    }

    public void setSelectedFrameConsumer(BiConsumer<FrameBox<T>, MouseEvent> consumer) {
        this.canvas.setSelectedFrameConsumer(Objects.requireNonNull(consumer));
    }

    public void setHoverListener(HoverListener<T> hoverListener) {
        this.scrollPaneListener.setHoverListener(hoverListener);
    }

    public void setModel(FrameModel<T> frameModel) {
        this.framesModel = Objects.requireNonNull(frameModel);
        this.canvas.getFlamegraphRenderEngine().ifPresent(fre -> fre.init(frameModel));
        this.canvas.revalidate();
        this.canvas.repaint();
    }

    public void setRenderConfiguration(FrameTextsProvider<T> frameTextsProvider, FrameColorProvider<T> frameColorProvider, FrameFontProvider<T> frameFontProvider) {
        FlamegraphRenderEngine<T> flamegraphRenderEngine = new FlamegraphRenderEngine<T>(new FrameRenderer<T>(frameTextsProvider, frameColorProvider, frameFontProvider)).init(this.framesModel);
        this.canvas.setFlamegraphRenderEngine(Objects.requireNonNull(flamegraphRenderEngine));
        this.canvas.revalidate();
        this.canvas.repaint();
    }

    public void setTooltipTextFunction(BiFunction<FrameModel<T>, FrameBox<T>, String> tooltipTextFunction) {
        this.canvas.setToolTipTextFunction(Objects.requireNonNull(tooltipTextFunction));
    }

    public void clear() {
        this.framesModel = FrameModel.empty();
        this.canvas.getFlamegraphRenderEngine().ifPresent(FlamegraphRenderEngine::reset);
        this.canvas.revalidate();
        this.canvas.repaint();
    }

    public FrameModel<T> getFrameModel() {
        return this.framesModel;
    }

    public List<FrameBox<T>> getFrames() {
        return this.framesModel.frames;
    }

    public void putClientProperty(String key, Object value) {
        this.canvas.putClientProperty(Objects.requireNonNull(key), value);
    }

    public Object getClientProperty(String key) {
        return this.canvas.getClientProperty(Objects.requireNonNull(key));
    }

    public void requestRepaint() {
        this.canvas.revalidate();
        this.canvas.repaint();
        this.canvas.triggerMinimapGeneration();
    }

    public void overrideZoomAction(ZoomAction zoomActionOverride) {
        Objects.requireNonNull(zoomActionOverride);
        this.canvas.zoomActionOverride = zoomActionOverride;
    }

    public void resetZoom() {
        FlamegraphView.zoom(this.canvas, this.canvas.getResetZoomTarget());
    }

    public void zoomTo(FrameBox<T> frame) {
        FlamegraphView.zoom(this.canvas, this.canvas.getFrameZoomTarget(frame));
    }

    private static <T> void zoom(FlamegraphCanvas<T> canvas, ZoomTarget zoomTarget) {
        if (zoomTarget == null) {
            return;
        }
        if (canvas.getMode() == Mode.FLAMEGRAPH) {
            Rectangle visibleRect = canvas.getVisibleRect();
            JViewport viewPort = (JViewport)SwingUtilities.getUnwrappedParent(canvas);
            JScrollPane scrollPane = (JScrollPane)viewPort.getParent();
            JScrollBar hsb = scrollPane.getHorizontalScrollBar();
            if (!hsb.isVisible() && visibleRect.getWidth() < zoomTarget.getWidth()) {
                zoomTarget.y -= hsb.getPreferredSize().height;
            }
        }
        if (canvas.zoomActionOverride == null || !canvas.zoomActionOverride.zoom(canvas, zoomTarget)) {
            canvas.zoom(zoomTarget);
        }
    }

    public void highlightFrames(Set<FrameBox<T>> framesToHighlight, String searched) {
        Objects.requireNonNull(framesToHighlight);
        Objects.requireNonNull(searched);
        this.canvas.getFlamegraphRenderEngine().ifPresent(painter -> painter.setHighlightFrames(framesToHighlight, searched));
        this.canvas.repaint();
    }

    static class FlamegraphCanvas<T>
    extends JPanel
    implements ZoomableComponent {
        public static final String GRAPH_MODE = "mode";
        private Image minimap;
        private JToolTip toolTip;
        private FlamegraphRenderEngine<T> flamegraphRenderEngine;
        private BiFunction<FrameModel<T>, FrameBox<T>, String> tooltipToTextFunction;
        private Dimension flamegraphDimension = new Dimension();
        private final Rectangle minimapBounds = new Rectangle(50, 50, 200, 100);
        private final int minimapInset = 10;
        private Supplier<Color> minimapShadeColorSupplier = null;
        private boolean showMinimap = true;
        private Supplier<JToolTip> tooltipComponentSupplier;
        private ZoomAction zoomActionOverride;
        private BiConsumer<FrameBox<T>, MouseEvent> popupConsumer;
        private BiConsumer<FrameBox<T>, MouseEvent> selectedFrameConsumer;
        private final FlamegraphView<T> flamegraphView;
        private long lastDrawTime;

        public FlamegraphCanvas(FlamegraphView<T> flamegraphView) {
            this.flamegraphView = flamegraphView;
        }

        @Override
        public void updateUI() {
            super.updateUI();
        }

        @Override
        public void addNotify() {
            super.addNotify();
            Container parent = SwingUtilities.getUnwrappedParent(this);
            if (parent instanceof JViewport) {
                final JViewport viewport = (JViewport)parent;
                JScrollPane scrollPane = (JScrollPane)viewport.getParent();
                JScrollBar vsb = scrollPane.getVerticalScrollBar();
                vsb.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentShown(ComponentEvent e) {
                        SwingUtilities.invokeLater(() -> {
                            int canvasWidth = this.getWidth();
                            if (canvasWidth == 0) {
                                return;
                            }
                            this.setSize(viewport2.getViewRect().width, this.getHeight());
                        });
                    }
                });
                this.addPropertyChangeListener(GRAPH_MODE, evt -> SwingUtilities.invokeLater(() -> {
                    int value = vsb.getValue();
                    Rectangle bounds = this.getBounds();
                    Rectangle visibleRect = this.getVisibleRect();
                    switch ((Mode)((Object)((Object)((Object)evt.getNewValue())))) {
                        case ICICLEGRAPH: {
                            vsb.setValue(value == vsb.getMaximum() ? vsb.getMinimum() : bounds.height - Math.abs(bounds.y) - visibleRect.height);
                            break;
                        }
                        case FLAMEGRAPH: {
                            vsb.setValue(value == vsb.getMinimum() ? vsb.getMaximum() : bounds.height - visibleRect.height - value);
                        }
                    }
                }));
                this.addPropertyChangeListener("preferredSize", evt -> {
                    Dimension preferredSize = (Dimension)evt.getNewValue();
                    SwingUtilities.invokeLater(() -> {
                        if (this.isVisible() && this.showMinimap) {
                            this.triggerMinimapGeneration();
                        }
                    });
                });
            }
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension oldFlamegraphDimension = this.flamegraphDimension;
            Dimension preferredSize = new Dimension(10, 10);
            int flamegraphWidth = this.getWidth();
            if (this.flamegraphRenderEngine == null || flamegraphWidth == 0 || this.getGraphics() == null) {
                this.flamegraphDimension = preferredSize;
                this.firePropertyChange("preferredSize", oldFlamegraphDimension, preferredSize);
                return preferredSize;
            }
            int flamegraphHeight = this.flamegraphRenderEngine.computeVisibleFlamegraphHeight((Graphics2D)this.getGraphics(), flamegraphWidth, true);
            preferredSize.width = Math.max(preferredSize.width, flamegraphWidth);
            preferredSize.height = Math.max(preferredSize.height, flamegraphHeight);
            if (!this.flamegraphDimension.equals(preferredSize)) {
                this.flamegraphDimension = preferredSize;
                this.firePropertyChange("preferredSize", oldFlamegraphDimension, preferredSize);
            }
            return preferredSize;
        }

        @Override
        protected void paintComponent(Graphics g) {
            long start = System.currentTimeMillis();
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g.create();
            Rectangle visibleRect = this.getVisibleRect();
            if (this.flamegraphRenderEngine == null) {
                String message = "No data to display";
                Font font = g2.getFont();
                Rectangle2D bounds = g2.getFontMetrics(font).getStringBounds(message, g2);
                int xx = visibleRect.x + (int)(((double)visibleRect.width - bounds.getWidth()) / 2.0);
                int yy = visibleRect.y + (int)(((double)visibleRect.height + bounds.getHeight()) / 2.0);
                g2.drawString(message, xx, yy);
                g2.dispose();
                return;
            }
            this.flamegraphRenderEngine.paint(g2, this.getBounds(), visibleRect);
            this.paintMinimap(g2, visibleRect);
            this.lastDrawTime = System.currentTimeMillis() - start;
            this.paintDetails(g2);
            g2.dispose();
        }

        private void paintDetails(Graphics2D g2) {
            if (this.getClientProperty(SHOW_STATS) == Boolean.TRUE) {
                Rectangle viewRect = this.getVisibleRect();
                Rectangle bounds = this.getBounds();
                double zoomFactor = bounds.getWidth() / viewRect.getWidth();
                String stats = "Canvas (" + bounds.getWidth() + ", " + bounds.getHeight() + ") Zoom Factor " + zoomFactor + " Coordinate (" + viewRect.getX() + ", " + viewRect.getY() + ") View (" + viewRect.getWidth() + ", " + viewRect.getHeight() + "), Visible " + this.flamegraphRenderEngine.getVisibleDepth() + " Draw time: " + this.lastDrawTime + " ms";
                int frameTextPadding = 3;
                double w = viewRect.getWidth();
                int h = 16;
                double x = viewRect.getX();
                double y = this.getMode() == Mode.ICICLEGRAPH ? viewRect.getY() + viewRect.getHeight() - (double)h : viewRect.getY();
                g2.setColor(new Color(-1539293120, true));
                g2.fillRect((int)x, (int)y, (int)w, h);
                g2.setColor(Color.YELLOW);
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2.drawString(stats, (int)(x + (double)frameTextPadding), (int)(y + (double)h - (double)frameTextPadding));
            }
        }

        private void paintMinimap(Graphics g, Rectangle visibleRect) {
            if (this.flamegraphDimension != null && this.showMinimap && this.minimap != null) {
                Graphics2D g2 = (Graphics2D)g.create(visibleRect.x + this.minimapBounds.x, visibleRect.y + visibleRect.height - this.minimapBounds.height - this.minimapBounds.y, this.minimapBounds.width + 20, this.minimapBounds.height + 20);
                g2.setColor(this.getBackground());
                int minimapRadius = 10;
                g2.fillRoundRect(1, 1, this.minimapBounds.width + 20 - 1, this.minimapBounds.height + 20 - 1, minimapRadius, minimapRadius);
                g2.drawImage(this.minimap, 10, 10, null);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2.setColor(this.getForeground());
                g2.setStroke(new BasicStroke(2.0f));
                g2.drawRoundRect(1, 1, this.minimapBounds.width + 20 - 2, this.minimapBounds.height + 20 - 2, minimapRadius, minimapRadius);
                double zoomZoneScaleX = (double)this.minimapBounds.width / (double)this.flamegraphDimension.width;
                double zoomZoneScaleY = (double)this.minimapBounds.height / (double)this.flamegraphDimension.height;
                int x = (int)((double)visibleRect.x * zoomZoneScaleX);
                int y = (int)((double)visibleRect.y * zoomZoneScaleY);
                int w = (int)((double)visibleRect.width * zoomZoneScaleX);
                int h = (int)((double)visibleRect.height * zoomZoneScaleY);
                Area zoomZone = new Area(new Rectangle(10, 10, this.minimapBounds.width, this.minimapBounds.height));
                zoomZone.subtract(new Area(new Rectangle(x + 10, y + 10, w, h)));
                Color color = this.minimapShadeColorSupplier == null ? new Color(this.getBackground().getRGB() & 0x90FFFFFF, true) : this.minimapShadeColorSupplier.get();
                g2.setColor(color);
                g2.fill(zoomZone);
                g2.setColor(this.getForeground());
                g2.setStroke(new BasicStroke(1.0f));
                g2.drawRect(x + 10, y + 10, w, h);
                g2.dispose();
            }
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            if (this.isInsideMinimap(e.getPoint())) {
                return "";
            }
            return super.getToolTipText(e);
        }

        public boolean isInsideMinimap(Point point) {
            if (!this.showMinimap) {
                return false;
            }
            Rectangle visibleRect = this.getVisibleRect();
            Rectangle rectangle = new Rectangle(visibleRect.x + this.minimapBounds.y, visibleRect.y + visibleRect.height - this.minimapBounds.height - this.minimapBounds.y, this.minimapBounds.width + 20, this.minimapBounds.height + 20);
            return rectangle.contains(point);
        }

        public void setToolTipText(FrameBox<T> frame) {
            if (this.tooltipToTextFunction == null) {
                return;
            }
            this.setToolTipText(this.tooltipToTextFunction.apply(this.flamegraphView.framesModel, frame));
        }

        @Override
        public JToolTip createToolTip() {
            if (this.tooltipComponentSupplier == null) {
                return super.createToolTip();
            }
            if (this.toolTip == null) {
                this.toolTip = this.tooltipComponentSupplier.get();
                this.toolTip.setComponent(this);
            }
            return this.toolTip;
        }

        private void triggerMinimapGeneration() {
            if (!this.showMinimap || this.flamegraphRenderEngine == null) {
                this.repaintMinimapArea();
                return;
            }
            CompletableFuture.runAsync(() -> {
                int height = this.flamegraphRenderEngine.computeVisibleFlamegraphMinimapHeight(this.minimapBounds.width);
                if (height <= 1) {
                    return;
                }
                GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsConfiguration c = e.getDefaultScreenDevice().getDefaultConfiguration();
                BufferedImage minimapImage = c.createCompatibleImage(this.minimapBounds.width, height, 3);
                Graphics2D minimapGraphics = minimapImage.createGraphics();
                minimapGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                minimapGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                minimapGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                Rectangle bounds = new Rectangle(this.minimapBounds.width, height);
                this.flamegraphRenderEngine.paintMinimap(minimapGraphics, bounds);
                minimapGraphics.dispose();
                SwingUtilities.invokeLater(() -> this.setMinimapImage(minimapImage));
            }).handle((__, t) -> {
                if (t != null) {
                    t.printStackTrace();
                }
                return null;
            });
        }

        private void setMinimapImage(BufferedImage minimapImage) {
            this.minimap = minimapImage.getScaledInstance(this.minimapBounds.width, this.minimapBounds.height, 4);
            this.repaintMinimapArea();
        }

        private void repaintMinimapArea() {
            Rectangle visibleRect = this.getVisibleRect();
            this.repaint(visibleRect.x + this.minimapBounds.x, visibleRect.y + visibleRect.height - this.minimapBounds.height - this.minimapBounds.y, this.minimapBounds.width + 20, this.minimapBounds.height + 20);
        }

        public void linkListenerTo(final JScrollPane scrollPane) {
            MouseInputAdapter mouseAdapter = new MouseInputAdapter(){
                private Point pressedPoint;

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() != 1 || e.getButton() != 1) {
                        return;
                    }
                    if (selectedFrameConsumer == null) {
                        return;
                    }
                    FlamegraphCanvas canvas = this;
                    flamegraphRenderEngine.getFrameAt((Graphics2D)canvas.getGraphics(), canvas.getBounds(), e.getPoint()).ifPresent(frame -> selectedFrameConsumer.accept((FrameBox<FrameBox>)frame, e));
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        if (this.isInsideMinimap(e.getPoint())) {
                            this.processMinimapMouseEvent(e);
                            this.pressedPoint = e.getPoint();
                        } else {
                            this.pressedPoint = null;
                        }
                        return;
                    }
                    this.handlePopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.handlePopup(e);
                }

                private void handlePopup(MouseEvent e) {
                    if (!e.isPopupTrigger()) {
                        return;
                    }
                    if (popupConsumer == null) {
                        return;
                    }
                    FlamegraphCanvas canvas = this;
                    flamegraphRenderEngine.getFrameAt((Graphics2D)canvas.getGraphics(), canvas.getBounds(), e.getPoint()).ifPresent(frame -> popupConsumer.accept((FrameBox<FrameBox>)frame, e));
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (this.isInsideMinimap(e.getPoint()) && this.pressedPoint != null) {
                        this.processMinimapMouseEvent(e);
                    }
                }

                private void processMinimapMouseEvent(MouseEvent e) {
                    if (flamegraphDimension == null) {
                        return;
                    }
                    Point pt = e.getPoint();
                    if (!(e.getComponent() instanceof FlamegraphCanvas)) {
                        return;
                    }
                    Rectangle visibleRect = ((FlamegraphCanvas)e.getComponent()).getVisibleRect();
                    double zoomZoneScaleX = (double)minimapBounds.width / (double)flamegraphDimension.width;
                    double zoomZoneScaleY = (double)minimapBounds.height / (double)flamegraphDimension.height;
                    double h = (double)(pt.x - (visibleRect.x + minimapBounds.x)) / zoomZoneScaleX;
                    BoundedRangeModel horizontalBarModel = scrollPane.getHorizontalScrollBar().getModel();
                    horizontalBarModel.setValue((int)h - horizontalBarModel.getExtent());
                    double v = (double)(pt.y - (visibleRect.y + visibleRect.height - minimapBounds.height - minimapBounds.y)) / zoomZoneScaleY;
                    BoundedRangeModel verticalBarModel = scrollPane.getVerticalScrollBar().getModel();
                    verticalBarModel.setValue((int)v - verticalBarModel.getExtent());
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    this.setCursor(this.isInsideMinimap(e.getPoint()) ? Cursor.getPredefinedCursor(System.getProperty("os.name").startsWith("Mac") ? 12 : 13) : Cursor.getDefaultCursor());
                }
            };
            this.addMouseListener(mouseAdapter);
            this.addMouseMotionListener(mouseAdapter);
        }

        void setFlamegraphRenderEngine(FlamegraphRenderEngine<T> flamegraphRenderEngine) {
            this.flamegraphRenderEngine = flamegraphRenderEngine;
        }

        Optional<FlamegraphRenderEngine<T>> getFlamegraphRenderEngine() {
            return Optional.ofNullable(this.flamegraphRenderEngine);
        }

        public void setToolTipTextFunction(BiFunction<FrameModel<T>, FrameBox<T>, String> tooltipTextFunction) {
            this.tooltipToTextFunction = tooltipTextFunction;
        }

        public void setTooltipComponentSupplier(Supplier<JToolTip> tooltipComponentSupplier) {
            this.tooltipComponentSupplier = tooltipComponentSupplier;
        }

        public void setMinimapShadeColorSupplier(Supplier<Color> minimapShadeColorSupplier) {
            this.minimapShadeColorSupplier = minimapShadeColorSupplier;
        }

        public void showMinimap(boolean showMinimap) {
            if (this.showMinimap == showMinimap) {
                return;
            }
            this.showMinimap = showMinimap;
            this.firePropertyChange("minimap", !showMinimap, showMinimap);
            this.triggerMinimapGeneration();
        }

        public boolean isShowMinimap() {
            return this.showMinimap;
        }

        public void setMode(Mode mode) {
            Mode oldMode = this.getMode();
            if (oldMode == mode) {
                return;
            }
            this.getFlamegraphRenderEngine().ifPresent(fre -> fre.setIcicle(Mode.ICICLEGRAPH == mode));
            this.firePropertyChange(GRAPH_MODE, (Object)oldMode, (Object)mode);
        }

        public Mode getMode() {
            return this.getFlamegraphRenderEngine().map(fre -> fre.isIcicle() ? Mode.ICICLEGRAPH : Mode.FLAMEGRAPH).orElseThrow();
        }

        public void setPopupConsumer(BiConsumer<FrameBox<T>, MouseEvent> consumer) {
            this.popupConsumer = consumer;
        }

        public void setSelectedFrameConsumer(BiConsumer<FrameBox<T>, MouseEvent> consumer) {
            this.selectedFrameConsumer = consumer;
        }

        public ZoomTarget getResetZoomTarget() {
            Graphics2D graphics = (Graphics2D)this.getGraphics();
            if (graphics == null) {
                return null;
            }
            Rectangle visibleRect = this.getVisibleRect();
            Rectangle bounds = this.getBounds();
            int newHeight = this.flamegraphRenderEngine.computeVisibleFlamegraphHeight(graphics, visibleRect.width);
            return new ZoomTarget(0, this.getMode() == Mode.FLAMEGRAPH ? -(bounds.height - visibleRect.height) : 0, visibleRect.width, newHeight);
        }

        public ZoomTarget getFrameZoomTarget(FrameBox<T> frame) {
            Graphics2D graphics = (Graphics2D)this.getGraphics();
            if (graphics == null) {
                return null;
            }
            return this.flamegraphRenderEngine.calculateZoomTargetFrame(graphics, this.getBounds(), this.getVisibleRect(), frame, 2, 0);
        }

        @Override
        public void zoom(ZoomTarget zoomTarget) {
            this.setBounds(zoomTarget);
        }
    }

    private static class FlamegraphScrollPaneMouseInputListener<T>
    implements MouseInputListener {
        private Point pressedPoint;
        private final FlamegraphCanvas<T> canvas;
        private Rectangle hoveredFrameRectangle;
        private HoverListener<T> hoverListener;
        private FrameBox<T> hoveredFrame;

        public FlamegraphScrollPaneMouseInputListener(FlamegraphCanvas<T> canvas) {
            this.canvas = canvas;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (e.getSource() instanceof JScrollPane && this.pressedPoint != null) {
                JScrollPane scrollPane = (JScrollPane)e.getComponent();
                JViewport viewPort = scrollPane.getViewport();
                if (viewPort == null) {
                    return;
                }
                int dx = e.getX() - this.pressedPoint.x;
                int dy = e.getY() - this.pressedPoint.y;
                Point viewPortViewPosition = viewPort.getViewPosition();
                viewPort.setViewPosition(new Point(Math.max(0, viewPortViewPosition.x - dx), Math.max(0, viewPortViewPosition.y - dy)));
                this.pressedPoint = e.getPoint();
                e.consume();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                if (this.canvas.isInsideMinimap(SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.canvas))) {
                    this.pressedPoint = null;
                    return;
                }
                this.pressedPoint = e.getPoint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.pressedPoint = null;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e) && e.getSource() instanceof JScrollPane) {
                return;
            }
            JScrollPane scrollPane = (JScrollPane)e.getComponent();
            JViewport viewPort = scrollPane.getViewport();
            scrollPane.requestFocus();
            Point latestMouseLocation = MouseInfo.getPointerInfo().getLocation();
            SwingUtilities.convertPointFromScreen(latestMouseLocation, this.canvas);
            if (this.canvas.isInsideMinimap(latestMouseLocation)) {
                return;
            }
            if (e.getClickCount() == 2) {
                this.canvas.getFlamegraphRenderEngine().flatMap(fgp -> fgp.calculateZoomTargetForFrameAt((Graphics2D)this.canvas.getGraphics(), this.canvas.getBounds(), this.canvas.getVisibleRect(), latestMouseLocation)).ifPresent(zoomTarget -> FlamegraphView.zoom(this.canvas, zoomTarget));
                return;
            }
            this.canvas.getFlamegraphRenderEngine().ifPresent(fgp -> fgp.toggleSelectedFrameAt((Graphics2D)viewPort.getView().getGraphics(), this.canvas.getBounds(), latestMouseLocation, (frame, r) -> this.canvas.repaint()));
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (e.getSource() instanceof JScrollPane) {
                this.hoveredFrameRectangle = null;
                this.hoveredFrame = null;
                this.canvas.getFlamegraphRenderEngine().ifPresent(fgp -> fgp.stopHover((Graphics2D)this.canvas.getGraphics(), this.canvas.getBounds(), this.canvas::repaint));
                this.canvas.repaint();
                if (this.hoverListener != null) {
                    this.hoverListener.onStopHover(this.hoveredFrame, this.hoveredFrameRectangle, e);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point latestMouseLocation = MouseInfo.getPointerInfo().getLocation();
            SwingUtilities.convertPointFromScreen(latestMouseLocation, this.canvas);
            if (this.canvas.isInsideMinimap(latestMouseLocation)) {
                if (this.hoverListener != null) {
                    this.hoverListener.onStopHover(this.hoveredFrame, this.hoveredFrameRectangle, e);
                }
                return;
            }
            if (this.hoveredFrameRectangle != null && this.hoveredFrameRectangle.contains(latestMouseLocation)) {
                if (this.hoverListener != null) {
                    this.hoverListener.onFrameHover(this.hoveredFrame, this.hoveredFrameRectangle, e);
                }
                return;
            }
            this.canvas.getFlamegraphRenderEngine().ifPresent(fgp -> {
                Graphics2D canvasGraphics = (Graphics2D)this.canvas.getGraphics();
                fgp.getFrameAt(canvasGraphics, this.canvas.getBounds(), latestMouseLocation).ifPresentOrElse(frame -> {
                    fgp.hoverFrame(frame, canvasGraphics, this.canvas.getBounds(), this.canvas::repaint);
                    this.canvas.setToolTipText((FrameBox<T>)frame);
                    this.hoveredFrameRectangle = fgp.getFrameRectangle(canvasGraphics, this.canvas.getBounds(), frame);
                    this.hoveredFrame = frame;
                    if (this.hoverListener != null) {
                        this.hoverListener.onFrameHover((FrameBox<T>)frame, this.hoveredFrameRectangle, e);
                    }
                }, () -> {
                    fgp.stopHover(canvasGraphics, this.canvas.getBounds(), this.canvas::repaint);
                    Rectangle prevHoveredFrameRectangle = this.hoveredFrameRectangle;
                    FrameBox<T> prevHoveredFrame = this.hoveredFrame;
                    this.hoveredFrameRectangle = null;
                    this.hoveredFrame = null;
                    if (this.hoverListener != null) {
                        this.hoverListener.onStopHover(prevHoveredFrame, prevHoveredFrameRectangle, e);
                    }
                });
            });
        }

        public void setHoverListener(HoverListener<T> hoveringListener) {
            this.hoverListener = hoveringListener;
        }

        public void install(JScrollPane sp) {
            sp.addMouseListener(this);
            sp.addMouseMotionListener(this);
        }
    }

    public static interface HoverListener<T> {
        default public void onStopHover(FrameBox<T> previousHoveredFrame, Rectangle prevHoveredFrameRectangle, MouseEvent e) {
        }

        public void onFrameHover(FrameBox<T> var1, Rectangle var2, MouseEvent var3);

        public static Point getPointLeveledToFrameDepth(MouseEvent mouseEvent, Rectangle frameRect) {
            JScrollPane scrollPane = (JScrollPane)mouseEvent.getComponent();
            Component canvas = scrollPane.getViewport().getView();
            FlamegraphView ownerFg = FlamegraphView.from(scrollPane).orElseThrow(() -> new IllegalStateException("Cannot find FlamegraphView owner"));
            Point pointOnCanvas = SwingUtilities.convertPoint(scrollPane, mouseEvent.getPoint(), canvas);
            pointOnCanvas.y = frameRect.y;
            return SwingUtilities.convertPoint(canvas, pointOnCanvas, ownerFg.component);
        }
    }

    public static interface ZoomableComponent {
        public void zoom(ZoomTarget var1);

        public int getWidth();

        public int getHeight();

        public Point getLocation();
    }

    public static interface ZoomAction {
        public boolean zoom(ZoomableComponent var1, ZoomTarget var2);
    }

    public static enum Mode {
        FLAMEGRAPH,
        ICICLEGRAPH;

    }
}

