/*
 * Decompiled with CFR 0.152.
 */
package io.github.bric3.fireplace.flamegraph;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;

public class FrameBox<T> {
    public final T actualNode;
    public final double startX;
    public final double endX;
    public final int stackDepth;

    public FrameBox(T actualNode, double startX, double endX, int stackDepth) {
        if (startX > endX || startX < 0.0 || endX > 1.0) {
            throw new IllegalArgumentException("Invalid frame coordinates, should be 0 <= startX <= endX <= 1, actual values: startX=" + startX + ", endX=" + endX);
        }
        if (stackDepth < 0) {
            throw new IllegalArgumentException("Invalid stack depth, should be >= 0, actual value: " + stackDepth);
        }
        this.actualNode = Objects.requireNonNull(actualNode);
        this.startX = startX;
        this.endX = endX;
        this.stackDepth = stackDepth;
    }

    public String toString() {
        return "FlameNode{startX=" + this.startX + ", endX=" + this.endX + ", depth=" + this.stackDepth + "}";
    }

    public static <T> void flattenAndCalculateCoordinate(List<FrameBox<T>> accumulator, T fromNode, Function<T, List<T>> getChildren, ToDoubleFunction<T> nodeWeight, double startX, double endX, int depth) {
        FrameBox.flattenAndCalculateCoordinate(accumulator, fromNode, getChildren, nodeWeight, nodeWeight, startX, endX, depth);
    }

    public static <T> void flattenAndCalculateCoordinate(List<FrameBox<T>> accumulator, T fromNode, Function<T, List<T>> getChildren, ToDoubleFunction<T> nodeWeight, ToDoubleFunction<T> totalNodeWeight, double startX, double endX, int depth) {
        accumulator.add(new FrameBox<T>(fromNode, startX, endX, depth));
        List<T> children = getChildren.apply(fromNode);
        if (children == null || children.isEmpty()) {
            return;
        }
        ++depth;
        double parentWidth = endX - startX;
        double totalWeight = totalNodeWeight.applyAsDouble(fromNode);
        for (T node : children) {
            double nodeWidth = nodeWeight.applyAsDouble(node) / totalWeight * parentWidth;
            endX = Math.min(startX + nodeWidth, 1.0);
            FrameBox.flattenAndCalculateCoordinate(accumulator, node, getChildren, nodeWeight, startX, endX, depth);
            startX = endX;
        }
    }

    public boolean isRoot() {
        return this.stackDepth == 0;
    }
}

