/*
 * Decompiled with CFR 0.152.
 */
package io.github.bric3.fireplace.flamegraph;

import io.github.bric3.fireplace.flamegraph.FrameBox;
import io.github.bric3.fireplace.flamegraph.FrameColorProvider;
import io.github.bric3.fireplace.flamegraph.FrameFontProvider;
import io.github.bric3.fireplace.flamegraph.FrameModel;
import io.github.bric3.fireplace.flamegraph.FrameRenderingFlags;
import io.github.bric3.fireplace.flamegraph.FrameTextsProvider;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Objects;
import java.util.function.Function;

class FrameRenderer<T> {
    private FrameTextsProvider<T> frameTextsProvider;
    private FrameFontProvider<T> frameFontProvider;
    private FrameColorProvider<T> frameColorProvider;
    private final int frameTextPadding = 2;
    private boolean drawingFrameGap = true;
    private final int frameGapWidth = 1;
    public int frameBorderWidth = 1;
    public Stroke frameBorderStroke = new BasicStroke(this.frameBorderWidth);

    public FrameRenderer(FrameTextsProvider<T> frameTextsProvider, FrameColorProvider<T> frameColorProvider, FrameFontProvider<T> frameFontProvider) {
        this.frameTextsProvider = Objects.requireNonNull(frameTextsProvider, "nodeToTextProvider");
        this.frameColorProvider = Objects.requireNonNull(frameColorProvider, "frameColorProvider");
        this.frameFontProvider = Objects.requireNonNull(frameFontProvider, "frameFontProvider");
    }

    public int getFrameTextPadding() {
        return 2;
    }

    public int getFrameGapWidth() {
        return 1;
    }

    public void setDrawingFrameGap(boolean drawingFrameGap) {
        this.drawingFrameGap = drawingFrameGap;
    }

    public boolean isDrawingFrameGap() {
        return this.drawingFrameGap;
    }

    public int getFrameBoxHeight(Graphics2D g2) {
        return g2.getFontMetrics(this.frameFontProvider.getFont(null, 0)).getAscent() + 4 + 2;
    }

    public float getFrameBoxTextOffset(Graphics2D g2) {
        return (float)this.getFrameBoxHeight(g2) - (float)g2.getFontMetrics(this.frameFontProvider.getFont(null, 0)).getDescent() / 2.0f - 2.0f - 1.0f;
    }

    void paintFrame(Graphics2D g2, FrameModel<T> frameModel, Rectangle2D frameRect, FrameBox<T> frame, Rectangle2D paintableIntersection, int flags) {
        boolean minimapMode = FrameRenderingFlags.isMinimapMode(flags);
        FrameColorProvider.ColorModel colorModel = this.frameColorProvider.getColors(frame, flags);
        this.paintFrameRectangle(g2, frameRect, colorModel.background, minimapMode);
        if (minimapMode) {
            return;
        }
        Font frameFont = this.frameFontProvider.getFont(frame, flags);
        String text = this.calculateFrameText(g2, frameFont, paintableIntersection.getWidth() - 4.0 - 2.0, frameModel, frame);
        if (text == null || text.isEmpty()) {
            return;
        }
        g2.setFont(frameFont);
        g2.setColor(colorModel.foreground);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.drawString(text, (float)(paintableIntersection.getX() + 2.0 + (double)this.frameBorderWidth), (float)(frameRect.getY() + (double)this.getFrameBoxTextOffset(g2)));
    }

    private void paintFrameRectangle(Graphics2D g2, Rectangle2D frameRect, Color bgColor, boolean minimapMode) {
        boolean gapThickness = minimapMode ? false : this.drawingFrameGap;
        double x = frameRect.getX();
        double y = frameRect.getY();
        double w = frameRect.getWidth() - (double)gapThickness;
        double h = frameRect.getHeight() - (double)gapThickness;
        frameRect.setRect(x, y, w, h);
        g2.setColor(bgColor);
        g2.fill(frameRect);
    }

    private String calculateFrameText(Graphics2D g2, Font font, double targetWidth, FrameModel<T> frameModel, FrameBox<T> frame) {
        Object textBounds;
        String textCandidate;
        FontMetrics metrics = g2.getFontMetrics(font);
        String string = textCandidate = frame.isRoot() ? frameModel.title : "";
        if (frame.isRoot() && !textCandidate.isBlank()) {
            textBounds = metrics.getStringBounds(textCandidate, g2);
            if (((RectangularShape)textBounds).getWidth() <= targetWidth) {
                return textCandidate;
            }
        } else {
            textBounds = this.frameTextsProvider.frameToTextCandidates().iterator();
            while (textBounds.hasNext()) {
                Function nodeToTextCandidate = (Function)textBounds.next();
                textCandidate = (String)nodeToTextCandidate.apply(frame);
                Rectangle2D textBounds2 = metrics.getStringBounds(textCandidate, g2);
                if (!(textBounds2.getWidth() <= targetWidth)) continue;
                return textCandidate;
            }
        }
        if (((RectangularShape)(textBounds = metrics.getStringBounds(textCandidate = this.frameTextsProvider.clipStrategy().clipString(font, metrics, targetWidth, textCandidate, "\u2026"), g2))).getWidth() > targetWidth || textCandidate.length() <= "\u2026".length() + 1) {
            return null;
        }
        return textCandidate;
    }

    public void setFrameTextsProvider(FrameTextsProvider<T> frameTextsProvider) {
        this.frameTextsProvider = Objects.requireNonNull(frameTextsProvider, "frameTextsProvider");
    }

    public FrameTextsProvider<T> getFrameTextsProvider() {
        return this.frameTextsProvider;
    }

    public void setFrameFontProvider(FrameFontProvider<T> frameFontProvider) {
        this.frameFontProvider = Objects.requireNonNull(frameFontProvider, "frameFontProvider");
    }

    public FrameFontProvider<T> getFrameFontProvider() {
        return this.frameFontProvider;
    }

    public void setFrameColorProvider(FrameColorProvider<T> frameColorProvider) {
        this.frameColorProvider = Objects.requireNonNull(frameColorProvider, "frameColorProvider");
    }

    public FrameColorProvider<T> getFrameColorProvider() {
        return this.frameColorProvider;
    }
}

